<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Bpatrak_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }
   
    /*------------------ SERVER SIDE DATA TABLE FETCH STATE RECORD CODE ----------------------*/
 
    var $column_order = array(null,'ps.name','p.police_name','b.incident_name','b.description','b.date','b.time','b.current_location',null,null); //set column field database for datatable orderable
    var $column_search = array('ps.name','p.police_name','b.incident_name','b.description','b.date','b.time','b.current_location',); //set column field database for datatable searchable
    var $order = array('b.id' => 'DESC'); // default order
 
    private function _get_datatables_query($cond) {
        $this->db->select("b.*,ps.name,p.police_name");
        $this->db->from("bpatrak b");
        $this->db->join("mst_police_stations ps","ps.id=b.police_station_id","LEFT");
         $this->db->join("mst_police p","p.id=b.police_id","LEFT");
        $this->db->where($cond);
        $i = 0;
     
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (ps.name LIKE '%".$show_string."%' ";   
            $cond.=" OR p.police_name LIKE '%".$show_string."%' ";   
            $cond.=" OR b.incident_name LIKE '%".$show_string."%' ";   
            $cond.=" OR b.description LIKE '%".$show_string."%' ";   
            $cond.=" OR b.date LIKE '%".$show_string."%' ";   
            $cond.=" OR b.time LIKE '%".$show_string."%' ";   
            $cond.=" OR b.current_location LIKE '%".$show_string."%' ) ";   
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) { // here order processing
    
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if(isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond) {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered($cond) {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond) {
        $this->db->select("b.*,ps.name,p.police_name");
        $this->db->from("bpatrak b");
        $this->db->join("mst_police_stations ps","ps.id=b.police_station_id","LEFT");
         $this->db->join("mst_police p","p.id=b.police_id","LEFT");
        $this->db->where($cond);
        return $this->db->count_all_results();
    }  

    public function viewBpatrakDetails($cond) {
       $this->db->select("b.*,ps.name,p.police_name");
        $this->db->from("bpatrak b");
        $this->db->join("mst_police_stations ps","ps.id=b.police_station_id","LEFT");
        $this->db->join("mst_police p","p.id=b.police_id","LEFT");
        $this->db->where($cond);
       $query = $this->db->get();
        return $query->row();
    }   

    public function getBpatrakData()
    {   
         $this->db->select("b.*,ps.name,p.police_name");
        $this->db->from("bpatrak b");
        $this->db->join("mst_police_stations ps","ps.id=b.police_station_id","LEFT");
        $this->db->join("mst_police p","p.id=b.police_id","LEFT");        
       $query = $this->db->get();
        return $query->result();
    }

}