<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Assigned_station_task_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    var $column_order = array(null,'pa.name',null,'ps.name',null,null,null,null); //set column field database for datatable orderable
    var $column_search = array('pa.name','ps.name'); //set column field database for datatable searchable
    var $order = array('psam.id' => 'DESC'); // default order
 
    private function _get_datatables_query($cond)
    {
       
            $this->db->select("psam.*,pa.name,ps.name as ps_name");
            $this->db->from("police_activity_map pam");
            $this->db->join("police_station_activity_map psam",'psam.id=pam.police_station_activity_map_id','left');
            $this->db->join("police_activities pa",'pa.id=psam.activity_id','left');       
              $this->db->join("mst_police_stations ps", 'ps.id = psam.police_station_id', 'left');
             $this->db->group_by("pam.police_station_activity_map_id"); 
            $this->db->where($cond);
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (pa.name LIKE '%".$show_string."%' ";
           
            $cond.=" OR ps.name LIKE '%".$show_string."%') ";      
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
        $this->db->from("police_activity_map pam");
            $this->db->join("police_station_activity_map psam",'psam.id=pam.police_station_activity_map_id','left');
        $this->db->join("police_activities pa",'pa.id=psam.activity_id','left');       
        $this->db->join("mst_police_stations ps", 'ps.id = psam.police_station_id', 'left');
        return $this->db->count_all_results();
    }
   
    function GetActivityDetails($cond)
    {
        $this->db->select('psam.*,pa.*,mps.name as station_name');
        $this->db->from('police_station_activity_map psam');
        $this->db->join('police_activities pa',"psam.activity_id=pa.id",'left');
        $this->db->join("mst_police_stations mps", 'mps.id=psam.police_station_id','left');

        $this->db->where($cond);
        return $this->db->get()->result();
    }

    function viewPolicetaskDetails($cond)
    {    
        $this->db->select('psam.*,psam.id as psamId,mps.id as psId,mps.name as psname,mps.address as psaddress,p.police_name');
        $this->db->from('police_station_activity_map psam');      
        $this->db->join("mst_police p",'p.police_station_id=psam.police_station_id','left');
        $this->db->join("mst_police_stations mps", 'mps.id=psam.police_station_id','left');
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');
        $this->db->where($cond);
        return $this->db->get()->row();
    }
    function viewPoliceactivityDetails($cond)
    {    
        $this->db->select('psam.*,pa.name as paname');
        $this->db->from('police_station_activity_map psam');       
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');
        $this->db->where("psam.id NOT IN (SELECT police_station_activity_map_id FROM police_activity_map)");      
        $this->db->where($cond);
        return $this->db->get()->result();
    }
    function viewPoliceactivityDetailsforupdate($cond)
    {    
        $this->db->select('psam.*,pa.name as paname');
        $this->db->from('police_station_activity_map psam');       
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');
        $this->db->where($cond);
        return $this->db->get()->result();
    }

    public function GetPoliceActivityMapData($cond){
        $this->db->select('pam.*,p.police_name');
        $this->db->from('police_activity_map pam');       
        $this->db->join("mst_police p",'p.id=pam.police_id', 'left');      
        $this->db->where($cond);
        return $this->db->get()->result();
    }

   
}