<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Ward_members extends CI_Controller 
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Ward_members_model");
    }

    public function index()
    {
        $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Ward members</li>
                        </ul>";

        $data = array(
            'breadcrumbs' => $breadcrumbs,
            'actioncolumn' => '11',
            'ajax_manage_page' => site_url('Ward_members/ajax_manage_page'),
            'action' => site_url('Ward_members/create'),
            'deleteAction' => site_url('Ward_members/delete'),
            'changeAction' => site_url('Ward_members/changeStatus'),
            'button' => 'Create',
            'heading' => 'Manage Ward members',
        );
        $this->load->view('ward_members/ward_members_list',$data);
    }

    public function ajax_manage_page() 
    {
        $Data = $this->Ward_members_model->get_datatables();  
        $data = array();  
        if(empty($_POST['start'])) {
          $no =0;   
        } else {
          $no =$_POST['start'];
        }

        foreach($Data as $row) {
          $viewUrl = "Ward_members/view";
          $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

          $updateUrl = "Ward_members/update";
          $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';


          $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

          if($row->status=='Active')
            {
              $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
            }
            else
            {
              $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
            }
          $no++;  
          $nestedData = array();
          $nestedData[] = $no;
          $nestedData[] = ucfirst($row->name);
          $nestedData[] = $row->email;
          $nestedData[] = $row->mobile;
          //$nestedData[] = $row->gender;
          $nestedData[] = ucfirst($row->country_name);
          $nestedData[] = ucfirst($row->state_name);
          $nestedData[] = ucfirst($row->city);
          $nestedData[] = $row->address;
          $nestedData[] = $row->pincode;
          $nestedData[] = $status;
          $nestedData[] = $btn;
          $data[] = $nestedData;
          $selected = '';

        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Ward_members_model->count_all(),
          "recordsFiltered" => $this->Ward_members_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
    
  public function create() {  
      $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active'","","country_name asc");
      $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active'","","state_name asc");

      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                            <i class='ace-icon fa fa-home home-icon'></i>
                            <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li>Manage Ward_members</li>
                        <li class='active'>Add Citizen</li>
                        </ul>";

        $data = array(
          'button'    => 'Create',
          'heading'   => 'Create Citizen',
          'breadcrumbs' => $breadcrumbs,
          'action'    => site_url('Ward_members/create_action'),
          'cancelbtn'   => site_url('Ward_members/index'), 
          'id'      => set_value('id',$this->input->post('id')),
          'name'        => set_value('name',$this->input->post('name')),
          'email'     => set_value('email',$this->input->post('email')),
          'mobile'     => set_value('mobile',$this->input->post('mobile')),
          'password'   => set_value('password',$this->input->post('password')),
          'dob'    => set_value('dob',$this->input->post('dob')),
          'address'    => set_value('address',$this->input->post('address')),
          'pincode'    => set_value('pincode',$this->input->post('pincode')),
          'country_id'    => set_value('country_id',$this->input->post('country_id')),
          'state_id'    => set_value('state_id',$this->input->post('state_id')),
          //'gender'    => set_value('gender',$this->input->post('gender')),
          'countries'    => $countries,
          'states'    => $states,
          'city'    => set_value('city',$this->input->post('city')),
        ); 
        $this->load->view('Ward_members/add_citizen',$data);
  }


  public function create_action() {   
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) {  
      $this->create();
    } else {

      $image='';
      if( $_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/Ward_members/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/Ward_members/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }
      }
      $data = array(
        'name'      => $this->input->post('name'),
        'email'     => $this->input->post('email'),
        'mobile'    => $this->input->post('mobile'),
        'dob'    => $this->input->post('dob'),
        'password'    => $this->input->post('password'),
        'image'    => $image,
        // 'gender'    => $this->input->post('gender'),
        'country_id'    => $this->input->post('country_id'),
        'state_id'    => $this->input->post('state_id'),
        'city'    => $this->input->post('city'),
        'address'    => $this->input->post('address'),
        'pincode'    => $this->input->post('pincode'),
      );  
      $this->Crud_model->SaveData("Ward_members",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen has been created successfully</span>');
      redirect('Ward_members/index');
    }
  }

    public function getState() {
      $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and status='Active'",'',"state_name asc");

      if(!empty($states)) {
        $response = '<option value="">Select State</option>';
        foreach($states as $row) {
          $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
        }
      }else {
          $response = '<option value="">Select State</option>';
      }
      echo $response;
    }
  
    // VIEW
    public function view($id)
    {
        $cond = "id='".base64_decode($id)."'";
        $row = $this->Ward_members_model->viewCompDetails($cond);
        //echo "<pre>"; print_r($row); die();
        $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Ward_members/index').'">Manage Citizen</a></li>
                        <li class="active">Citizen Details</li>
                      </ul>';

        $data = array(

                        'row'=> $row,
                        'breadcrumbs'=>$breadcrumbs, 
                        'id'=>$row->id,    
                        'name'=>$row->name,    
                        'email'=>$row->email,    
                        'mobile'=>$row->mobile,    
                        'dob'=>$row->dob,    
                        'gender'=>$row->gender,    
                        'country_name'=>$row->country_name,    
                        'state_name'=>$row->state_name,    
                        'city'=>$row->city,    
                        'state_id'=>$row->state_id,    
                        'city'=>$row->city,    
                        'address'=>$row->address,    
                        'pincode'=>$row->pincode,   
                        'image'=>$row->image,   
                        'status'=>$row->status,   
                  );
       $this->load->view('Ward_members/view',$data);
    }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("Ward_members",'',"id='".$id."'",'','','','1'); 
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Ward_members</li>
                    </ul>";

      if(!empty($row)) {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active'","","country_name asc");
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and country_id='".$row->country_id."'","","state_name asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Citizen',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'cancelbtn'   => site_url('Ward_members/index'), 
          'action'    => site_url('Ward_members/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'city'   => set_value('city', $row->city),
          'name'   => set_value('name', $row->name),
          'dob'   => set_value('dob', $row->dob),
          'password'   => set_value('password', $row->password),
          'email'   => set_value('email', $row->email),
          'mobile'   => set_value('mobile', $row->mobile),
          'pincode'   => set_value('pincode', $row->pincode),
          'address'   => set_value('address', $row->address),
          'image'   => set_value('image', $row->image),
        );
        $this->load->view('Ward_members/add_citizen', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Ward_members/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Ward_members/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } else {  
      $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/Ward_members/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/Ward_members/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }

      $data = array(
        'name' => $this->input->post('name',TRUE),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'dob' => $this->input->post('dob',TRUE),
        'password' => $this->input->post('password',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'city' => $this->input->post('city',TRUE),
        'address' => $this->input->post('address',TRUE),
        'pincode' => $this->input->post('pincode',TRUE),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("Ward_members",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen has been updated successfully</span>');
      redirect('Ward_members/index');
    }
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('Ward_members','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
        $this->Crud_model->SaveData('Ward_members',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('Ward_members',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Ward_members/index');
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('Ward_members', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen deleted successfully</span>');
    redirect('Ward_members/index');
  } 

  // SEVER SIDE VALIDATION
  public function _rules($id) {
      $cond = "mobile='".trim($this->input->post('mobile',TRUE))."' and email='".trim($this->input->post('email',TRUE))."' and id!='".$id."'";
      $row = $this->Crud_model->GetData("Ward_members",'',$cond,'','','','');
      $count = count($row); 
      if($count==0) {
        $is_unique = "";
        $is_unique2 = "";
      } else {
        $is_unique = "|is_unique[Ward_members.email]";
        $is_unique2 = "|is_unique[Ward_members.mobile]";
      } 

      $this->form_validation->set_rules('name', 'name', 'trim|required', array('required' => 'Please enter %s'));

      $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
      array(
        'required'      => 'Please enter %s',
        'is_unique'     => 'email already exists'
      ));

      $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
      array(
        'required'      => 'Please enter %s',
        'is_unique'     => 'mobile already exists'
      ));

      //$this->form_validation->set_rules('mobile', 'mobile', 'trim|required', array('required' => 'Please enter %s'));

      $this->form_validation->set_rules('password', 'password', 'trim|required', array('required' => 'Please enter %s'));

      $this->form_validation->set_rules('dob', 'dob', 'trim|required', array('required' => 'Please select %s'));
      $this->form_validation->set_rules('country_id', 'country', 'trim|required', array('required' => 'Please select %s'));
      $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please select %s'));
      $this->form_validation->set_rules('city', 'city', 'trim|required', array('required' => 'Please enter %s'));
      $this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please enter %s'));
      //$this->form_validation->set_rules('gender', 'gender', 'trim|required', array('required' => 'Please select %s'));
      $this->form_validation->set_rules('pincode', 'pincode', 'trim|required', array('required' => 'Please select %s'));

      $this->form_validation->set_rules('id', 'id', 'trim');
      $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}