<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Roles_and_responsibilities extends CI_Controller 
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model("Roles_and_responsibilities_model");
  }

  public function index()
  {

    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Roles and responsibilities</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '3',
      'ajax_manage_page' => site_url('Roles_and_responsibilities/ajax_manage_page'),
      'action' => site_url('Roles_and_responsibilities/create'),
      'deleteAction' => site_url('Roles_and_responsibilities/delete'),
      'changeAction' => site_url('Roles_and_responsibilities/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Roles and responsibilities',
    );
    $this->load->view('roles_and_responsibilities/list',$data);
  }

  public function ajax_manage_page() 
  {
    $rolesAndResponsibilityData = $this->Roles_and_responsibilities_model->get_datatables();  

    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    $responsibilities = '';   
    foreach($rolesAndResponsibilityData as $row) 
    { 
      $getResponsibilities = $this->Roles_and_responsibilities_model->getResponsibilities($row->id);

      $responsibilities = "<ul>";
      
      foreach ($getResponsibilities as $rowData) {
        $responsibilities .='<li>'.$rowData->responsibility.'</li>';      
      }

      $responsibilities .='<ul>';

      /*$viewUrl = "Roles_and_responsibilities/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';*/

      $updateUrl = "Roles_and_responsibilities/update";
      $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->role_id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->role_id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucwords($row->title);
      // $nestedData[] = $row->responsibility;
      $nestedData[] = $responsibilities;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Roles_and_responsibilities_model->count_all(),
      "recordsFiltered" => $this->Roles_and_responsibilities_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create() 
  {  

    $mst_roles = $this->Crud_model->GetData("mst_roles",'','status="Active" and is_delete="No"','',"title asc");

    $breadcrumbs = "<ul class='breadcrumb'>
                  <li>
                  <i class='ace-icon fa fa-home home-icon'></i>
                  <a href='".site_url('Dashboard')."'>Dashboard</a>
                  </li>
                  <li><a href='".site_url('Roles_and_responsibilities')."'>Manage Roles and responsibilities</a></li>
                  <li class='active'>Add</li>
                </ul>";

    $data = array(
      'button'    => 'Create',
      'heading'   => 'Create',
      'breadcrumbs' => $breadcrumbs,
      'mst_roles' => $mst_roles,
      // 'corporates'    => $corporates,
      'action'    => site_url('Roles_and_responsibilities/create_action'),
      'cancelbtn'   => site_url('Roles_and_responsibilities/index'), 
      'id'      => set_value('id',$this->input->post('id')),
      'role_id'        => set_value('role_id',$this->input->post('role_id')),
      'responsibility'     => set_value('responsibility',$this->input->post('responsibility')),
      'responsibility_marathi'     => set_value('responsibility_marathi',$this->input->post('responsibility_marathi')),
      'responsibility_hindi'     => set_value('responsibility_hindi',$this->input->post('responsibility_hindi')),
    ); 
    $this->load->view('roles_and_responsibilities/form',$data);
  }

  public function create_action() 
  { 
      $image='';
      if( $_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/roles_and_responsibilities/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/roles_and_responsibilities/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }
      }
      else
      {
        $image = "";
      }

      $data = array(
        'role_id'      => $this->input->post('role_id'),
        'image'    => $image,
      );  

      $this->Crud_model->SaveData("roles_and_responsibilities",$data);
      $last_inserted_id = $this->db->insert_id();

      for($i = 0; $i < count($_POST['responsibility']); $i++) {
              if(!empty($_POST['responsibility'][$i])) {
                  $record = array(
                      'role_id' => $this->input->post('role_id'),
                      'roles_respo_id' => $last_inserted_id,
                      'responsibility' => $_POST['responsibility'][$i],
                      'responsibility_marathi' => $_POST['responsibility_marathi'][$i],
                      'responsibility_hindi' => $_POST['responsibility_hindi'][$i]
                  );
                  $this->Crud_model->SaveData('corporate_responsibilities_mapping',$record);
              }
          }

      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Created successfully</span>');
      redirect('Roles_and_responsibilities/index');
  }


  // view
 /* public function view($id)
  {
    $cond = base64_decode($id);
    $result = $this->Roles_and_responsibilities_model->viewRolesAndResponsibility($cond);

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Roles_and_responsibilities/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Roles_and_responsibilities/index').'">Manage Roles & Responsibilities</a></li>
                  </ul>';

    $data = array(

      'breadcrumbs'=>$breadcrumbs, 
      'result'=> $result,

    );
    $this->load->view('roles_and_responsibilities/view',$data);
  }*/

  // update 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("roles_and_responsibilities",'',"role_id='".$id."'",'','','','1');

      $responsibilities = $this->Crud_model->GetData("corporate_responsibilities_mapping",'',"role_id='".$id."'");
      // echo "<pre>"; print_r($responsibilities); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li><a href='".site_url('Roles_and_responsibilities')."'>Manage Roles and responsibilities</a></li>
                        <li class='active'>Update</li>
                      </ul>";

      if(!empty($row)) 
      {
        
        $mst_roles = $this->Crud_model->GetData("mst_roles",'','','',"title asc");

        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update',
          'breadcrumbs' => $breadcrumbs,
          'responsibilities'   => $responsibilities,
          'mst_roles'   => $mst_roles,
          'cancelbtn'   => site_url('Roles_and_responsibilities/index'), 
          'action'    => site_url('Roles_and_responsibilities/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'role_id'   => set_value('role_id', $row->role_id),
          'image'   => set_value('image', $row->image),
        );
        $this->load->view('roles_and_responsibilities/form', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Roles_and_responsibilities/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Roles_and_responsibilities/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) 
  {

    $id = base64_decode($update_id);
   
      if($_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/roles_and_responsibilities/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/roles_and_responsibilities/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      
      }
      else
      {
        $image = $_POST['old_image'];
      }

      $data = array(
        'role_id' => $this->input->post('role_id',TRUE),
        'image'=> $image,
      ); 

      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("roles_and_responsibilities",$data,$con);

      $this->Crud_model->DeleteData('corporate_responsibilities_mapping', "roles_respo_id='".$id."'");

      for($i = 0; $i < count($_POST['responsibility']); $i++)
             {
                if(!empty($_POST['responsibility'][$i])) {
                    $record = array(
                        'role_id' => $this->input->post('role_id',TRUE),
                        'roles_respo_id' => $id,
                        'responsibility' => $_POST['responsibility'][$i],
                        'responsibility_marathi' => $_POST['responsibility_marathi'][$i],
                        'responsibility_hindi' => $_POST['responsibility_hindi'][$i]
                    );
                    $this->Crud_model->SaveData('corporate_responsibilities_mapping',$record);
                }
            }

      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Updated successfully</span>');
      redirect('Roles_and_responsibilities/index');

  }


  public function changeStatus()
  {
    $change_status = $this->Crud_model->GetData('roles_and_responsibilities','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
      $this->Crud_model->SaveData('roles_and_responsibilities',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
      $this->Crud_model->SaveData('roles_and_responsibilities',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Roles_and_responsibilities/index');
  }

  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('roles_and_responsibilities', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Deleted successfully</span>');
    redirect('Roles_and_responsibilities/index');
  }

  // SEVER SIDE VALIDATION
  /*public function _rules($id) 
  {
    $cond = "id!='".$id."'";
    $row = $this->Crud_model->GetData("Roles_and_responsibilities",'',$cond,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[Roles_and_responsibilities.id]";
    }

    $this->form_validation->set_rules('role', 'role', 'trim|required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('responsibility', 'responsibility', 'trim|required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }*/
}