<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Professions extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model("Professions_model");
  }

  public function index() {
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Professions</li>
                    </ul>";
    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '3',
      'ajaxManagePage' => site_url('Professions/ajaxManagePage'),
      'addAction' => site_url('Professions/addData'),
      'updateAction' => site_url('Professions/updateData'),
      'deleteAction' => site_url('Professions/deleteData'),
      'changeAction' => site_url('Professions/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Professions'
    );
    $this->load->view('professions/professions_list', $data);       
  }

  public function ajaxManagePage() {
    $condition = "";
    $getData = $this->Professions_model->get_datatables($condition);
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $btn = '';
      $btn .= ('<a href="#myModaledit" title="Edit"  data-toggle="modal" class="btn btn-info btn-circle btn-sm" onclick="getEditValue('.$Data->id.');">
              <i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      $status = '';

      if($Data->status=='Active') {
        $status .=  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      } else {
        $status .=  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->profession);
      $row[] = $status;
      $row[] = $btn;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Professions_model->count_all($condition),
      "recordsFiltered" => $this->Professions_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

	public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_Professions','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active') {
        $this->Crud_model->SaveData('mst_professions',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
        $this->Crud_model->SaveData('mst_professions',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Professions/index');
  }
  
  public function addData() {
    $condDuplication = "profession='".$this->input->post('profession')."'";
    $duplication = $this->Crud_model->GetData('mst_professions','', $condDuplication);

    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(
        'profession' => $this->input->post('profession'),
        'profession_marathi' => $this->input->post('profession_marathi'),
        'profession_hindi' => $this->input->post('profession_hindi'),
      );
      $this->Crud_model->SaveData('mst_professions',$data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }      
  }

  public function updateData() {
    $condDuplication = "profession='".$this->input->post('profession')."' and id !='".$this->input->post('id')."'";
    $duplication = $this->Crud_model->GetData('mst_professions','', $condDuplication);
    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(                              
        'profession' => $this->input->post('profession'),               
        'profession_marathi' => $this->input->post('profession_marathi'),               
        'profession_hindi' => $this->input->post('profession_hindi'),               
      );
      $this->Crud_model->SaveData('mst_professions', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo 2;
    } 
  }

  public function deleteData() {
    $con = "id='".$_POST['id']."'";
    $data = array('is_delete' =>'Yes',);
    $this->Crud_model->SaveData('mst_professions',$data,$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Professions/index');
  }

  public function getUpdateName() {
    $row = $this->Crud_model->GetData('mst_professions','',"id='".$_POST['id']."'",'','','','row');   
    $data = array(
			'profession' => $row->profession,
      'profession_marathi' => $row->profession_marathi,
      'profession_hindi' => $row->profession_hindi,
			);
    echo json_encode($data);
  }

  public function import()
  {
      $file = $_FILES['excel_file']['tmp_name'];
      $this->load->library('excel');
      //read file from path
      $objPHPExcel = PHPExcel_IOFactory::load($file);
      $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);
      $arrayCount = count($allDataInSheet);
      $i = 1;

      foreach ($allDataInSheet as $val) 
      {
          if ($i == 1) 
          {

          }
          else
          {
              $fields_fun[] = $val;
          }
          $i++;
      }
       if(!isset($fields_fun))
        {
         
          $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
        redirect(site_url('Professions/index'));
          
        }
      $data = $fields_fun;
      
      $exists = 0;
      foreach ($data as $val) 
      {

          if(isset($val[0]) && $val[0]!='')
          {
              if(!preg_match("/^[A-Za-z' ]*$/",$val[0]))
              {
                   $type='Wrong Format';
                   $existProfessions[]=array($val[0],$type);
                  
              }
              else
              {
                 $checkExists = $this->Crud_model->GetData('mst_professions','',"profession='".trim($val[0])."'");
                  if(empty($checkExists))
                  {
                      $SaveState = $this->Crud_model->SaveData('mst_professions',array('profession'=>trim($val[0])));
                  }
                  else
                  {
                      $type='Duplicate Entry';
                      $existProfessions[]=array($val[0],$type);
                  }
              }
          }
          else
          {
             if(isset($val[0]) && !empty($val[0]))
              {
                $val[0] = $val[0];
              }
              else
              {
                $val[0]='';
              }
                $type='Wrong Format';
              $existProfessions[]=array($val[0],$type);
          }
      } 

      if(empty($existProfessions))
      {
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
        redirect(site_url('Professions/index'));
      }
      else
      {
          $data = array('existProfessions' => $existProfessions);
          $this->load->view('professions/duplicateProfessions',$data);
      }
  }

}