<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Police_eyes extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Police_eyes_model');
    $this->load->database();
  }

  public function index() 
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Eyes</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '7' ,
      'action' =>  site_url('Police_eyes/create') ,
      'ajax_manage_page' => site_url('Police_eyes/ajax_manage_page'),
      'heading' => 'Manage Police Eyes',
    );
    $this->load->view('police_eyes/list', $data);
  }

  public function ajax_manage_page() 
  {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mc.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
      
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mc.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $allData = $this->Police_eyes_model->get_datatables($condition);  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($allData as $row) 
    {
      $viewUrl = "Police_eyes/view";
      $btn = '<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Police_eyes/update";
      $btn .= '<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      /*
      $updateUrl = "Corporates/change_password";
      $btn .= '&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Corporates/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Reset Password" ' );
      */

      $btn .= '&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      
     
      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }


       if(strlen($row->camera_description)>100)
            {
                $desc=substr($row->camera_description,0,100).'.......';
            }
            else
            {
                $desc=$row->camera_description;
            }

       if($row->address=='')
      {
        $address = "N/A";            
      }
      else
      {
        $address =  $row->address;
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
     /* $nestedData[] = $row->zone_name;
      $nestedData[] = $row->area;*/
      $nestedData[] = $address;
      $nestedData[] = $desc;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_eyes_model->count_all($condition),
      "recordsFiltered" => $this->Police_eyes_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Police_eyes')."'>Manage Police Eyes</a></li>
                    <li class='active'>Create Police Eyes</li>
                  </ul>";

         // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");

      $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

     /*   $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No'","","zone_name asc");
        //print_r($zones);exit();
        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No'","","area asc");*/

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Eyes',
      'sub_title'=>'Create',
      'states' =>$states,
      'breadcrumbs' =>$breadcrumbs,
          'policeStations'    => $policeStations,
         /* 'zones'    => $zones,
          'areas'    => $areas,*/
      'action' => site_url("Police_eyes/create_action"), 
      'cancelbtn' => site_url('Police_eyes/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'country_id' => "101",
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
     /* 'zone_id' =>  set_value('zone_id',$this->input->post('zone_id')),
      'area_id' =>  set_value('area_id',$this->input->post('area_id')),*/
      'address' =>  set_value('address',$this->input->post('address')),
      'latitude' => set_value('lat',$this->input->post('lat')),
      'longitude' => set_value('lon',$this->input->post('lon')),
      'camera_description' =>  set_value('camera_description',$this->input->post('camera_description')),
    ); 
    $this->load->view('police_eyes/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
   // print_r($_POST);exit();
   		
   	 $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_eyes/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_eyes/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }		

      $data = array(
                       'country_id' => "101",
                       'state_id' => $this->input->post('state_id',TRUE),
                       'district_id' => $this->input->post('district_id',TRUE),
                       'city_id' => $this->input->post('city_id',TRUE),
                       'police_station_id' => $this->input->post('police_station_id',TRUE),
                      /*'zone_id' => $this->input->post('zone_id',TRUE),
                      'area_id' => $this->input->post('area_id',TRUE),*/
                       'address' => trim($this->input->post('address',TRUE)),
                       'latitude'    => $this->input->post('lat'),
                        'longitude'    => $this->input->post('lon'),
                       'camera_description' => trim($this->input->post('camera_description',TRUE)),
                       'image'=>$image,
                    );  
      $this->Crud_model->SaveData("mst_cameras",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_eyes/index');
    
  }

  //UPDATE 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_cameras",'',"id='".$id."'",'','','','1');
      //echo "<pre>"; print_r($row); die();

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Eyes</li>
                    </ul>";

      if(!empty($row)) 
      {
      
         // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
        // $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

      /*  $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No'","","zone_name asc");

        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No'","","area asc");*/
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Eyes',
          'breadcrumbs' => $breadcrumbs, 
          // 'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities, 
          'policeStations'    => $policeStations,
          /*'zones'    => $zones,
          'areas'    => $areas,*/
          'cancelbtn'   => site_url('Police_eyes/index'), 
          'action'    => site_url('Police_eyes/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'police_station_id'    => set_value('police_station_id', $row->police_station_id),
          /*'zone_id'    => set_value('zone_id', $row->zone_id),
          'area_id'    => set_value('area_id', $row->area_id),*/
          'address'   => set_value('address', $row->address),
          'latitude'   => set_value('lat', $row->latitude),
          'longitude'   => set_value('lon', $row->longitude),
          'camera_description'   => set_value('camera_description', $row->camera_description),
          'image'   => set_value('image', $row->image),

        );
        $this->load->view('police_eyes/form', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_eyes/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_eyes/index');
    }
  }



  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_eyes/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_eyes/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'country_id' => "101",
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
       /* 'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),*/
        'address' => trim($this->input->post('address',TRUE)),
        'latitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),
        'camera_description' => trim($this->input->post('camera_description',TRUE)),
        'image'=>$image,
       
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_cameras",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_eyes/index');
   
  }

  // VIEW
  public function view($id)
  {
    $cond = "id='".base64_decode($id)."'";
    $row = $this->Police_eyes_model->viewDetails($cond);
    // echo "<pre>"; print_r($row); die();
  

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Police_eyes/index').'">Manage Police Eyes</a></li>
                    <li class="active">Police Eye Details</li>
                  </ul>';

    $data = array(
        'row'=> $row,
        'breadcrumbs'=>$breadcrumbs, 
        
        );
   $this->load->view('police_eyes/view',$data);
  }
  
  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Police_eyes/index'));            
    } 
    $data = $fields_fun;
    // echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='')
      { 
         $getCamera = $this->Crud_model->GetData('mst_cameras','police_station_id',"police_station_id='".trim($val[3])."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[0]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[1]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[2]."'",'','','','single');
     

         /*for already exist check*/

         if(empty($getCamera))
         {
            if(!empty($val[5]))
            {
               $camera_description=$val[5];
            } 
            else
            {
               $camera_description="";
            }

            if(!empty($val[4]))
            {
               $address=$val[4];
            } 
            else
            {
               $address="";
            }

            if(!empty($getCamera))
            {
               $police_station_id=$getCamera->police_station_id;
            } 
            else
            {
               $police_station_id="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            $data = array(
               'country_id' => "101",
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'police_station_id' => $police_station_id,
               'address' => $address,
               'camera_description' => $camera_description,
            );
            $SaveAssets = $this->Crud_model->SaveData('mst_cameras',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],'Police eyes already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],'Mandatory fields empty');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Police_eyes/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('police_eyes/duplicatePoliceEyes',$data);
   } 
  }

  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_cameras', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_eyes/index');
  } 

  public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('mst_cameras','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') 
    {
      $this->Crud_model->SaveData('mst_cameras',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } 
    else 
    {
      $this->Crud_model->SaveData('mst_cameras',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Police_eyes/index");
  }

  public function getCityPoliceStation()
  {
    $zones = $this->Crud_model->GetData("mst_police_stations",'name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Police Station</option>';
      foreach($zones as $row)
      {
        $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select Police Station</option>';
    }
    echo $response;
  }

  /*public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row)
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }
*/


 /* public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"area asc");
    
    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else
    {
        $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }*/
 
 public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  } 
     
}