<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Police_Station_Head extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Police_Station_Head_model');
    $this->load->database();
  }

  public function index() 
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station Head</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '11' ,
      'action' =>  site_url('Police_Station_Head/create') ,
      'ajax_manage_page' => site_url('Police_Station_Head/ajax_manage_page'),
      'heading' => 'Manage Police Station Head',
    );
    $this->load->view('police_station_head/list', $data);
  }

  public function ajax_manage_page() 
  {

    $allData = $this->Police_Station_Head_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($allData as $row) 
    {
      $viewUrl = "Police_Station_Head/view";
      $btn = '<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Police_Station_Head/update";
      $btn .= '<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      /*
      $updateUrl = "Corporates/change_password";
      $btn .= '&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Corporates/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Reset Password" ' );
      */

      $btn .= '&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

    
     
      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      if($row->address=='')
      {
        $address = "N/A";            
      }
      else
      {
        $address =  $row->address;
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->station_head_name);
      $nestedData[] = ucfirst($row->email);
      $nestedData[] = ucfirst($row->mobile);
      $nestedData[] = ucfirst($row->gender);
      $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = ucfirst($row->higher_authority_name);
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_Station_Head_model->count_all(),
      "recordsFiltered" => $this->Police_Station_Head_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Police_Station_Head')."'>Police Station Head</a></li>
                    <li class='active'>Create Police Station Head</li>
                  </ul>";
$countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
 $designations = $this->Crud_model->GetData('mst_police_designations',"designation_name,id","status='Active' and is_delete='No'","","designation_name asc");
       $higherAuthority = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");

        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");


    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Station Head',
      'sub_title'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
      'countries' =>$countries,
          'higherAuthority'    => $higherAuthority,
          'policeStations'    => $policeStations,
          'designations'    => $designations,
       
      'action' => site_url("Police_Station_Head/create_action"), 
      'cancelbtn' => site_url('Police_Station_Head/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'higher_authority_id' =>  set_value('higher_authority_id',$this->input->post('higher_authority_id')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
      'station_head_name' =>  set_value('station_head_name',$this->input->post('station_head_name')),
      'designation_id' =>  set_value('designation_id',$this->input->post('designation_id')),
      'email' =>  set_value('email',$this->input->post('email')),
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'address' =>  set_value('address',$this->input->post('address')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'gender' =>  set_value('gender',$this->input->post('gender')),
    ); 
    $this->load->view('police_station_head/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
   // print_r($_POST);exit();
   
       $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_head/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_head/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
        
      /*  'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),*/
        
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'higher_authority_id' => $this->input->post('higher_authority_id',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'station_head_name' => trim($this->input->post('station_head_name',TRUE)),
        'designation_id' => trim($this->input->post('designation_id',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'pincode' => trim($this->input->post('pincode',TRUE)),
        'gender' => trim($this->input->post('gender',TRUE)),
        'image'=>$image,
      
      /*  'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),*/
      );  
      $this->Crud_model->SaveData("head_of_police_stations",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_Station_Head/index');
    
  }

  //UPDATE 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("head_of_police_stations",'',"id='".$id."'",'','','','1');
      //echo "<pre>"; print_r($row); die();

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station Head</li>
                    </ul>";

      if(!empty($row)) 
      {

        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");

         $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

       $higherAuthority = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");

        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Station Head',
          'breadcrumbs' => $breadcrumbs,
          'higherAuthority'    => $higherAuthority,
          'policeStations'    => $policeStations,
          'countries'    => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'cancelbtn'   => site_url('Police_Station_Head/index'), 
          'action'    => site_url('Police_Station_Head/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'higher_authority_id'    => set_value('higher_authority_id', $row->higher_authority_id),
          'police_station_id'    => set_value('police_station_id', $row->police_station_id),
          'address'   => set_value('address', $row->address),
          'pincode'   => set_value('pincode', $row->pincode),
          'station_head_name'   => set_value('station_head_name', $row->station_head_name),
          'designation_id'   => set_value('designation_id', $row->designation_id),
          'designation_id'   => set_value('designation_id', $row->designation_id),
          'designation_id'   => set_value('designation_id', $row->designation_id),
          'designation_id'   => set_value('designation_id', $row->designation_id),
          'email'   => set_value('email', $row->email),
          'mobile'   => set_value('mobile', $row->mobile),
          'gender'   => set_value('gender', $row->gender),
           'image'   => set_value('image', $row->image),
        );
        $this->load->view('police_station_head/form', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_Station_Head/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_Station_Head/index');
    }
  }



  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_head/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_head/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'higher_authority_id' => $this->input->post('higher_authority_id',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'station_head_name' => $this->input->post('station_head_name',TRUE),
        'designation_id' => $this->input->post('designation_id',TRUE),
        'name' => trim($this->input->post('name',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'pincode' => trim($this->input->post('pincode',TRUE)),
        'gender' => trim($this->input->post('gender',TRUE)),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("head_of_police_stations",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_Station_Head/index');
   
  }

  // VIEW
  public function view($id)
  {
    $cond = "id='".base64_decode($id)."'";
    $row = $this->Police_Station_Head_model->viewDetails($cond);
    //echo "<pre>"; print_r($row); die();
  

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Police_Station_Head/index').'">Manage Police Station Head</a></li>
                    <li class="active">Manage Police Station Head Details</li>
                  </ul>';

    $data = array(
        'row'=> $row,
        'breadcrumbs'=>$breadcrumbs, 
        
        );
   $this->load->view('police_station_head/view',$data);
  }
    
  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('head_of_police_stations', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_Station_Head/index');
  } 

  public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('head_of_police_stations','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') 
    {
      $this->Crud_model->SaveData('head_of_police_stations',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } 
    else 
    {
      $this->Crud_model->SaveData('head_of_police_stations',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Police_Station_Head/index");
  }

   public function getState() 
  {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

        $response = '<option value="">Select State</option>';
    if(!empty($states)) 
    {
      $response = '<option value="">Select State</option>';
      foreach($states as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }
    echo $response;
  }

  
  public function getDistrict()
  {
    $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        $response = '<option value="">Select District</option>';
    if(!empty($districts)) 
    {
      $response = '<option value="">Select District</option>';
      foreach($districts as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
      }
    }
    echo $response;
  }

  public function getCity()
  {
    $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

      $response = '<option value="">Select City</option>';
    if(!empty($cities)) 
    {
      foreach($cities as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
      }
    }
    echo $response;
  }

     
}