<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Police_Designations extends CI_Controller {

  function __construct()
    {
    parent::__construct();
    $this->load->model("Police_Designations_model");
    }

    //LIST VIEW
  public function index()
  {
        $breadcrumbs = "<ul class='breadcrumb'>
                    <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li class='active'>Manage Police Designation</li>
                    </ul>";
        $data = array(
        'breadcrumbs' => $breadcrumbs ,
        'actioncolumn' => '2' ,
        'ajax_manage_page' => site_url('Police_Designations/ajax_manage_page') ,
        'button' => 'Create',
        'heading' => 'Manage Police Designation',
        );
        $this->load->view('police_designations/designations_list',$data);
  }

   public function ajax_manage_page()
   {
     
      $getData = $this->Police_Designations_model->get_datatables();

        $data = array();
        if(empty($_POST['start']))
            {
                $no =0;   
            }
            else
            {
                $no =$_POST['start'];
            }
            foreach ($getData as $Data) {
              $btn = '';
               $updateUrl = "Police_Designations/update";
               $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($Data->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
            $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
            $status = '';
             if($Data->status=='Active')
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
              }
              else
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-warning label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
              }
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = ucfirst($Data->designation_name);
            $row[] = $status;
            $row[] = $btn;
            $data[] = $row;
        }
        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Police_Designations_model->count_all(),
          "recordsFiltered" => $this->Police_Designations_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
   		public function changeStatus(){
        //print_r($_POST);exit;
        $change_status = $this->Crud_model->GetData('mst_police_designations','',"id='".$_POST['id']."'",'','','','row');

        if($change_status->status=='Active')
        {
            $this->Crud_model->SaveData('mst_police_designations',array('status'=>'Inactive'),"id='".$_POST['id']."'");
        }
        else
        {
            $this->Crud_model->SaveData('mst_police_designations',array('status'=>'Active'),"id='".$_POST['id']."'");
        }
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
        redirect('Police_Designations/index');
    }
    
 public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Police_station/index')."'>Manage Police Designation</a></li>
    <li class='active'>Create Police Designation</li>
    </ol>";   

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Designation',
      'sub_title'=>'Create',      
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Police_Designations/create_action"), 
      'cancelbtn' => site_url('Police_Designations/index'), 
      'id' =>  set_value('id',$this->input->post('id')),      
      'designation_name' => set_value('designation_name',$this->input->post('designation_name')),
    ); 
    $this->load->view('police_designations/designations_form',$data);
   }
  public function create_action() 
  { 
   $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $data = array(            
        'designation_name' => $this->input->post('designation_name',TRUE),       
        'created'=> date('Y-m-d H:i:s'),
      ); 

      $this->Crud_model->SaveData("mst_police_designations",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_Designations/index');
  }
}

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_police_designations",'',"id='".$id."'",'','','','1'); 
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Designation</li>
                    </ul>";

      if(!empty($row)) {
       
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Designation',
          'breadcrumbs' => $breadcrumbs,         
          'cancelbtn'   => site_url('Police_Designations/index'), 
          'action'    => site_url('Police_Designations/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),          
          'designation_name'   => set_value('designation_name', $row->designation_name),
         
        );
     
        $this->load->view('police_designations/designations_form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('police_designations/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('police_designations/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) { 
      
      $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    { 
      $data = array(              
        'designation_name' => $this->input->post('designation_name',TRUE),        
      ); 
     if(!empty($update_id)) {
      $id = base64_decode($update_id);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police_designations",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_Designations/index');
    }
  }
}

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_police_designations', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_Designations/index');
  } 

  public function _rules($id) {
    $cond = "designation_name='".$this->input->post('designation_name',TRUE)."' ";
    $row = $this->Crud_model->GetData("mst_police_designations",'',$cond,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[mst_police_designations.designation_name]";
    }

   

    $this->form_validation->set_rules('designation_name', 'designation_name', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'Police designation name already exists'
    ));

    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }


     
}
