<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class GpsPetrollings extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('GpsPetrollings_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index() { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Gps Petrollings</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '15' ,
      'action' =>  site_url('GpsPetrollings/create') ,
      'ajax_manage_page' => site_url('GpsPetrollings/ajax_manage_page') ,
      'heading' => 'Manage Gps Petrollings',
    );
    $this->load->view('gps_petrollings/list', $data);
  }

  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "gp.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "gp.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $Data = $this->GpsPetrollings_model->get_datatables($condition);  
    //print_r($this->db->last_query());exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
      /*$updateUrl = "GpsPetrollings/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';*/

      $updateUrl = "GpsPetrollings/update";
      $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id).'/'.base64_encode($row->map_id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
      /* $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';*/
       
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $row->vehicle_type.' | '.$row->vehicle_name.' | '.$row->vehicle_no;     
      $nestedData[] = $row->address;
      $nestedData[] = date('d-m-Y',strtotime($row->from_date)) . ' to ' .date('d-m-Y',strtotime($row->to_date));
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->GpsPetrollings_model->count_all($condition),
      "recordsFiltered" => $this->GpsPetrollings_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('GpsPetrollings/index')."'>Manage Gps Petrollings</a></li>
    <li class='active'>Create Gps Petrollings</li>
    </ol>";
    $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101'","","state_name asc");
    $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
    $vehicleDetails = $this->Crud_model->GetData("mst_vehicles","","status='Active' and is_delete='No'","","vehicle_no asc");
    $policeDetails = $this->Crud_model->GetData('mst_police',"police_name,id","status='Active' and is_delete='No'","","police_name asc");
    $data = array(
      'button'=>'Create',
      'heading'=>'Create Gps Petrollings',
      'sub_title'=>'Create',
      'states' =>$states,
      'breadcrumbs' =>$breadcrumbs,
      'policeStations' =>$policeStations,
      'vehicleDetails' =>$vehicleDetails,
      'policeDetails' =>$policeDetails,
      'action' => site_url("GpsPetrollings/create_action"), 
      'cancelbtn' => site_url('GpsPetrollings/index'), 
      'id' =>  set_value('id',$this->input->post('id')),     
       'update_id' =>set_value('update_id',$this->input->post('update_id')),     
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'address' =>  set_value('address',$this->input->post('address')),     
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
      'police_id' =>  set_value('police_id',$this->input->post('police_id')),
      'vehicle_id' =>  set_value('vehicle_id',$this->input->post('vehicle_id')),
      'vehicle_type' =>  set_value('vehicle_type',$this->input->post('vehicle_type')),
      'from_date' =>  set_value('from_date',$this->input->post('from_date')),
      'to_date' =>  set_value('to_date',$this->input->post('to_date')),
    ); 
    $this->load->view('gps_petrollings/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    //  print_r($_POST);exit();        
      $data = array(
          'country_id' => '101',
          'state_id' => $this->input->post('state_id',TRUE),
          'district_id' => $this->input->post('district_id',TRUE),
          'city_id' => $this->input->post('city_id',TRUE),
          'police_station_id' => $this->input->post('police_station_id',TRUE),
          'from_date' => trim($this->input->post('from_date',TRUE)),
          'to_date' => trim($this->input->post('to_date',TRUE)),       
          'created'=> date('Y-m-d H:i:s'),
          );
      $this->Crud_model->SaveData("gps_petrollings",$data);
      $petrolling_id = $this->db->insert_id();
      foreach ($_POST['vehicle_id'] as $i=>$rowId) 
      {
      
          $data = array(
                'vehicle_id'  => $_POST['vehicle_id'][$i],       
                'petrolling_id' => $petrolling_id,                
                'address' => $_POST['address'][$i],                
                //'police_id' => $_POST['police_id'][$i],          
                'created' => date("Y-m-d H:i:s"),          
                );
                $this->Crud_model->SaveData("police_petrollings_map",$data);
               $police_petrollings_map_id = $this->db->insert_id(); 


               foreach ($_POST['police_id'][$i] as $j=>$police_id) {
                  $data2 = array(
                   'petrolling_id' =>$petrolling_id, 
                   'police_petrollings_map_id' =>$police_petrollings_map_id, 
                   'police_id' =>$_POST['police_id'][$i][$j], 
                   'created' => date("Y-m-d H:i:s"), 
                 );
                  $this->Crud_model->SaveData("police_petrollings_for_polices_map",$data2);
               }
         
      
    }
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('GpsPetrollings/index');
  }

  public function update($update_id,$up_id)
  {
      if(!empty($update_id))
      {
        $id = base64_decode($update_id);
        $up_id = base64_decode($up_id);
        //print_r($id);exit();
        $con=" gp.id='".$id."'";
        $row = $this->GpsPetrollings_model->getpetrollingDetails($con);
        //print_r($row);exit();
        $breadcrumbs="<ol class='breadcrumb'>
        <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
        <li><a href='".site_url('GpsPetrollings/index')."'>Manage Gps Petrollings</a></li>
        <li class='active'>Update Gps Petrollings</li>
        </ol>"; 
        if(!empty($row))
        {
            $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
            $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
            
            $policeDetails = $this->Crud_model->GetData('mst_police',"police_name,id","status='Active' and is_delete='No'","","police_name asc");
            $policeDetailscheck = $this->GpsPetrollings_model->getdetailspolicepetrollings("ppfm.petrolling_id='".$id."'");
            //print_r($this->db->last_query());exit;
           
            $vehicleDetails = $this->Crud_model->GetData("mst_vehicles","","status='Active' and is_delete='No'","","vehicle_no asc");
            $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101'","","state_name asc");
            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");
            $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

            $data = array(
                  'button'    => 'Update',
                  'heading'   => 'Update Gps Petrolling',
                  'breadcrumbs' => $breadcrumbs,
                  'policeStations'    => $policeStations,
                  'vehicleDetails'    => $vehicleDetails,
                  'policeDetails'    => $policeDetails,
                  'policeDetailscheck'    => $policeDetailscheck,
                  'countries'   => $countries,
                  'states'    => $states,
                  'districts'    => $districts,
                  'cities'    => $cities,
                  'cancelbtn'   => site_url('GpsPetrollings/index'), 
                  'action'    => site_url('GpsPetrollings/update_action'.'/'.$update_id.'/'.$up_id),
                  'id'      => set_value('id', $id),
                  'update_id' =>set_value('update_id', $up_id),
                  'police_station_id'    => set_value('police_station_id', $row->police_station_id),
                 
                  'state_id'    => set_value('state_id', $row->state_id),
                  'district_id'    => set_value('district_id', $row->district_id),
                  'vehicle_id'    => set_value('vehicle_id', $row->vehicle_id),
                  'police_id'    => set_value('police_id', $row->police_id),
                  'vehicle_type'    => set_value('vehicle_type', $row->vehicle_type),
                  'city_id'    => set_value('city_id', $row->city_id),
                  'address'   => set_value('address', $row->address),
                  'from_date'   => set_value('from_date', $row->from_date),
                  'to_date'   => set_value('to_date', $row->to_date),
            );

            $this->load->view('gps_petrollings/form', $data);
        }
        else 
        {
          print_r("expression");exit;
          $this->session->set_flashdata('message', 'Record Not Found');
          redirect('GpsPetrollings/index');
        }
      }
  } 


  public function update_action()
  {
    $id=$this->input->post('id',TRUE);
    $update_id=$this->input->post('update_id',TRUE);
  //print_r($_POST);exit();
      $data = array(
          'country_id' => '101',
          'state_id' => $this->input->post('state_id',TRUE),
          'district_id' => $this->input->post('district_id',TRUE),
          'city_id' => $this->input->post('city_id',TRUE),
          'police_station_id' => $this->input->post('police_station_id',TRUE),
          'from_date' => trim($this->input->post('from_date',TRUE)),
          'to_date' => trim($this->input->post('to_date',TRUE)),                  
         
          );
      $this->Crud_model->SaveData("gps_petrollings",$data,"id = '".$id."'");
      
    
      $this->Crud_model->DeleteData('police_petrollings_for_polices_map', "petrolling_id='".$id."' and police_petrollings_map_id='".$update_id."'");
      foreach ($_POST['vehicle_id'] as $i=>$rowId) 
      {
      
          $data = array(
                'vehicle_id'  => $_POST['vehicle_id'][$i],       
                'petrolling_id' => $id,                
                'address' => $_POST['address'][$i],                
                //'police_id' => $_POST['police_id'][$i],          
                'created' => date("Y-m-d H:i:s"),          
                );
                $this->Crud_model->SaveData("police_petrollings_map",$data,"id='".$update_id."'");
                $police_petrollings_map_id = $this->db->insert_id(); 
                


               foreach ($_POST['police_id'][$i] as $j=>$police_id) {
                  $data2 = array(
                   'petrolling_id' =>$id, 
                   'police_petrollings_map_id' =>$update_id, 
                   'police_id' =>$_POST['police_id'][$i][$j], 
                   'created' => date("Y-m-d H:i:s"), 
                 );
                  $this->Crud_model->SaveData("police_petrollings_for_polices_map",$data2);
               }
         
      
    }
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been Updated successfully</span>');
      redirect('GpsPetrollings/index');


  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }

    public function getpolicestation()
    {
      $policestation = $this->Crud_model->GetData("mst_police_stations","id,name","city_id='".$_POST['id']."' and is_delete='No' and status='Active'","","name asc");
        if(!empty($policestation)) {
            $response = '<option value="">Select Police Station</option>';
            foreach($policestation as $row) {
              $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
            }
          }else {
              $response = '<option value="">Select Police Station</option>';
          }
          echo $response;
    }
  
    public function getpolicedetails()
    {
    
      if($_POST['button']=="Update"){
        

        $addressdata = $this->Crud_model->GetData("police_petrollings_map","","id='".$_POST['update_id']."' and is_delete='No' and status='Active'","","",'','1'); 
        $policesdata = $this->Crud_model->GetData("police_petrollings_for_polices_map","police_id","police_petrollings_map_id='".$_POST['update_id']."' and is_delete='No' and status='Active'","","",'','');

        $policepersonlist = $this->Crud_model->GetData("mst_police","id,police_name","police_station_id='".$_POST['id']."' and is_delete='No' and status='Active' and designation_type='Police'","","police_name asc"); 
        $vehicleDetails = $this->Crud_model->GetData("mst_vehicles","","status='Active' and is_delete='No' and police_station_id='".$_POST['id']."' ","","vehicle_no asc");
       //print_r($policesdata[0]->police_id);exit();
        $polices_id=[];
        foreach ($policesdata as $i=>$value) {            
         $polices_id[$i]=$value->police_id;
        }
       // print_r($polices_id);exit();
        $data= array(
          'button'=>'Update',
          'policepersonlist' => $policepersonlist,
          'vehicleDetails' => $vehicleDetails,
          'police_id' =>  set_value('police_id',$polices_id),
          'address' =>  set_value('address',$addressdata->address),
          'vehicle_id' =>  set_value('vehicle_id',$addressdata->vehicle_id),
          //'vehicle_type' =>  set_value('vehicle_type',$this->input->post('vehicle_type')),
        );

      }else{
        $policepersonlist = $this->Crud_model->GetData("mst_police","id,police_name","police_station_id='".$_POST['id']."' and is_delete='No' and status='Active' and designation_type='Police'","","police_name asc"); 
        $vehicleDetails = $this->Crud_model->GetData("mst_vehicles","","status='Active' and is_delete='No' and police_station_id='".$_POST['id']."' ","","vehicle_no asc");
        $data= array(
          'button'=>'Create',
          'policepersonlist' => $policepersonlist,
          'vehicleDetails' => $vehicleDetails,
          'police_id' =>  set_value('police_id',$this->input->post('police_id')),
          'address' =>  set_value('address',$this->input->post('address')),
          'vehicle_id' =>  set_value('vehicle_id',$this->input->post('vehicle_id')),
          'vehicle_type' =>  set_value('vehicle_type',$this->input->post('vehicle_type')),
        );
      }
      $this->load->view('gps_petrollings/policelist',$data);
    }
   


}