<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Countries extends CI_Controller {

  public function __construct() 
  {
    parent::__construct();
    $this->load->model("Countries_model");
  }

  public function index() 
  {
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Countries</li>
                    </ul>";
    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '4',
      'ajaxManagePage' => site_url('Countries/ajaxManagePage'),
      'addAction' => site_url('Countries/addData'),
      'updateAction' => site_url('Countries/updateData'),
      'deleteAction' => site_url('Countries/deleteData'),
      'changeAction' => site_url('Countries/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Countries'
    );
    $this->load->view('countries/countries_list', $data);       
  }

  public function ajaxManagePage() 
  {
    $condition = "";
    $getData = $this->Countries_model->get_datatables($condition);
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $btn = '';
      $btn .= ('<a href="#myModaledit" title="Edit"  data-toggle="modal" class="btn btn-info btn-circle btn-sm" onclick="getEditValue('.$Data->id.');">
              <i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      $status = '';

      if($Data->status=='Active') {
        $status .=  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      } else {
        $status .=  "<a href='#checkStatus' data-toggle='modal'  class='label-warning label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = $Data->country_code;
      $row[] = $Data->country_name;
      $row[] = $status;
      $row[] = $btn;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Countries_model->count_all($condition),
      "recordsFiltered" => $this->Countries_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

	public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('mst_countries','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active') {
        $this->Crud_model->SaveData('mst_countries',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
        $this->Crud_model->SaveData('mst_countries',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Countries/index');
  }
  
  public function addData() {
    $condDuplication = "country_name='".trim($this->input->post('countryName'))."'";
    $duplication = $this->Crud_model->GetData('mst_countries','', $condDuplication);

    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(
        'country_code' => $this->input->post('countryCode'),
        'country_name' => $this->input->post('countryName'),
      );
      $this->Crud_model->SaveData('mst_countries',$data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }      
  }

  public function updateData() {
    $condDuplication = "country_name='".trim($this->input->post('countryName'))."' and id !='".$this->input->post('id')."'";
    $duplication = $this->Crud_model->GetData('mst_countries','', $condDuplication);
    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(                
        'country_code' => $this->input->post('countryCode'),                
        'country_name' => $this->input->post('countryName'),               
      );
      $this->Crud_model->SaveData('mst_countries', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo 2;
    } 
  }

  public function deleteData() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_countries',$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Countries/index');
  }

  public function getUpdateName() {
    $row = $this->Crud_model->GetData('mst_countries','',"id='".$_POST['id']."'",'','','','row');   
    $data = array(
			'country_code' => $row->country_code,
			'country_name' => $row->country_name,
			);
    echo json_encode($data);
  }

}