<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Complaints extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Complaints_model');
    $this->load->database();
  }

  public function index() { 
    //$cond ="status='Active' and department_name!='Others'";
    //$departments =  $this->Crud_model->GetData('mst_departments','',$cond);

    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Complaints</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs,
      //'departments' => $departments,
      'actioncolumn' => '8',
      'action' =>  site_url('Complaints/create'),
      'ajax_manage_page' => site_url('Complaints/ajax_manage_page'),
      'heading' => 'Manage Complaints',
    );
    $this->load->view('complaints/list', $data);
  }

  public function ajax_manage_page() {
    $Data = $this->Complaints_model->get_datatables();  

   //echo "<pre>";print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {


     if(strlen($row->description)>100)
      {
          $desc=substr($row->description,0,100).'.......';
      }
      else
      {
          $desc=$row->description;
      }

      if($row->corporate_id==0 || $row->branch_id==0)
      {
        $assignUrl = "Complaints/assign_complaint";
        //$btn ='<a href="#assignComplaint" data-toggle="modal" title="Assign" class="btn btn-info btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="fa fa-arrows-h"></i></a>&nbsp;|';

        $btn ='<a href="'.site_url($assignUrl.'/'.base64_encode($row->id)).'" title="Assign complaint" class="btn btn-info btn-circle btn-xs"><i class="fa fa-arrows-h"></i></a>&nbsp;|';

        $viewUrl = "Complaints/view";
       $btn .='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';


      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      } else {

       $viewUrl = "Complaints/view";
       $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';


      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
    }

      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      if($row->corporate_name=='')
      {
        $row->corporate_name = "Others";
      }
      else
      {
        $row->corporate_name;
      } 

      if($row->department_name=='')
      {
        $row->department_name = "N/A";
      }
      else
      {
        $row->department_name;
      }    


      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->name;
      //$nestedData[] = $row->email;
      //$nestedData[] = $row->mobile;
      //$nestedData[] = $row->department_name;
      $nestedData[] = $row->comp_code;
      $nestedData[] = $row->title;
      $nestedData[] = $desc;
      $nestedData[] = $row->corporate_name;
      $nestedData[] = $row->branch_name." "."(".$row->department_name.")";
      // $nestedData[] = $complaint_status;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Complaints_model->count_all(),
      "recordsFiltered" => $this->Complaints_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('complaints','',"id='".$_POST['id']."'",'','','','row');

    // if($change_status->complaint_status=='Pending') {
    //   $this->Crud_model->SaveData('complaints',array('complaint_status'=>'Approved'),"id='".$_POST['id']."'");
    // } else if($change_status->complaint_status=='Approved') {
    //   $this->Crud_model->SaveData('complaints',array('complaint_status'=>'In Progress'),"id='".$_POST['id']."'");
    // } else {
    //   $this->Crud_model->SaveData('complaints',array('complaint_status'=>'Resolved'),"id='".$_POST['id']."'");
    // }

    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('complaints',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('complaints',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Complaints/index");
  }


  public function getState() {
      $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"state_name asc");

      if(!empty($states)) {
        $response = '<option value="">Select State</option>';
        foreach($states as $row) {
          $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
        }
      }else {
          $response = '<option value="">Select State</option>';
      }
      echo $response;
    }

  
   public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

     public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }

       public function getZone()
    {
        $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"zone_name asc");

        if(!empty($zones)) {
          $response = '<option value="">Select Zone</option>';
          foreach($zones as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
          }
        }else {
            $response = '<option value="">Select Zone</option>';
        }
        echo $response;
    }



   public function getArea()
      {
        $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"area asc");
        
        if(!empty($areas)) {
          $response = '<option value="">Select Area</option>';
          foreach($areas as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
          }
        }else {
            $response = '<option value="">Select Area</option>';
        }
        echo $response;
    }

    public function getCorporate()
    {
        $corporates = $this->Crud_model->GetData("corporates",'name,id',"area_id='".$_POST['id']."' and status='Active' and is_delete='No' and role='Ward Member'",'',"name asc");

        if(!empty($corporates)) 
        {
          $response = '<option value="">Select Corporate</option>';
          foreach($corporates as $row) 
          {
            $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
          }
        }
        else 
        {
            $response = '<option value="">Select Corporate</option>';
        }
        echo $response;
    }

    public function getBranch()
    {
        $branches = $this->Crud_model->GetData("mst_department_branches",'branch_name,id',"area_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"branch_name asc");

        if(!empty($branches)) 
        {
          $response = '<option value="">Select Branch</option>';
          foreach($branches as $row) 
          {
            $response .= '<option value="'.$row->id.'">'.$row->branch_name.'</option>';
          }
        }
        else 
        {
            $response = '<option value="">Select Branch</option>';
        }
        echo $response;
    }


  public function assign_complaint($id) 
  {

      if(!empty($id)) {
      $id = base64_decode($id);

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Assign Complaint</li>
                    </ul>";

      $row = $this->Crud_model->GetData("complaints",'',"id='".$id."'",'','','','1'); 
      //echo "<pre>"; print_r($row); die();
      if(!empty($row)) {

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","zone_name asc");

        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No' and zone_id='".$row->zone_id."'","","area asc");

        $corporates = $this->Crud_model->GetData('corporates',"name,id","status='Active' and area_id='".$row->area_id."' and is_delete='No' and role='Ward Member'","","name asc");

        $branches = $this->Crud_model->GetData('mst_department_branches',"branch_name,id","status='Active' and id='".$row->branch_id."' and is_delete='No'","","branch_name asc");

        //echo "<pre>"; print_r($branches); die();

        $data=array(
          'button'    => 'Assign',
          'heading'   => 'Assign Complaint',
          'breadcrumbs' => $breadcrumbs,
          'cities'    => $cities,
          'zones'    => $zones,
          'areas'    => $areas,
          'branches'    => $branches,
          'corporates'    => $corporates,
          'cancelbtn'   => site_url('Complaints/index'), 
          'action'    => site_url('Complaints/assign_complaint_action'.'/'.$id),
          'id'      => set_value('id', $row->id),
          'city_id'    => set_value('city_id', $row->city_id),
          'zone_id'    => set_value('zone_id', $row->zone_id),
          'area_id'    => set_value('area_id', $row->area_id),
          'branch_id'    => set_value('branch_id', $row->branch_id),
          'corporate_id'    => set_value('corporate_id', $row->corporate_id),
        );
        //echo "<pre>"; print_r($data); die();
        $this->load->view('complaints/assign_complaint', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Complaints/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Complaints/index');
    }
  }

    //UPDATE ACTION
  public function assign_complaint_action($id) {
    
      $branches = $this->Crud_model->GetData("mst_department_branches",'',"id='".$this->input->post('branch_id',TRUE)."'",'','','','1');

      $data = array(
        
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'branch_id' => $this->input->post('branch_id',TRUE),
        'department_id' => $branches->department_id,
        'corporate_id' => $this->input->post('corporate_id',TRUE),
      ); 
      //echo "<pre>"; print_r($data); die();
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("complaints",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Complaint assigned successfully</span>');
      redirect('Complaints/index');
    }

    public function view($id)
    {
        $cond = "id='".base64_decode($id)."'";
        $row = $this->Complaints_model->viewCompDetails($cond);
        //echo "<pre>"; print_r($row); die();
        $professions = $this->Crud_model->GetData("mst_professions",'',"id='".$row->profession_id."'",'','','','1');

        $corporates = $this->Crud_model->GetData("corporates",'name, id',"id='".$row->approved_by."'",'','','','1');

        $complaint_images = $this->Crud_model->GetData("complaint_images",'',"complaint_id='".$row->id."'");

        $branches = $this->Crud_model->GetData("mst_department_branches",'',"id='".$row->branch_id."'",'','','','1');

        $zones = $this->Crud_model->GetData("mst_zones",'',"id='".$row->zone_id."'",'','','','1');

        $areas = $this->Crud_model->GetData("mst_areas",'',"id='".$row->area_id."'",'','','','1');

        $branchHead = $this->Crud_model->GetData("corporates",'name',"id='".$row->branch_emp_id."'",'','','','1');

        $complaint_feedbacks = $this->Crud_model->GetData("complaint_feedbacks",'',"complaint_id='".$row->id."'",'','','','');
        //echo "<pre>"; print_r($complaint_feedbacks); die();
        $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Complaints/index').'">Manage Complaint</a></li>
                        <li class="active">Complaint Details</li>
                        </ul>';

        $data = array(

                        'row'=> $row,
                        'professions'=> $professions,
                        'branches'=> $branches,
                        'zones'=> $zones,
                        'areas'=> $areas,
                        'corporates'=> $corporates,
                        //'dept_heads'=> $dept_heads,
                        'branchHead'=> $branchHead,
                        'citizen_image'=> $row->citizen_image,
                        'citizen_name'=> $row->citizen_name,
                        'citizen_email'=> $row->citizen_email,
                        'citizen_mobile'=> $row->citizen_mobile,
                        'citizen_gender'=> $row->citizen_gender,
                        'citizen_address'=> $row->citizen_address,
                        'citizen_pincode'=> $row->citizen_pincode,
                        'complaint_images'=> $complaint_images,
                        'corporate_name'=> $row->corporate_name,
                        'corporate_email'=> $row->corporate_email,
                        'corporate_mobile'=> $row->corporate_mobile,
                        'corporate_address'=> $row->corporate_address,
                        'mla'=> $row->mla,
                        'country_name'=> $row->country_name,
                        'state_name'=> $row->state_name,
                        'district_name'=> $row->district_name,
                        'city_name'=> $row->city_name,
                        'role'=> $row->role,
                        'breadcrumbs'=>$breadcrumbs, 
                        'id'=>$row->id,    
                        'title'=>$row->title,    
                        'description'=>$row->description,    
                        'latitude'=>$row->latitude,    
                        'longitude'=>$row->longitude,    
                        'status'=>$row->status,    
                        'department_name'=>$row->department_name,    
                        'comp_code'=>$row->comp_code,    
                        'created'=>$row->created,   
                        'status'=>$row->status,   
                        'date'=>$row->date,   
                        'time'=>$row->time,   
                        'complaint_feedbacks'=>$complaint_feedbacks,   
                  );
      //  print_r($data); die();
       $this->load->view('complaints/complaint_view',$data);
    }

    public function delete()
    {
        $con = "id='".$_POST['id']."'";
        $data = array('is_delete' =>'Yes',);
        $this->Crud_model->SaveData('complaints',$data,$con);

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
        redirect(site_url('Complaints'));
    }

    public function update()
    {
        $dept_id = $_POST['deptId']."'"; //echo $con; die();

        //$this->db->update("complaints");
        $this->db->set("dept_id", $dept_id);
        $this->db->update("complaints");

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Complaint assign successfully</span>');
        redirect(site_url('Complaints'));

        die();

        $data = array('dept_id');
        $this->Crud_model->SaveData('complaints',$data,$con);

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Complaint assign successfully</span>');
        redirect(site_url('Complaints'));
    }

    /* Function for order notification and play audio implemented by praful bagde */
    public function getNotification()
    {        
        $complaintsNotification = $this->Crud_model->getComplaintsData();

        if(count($complaintsNotification) > 0 )
        {
          echo 'ring'; 
        }
        else
        {
          echo ""; 
        }
    }

    public function read_notification() 
    {
        // $notification_id = $this->input->post('notification_id');
        // $complaint_id = $this->input->post('complaint_id');
        
        $data=array(
          'is_read'=> 'Yes'
        );

        /*$this->Crud_model->SaveData('notifications',$data,"id='".$notification_id."' OR id_type='".$complaint_id."' AND type='Complaint'");
        echo 1;*/

        $this->Crud_model->SaveData('notifications',$data,"is_read='No' and type='Complaint'");
        echo 1;
    }

}