<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Cities extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('Cities_model');
		$this->load->database();
	}

	public function index()
	{ 
		$breadcrumbs = "<ul class='breadcrumb'>
		<li>
		<i class='ace-icon fa fa-home home-icon'></i>
		<a href='".site_url('Dashboard')."'>Dashboard</a>
		</li>
		<li class='active'>Manage Cities</li>
		</ul>";

		$data = array(
			'breadcrumbs' => $breadcrumbs,
			'actioncolumn' => '5',
			'ajax_manage_page' => site_url('Cities/ajax_manage_page'),
			'heading' => 'Manage Cities',
		);
		$this->load->view('cities/list',$data);
	}

	public function ajax_manage_page()
	{
		$Data = $this->Cities_model->get_datatables();	
		$data = array();  
		if(empty($_POST['start']))
		{
			$no =0;   
		}
		else
		{
			$no =$_POST['start'];
		}      
		foreach($Data as $row) 
		{
			$updateUrl = "Cities/update";

			$btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
			$btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

			if($row->status=='Active')
		    {
		      $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
		    }
		    else
		    {
		      $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
		    }
			$no++;  
			$nestedData = array();
			$nestedData[] = $no;
			$nestedData[] = $row->country_name;
			$nestedData[] = $row->state_name;
			$nestedData[] = $row->district_name;
			$nestedData[] = $row->city_name;
			$nestedData[] = $status;
			$nestedData[] = $btn;
			$data[] = $nestedData;
			$selected = '';

		}

		$output = array(
			"draw" => $_POST['draw'],
			"recordsTotal" => $this->Cities_model->count_all(),
			"recordsFiltered" => $this->Cities_model->count_filtered(),
			"data" => $data,
		);
		echo json_encode($output);
	}

	public function create()
	{  
		//BREADCRUMBS
		$breadcrumbs="<ol class='breadcrumb'>
		<li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
		<li><a href='".site_url('Cities')."'>Manage Cities</a></li>
		<li class='active'>Create City</li>
		</ol>";
		$countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

		$data = array(
			'button'=>'Create',
			'heading'=>'Create City',
			'sub_title'=>'Create',
			'countries' =>$countries,
			'breadcrumbs' =>$breadcrumbs,
			'action' => site_url('Cities/create_action'), 
			'cancelbtn' => site_url('Cities/index'), 
			'id' =>  set_value('id',$this->input->post('id')),
			'country_id' =>  set_value('country_id',$this->input->post('country_id')),
			'state_id' =>  set_value('state_id',$this->input->post('state_id')),
			'district_id' =>  set_value('district_id',$this->input->post('district_id')),
			'city_name' =>  set_value('city_name',$this->input->post('city_name')),
			'city_name_marathi' =>  set_value('city_name_marathi',$this->input->post('city_name_marathi')),
			'city_name_hindi' =>  set_value('city_name_hindi',$this->input->post('city_name_hindi')),
		); 
		$this->load->view('cities/form',$data);
	}

	//ADD ACTION
	public function create_action() 
	{  
		$id = '0';
		$this->_rules($id);
		if($this->form_validation->run() == FALSE) 
		{  
			$this->create();
		} 
		else
		{  
			$data = array(
				'country_id' => $this->input->post('country_id',TRUE),
				'state_id' => $this->input->post('state_id',TRUE),
				'district_id' => $this->input->post('district_id',TRUE),
				'city_name' => trim($this->input->post('city_name',TRUE)),
				'city_name_marathi' => trim($this->input->post('city_name_marathi',TRUE)),
				'city_name_hindi' => trim($this->input->post('city_name_hindi',TRUE)),
				'created'=> date('Y-m-d H:i:s'),
			);  
			$this->Crud_model->SaveData("mst_cities",$data);
			$this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">City has been created successfully</span>');
			redirect('Cities/index');
		}
	}

	//UPDATE 
	public function update($update_id)
	{  
		if(!empty($update_id))
		{
			$id = base64_decode($update_id);

			$row = $this->Crud_model->GetData("mst_cities",'',"id='".$id."'",'','','','1'); 
			$breadcrumbs="<ol class='breadcrumb'>
			<li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
			<li><a href='".site_url('Cities')."'>Manage Cities</a></li>
			<li class='active'>Update City</li>
			</ol>";
			if(!empty($row))
			{
				$countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");
				$states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");
				$districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");
				$data=array(
					'button'	  => 'Update',
					'heading'	  => 'Update City',
					'breadcrumbs' => $breadcrumbs,
					'countries'   => $countries,
					'states'	  => $states,
					'districts'	  => $districts,
					'cancelbtn'	  => site_url('Cities'), 
					'action' 	  => site_url('Cities/update_action'.'/'.$update_id),
					'id'		  => set_value('id', $row->id),
					'country_id'  => set_value('country_id', $row->country_id),
					'state_id'	  => set_value('state_id', $row->state_id),
					'district_id' => set_value('district_id', $row->district_id),
					'city_name'	  => set_value('city_name', $row->city_name),
					'city_name_marathi'	  => set_value('city_name_marathi', $row->city_name_marathi),
					'city_name_hindi'	  => set_value('city_name_hindi', $row->city_name_hindi),
				);
				$this->load->view('cities/form',$data);
			}
			else
			{
				print_r("expression");exit;
				$this->session->set_flashdata('message', 'Record Not Found');
				redirect('Cities/index');
			}
		}
		else
		{
			print_r("expression1");exit;
			$this->session->set_flashdata('message', 'Record Not Found');
			redirect('Cities/index');
		}
	}

	//UPDATE ACTION
	public function update_action($update_id) 
	{
		$id = base64_decode($update_id);
		$this->_rules($id);
		if ($this->form_validation->run() == FALSE)
		{          
			$this->update($update_id);
		}
		else 
		{  
			$data = array(
				'country_id' => $this->input->post('country_id',TRUE),
				'state_id' => $this->input->post('state_id',TRUE),
				'district_id' => $this->input->post('district_id',TRUE),
				'city_name' => ucwords($this->input->post('city_name',TRUE)),
				'city_name_marathi' => trim($this->input->post('city_name_marathi',TRUE)),
				'city_name_hindi' => trim($this->input->post('city_name_hindi',TRUE)),
				'modified'=> date('Y-m-d H:i:s'),
			); 
			$id = $this->input->post('id', TRUE);
			$con  = "id = '".$id."'";
			$this->Crud_model->SaveData("mst_cities",$data,$con);
			$this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">City has been updated successfully</span>');
			redirect('Cities/index');
		}
	}

	public function delete()
	{
		$con = "id='".$_POST['id']."'";
		$this->Crud_model->SaveData('mst_cities', array('is_delete'=>'Yes'), $con);

		$this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">City deleted successfully</span>');
		redirect('Cities/index');
	} 

	public function changeStatus()
	{
		$change_status = $this->Crud_model->GetData('mst_cities','',"id='".$_POST['id']."'",'','','','row');
		if($change_status->status=='Active')
		{
			$this->Crud_model->SaveData('mst_cities',array('status'=>'Inactive'),"id='".$_POST['id']."'");
		}
		else
		{
			$this->Crud_model->SaveData('mst_cities',array('status'=>'Active'),"id='".$_POST['id']."'");
		}
		$this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
		redirect('Cities/index');
	}

	function getState()
    {
        $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"state_name asc");
        if(!empty($states))
        {
            $response = '<option value="">Select State</option>';
            foreach($states as $row)
            {
                 $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
            }
        }
        else
        {
             $response = '<option value="">Select State</option>';
        }

        echo $response;
    }

    function getDistrict()
    {
        $states = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"district_name asc");
        if(!empty($states))
        {
            $response = '<option value="">Select District</option>';
            foreach($states as $row)
            {
                 $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
            }
        }
        else
        {
             $response = '<option value="">Select District</option>';
        }

        echo $response;
    }

	public function _rules($id)
	{
		$cond = "city_name='".trim($this->input->post('city_name',TRUE))."' and id!='".$id."' and country_id='".$this->input->post('country_id',TRUE)."' and state_id='".$this->input->post('state_id',TRUE)."' and district_id='".$this->input->post('district_id',TRUE)."'";
		$row = $this->Crud_model->GetData("mst_cities",'',$cond,'','','','');
		$count = count($row); 
		if($count==0)
		{
			$is_unique = "";
		}
		else 
		{
			$is_unique = "|is_unique[mst_cities.city_name]";

		} 
		$this->form_validation->set_rules('city_name', 'city name', 'trim|required'.$is_unique,
			array(
				'required'      => 'Required',
				'is_unique'     => 'City already exists'
			));

		$this->form_validation->set_rules('id', 'id', 'trim');
		$this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
	}
}