<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bpatrak extends CI_Controller {
  

  public function __construct() {
    parent::__construct();
     $this->load->library('Excel');
    $this->load->model("Bpatrak_model");
  }


  public function index()
  {   

    $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Incidence Spot</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '6',
            'heading' => 'Incidence Spot',
            'ajax_manage_page' => site_url('Bpatrak/ajax_manage_page'),
          );
          $this->load->view('bpatrak/list',$data);
  }


  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $getData = $this->Bpatrak_model->get_datatables($condition);

    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {

      $viewUrl = "Bpatrak/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($Data->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

        if(empty($Data->description) || $Data->description=="" || $Data->description==null)
              {
                  $description =  "N/A";            
              }
              else
              {
                  if(strlen($Data->description)>100)
                  {
                      $description = substr($Data->description, 0,100).'...';
                  } else {
                      $description = $Data->description;                
                  }
              }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($Data->name);
      $nestedData[] = ucfirst($Data->police_name);
      $nestedData[] = $Data->incident_name;
      $nestedData[] = $description;
      $nestedData[] = date("d/m/Y", strtotime($Data->date));
      $nestedData[] = date("h:i:s", strtotime($Data->time));
      $nestedData[] = $Data->current_location;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Bpatrak_model->count_all($condition),
      "recordsFiltered" => $this->Bpatrak_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function view($id)
  {
    $id = base64_decode($id);
    $con="b.id='".$id."'";
    $row = $this->Bpatrak_model->viewBpatrakDetails($con);
    
    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Bpatrak/index').'">Manage Incidence Spot</a></li>
                    <li class="active">Incidence Spot Details</li>
                  </ul>';

    if(!empty($row))
    {
      $data = array(
        "breadcrumbs"=>$breadcrumbs,
        "cancelbtn"=>site_url('Bpatrak'),
        "station_name"=>$row->name,
        "police_name"=>$row->police_name,
        "current_location"=>$row->current_location,
        "incident_name"=>$row->incident_name,
        "description"=>$row->description,        
        "location"=>$row->current_location,        
        "date"=>$row->date,        
        "time"=>$row->time,        
        "image"=>$row->image,
        "video"=>$row->video,
      );
      $this->load->view('bpatrak/view', $data);
    }   
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Bpatrak/index');
    }         
  }

  public function export() {

        $filename = 'incidenceSpot_'.date('Ymd').'.csv'; 

         header("Content-Description: File Transfer"); 
         header("Content-Disposition: attachment; filename=$filename"); 
         header("Content-Type: application/csv; ");
        
        // get data
        $bpatrakData = $this->Bpatrak_model->getBpatrakData();
       // echo "<pre>";print_r($bpatrakData);exit(); 
        //echo "hey";exit(); 

        // file creation 
        $file = fopen('php://output','w');
        $header = array("Sr.No","Station Name","Police Name","Date","Time","Incident Name","Discription","Location","Image","Video"); 
        fputcsv($file, $header);
        $sr=1;

      foreach ($bpatrakData as $i=>$line){ 
      if(!empty($line->image)){
       $img=base_url('uploads/patrolling/'.$line->image);
      }else{
        $img="N/A";
      }
      if(!empty($line->video)){
       $video=base_url('uploads/patrolling/'.$line->video);
      }else{
        $video="N/A";
      }

        
            $keys['sr_no'] = $sr;
            $keys['station_name'] = strtoupper($line->name); 
            $keys['police_name'] = strtoupper($line->police_name);
            $keys['date'] = strtoupper($line->date);
            $keys['time'] = strtoupper($line->time);
            $keys['incident_name'] = strtoupper($line->incident_name);
            $keys['description'] = strtoupper($line->description);
            $keys['current_location'] = strtoupper($line->current_location);            
            $keys['image'] =  $img;
            $keys['video'] = $video;
            
          fputcsv($file,$keys); 
          $sr++;
        }
        fclose($file); 
        exit; 
    }


  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Bpatrak/index'));            
    } 
    $data = $fields_fun;
    //echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' )
      { 
         $police_station_id = $this->Crud_model->GetData('mst_police_stations','',"name='".trim($val[1])."'",'','','','single'); 

         $police_id = $this->Crud_model->GetData('mst_police','id',"police_name='".trim($val[2])."'",'','','','single'); 

       
     

         

            if(!empty($val[7]))
            {
               $current_location=$val[7];
            } 
            else
            {
               $current_location="";
            }

            if(!empty($val[6]))
            {
               $description=$val[6];
            } 
            else
            {
               $description="";
            }

            if(!empty($val[5]))
            {
               $incident_name=$val[5];
            } 
            else
            {
               $incident_name="";
            }

            if(!empty($val[4]))
            {
               $time=$val[4];
            } 
            else
            {
               $time="";
            }

            if(!empty($val[3]))
            {
               $date=$val[3];
            } 
            else
            {
               $date="";
            }

            if(!empty($police_station_id))
            {
               $police_station_id=$police_station_id->id;
            } 
            else
            {
               $police_station_id="";
            }
            if(!empty($police_id))
            {
               $police_id=$police_id->id;
            } 
            else
            {
               $police_id="";
            }

            
            $data = array(       
        "police_station_id"=>$police_station_id->id,
        'country_id'=> $police_station_id->country_id,
        'state_id'=> $police_station_id->state_id,
        'district_id'=> $police_station_id->district_id,
        'city_id'=> $police_station_id->city_id,
        "police_id"=>$police_id,
        "date"=> date("d/m/Y", strtotime($date)),        
        "time"=>date("h:i:s", strtotime($time)),        
        "incident_name"=>$incident_name,
        "description"=>$description,        
        "current_location"=>$current_location,
              
       
      );
            $SaveAssets = $this->Crud_model->SaveData('bpatrak',$data);
       
      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Mandatory fields empty');
      }
   }
     $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Bpatrak/index');
 } 
}