<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Authority extends CI_Controller 
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Authority_model");
    }

    public function index()
    {
        $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Authority</li>
                        </ul>";

        $data = array(
            'breadcrumbs' => $breadcrumbs,
            'actioncolumn' => '3',
            'ajax_manage_page' => site_url('Authority/ajax_manage_page'),
            'action' => site_url('Authority/create'),
            'deleteAction' => site_url('Authority/delete'),
            'changeAction' => site_url('Authority/changeStatus'),
            'button' => 'Create',
            'heading' => 'Manage Authority',
        );
        $this->load->view('authority/list',$data);
    }

    public function ajax_manage_page() 
    {
        $Data = $this->Authority_model->get_datatables();  
        //echo "<pre>"; print_r($Data); die();
        $data = array();  
        if(empty($_POST['start'])) {
          $no =0;   
        } else {
          $no =$_POST['start'];
        }

        foreach($Data as $row) {
          
          $updateUrl = "Authority/update";
          $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

          $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

          if($row->status=='Active')
            {
              $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
            }
            else
            {
              $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
            }

            if(!empty($row->image))
            {
              $image = '<img style="width: 150px; height:150px;" src="'.base_url().'uploads/authority/'.$row->image.'" class="img-thumbnail">';
            }
            else 
            {
              $image = '<img style="width: 150px; height:150px;" src="'.base_url().'uploads/authority/profile_default.png">';
            }

          $no++;  
          $nestedData = array();
          $nestedData[] = $no;
          $nestedData[] = ucfirst($row->title);
          //$nestedData[] = ucfirst($row->image);
          // $nestedData[] = '<img style="width: 150px; height:150px;" src="'.base_url().'uploads/authority/'.$row->image.'" class="img-thumbnail">';
          $nestedData[] = $image;
          $nestedData[] = $status;
          $nestedData[] = $btn;
          $data[] = $nestedData;
          $selected = '';

        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Authority_model->count_all(),
          "recordsFiltered" => $this->Authority_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
    
  public function create() {  
      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                            <i class='ace-icon fa fa-home home-icon'></i>
                            <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li><a href='".site_url('Authority')."'>Manage Authority</a></li>
                        <li class='active'>Add Authority</li>
                        </ul>";

        $data = array(
          'button'    => 'Create',
          'heading'   => 'Create Authority',
          'breadcrumbs' => $breadcrumbs,
          'action'    => site_url('Authority/create_action'),
          'cancelbtn'   => site_url('Authority/index'), 
          'id'      => set_value('id',$this->input->post('id')),
          'title'    => set_value('title',$this->input->post('title')),
          'title_marathi'    => set_value('title_marathi',$this->input->post('title_marathi')),
          'title_hindi'    => set_value('title_hindi',$this->input->post('title_hindi')),
        ); 
        $this->load->view('authority/form',$data);
  }


  public function create_action() {   
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) {  
      $this->create();
    } 
    else
     {
        //echo "<pre>"; print_r($_POST); die();
        $image='';
        if( $_FILES['image']['name']!='' )
        {
          $image= rand(0000,9999)."_".$_FILES['image']['name'];
          $config2['image_library'] = 'gd2';
          $config2['source_image'] =  $_FILES['image']['tmp_name'];
          $config2['new_image'] =   getcwd().'/uploads/authority/'.$image;
          $config2['upload_path'] =  getcwd().'/uploads/authority/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
          $this->image_lib->initialize($config2);
          if(!$this->image_lib->resize())
          {
            echo('<pre>');
            echo ($this->image_lib->display_errors());
            exit;
          }
        }

        $data = array(
          'title'    => trim($this->input->post('title')),
          'title_marathi'    => trim($this->input->post('title_marathi')),
          'title_hindi'    => trim($this->input->post('title_hindi')),
          'image'    => $image,
        );  
        $this->Crud_model->SaveData("mst_departments_parent",$data);
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Authority has been created successfully</span>');
        redirect('Authority/index');
    }
  }

  
    // VIEW
    public function view($id)
    {
        $cond = "id='".base64_decode($id)."'";
        $row = $this->Authority_model->branchMembers($cond);
        //echo "<pre>"; print_r($row); die();
        $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Authority/index').'">Manage Authority</a></l>
                        <li class="active">Authority Detail</li>
                      </ul>';

        $data = array(

                        'row'=> $row,
                        'breadcrumbs'=>$breadcrumbs, 
                        'id'=>$row->id,    
                        'department_name'=>$row->department_name,    
                        'title'=>$row->title,  
                        //'name'=>$row->name,  
                  );
       $this->load->view('authority/view',$data);
    }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_departments_parent",'',"id='".$id."'",'','','','1'); 
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Authority</li>
                    </ul>";

      if(!empty($row)) {
       
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Authority',
          'breadcrumbs' => $breadcrumbs,
          'cancelbtn'   => site_url('Authority/index'), 
          'action'    => site_url('Authority/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'title'   => set_value('title', $row->title),
          'title_marathi'   => set_value('title_marathi', $row->title_marathi),
          'title_hindi'   => set_value('title_hindi', $row->title_hindi),
          'image'   => set_value('image', $row->image),
        );
        $this->load->view('authority/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Authority/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Authority/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {

    $id = base64_decode($update_id);
    //echo $id; die;

    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } 
    else 
    {  
      $image=$_POST['old_image'];
      if($_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/authority/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/authority/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      
      }
      $data = array(
        'title' => trim($this->input->post('title',TRUE)),
        'title_marathi' => trim($this->input->post('title_marathi',TRUE)),
        'title_hindi' => trim($this->input->post('title_hindi',TRUE)),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_departments_parent",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Authority has been updated successfully</span>');
      redirect('Authority/index');
      
    }
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('mst_departments_parent','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
        $this->Crud_model->SaveData('mst_departments_parent',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('mst_departments_parent',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Authority/index');
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_departments_parent', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Branch deleted successfully</span>');
    redirect('Authority/index');
  } 

  public function getArea() {
      $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and status='Active'  and is_delete='No'",'',"area asc");

      if(!empty($areas)) {
        $response = '<option value="">Select Area</option>';
        foreach($areas as $row) {
          $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
        }
      }else {
          $response = '<option value="">Select Area</option>';
      }
      echo $response;
    }

  public function gettitle() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get title from json data
          $title = ($status=="OK")?$output->results[1]->formatted_title:'';
          
          if(!empty($title))
          {
              $dataKey['title']=$title;
          }    
          else
          {
              $dataKey['title']='';
          }    
         
      }
      else
      {
           $dataKey['title']='';
      }  
      echo json_encode($dataKey);exit;
}   

  
  public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Authority/index'));            
   } 
   $data = $fields_fun;
  //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='')
      { 
         $getBranch = $this->Crud_model->GetData('mst_departments_parent','title',"title='".trim($val[1])."'",'','','','single'); 
       
         $departments = $this->Crud_model->GetData('mst_departments','id',"department_name='".$val[0]."'",'','','','single'); 

         $areas = $this->Crud_model->GetData('mst_areas','id',"area='".$val[2]."'",'','','','single'); 
         /*for already exist check*/

         if(empty($getBranch))
         {

            if(!empty($val[4]))
            {
               $discription=$val[4];
            } 
            else
            {
               $discription="";
            }

            if(!empty($val[3]))
            {
               $title=$val[3];
            } 
            else
            {
               $title="";
            }

            if(!empty($areas))
            {
               $area_id=$areas->id;
            } 
            else
            {
               $area_id="";
            }

            if(!empty($val[1]))
            {
               $title=$val[1];
            } 
            else
            {
               $title="";
            }

            if(!empty($departments))
            {
               $department_id=$departments->id;
            } 
            else
            {
               $department_id="";
            }
  
            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'department_id' => $department_id,
               'title' => trim($title),
               'area_id' => $area_id,
               'title' => $title,
               'discription' => $discription,
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_departments_parent',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],'Branch already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Authority/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('authority/duplicateAuthority',$data);
   } 
}



  // SEVER SIDE VALIDATION
  public function _rules($id) {
      $cond = "title='".trim($this->input->post('title',TRUE))."' and id!='".$id."'";
      $row = $this->Crud_model->GetData("mst_departments_parent",'',$cond,'','','','');
      $count = count($row); 
      if($count==0) {
        $is_unique = "";
        
      } else {
        $is_unique = "|is_unique[mst_departments_parent.title]";
        
      } 

      $this->form_validation->set_rules('title', 'title', 'trim|required'.$is_unique,
      array(
        'required'      => 'Please enter %s',
        'is_unique'     => 'title already exists'
      ));

      
      $this->form_validation->set_rules('id', 'id', 'trim');
      $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}