<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Appointments extends CI_Controller {

   public function __construct() {
    parent::__construct();
    $this->load->model("Appointments_model");
  }
  
  public function index()
  {   
    
       $appointments = $this->Crud_model->GetData("appointments"); 

       $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Appointments</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'appointments' =>$appointments,
            'actioncolumn' => '6',
            'heading' => 'Manage Appointments',
            'ajax_manage_page' => site_url('Appointments/ajax_manage_page'),
          );
          $this->load->view('appointments/list',$data);
  }

  public function ajax_manage_page() {
    $condition = "";
    $getData = $this->Appointments_model->get_datatables($condition);
    //echo "<pre>"; print_r($getData); die();
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {

      if($Data->status=='Confirmed')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Confirmed </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Pending </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->citizens_name);
      $row[] = $Data->purpose;
      $row[] = ucfirst($Data->corporates_name);
      $row[] = date("d-m-Y", strtotime($Data->date));
      $row[] = date("h:i A", strtotime($Data->time));
      $row[] = $status;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Appointments_model->count_all($condition),
      "recordsFiltered" => $this->Appointments_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('appointments','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Confirmed')
    {
        $this->Crud_model->SaveData('appointments',array('status'=>'Pending'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('appointments',array('status'=>'Confirmed'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Appointments/index');
  }


}
