<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Sdpo extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Sdpo_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index($flag='') { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                        <li>Manage Masters</li>
                      <li class='active'>Manage SDPO</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '6' ,
      'action' =>  site_url('Sdpo/create') ,
      'ajax_manage_page' => site_url('Sdpo/ajax_manage_page'),
      'heading' => 'Manage SDPO',
    );
    $this->load->view('sdpo/list', $data);
  }

  public function ajax_manage_page() {

     
      
    if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "sdpo.district_id='".$row->district_id."' ";
      
    }else{
       $condition="1=1";
     }

    $Data = $this->Sdpo_model->get_datatables($condition);  
    //print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
     

       $updateUrl = "Sdpo/update";
      $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
    
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';



      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;  
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = $row->name;    
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Sdpo_model->count_all($condition),
      "recordsFiltered" => $this->Sdpo_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Sdpo/index')."'>Manage SDPO</a></li>
    <li class='active'>Create SDPO</li>
    </ol>";


    $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");    

    $data = array(
      'button'=>'Create',
      'heading'=>'Create SDPO ',
      'sub_title'=>'Create',
      'states' =>$states,  
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Sdpo/create_action"), 
      'cancelbtn' => site_url('Sdpo/index'), 
      'id' =>  set_value('id',$this->input->post('id')),     
      'country_id' => '101',
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),      
      'name' =>  set_value('name',$this->input->post('name')),     
         
      
    ); 
    $this->load->view('sdpo/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {
        $data = array(
          'country_id' => '101',
          'state_id' => $this->input->post('state_id',TRUE),
          'district_id' => $this->input->post('district_id',TRUE),
          'city_id' => $this->input->post('city_id',TRUE),
          'name' => $this->input->post('name',TRUE),    
          'created'=> date('Y-m-d H:i:s'),
        ); 
        $this->Crud_model->SaveData("mst_sdpo",$data);
        
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
        redirect('Sdpo/index');
    }
  }

  //UPDATE 
  public function update($update_id) {
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_sdpo",'',"id='".$id."'",'','','','1'); 

  
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage SDPO</li>
                    </ul>";

      if(!empty($row)) {       

        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
          $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update SDPO',
          'breadcrumbs' => $breadcrumbs,        
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'cancelbtn'   => site_url('Sdpo/index'), 
          'action'    => site_url('Sdpo/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),          
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'name'   => set_value('name', $row->name),
          
        );
      
        $this->load->view('sdpo/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Sdpo/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Sdpo/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE)
    {          
      $this->update($update_id);
    }
    else 
    { 
  
        $data = array(
          'country_id' => '101',
          'state_id' => $this->input->post('state_id',TRUE),
          'district_id' => $this->input->post('district_id',TRUE),
          'city_id' => $this->input->post('city_id',TRUE),
          'name' => $this->input->post('name',TRUE),
        );        
        $this->Crud_model->SaveData('mst_sdpo',$data,"id='".$id."'");     
      
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
        redirect('Sdpo/index');
    }
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData("mst_sdpo",$con);
   
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Sdpo/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_sdpo','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('mst_sdpo',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('mst_sdpo',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Sdpo/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }

  public function _rules($id)
  {
    $cond = "city_id='".$this->input->post('city_id',TRUE)."' and id!='".$id."' ";
    $row = $this->Crud_model->GetData("mst_sdpo",'',$cond,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else 
    {
      $is_unique = "|is_unique[mst_sdpo.name]";
    } 

    $this->form_validation->set_rules('name', 'name', 'trim|required'.$is_unique,
    array(
      'required'      => 'Required',
      'is_unique'     => 'SDPO name already exists'
    ));

    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
    

}