<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Polices extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Polices_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index() { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Polices</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '10' ,
      'action' =>  site_url('Polices/create') ,
      'ajax_manage_page' => site_url('Polices/ajax_manage_page') ,
      'heading' => 'Manage Polices',
    );
    $this->load->view('polices/list', $data);
  }

  public function ajax_manage_page() {
     if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "admins.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "admins.district_id='".$row->district_id."'";
      
    }else{

    $condition = "1=1";
    }
    $Data = $this->Polices_model->get_datatables($condition);  

    // print_r($this->db->last_query());exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
       $updateUrl = "Polices/view";

      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "Polices/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

       $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
        $img="";
      if(!empty($row->image))
          {
            
            if(!file_exists("uploads/polices/".$row->image))
              {  //print_r("hii");
                $img ='<img height="100px" width="100px" class="img-thumbnail img-responsive" src="'.base_url('uploads/profile_default.png').'">';
              }
            else
              { 
                 
                 $img ='<a href="'.base_url('uploads/polices/'.$row->image).'" data-lightbox="roadtrip"><img height="100px" width="100px" class="img-thumbnail img-responsive" src="'.base_url('uploads/polices/'.$row->image).'" style="height:100px;width:100px"></a>';
              }
          }

        

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
        $desig_type='';
        if($row->designation_type =='Head_Person')
        {
          $desig_type = 'Head Person';
        }
        elseif($row->designation_type =='Station_Head')
        {
          $desig_type = 'Station Head';
        }
        elseif($row->designation_type =='Police')
        {
          $desig_type = 'Police';
        }
        if($row->police_station_name=="" || empty($row->police_station_name)){
          $police_station_name="N/A";
        }else{
         $police_station_name=ucfirst($row->police_station_name);
        }
        if($row->police_name=="" || empty($row->police_name)){
          $police_name="N/A";
        }else{
         $police_name=ucfirst($row->police_name);
        }
        if($row->buckal_number=="" || empty($row->buckal_number)){
          $buckal_number="N/A";
        }else{
         $buckal_number=ucfirst($row->buckal_number);
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $police_station_name;
      $nestedData[] = $police_name;
      $nestedData[] = $buckal_number;
      $nestedData[] = $desig_type;
      $nestedData[] = $img;
      // $nestedData[] = $row->designation_name;     
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      $nestedData[] = $row->gender;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Polices_model->count_all($condition),
      "recordsFiltered" => $this->Polices_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Polices/index')."'>Manage Police</a></li>
    <li class='active'>Create Police</li>
    </ol>";
    // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
    $condition="status='Active' and is_delete='No'";
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition.=" and police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition.=" and district_id='".$row->district_id."'";
    }
    $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
    $designations = $this->Crud_model->GetData('mst_police_designations',"designation_name,id","status='Active' and is_delete='No'","","designation_name asc");
     $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id",$condition,"","name asc");
     $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
    $data = array(
      'button'=>'Create',
      'heading'=>'Create Polices',
      'sub_title'=>'Create',
      'states' =>$states,
      'breadcrumbs' =>$breadcrumbs,
      'designations' =>$designations,
      'policeStations' =>$policeStations,
      'police_departments' =>$police_departments,
      'action' => site_url("Polices/create_action"), 
      'cancelbtn' => site_url('Polices/index'), 
      'id' =>  set_value('id',$this->input->post('id')),     
      'country_id' => '101',
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'designation_id' =>  set_value('designation_id',$this->input->post('designation_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'password' =>  set_value('password',$this->input->post('password')),
      'police_name' =>  set_value('police_name',$this->input->post('police_name')),     
      'email' =>  set_value('email',$this->input->post('email')),      
      'address' =>  set_value('address',$this->input->post('address')), 
      'latitude' => set_value('lat',$this->input->post('lat')),
      'longitude' => set_value('lon',$this->input->post('lon')),    
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'gender' =>  set_value('gender',$this->input->post('gender')),
      'designation_type' =>  set_value('designation_type',$this->input->post('designation_type')),
      'show_password' =>  set_value('show_password',$this->input->post('show_password')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
      'buckal_number' =>  set_value('buckal_number',$this->input->post('buckal_number')),
      'aadhar_number' =>  set_value('aadhar_number',$this->input->post('aadhar_number')),
      'pan_number' =>  set_value('pan_number',$this->input->post('pan_number')),
      // 'department_id' =>  set_value('department_id',$this->input->post('department_id')),
    ); 
    $this->load->view('polices/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/polices/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/polices/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
               
        'police_name' => trim($this->input->post('police_name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => '101',
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'designation_id' => $this->input->post('designation_id',TRUE),
        'password' => md5($this->input->post('password',TRUE)),
        'show_password' => $this->input->post('password',TRUE),
        'address' => trim($this->input->post('address',TRUE)), 
        'latitude'    => $this->input->post('lat'),
        'longitude'    => $this->input->post('lon'),      
        'pincode' => $this->input->post('pincode',TRUE),
        'gender' => $this->input->post('gender',TRUE),
        'designation_type' => $this->input->post('designation_type',TRUE),
        
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'buckal_number' => $this->input->post('buckal_number',TRUE),
        'aadhar_number' => $this->input->post('aadhar_number',TRUE),
        'pan_number' => $this->input->post('pan_number',TRUE),
        // 'department_id' => $this->input->post('department_id',TRUE),

         'image'=>$image,           
        'created'=> date('Y-m-d H:i:s'),
      ); 
      $this->Crud_model->SaveData("mst_police",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Polices/index');
    }
  }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_police",'',"id='".$id."'",'','','','1'); 
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Polices
               </li>
                    </ul>";

      if(!empty($row)) {
        // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
        // $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");
        $condition="status='Active' and is_delete='No'";
        if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
           $user = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
          $condition.=" and police_station_id='".$user->police_station_id."'";
          
        }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
           $user = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
          $condition.=" and district_id='".$user->district_id."'";
        }
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");

          if($_SESSION[SESSION_NAME]['type']=='Head_Person' || $_SESSION[SESSION_NAME]['type']=='Station_Head'){

            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."' and id='".$row->district_id."'","","district_name asc");
          } else {
            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");
          }


        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
           $designations = $this->Crud_model->GetData('mst_police_designations',"designation_name,id","status='Active' and is_delete='No'","","designation_name asc");
            $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id",$condition,"","name asc");
             $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police',
          'breadcrumbs' => $breadcrumbs,
          // 'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'designations'    => $designations,
          'policeStations'    => $policeStations,
          'police_departments'    => $police_departments,
          'cancelbtn'   => site_url('Polices/index'), 
          'action'    => site_url('Polices/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'designation_id'  => set_value('designation_id',$row->designation_id),
          'password'   => set_value('password', $row->password),         
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),          
          'police_name'   => set_value('police_name', $row->police_name),
          'email'   => set_value('email', $row->email),
          'address'   => set_value('address', $row->address),
          'latitude'   => set_value('lat', $row->latitude),
          'longitude'   => set_value('lon', $row->longitude),
          'mobile'   => set_value('mobile', $row->mobile),
          'pincode'   => set_value('pincode', $row->pincode),
          'image'   => set_value('image', $row->image),         
           'gender' =>  set_value('gender',$row->gender),
           'designation_type' =>  set_value('designation_type',$row->designation_type),
           'show_password' =>  set_value('show_password',$row->show_password),
           'police_station_id' =>  set_value('police_station_id',$row->police_station_id),
           'buckal_number' =>  set_value('buckal_number',$row->buckal_number),
           'aadhar_number' =>  set_value('aadhar_number',$row->aadhar_number),
           'pan_number' =>  set_value('pan_number',$row->pan_number),
           // 'department_id' =>  set_value('department_id',$row->department_id),
        );
      
        $this->load->view('polices/form', $data);
      } else {
       
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Polices/index');
      }
    } else {

      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Polices/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } 
    else 
    {  

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/polices/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/polices/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)),                    
        'police_name' => trim($this->input->post('police_name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'designation_id' => $this->input->post('designation_id',TRUE),
        'country_id' => '101',
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),        
        'address' => trim($this->input->post('address',TRUE)), 
        'latitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),      
        'pincode' => $this->input->post('pincode',TRUE),       
        'gender' => $this->input->post('gender',TRUE),
         'password' => $this->input->post('password',TRUE),
         'show_password' => $this->input->post('show_password',TRUE),
        'designation_type' => $this->input->post('designation_type',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'buckal_number' => $this->input->post('buckal_number',TRUE),
        'aadhar_number' => $this->input->post('aadhar_number',TRUE),
        'pan_number' => $this->input->post('pan_number',TRUE),
        // 'department_id' => $this->input->post('department_id',TRUE),
         'image'=>$image,           
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Polices/index');
    }
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_police', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Polices/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_police','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('mst_police',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('mst_police',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Polices/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='admin'){
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }
     public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }

  
  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"area asc");

    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

 public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Polices/index'));            
    } 
    $data = $fields_fun;
    // echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' && $val[8] !='' && $val[9] !='' && $val[10] !=' '&& $val[11] !='' && $val[12] !='')
      { 
         $getPolice = $this->Crud_model->GetData('mst_police','mobile',"mobile='".trim($val[4])."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[5]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[6]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[7]."'",'','','','single');
     

         /*for already exist check*/

         if(empty($getPolice))
         {

            if(!empty($val[12]))
            {
               $address=$val[12];
            } 
            else
            {
               $address="";
            }

            if(!empty($val[11]))
            {
               $pan_number=$val[11];
            } 
            else
            {
               $pan_number="";
            }

            if(!empty($val[10]))
            {
               $aadhar_number=$val[10];
            } 
            else
            {
               $aadhar_number="";
            }

            if(!empty($val[9]))
            {
               $buckal_number=$val[9];
            } 
            else
            {
               $buckal_number="";
            }

            if(!empty($val[8]))
            {
               $pincode=$val[8];
            } 
            else
            {
               $pincode="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($val[4]))
            {
               $mobile=$val[4];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[3]))
            {
               $designation_id=$val[3];
            } 
            else
            {
               $designation_id="";
            }

            if(!empty($val[2]))
            {
               $password=$val[2];
            } 
            else
            {
               $password="";
            }

            if(!empty($val[1]))
            {
               $email=$val[1];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[0]))
            {
               $police_name=$val[0];
            } 
            else
            {
               $police_name="";
            }

            $data = array(
               'police_name' => trim($police_name),
               'email' => trim($email),
               'password' => md5($password),
               'show_password' => $password,
               'designation_id' => $designation_id,
               'mobile' => trim($mobile),
               'country_id' => "101",
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'pincode' => $pincode,
               'buckal_number' => $buckal_number,
               'aadhar_number' => $aadhar_number,
               'pan_number' => $pan_number,
               'address' => $address,
            );
            $SaveAssets = $this->Crud_model->SaveData('mst_police',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[11],$val[12],'Police already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[11],$val[12],'Mandatory fields empty');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Polices/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('polices/duplicatePolices',$data);
   } 
  }


  public function _rules($id) {
    $cond_email = "email='".$this->input->post('email',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police",'',$cond_email,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[mst_police.email]";
    }

    $cond_mobile = "mobile='".$this->input->post('mobile',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police",'',$cond_mobile,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique2 = "";
    }
    else
    {
      $is_unique2 = "|is_unique[mst_police.mobile]";
    }


    $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'email already exists'
    ));

    $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'mobile already exists'
    ));

    $this->form_validation->set_rules('police_name', 'higher authority name', 'trim|required', array('required' => 'Please enter %s'));


    // $this->form_validation->set_rules('country_id', 'country', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('district_id', 'district', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('city_id', 'city', 'trim|required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }

   public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  }
  
   public function view($id)
  {
    
    $row = $this->Polices_model->getHigherAuthoritiesDetails("admins.id='".$id."'");

    $taskDetails = $this->Polices_model->taskDetails($row->id);

    $breadcrumbs='<ul class="breadcrumb">
    <li>
    <i class="ace-icon fa fa-home home-icon"></i>
    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
    </li>
    <li><a href="'.site_url('Polices/index').'">Manage Polices</a></li>
    <li class="active"><a >Police Detail</a></li>
    </ul>';
    $desig_type='';
        if($row->designation_type =='Head_Person')
        {
          $desig_type = 'Head Person';
        }
        elseif($row->designation_type =='Station_Head')
        {
          $desig_type = 'Station Head';
        }
        elseif($row->designation_type =='Police')
        {
          $desig_type = 'Police';
        }
    if(!empty($row)) 
    {

          $data = array(

                          'breadcrumbs'=>$breadcrumbs, 
                          'taskDetails'=>$taskDetails, 
                          'cancelbtn' => site_url('Polices/index'),
                          'id'=>$row->id,    
                          'name'=>$row->police_name,    
                          'police_station_name'=>$row->police_station_name,    
                          'email'=>$row->email,    
                          'mobile'=>$row->mobile,   
                          'image'=>$row->image,                             
                          'country'=>$row->country_name, 
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name, 
                          'address'=>$row->address, 
                          'pincode'=>$row->pincode, 
                          'show_password'=>$row->show_password, 
                          // 'designation_name'=>$row->designation_name, 
                          'designation_type'=>$desig_type, 
                          'gender'=>$row->gender, 
                          'status'=>$row->status,   
                    );
         $this->load->view('polices/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('Polices/index/'));
  }
}

}