<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Police_station extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Police_station_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index($flag='') { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '8' ,
      'action' =>  site_url('Police_station/create') ,
      'ajax_manage_page' => site_url('Police_station/ajax_manage_page'),
      'heading' => 'Manage Police Station',
    );
    $this->load->view('police_station/list', $data);
  }

  public function ajax_manage_page() {
    $Data = $this->Police_station_model->get_datatables();  
    //print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
       $updateUrl = "Police_station/view";

      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "Police_station/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
    
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';



      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      /*$nestedData[] = ucfirst($row->higher_authority_name);*/
      $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = $row->zone_name;
      $nestedData[] = $row->area;
    /*  $nestedData[] = $img;*/
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_station_model->count_all(),
      "recordsFiltered" => $this->Police_station_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Police_station/index')."'>Manage Police Station</a></li>
    <li class='active'>Create Police Station</li>
    </ol>";
    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
     $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
     $police_higher_authorities = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");
     $head_of_police_stations = $this->Crud_model->GetData('head_of_police_stations',"station_head_name,id","status='Active' and is_delete='No'","","station_head_name asc");

   // $designations = $this->Crud_model->GetData('mst_designations',"designation_name,id","status='Active'","","designation_name asc");

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Station',
      'sub_title'=>'Create',
      'countries' =>$countries,
      'police_higher_authorities' =>$police_higher_authorities,
      'head_of_police_stations' =>$head_of_police_stations,
      'police_departments' =>$police_departments,
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Police_station/create_action"), 
      'cancelbtn' => site_url('Police_station/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'higher_authority_id' =>  set_value('higher_authority_id',$this->input->post('higher_authority_id')),
      'station_head_id' =>  set_value('station_head_id',$this->input->post('station_head_id')),
      'department_id' =>  set_value('department_id',$this->input->post('department_id')),
     
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'zone_id' =>  set_value('zone_id',$this->input->post('zone_id')),
      'area_id' =>  set_value('area_id',$this->input->post('area_id')),
      'name' =>  set_value('name',$this->input->post('name')),     
      'email' =>  set_value('email',$this->input->post('email')),      
      'address' =>  set_value('address',$this->input->post('address')),     
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'gender' =>  set_value('gender',$this->input->post('gender')),
    ); 
    $this->load->view('police_station/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
     //print_r($_POST);exit(); 
    //echo "<pre>"; print_r($_POST); die();
  
      $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_image/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_image/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)),        
        

        'name' => trim($this->input->post('name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),
        'gender' => $this->input->post('gender',TRUE),
         'image'=>$image,           
        'created'=> date('Y-m-d H:i:s'),
      ); 
      $this->Crud_model->SaveData("mst_police_stations",$data);
      $last_id=$this->db->insert_id();
      foreach($_POST['department_id'] as $i=>$row){
        $data1 = array(
        'police_station_id' => $last_id,
        'station_head_id' => $_POST['station_head_id'][$i],
        'department_id' => $_POST['department_id'][$i],
      );
      $this->Crud_model->SaveData("police_station_department_map",$data1);

      }
      

      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_station/index');
   
  }

  //UPDATE 
  public function update($update_id) { 
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_police_stations",'',"id='".$id."'",'','','','1'); 
  
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station</li>
                    </ul>";

      if(!empty($row)) {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
          $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","zone_name asc");
            $area = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No' and zone_id='".$row->zone_id."'","","area asc");
       $police_station_department = $this->Crud_model->GetData('police_station_department_map',"","police_station_id='".$row->id."'","","");
       $police_higher_authorities = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");
     $head_of_police_stations = $this->Crud_model->GetData('head_of_police_stations',"station_head_name,id","status='Active' and is_delete='No'","","station_head_name asc");
      $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
     //print_r($row);exit(); 
     $department_id=[];
     $station_head_id=[];
     $j=0;
     foreach ($police_station_department as $i=>$psd) {

       $department_id[$j]=$psd->department_id;
       $station_head_id[$j]=$psd->station_head_id;
       $j++;
     }
   //print_r($department_id);exit();
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Station',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'zones'    => $zones,
          'area'    => $area,
          'police_station_department'    => $police_station_department,
          'police_higher_authorities'    => $police_higher_authorities,
          'head_of_police_stations'    => $head_of_police_stations,
          'police_departments'    => $police_departments,
          //'designations'    => $designations,
          'cancelbtn'   => site_url('Police_station/index'), 
          'action'    => site_url('Police_station/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'higher_authority_id'  => set_value('higher_authority_id', $row->higher_authority_id),
          'department_id'    => $department_id,
          'station_head_id'    => $station_head_id,
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'zone_id'   => set_value('zone_id', $row->zone_id),
          'area_id'   => set_value('area_id', $row->area_id),
          
          'name'   => set_value('name', $row->name),
          'email'   => set_value('email', $row->email),
          'address'   => set_value('address', $row->address),
          'mobile'   => set_value('mobile', $row->mobile),
          'pincode'   => set_value('pincode', $row->pincode),
          'image'   => set_value('image', $row->image),
        );
       // print_r($data);exit();
        $this->load->view('police_station/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_station/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_station/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
   // print_r($_POST);exit();
    $id = base64_decode($update_id);

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_image/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_image/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)),        
         
        'name' => trim($this->input->post('name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),
         'image'=>$image,           
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police_stations",$data,$con);
      $last_id=$this->db->insert_id();
      foreach($_POST['department_id'] as $i=>$row){
        $data1 = array(
        'police_station_id' => $last_id,
        'station_head_id' => $_POST['station_head_id'][$i],
        'department_id' => $_POST['department_id'][$i],
      );
      $this->Crud_model->SaveData("police_station_department_map",$data1,'id="'.$last_id.'"');

      }
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_station/index');
   
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_police_stations', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_station/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_police_stations','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('mst_police_stations',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('mst_police_stations',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Police_station/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }
     public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }

  
  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"area asc");

    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

  public function import()
  {
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Sub_admin/index'));            
   } 
   $data = $fields_fun;
  
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' || $val[1] !='' || $val[2] !='' || $val[3] !='' || $val[4] !='' || $val[5] !='' || $val[6] !='' || $val[7] !='')
      { 
         $getAdmins = $this->Crud_model->GetData('mst_police_stations','mobile',"mobile='".$val[6]."'",'','','','single'); 

         $countries = $this->Crud_model->GetData('mst_countries','id',"country_name='".$val[3]."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[4]."'",'','','','single'); 

         //$districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[6]."'",'','','','single'); 

         //$cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[5]."'",'','','','single');

         /*for already exist check*/

         if(empty($getAdmins))
         {

             if(!empty($val[7]))
            {
               $address=$val[7];
            } 
            else
            {
               $address="";
            }

            if(!empty($val[6]))
            {
               $mobile=$val[6];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[5]))
            {
               $city=$val[5];
            } 
            else
            {
               $city="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($countries))
            {
               $country_id=$countries->id;
            } 
            else
            {
               $country_id="";
            }


            if(!empty($val[2]))
            {
               $password=$val[2];
            } 
            else
            {
               $password="";
            }

            if(!empty($val[1]))
            {
               $email=$val[1];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }


            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'name' => $name,
               'email' => $email,
               'password' => $password,
               'country_id' => $country_id,
               'state_id' => $state_id,
               'city' => $city,
               'mobile' => $mobile,
               'address' => $address,
               'image'  => 'profile_default.png',
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_police_stations',$data);
         }
         else
         { 
            $existAssets[]=array($val[6],'Already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[11],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Imported successfully</span>');
      redirect('Sub_admin/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('sub_admin/duplicate',$data);
   } 
}

 
   public function view($id)
  {
    
    $row = $this->Police_station_model->getSubAdminDetails("admins.id='".$id."'"); 
   // print_r($row);exit();

     $breadcrumbs='<ul class="breadcrumb">
    <li>
    <i class="ace-icon fa fa-home home-icon"></i>
    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
    </li>
    <li><a href="'.site_url('Police_station/index').'">Manage Police Station</a></li>
    <li class="active"><a >Police Station Details</a></li>
    </ul>';

    if(!empty($row)) 
    {
        
         // $dept_id=explode(",", $row->dept_id);
         // print_r($dept_id);exit();
          $data = array(

                          /*'row'=> $row,*/
                          'breadcrumbs'=>$breadcrumbs, 
                          'id'=>$row->id,    
                          'name'=>$row->name,    
                          'email'=>$row->email,    
                          'mobile'=>$row->mobile,   
                          'image'=>$row->image,   
                        // 'higher_authority_name'=>$row->higher_authority_name,   
                          //'station_head_id'=>$row->station_head_id,   
                          'country'=>$row->country_name, 
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name,    
                          'zone'=>$row->zone_name,    
                          'area'=>$row->area,    
                          'address'=>$row->address, 
                          'pincode'=>$row->pincode, 
                          'status'=>$row->status,   
                    );
         // print_r($data);exit();
         $this->load->view('Police_station/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('Police_station/index/'));
  }
}

public function change_password($id)
    { 
     // print_r($id);exit();

        $id = base64_decode($id);
      $clientData=$this->Crud_model->GetData("mst_police_stations","","id='".$id."'",'','','','1');
        $password = rand(000000,999999);
   //  print_r($password);exit();

        $data = array(
        'password' => md5($password),
        'show_password' => $password 
        );
      //  print_r($data);exit();
        $this->Crud_model->SaveData("mst_police_stations",$data,"id='".$id."'");   

        /*$row = $this->Crud_model->GetData("clients","","id='".$id."'");

        /* $settings = $this->Common_model->GetData('settings','sitetitle,favicon,header_logo','id="1"','','','','1');*/

          /*$mail_body=$this->Common_model->GetData("mst_mail_body","","mail_subject='Change Password'");

          
          $mail_body[0]->template=str_replace("{user_name}",ucfirst($_SESSION[SESSION_NAME]['name']),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{email}",($_SESSION[SESSION_NAME]['email']),$mail_body[0]->template);*/
        /*  $mail_body[0]->template=str_replace("{company_name}",ucfirst($settings->sitetitle),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{Company_logo}","<img src='".base_url('admin/uploads/logo/'.$settings->header_logo)."'>",$mail_body[0]->template);*/

        /*  $subject=$mail_body[0]->subject;
          $body=$mail_body[0]->template;
          $to = $_SESSION[SESSION_NAME]['email'];
          $MailData = array('mailoutbox_to'=>$to,'mailoutbox_subject'=>$subject,'mailoutbox_body'=>$body);*/
         //print_r($body);
          //$this->SendMail->Send($MailData);
          /* if($this->email->send())
         { 
          $this->session->set_flashdata('message', '<div style="color:green">Your are password changed successfully, please check your email</div>');
                            }else {
          $this->session->set_flashdata("message","<div style='color:red'>Error in sending email</div>"); 
                }
           }  
          
        $this->session->set_flashdata('message', 'Password has been changed successfully');
        redirect(site_url('clients'));
}*/
     $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Password changed succesfully.Credentials has send to register email.</span>');
    redirect("Sub_admin/index");
}
}