<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Police_higher_authorities extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Police_higher_authorities_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index() { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Higher Authorities</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '15' ,
      'action' =>  site_url('Police_higher_authorities/create') ,
      'ajax_manage_page' => site_url('Police_higher_authorities/ajax_manage_page') ,
      'heading' => 'Manage Police Higher Authorities',
    );
    $this->load->view('police_higher_authorities/list', $data);
  }

  public function ajax_manage_page() {
    $Data = $this->Police_higher_authorities_model->get_datatables();  
    //print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
       $updateUrl = "Police_higher_authorities/view";

      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "Police_higher_authorities/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

       $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
       $img="";
      if(!empty($row->image))
      {
        $img=" <a class='example-image-link' href='". base_url('uploads/police_higher_authorities/'.$row->image)."' data-lightbox='example-set'>
        <img src='".base_url('uploads/police_higher_authorities/'.$row->image)."'style='width:100px;'></a>";
      }


      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->higher_authority_name);
      $nestedData[] = $img;
      $nestedData[] = $row->designation_name;     
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      $nestedData[] = $row->gender;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_higher_authorities_model->count_all(),
      "recordsFiltered" => $this->Police_higher_authorities_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Police_higher_authorities/index')."'>Manage Police Higher Authorities</a></li>
    <li class='active'>Create Police Higher Authorities</li>
    </ol>";
    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
    $designations = $this->Crud_model->GetData('mst_police_designations',"designation_name,id","status='Active' and is_delete='No'","","designation_name asc");

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Higher Authorities',
      'sub_title'=>'Create',
      'countries' =>$countries,
      'breadcrumbs' =>$breadcrumbs,
      'designations' =>$designations,
      'action' => site_url("Police_higher_authorities/create_action"), 
      'cancelbtn' => site_url('Police_higher_authorities/index'), 
      'id' =>  set_value('id',$this->input->post('id')),     
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'designation_id' =>  set_value('designation_id',$this->input->post('designation_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
     
      'higher_authority_name' =>  set_value('higher_authority_name',$this->input->post('higher_authority_name')),     
      'email' =>  set_value('email',$this->input->post('email')),      
      'address' =>  set_value('address',$this->input->post('address')),     
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'gender' =>  set_value('gender',$this->input->post('gender')),
    ); 
    $this->load->view('police_higher_authorities/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
     // print_r($_POST);exit(); 
    //echo "<pre>"; print_r($_POST); die();

    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_higher_authorities/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_higher_authorities/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
               
        'higher_authority_name' => trim($this->input->post('higher_authority_name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'designation_id' => $this->input->post('designation_id',TRUE),
        
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),
        'gender' => $this->input->post('gender',TRUE),
         'image'=>$image,           
        'created'=> date('Y-m-d H:i:s'),
      ); 
      $this->Crud_model->SaveData("mst_police_higher_authorities",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_higher_authorities/index');
    }
  }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_police_higher_authorities",'',"id='".$id."'",'','','','1'); 
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Higher Authorities</li>
                    </ul>";

      if(!empty($row)) {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
           $designations = $this->Crud_model->GetData('mst_police_designations',"designation_name,id","status='Active' and is_delete='No'","","designation_name asc");
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Higher Authorities',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'designations'    => $designations,
          'cancelbtn'   => site_url('Police_higher_authorities/index'), 
          'action'    => site_url('Police_higher_authorities/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'designation_id'  => set_value('designation_id',$row->designation_id),         
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),          
          'higher_authority_name'   => set_value('higher_authority_name', $row->higher_authority_name),
          'email'   => set_value('email', $row->email),
          'address'   => set_value('address', $row->address),
          'mobile'   => set_value('mobile', $row->mobile),
          'pincode'   => set_value('pincode', $row->pincode),
          'image'   => set_value('image', $row->image),         
           'gender' =>  set_value('gender',$row->gender),
        );
       // print_r($data);exit();
        $this->load->view('Police_higher_authorities/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_higher_authorities/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_higher_authorities/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } 
    else 
    {  

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_higher_authorities/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_higher_authorities/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)),                    
        'higher_authority_name' => trim($this->input->post('higher_authority_name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'designation_id' => $this->input->post('designation_id',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),        
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),       
        'gender' => $this->input->post('gender',TRUE),
         'image'=>$image,           
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police_higher_authorities",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_higher_authorities/index');
    }
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_police_higher_authorities', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_higher_authorities/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_police_higher_authorities','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('mst_police_higher_authorities',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('mst_police_higher_authorities',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Police_higher_authorities/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }
     public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }

  
  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"area asc");

    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

  public function _rules($id) {
    $cond_email = "email='".$this->input->post('email',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police_higher_authorities",'',$cond_email,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[mst_police_higher_authorities.email]";
    }

    $cond_mobile = "mobile='".$this->input->post('mobile',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police_higher_authorities",'',$cond_mobile,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique2 = "";
    }
    else
    {
      $is_unique2 = "|is_unique[mst_police_higher_authorities.mobile]";
    }


    $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'email already exists'
    ));

    $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'mobile already exists'
    ));

    $this->form_validation->set_rules('higher_authority_name', 'higher authority name', 'trim|required', array('required' => 'Please enter %s'));


    $this->form_validation->set_rules('country_id', 'country', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('district_id', 'district', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('city_id', 'city', 'trim|required', array('required' => 'Please enter %s'));

    //$this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }

   public function view($id)
  {
    
    $row = $this->Police_higher_authorities_model->getHigherAuthoritiesDetails("admins.id='".$id."'"); 
    //print_r($row);exit();

     $breadcrumbs='<ul class="breadcrumb">
    <li>
    <i class="ace-icon fa fa-home home-icon"></i>
    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
    </li>
    <li><a href="'.site_url('Police_higher_authorities/index').'">Manage Police Higher Authorities</a></li>
    <li class="active"><a >Police Police Higher Authorities</a></li>
    </ul>';

    if(!empty($row)) 
    {
        
         // $dept_id=explode(",", $row->dept_id);
         // print_r($dept_id);exit();
          $data = array(

                          /*'row'=> $row,*/
                          'breadcrumbs'=>$breadcrumbs, 
                          'id'=>$row->id,    
                          'name'=>$row->higher_authority_name,    
                          'email'=>$row->email,    
                          'mobile'=>$row->mobile,   
                          'image'=>$row->image,                             
                          'country'=>$row->country_name, 
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name, 
                          'address'=>$row->address, 
                          'pincode'=>$row->pincode, 
                          'designation_name'=>$row->designation_name, 
                          'gender'=>$row->gender, 
                          'status'=>$row->status,   
                    );
        // print_r($data);exit();
         $this->load->view('police_higher_authorities/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('Police_higher_authorities/index/'));
  }
}

}