<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Police_activities extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model("Police_activities_model");
  }

  public function index() {
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li>Tasks</li>
                      <li class='active'>Manage Police Tasks</li>
                    </ul>";
    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '3',
      'ajaxManagePage' => site_url('Police_activities/ajaxManagePage'),
      'addAction' => site_url('Police_activities/addData'),
      'updateAction' => site_url('Police_activities/updateData'),
      'deleteAction' => site_url('Police_activities/deleteData'),
      'changeAction' => site_url('Police_activities/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Police Tasks'
    );
    $this->load->view('police_activities/list', $data);       
  }

  public function ajaxManagePage() {
    $condition = "";
    $getData = $this->Police_activities_model->get_datatables($condition);
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $btn = '';
      $btn .= ('<a href="#myModaledit" title="Edit"  data-toggle="modal" class="btn btn-info btn-circle btn-sm" onclick="getEditValue('.$Data->id.');">
              <i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      $status = '';

      if($Data->status=='Active') {
        $status .=  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      } else {
        $status .=  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->name);
      $row[] = $status;
      $row[] = $btn;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_activities_model->count_all($condition),
      "recordsFiltered" => $this->Police_activities_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

	public function changeStatus() {
    $change_status = $this->Crud_model->GetData('police_activities','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active') {
        $this->Crud_model->SaveData('police_activities',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
        $this->Crud_model->SaveData('police_activities',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Police_activities/index');
  }
  
  public function addData() {
    $condDuplication = "name='".$this->input->post('name')."'";
    $duplication = $this->Crud_model->GetData('police_activities','', $condDuplication);

    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(
        'name' => $this->input->post('name'),
      /*  'profession_marathi' => $this->input->post('profession_marathi'),
        'profession_hindi' => $this->input->post('profession_hindi'),*/
      );
      $this->Crud_model->SaveData('police_activities',$data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }      
  }

  public function updateData() {
    $condDuplication = "name='".$this->input->post('name')."' and id !='".$this->input->post('id')."'";
    $duplication = $this->Crud_model->GetData('police_activities','', $condDuplication);
    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(                              
        'name' => $this->input->post('name'),               
      /*  'profession_marathi' => $this->input->post('profession_marathi'),               
        'profession_hindi' => $this->input->post('profession_hindi'),             */  
      );
      $this->Crud_model->SaveData('police_activities', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo 2;
    } 
  }

  public function deleteData() {
    $con = "id='".$_POST['id']."'";
    $data = array('is_delete' =>'Yes',);
    $this->Crud_model->SaveData('police_activities',$data,$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_activities/index');
  }

  public function getUpdateName() {
    $row = $this->Crud_model->GetData('police_activities','',"id='".$_POST['id']."'",'','','','row');   
    $data = array(
			'name' => $row->name,
      /*'profession_marathi' => $row->profession_marathi,
      'profession_hindi' => $row->profession_hindi,*/
			);
    echo json_encode($data);
  }

 /* public function import()
  {
      $file = $_FILES['excel_file']['tmp_name'];
      $this->load->library('excel');
      //read file from path
      $objPHPExcel = PHPExcel_IOFactory::load($file);
      $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);
      $arrayCount = count($allDataInSheet);
      $i = 1;

      foreach ($allDataInSheet as $val) 
      {
          if ($i == 1) 
          {

          }
          else
          {
              $fields_fun[] = $val;
          }
          $i++;
      }
       if(!isset($fields_fun))
        {
         
          $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
        redirect(site_url('Police_activities/index'));
          
        }
      $data = $fields_fun;
      
      $exists = 0;
      foreach ($data as $val) 
      {

          if(isset($val[0]) && $val[0]!='')
          {
              if(!preg_match("/^[A-Za-z' ]*$/",$val[0]))
              {
                   $type='Wrong Format';
                   $existPolice_activities[]=array($val[0],$type);
                  
              }
              else
              {
                 $checkExists = $this->Crud_model->GetData('mst_professions','',"profession='".trim($val[0])."'");
                  if(empty($checkExists))
                  {
                      $SaveState = $this->Crud_model->SaveData('mst_professions',array('profession'=>trim($val[0])));
                  }
                  else
                  {
                      $type='Duplicate Entry';
                      $existPolice_activities[]=array($val[0],$type);
                  }
              }
          }
          else
          {
             if(isset($val[0]) && !empty($val[0]))
              {
                $val[0] = $val[0];
              }
              else
              {
                $val[0]='';
              }
                $type='Wrong Format';
              $existPolice_activities[]=array($val[0],$type);
          }
      } 

      if(empty($existPolice_activities))
      {
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
        redirect(site_url('Police_activities/index'));
      }
      else
      {
          $data = array('existPolice_activities' => $existPolice_activities);
          $this->load->view('professions/duplicatePolice_activities',$data);
      }
  }*/

}