<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Incidence_analysis extends CI_Controller {

   public function __construct() {
    parent::__construct();
    $this->load->model("Incidence_analysis_model");
     
  }
  
 
  public function index()
  {   
       
       $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li>Reports</li>
       <li class='active'>Incidence Analysis</li>
       </ol>";
       if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $cond = "district_id='".$row->district_id."' and status='Active' and is_delete='No'";
    }else{
      $cond ="status='Active' and is_delete='No'";
    }
         $police_station = $this->Crud_model->GetData("mst_police_stations",'id,name',$cond,"","name asc","","");
    $police_name = $this->Crud_model->GetData("mst_police",'id,police_name',$cond,"","police_name asc","","");
          $police_designation = $this->Crud_model->GetData("mst_police_designations",'',"status='Active' and is_delete='No'","","designation_name asc","","");
          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'police_station' =>$police_station,
            'police_designation' =>$police_designation,
            'police' =>$police_name,
            'actioncolumn' => '6',
            'heading' => 'Manage Incidence Analysis ',
            'ajax_manage_page' => site_url('Incidence_analysis/ajax_manage_page'),             
          );
          $this->load->view('incidence_analysis/list',$data);
  }

  public function ajax_manage_page() 
  {
     ini_set('max_execution_time', '30000');
     ini_set('memory_limit', '2048M');
       $row = $this->Crud_model->GetData("mst_police",'district_id,police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'and status='Active' and is_delete='No'","","","","1");
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       
      $condition = "sa.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){


    $from_date = $_POST['SearchData1'];
    $to_date = $_POST['SearchData2'];
    $police_station = $_POST['SearchData3'];
    $police_name = $_POST['SearchData4'];
    
    /*$condition = " ";*/
    $condition = "bp.district_id='".$row->district_id."' and bp.id<>0";
    if($from_date!='' && $to_date!='')
    {
        $condition .=" and bp.created  >= '".$from_date."' and bp.created  <= '".$to_date."' "; 
    }
    if($police_station!='')
    {
        $condition .=" and bp.police_station_id ='".$police_station."' ";
    }
    if($police_name!='')
    {
        $condition .=" and bp.police_id ='".$police_name."' ";
    }
    
      
    }else{

      $from_date = $_POST['SearchData1'];
    $to_date = $_POST['SearchData2'];
    $police_station = $_POST['SearchData3'];
    $police_name = $_POST['SearchData4'];
     
    $condition = "bp.id<>0";
    if($from_date!='' && $to_date!='')
    {
        $condition .=" and bp.created  >= '".$from_date."' and bp.created  <= '".$to_date."' "; 
    }
    if($police_station!='')
    {
        $condition .=" and  bp.police_station_id ='".$police_station."' ";
    }
    if($police_name!='')
    {
        $condition .=" and bp.police_id ='".$police_name."' ";
    }
    

   
    }
   
    $Data = $this->Incidence_analysis_model->get_datatables($condition); 
    //print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) { 
    $viewUrl = "Bpatrak/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';   

      
        if (!empty($row->current_location)) {
         $current_location=$row->current_location;
        }else{
          $current_location='N/A'; 
        }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->ps_name;
      $nestedData[] = $row->p_name;     
      $nestedData[] = $row->incident_name;     
      $nestedData[] = $row->date;
      $nestedData[] = $row->time;
      $nestedData[] = $row->location;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }
    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Incidence_analysis_model->count_all($condition),
      "recordsFiltered" => $this->Incidence_analysis_model->count_filtered($condition),
      "data" => $data,     
    );
    echo json_encode($output);
  }


  
 public function export_csv() 
{   
     if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id,city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "sa.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      
       $condition = "cc.id<>0 and sa.city_id='".$row->city_id."'";
       if($this->input->post('from_date')!='' && $this->input->post('to_date')!='')
    {
        $condition .=" and cc.created  between '".$this->input->post('from_date')."' and '".$this->input->post('to_date')."' "; 
    }
    if($this->input->post('police_station')!='')
    {
        $condition .=" and sa.police_station_id ='".$this->input->post('police_station')."' ";
    }
    if($this->input->post('police')!='')
    {
        $condition .=" and cc.police_id ='".$this->input->post('police')."' ";
    }
     if($this->input->post('police_designation')!='')
    {
        $condition .=" and p.designation_id ='".$this->input->post('police_designation')."' ";
    }
      
    }else{

       $condition = "cc.id<>0";
       if($this->input->post('from_date')!='' && $this->input->post('to_date')!='')
    {
        $condition .=" and cc.created  between '".$this->input->post('from_date')."' and '".$this->input->post('to_date')."' "; 
    }
    if($this->input->post('police_station')!='')
    {
        $condition .=" and sa.police_station_id ='".$this->input->post('police_station')."' ";
    }
    if($this->input->post('police')!='')
    {
        $condition .=" and cc.police_id ='".$this->input->post('police')."' ";
    }
    if($this->input->post('police_designation')!='')
    {
        $condition .=" and p.designation_id ='".$this->input->post('police_designation')."' ";
    }

   
    }
   
    ob_clean();
    $Criminal_analysis = $this->Incidence_analysis_model->SelfieDataToExcel($condition);
    $FileTitle='Criminal_Analysis'.date('Ymd');
    $title1='';
     if($this->input->post('from_date')!='' && $this->input->post('to_date')!=''){
       $title1 .= '('.date('d/m/Y h:m',strtotime($this->input->post('from_date'))).' To '.date('d/m/Y h:m',strtotime($this->input->post('to_date'))).' )';
    }
   
    if($this->input->post('police_station')!=''){
      $pd = $this->Crud_model->GetData("mst_police_stations",'name',"id='".$this->input->post('police_station')."'","","","","1");
      $title1 .=' ('.ucfirst($pd->name).')';
    }
    

    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Criminal Analysis');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Criminal Analysis');
    $this->excel->getActiveSheet()->setCellValue('A2', $title1);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Sr.No');
    $this->excel->getActiveSheet()->setCellValue('B3', "Police Station Name");
    $this->excel->getActiveSheet()->setCellValue('C3', "Criminal Name");
    $this->excel->getActiveSheet()->setCellValue('D3', "Address");
    $this->excel->getActiveSheet()->setCellValue('E3', "Crime");
    $this->excel->getActiveSheet()->setCellValue('F3', "Crime Place");
    
    
   
    $a='4';        
    $sr_no=1;
   //echo "<pre>"; print_r($Selfie_data);exit();
    foreach ($Criminal_analysis as $line)
    {
       
      if(!empty($line->ps_name)){
       $ps_name=$line->ps_name;
      }else{
        $ps_name="N/A";
      }
      if(!empty($line->c_name)){
       $c_name=$line->c_name;
      }else{
        $c_name="N/A";
      }
      if(!empty($line->address)){
       $address=$line->address;
      }else{
        $address="N/A";
      }
      if(!empty($line->crime_name)){
       $crime_name=$line->crime_name;
      }else{
        $crime_name="N/A";
      }
      if(!empty($line->crime_place)){
       $crime_place=$line->crime_place;
      }else{
        $crime_place="N/A";
      }



        $this->excel->getActiveSheet()->setCellValue('A'.$a, $sr_no);
        $this->excel->getActiveSheet()->setCellValue('B'.$a, $ps_name); 
        $this->excel->getActiveSheet()->setCellValue('C'.$a, $c_name);
        $this->excel->getActiveSheet()->setCellValue('D'.$a, $address);
        $this->excel->getActiveSheet()->setCellValue('E'.$a, $crime_name);
        $this->excel->getActiveSheet()->setCellValue('F'.$a, $crime_place);
        
                    
        
        
        $a++;
        $sr_no++;
    }
            $this->excel->getActiveSheet()->mergeCells('A1:H1');
            $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(14);
            $this->excel->getActiveSheet()->mergeCells('A2:H2');
            $this->excel->getActiveSheet()->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setSize(14);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setSize(11);
           
            

            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setBold(true);
           
   
      foreach(range('A','F') as $columnID)
      {
          $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
      }
    $filename=$FileTitle.'.csv'; 
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="'.$filename.'"'); 
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
    $objWriter->save('php://output');
}
  public function getCriminal()
    {
        $criminal = $this->Crud_model->GetData("criminals",'id,criminal_name',"police_station_id='".$_POST['id']."' and is_delete='No' and status='Active'","","criminal_name asc","","");
        
          $response = '<option value="">Select Criminal</option>';
          foreach($criminal as $row) 
          {
            $response .= '<option value="'.$row->id.'">'.$row->criminal_name.'</option>';
          }
        echo $response;
    }
}