<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Districts extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Districts_model');
    $this->load->database();
  }

  public function index()
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
    <li>
    <i class='ace-icon fa fa-home home-icon'></i>
    <a href='".site_url('Dashboard')."'>Dashboard</a>
    </li>
      <li>Manage Masters</li>
    <li class='active'>Manage Districts</li>
    </ul>";
    $cond1 ="status='Active' and is_delete='No' and country_name='India'";
    $cond2 ="status='Active' and is_delete='No'";
    $countries =  $this->Crud_model->GetData('mst_countries','',$cond1);
    $states =  $this->Crud_model->GetData('mst_states','',$cond2);
    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => 5,
      'ajax_manage_page' => site_url('Districts/ajax_manage_page'),
      'addAction' => site_url('Districts/addData'),
      'changeAction' => site_url('Districts/changeStatus'),
      'deleteAction' => site_url('Districts/delete'),
      'heading' => 'Manage Districts',
      'countries' => $countries,
      'states' => $states,
    );
    $this->load->view('districts/list',$data);
  }

  public function ajax_manage_page()
  {
    $Data = $this->Districts_model->get_datatables(); 
    $data = array();  
    if(empty($_POST['start']))
    {
      $no =0;   
    }
    else
    {
      $no =$_POST['start'];
    }      
    foreach($Data as $row) 
    {
      $btn = ('<a href="#myModaledit" title="Edit" class="btn btn-info btn-circle btn-sm" data-toggle="modal"  onclick="getEditvalue('.$row->id.');"><i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";      
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = ucfirst($row->district_name);
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }
    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Districts_model->count_all(),
      "recordsFiltered" => $this->Districts_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function changeStatus(){
    $change_status = $this->Crud_model->GetData('mst_districts','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active')
    {
      $this->Crud_model->SaveData('mst_districts',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
      $this->Crud_model->SaveData('mst_districts',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Districts/index");
  }

  public function addData()
  {       
    //echo "<pre>"; print_r($_POST); die();
    $condDuplication = "district_name='".$this->input->post('district_name')."' && country_id='".$this->input->post('country_id')."' && state_id='".$this->input->post('state_id')."'";
    $duplication = $this->Crud_model->GetData('mst_districts','', $condDuplication);
    if(count($duplication) > 0 )
    {
      echo 1;
    }
    else
    {
      $data = array(
        'district_name' => $this->input->post('district_name'),
        'district_name_marathi' => $this->input->post('district_name_marathi'),
        'district_name_hindi' => $this->input->post('district_name_hindi'),
        'country_id' => $this->input->post('country_id'),
        'state_id' => $this->input->post('state_id'),
      );
      $this->Crud_model->SaveData('mst_districts', $data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }  
  }
  public function updateData()
  {
    $condDuplication = "district_name='".$this->input->post('district_name')."' and country_id='".$this->input->post('country_id')."' and state_id='".$this->input->post('state_id')."' and id !='".$this->input->post('id')."'"; 
    $duplication = $this->Crud_model->GetData('mst_districts','',$condDuplication);

    if(count($duplication) > 0 )
    {
      echo "1";
    }
    else
    {
      $data = array(
        'country_id' => $this->input->post('country_id'),     
        'state_id' => $this->input->post('state_id'),           
        'district_name' => ucwords($this->input->post('district_name')),
        'district_name_marathi' => trim($this->input->post('district_name_marathi')),
        'district_name_hindi' => trim($this->input->post('district_name_hindi')),
        'modified' => date('Y-m-d H:i:s'),                   
      );
      $this->Crud_model->SaveData('mst_districts', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo "2";
    }  
  }

  public function delete()
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_districts', $con); 

    $cities = $this->Crud_model->GetData('mst_cities','id',"district_id='".$_POST['id']."'",'','','','row');
    if(!empty($cities))
    {
      $con = "district_id='".$_POST['id']."'";
      $this->Crud_model->SaveData('mst_cities', array('is_delete'=>'Yes'), $con); 
    }

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect("Districts/index");
  }
  public function getUpdateName()
  {
    $row = $this->Crud_model->GetData('mst_districts','',"id='".$_POST['id']."'",'','','','row');       
    $country = $this->Crud_model->GetData('mst_countries','','status="Active" and is_delete="No" and country_name="India"');
    $state = $this->Crud_model->GetData('mst_states','',"country_id='".$row->country_id."' and status='Active' and is_delete='No'");
    $data = array('district_name'=> ucwords($row->district_name),'district_name_marathi'=> $row->district_name_marathi,'district_name_hindi'=> $row->district_name_hindi,'id'=> $row->id,'country_id'=> $row->country_id, 'country'=> $country,'state_id'=> $row->state_id, 'state'=> $state);

    $this->load->view('districts/geteditCity',$data);
  }


  public function get_state()
  {    
    $id = $this->input->post('id'); 
    $cond = "country_id ='".$id."' and is_delete='No' and status='Active'";
    $getstate = $this->Crud_model->GetData('mst_states','',$cond);
    $html="<option value=''>-- Select State--</option>";
    foreach($getstate as $states)
    {
      $html.="<option value=".$states->id.">".$states->state_name."</option>";
    }
    echo $html;
  }
}