<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Departments extends CI_Controller {

  function __construct()
    {
    parent::__construct();
    $this->load->model("Departments_model");
    $this->load->model("Departments_complaint_status_model");
    }

    //LIST VIEW
  public function index()
  {
        $breadcrumbs = "<ul class='breadcrumb'>
                    <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li class='active'>Manage Departments</li>
                    </ul>";
        $data = array(
        'breadcrumbs' => $breadcrumbs ,
        'actioncolumn' => '5' ,
        'action' =>  site_url('Departments/create') ,
        'ajax_manage_page' => site_url('Departments/ajax_manage_page'),
        'deleteAction' => site_url('Departments/delete'),
        'getUpdateName' => site_url('Departments/getUpdateName'),
        'updateAction' => site_url('Departments/updateData'),
        'changeAction' => site_url('Departments/changeStatus'),
        'button' => 'Create',
        'heading' => 'Manage Departments',
        );
        $this->load->view('departments/departments_list',$data);
  }

   public function ajax_manage_page()
   {
      $condition="";
      $getData = $this->Departments_model->get_datatables($condition);
        $data = array();
        if(empty($_POST['start']))
            {
                $no =0;   
            }
            else
            {
                $no =$_POST['start'];
            }
            foreach ($getData as $Data) {
              $btn = '';

              $viewUrl = "Departments/view";
              $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($Data->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

              $updateUrl = "Departments/update";
              $btn .= '<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($Data->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

            $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

            $status = '';
             if($Data->status=='Active')
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
              }
              else
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
              }
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = ucfirst($Data->authority); 
            $row[] = ucfirst($Data->department_name); 
            $row[] = $status;
            $row[] = $btn;
            $data[] = $row;
        }
        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Departments_model->count_all($condition),
          "recordsFiltered" => $this->Departments_model->count_filtered($condition),
          "data" => $data,
        );
        echo json_encode($output);
    }
      public function changeStatus(){
        //print_r($_POST);exit;
        $change_status = $this->Crud_model->GetData('mst_departments','',"id='".$_POST['id']."'",'','','','row');
        

        if($change_status->status=='Active')
        {
            $this->Crud_model->SaveData('mst_departments',array('status'=>'Inactive'),"id='".$_POST['id']."'");
        }
        else
        {
            $this->Crud_model->SaveData('mst_departments',array('status'=>'Active'),"id='".$_POST['id']."'");
        }
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
        redirect('Departments/index');
    }
    
  public function create()
  {  

    $parents = $this->Crud_model->GetData('mst_departments_parent',"","status='Active' and is_delete='No'","","title asc");
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Departments')."'>Manage Departments</a></li>
                    <li class='active'>Create Department</li>
                  </ul>";

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Department',
      'sub_title'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
      'parents' =>$parents,
      'action' => site_url("Departments/create_action"), 
      'cancelbtn' => site_url('Departments/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'parent_id' => set_value("parent_id",$this->input->post('parent_id')), 
      'department_name' => set_value("department_name",$this->input->post('department_name')), 
      'department_name_marathi' => set_value("department_name_marathi",$this->input->post('department_name_marathi')), 
      'department_name_hindi' => set_value("department_name_hindi",$this->input->post('department_name_hindi')), 
      'description' => set_value("description",$this->input->post('description')), 
      'description_marathi' => set_value("description_marathi",$this->input->post('description_marathi')), 
      'description_hindi' => set_value("description_hindi",$this->input->post('description_hindi')), 
    ); 
    $this->load->view('departments/add',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    // echo "<pre>"; print_r($_POST); die;
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  

      $data = array(
                'parent_id' => $this->input->post('parent_id'), 
                'department_name' => $this->input->post('department_name'), 
                'department_name_marathi' => $this->input->post('department_name_marathi'), 
                'department_name_hindi' => $this->input->post('department_name_hindi'), 
                'description' => $this->input->post('description'), 
                'description_marathi' => $this->input->post('description_marathi'), 
                'description_hindi' => $this->input->post('description_hindi'), 
              );
      $this->Crud_model->SaveData('mst_departments',$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Departments has been created successfully</span>');
      redirect('Departments/index');
    }
  }

  //UPDATE 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_departments",'',"id='".$id."'",'','','','1');
      // echo "<pre>"; print_r($row); die();
      $parents = $this->Crud_model->GetData('mst_departments_parent',"","status='Active' and is_delete='No'","","title asc");

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Departments</li>
                    </ul>";

      if(!empty($row)) 
      {
        $data=array(
          'action'    => site_url('Departments/update_action'.'/'.$update_id),
          'cancelbtn'   => site_url('Departments/index'), 
          'button'    => 'Update',
          'heading'   => 'Update Department',
          'breadcrumbs' => $breadcrumbs,
          'parents'   => $parents,
          'id' =>  set_value('id', $row->id),
          'parent_id' => set_value('parent_id', $row->parent_id), 
          'department_name' => set_value('department_name',$row->department_name), 
          'department_name_marathi' => set_value('department_name_marathi', $row->department_name_marathi), 
          'department_name_hindi' => set_value('department_name_hindi',$row->department_name_hindi), 
          'description' => set_value('description',$row->description), 
          'description_marathi' => set_value('description_marathi',$row->description_marathi), 
          'description_hindi' => set_value('description_hindi',$row->description_hindi), 
          
        );
        $this->load->view('departments/add', $data);
      } 
      else 
      {
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Departments/index');
      }
    } 
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Departments/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) 
  {
    // echo "<pre>"; print_r($_POST); die;

    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) 
    {          
      $this->update($update_id);
    } 
    else 
    {  

      $data = array(
        'parent_id' => $this->input->post('parent_id',TRUE),
        'department_name' => $this->input->post('department_name',TRUE),
        'department_name_marathi' => $this->input->post('department_name_marathi',TRUE),
        'department_name_hindi' => $this->input->post('department_name_hindi',TRUE),
        'description' => $this->input->post('description',TRUE),
        'description_marathi' => $this->input->post('description_marathi',TRUE),
        'description_hindi' => $this->input->post('description_hindi',TRUE),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_departments",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Department has been updated successfully</span>');
      redirect('Departments/index');
    }
  }

    public function view($id)
    {
          $cond = base64_decode($id);

          $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li><a href='".site_url('Departments')."'>Manage Departments</a></li>
                            <li class='active'>Departments Complaint Status</li>
                          </ul>";

          $complaints = $this->Crud_model->GetData('complaints', 'count(id) as total_complaints',"is_delete='No' and department_id='".$cond."'", '', '', '', '1');

          $pendingComplaints = $this->Crud_model->GetData('complaints', 'count(id) as pending_complaints',"is_delete='No' and complaint_status='Pending' and department_id='".$cond."'", '', '', '', '1');

          $approvedComplaints = $this->Crud_model->GetData('complaints', 'count(id) as approved_complaints',"is_delete='No' and complaint_status='Approved' and department_id='".$cond."'", '', '', '', '1');

          $resolvedComplaints = $this->Crud_model->GetData('complaints', 'count(id) as resolved_complaints',"is_delete='No' and complaint_status='Resolved' and department_id='".$cond."'", '', '', '', '1');

          $getComplaints = $this->Crud_model->GetData('complaints', '',"is_delete='No' and department_id='".$cond."'");
          // echo "<pre>"; print_r($getComplaints); die();

          $data = array(
                      'breadcrumbs' => $breadcrumbs,
                      'complaints' => $complaints->total_complaints,
                      'pendingComplaints' => $pendingComplaints->pending_complaints,
                      'approvedComplaints' => $approvedComplaints->approved_complaints,
                      'resolvedComplaints' => $resolvedComplaints->resolved_complaints,
                      'getComplaints' => $getComplaints,
                      'actioncolumn' => '3',
                      'ajax_manage_page2' => site_url('Departments/ajax_manage_page2/'.$id),
                      
                      );
         $this->load->view('departments/view',$data);
    }

    public function ajax_manage_page2($id)
    {
      $department_id = base64_decode($id);

      $getData = $this->Departments_complaint_status_model->get_datatables($department_id);
      // echo "<pre>"; print_r($getData); die();
        $data = array();
        if(empty($_POST['start']))
        {
            $no =0;   
        }
        else
        {
            $no =$_POST['start'];
        }

        foreach ($getData as $rowData) {
          $btn = '';

          $btn ='<span class="action-buttons"><a title="View Complaint" target="_blank" href="'.site_url('Complaints/view/'.'/'.base64_encode($rowData->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

        $no++;
        $row = array();
        $row[] = $no;
        $row[] = ucfirst($rowData->title); 
        $row[] = $rowData->comp_code;
        $row[] = $btn;
        $data[] = $row;
        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Departments_complaint_status_model->count_all($department_id),
          "recordsFiltered" => $this->Departments_complaint_status_model->count_filtered($department_id),
          "data" => $data,
        );
        echo json_encode($output);
    }

       public function delete()
      {
        $con = "id='".$_POST['id']."'";
        $data = array('is_delete' =>'Yes',);
        $this->Crud_model->DeleteData('mst_departments',$con);

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
        redirect(site_url('Departments'));
      }


     public function import()
  {
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Departments/index'));            
   } 
   $data = $fields_fun;
   
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='')
      { 

        $getAuthority = $this->Crud_model->GetData('mst_departments_parent','id',"title='".trim($val[0])."'",'','','','single'); 

         $getDepartment = $this->Crud_model->GetData('mst_departments','department_name',"department_name='".trim($val[1])."'",'','','','single'); 
       
         /*for already exist check*/

         if(empty($getDepartment))
         {

            if(!empty($val[3]))
            {
               $department_name_hindi=$val[3];
            } 
            else
            {
               $department_name_hindi="";
            }

            if(!empty($val[2]))
            {
               $department_name_marathi=$val[2];
            } 
            else
            {
               $department_name_marathi="";
            }

            if(!empty($val[1]))
            {
               $department_name=$val[1];
            } 
            else
            {
               $department_name="";
            }

            if(!empty($getAuthority))
            {
               $parent_id=$getAuthority->id;
            } 
            else
            {
               $parent_id="";
            }
  
            $data = array(
               'parent_id' => $parent_id,
               'department_name' => trim($department_name),
               'department_name_marathi' => trim($department_name_marathi),
               'department_name_hindi' => trim($department_name_hindi),
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_departments',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],'Department already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Departments/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('departments/duplicateDeparments',$data);
   } 
  }

  public function _rules($id) 
    {
        $cond = "department_name='".trim($this->input->post('department_name',TRUE))."' and parent_id='".trim($this->input->post('parent_id',TRUE))."' and is_delete='No' and id!='".$id."'";
        $row = $this->Crud_model->GetData("mst_departments",'',$cond,'','','','');
        $count = count($row);

        if($count==0) 
        {
            $is_unique = "";
        } 
        else 
        {
            $is_unique = "|is_unique[mst_departments.department_name]";
        } 
        
        $this->form_validation->set_rules('parent_id', 'authority', 'trim|required', array('required' => 'Please select %s'));

        $this->form_validation->set_rules('department_name', 'department name', 'trim|required'.$is_unique,
        array(
          'required'      => 'Please enter %s',
          'is_unique'     => 'Department already exists'
        ));

        $this->form_validation->set_rules('id', 'id', 'trim');
        $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
    }

}