<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

  public function __construct()
  {
      parent::__construct();
      $this->load->database();
      $session_id = $this->session->userdata(SESSION_NAME)['id'];
      if(empty($session_id) || SESSION_NAME != "CITIZENAPPADMIN")
      {
        redirect(site_url('Welcome'));
      }
  }
  
  public function index()
  { 
      $breadcrumbs = "<ul class='breadcrumb'><li class='active'><i class='fa fa-home'></i> Dashboard</li></ul>";

      $criminals = $this->Crud_model->GetData('criminals', 'count(id) as total_criminals',"is_delete='No'", '', '', '', '1');

      $criminals_data = $this->Crud_model->GetData('criminals','',"is_delete='No' and status='Active'");

      $sensitive_areas_data = $this->Crud_model->GetData('sensitive_areas','',"is_delete='No' and status='Active'");
      
      $police_stations_data = $this->Crud_model->GetData('mst_police_stations','',"is_delete='No' and status='Active'");

      $criminals_data = $this->Crud_model->GetData('criminals','',"is_delete='No' and status='Active'");
        
      $cameras = $this->Crud_model->GetData('mst_cameras', 'count(id) as total_cameras',"is_delete='No'", '', '', '', '1');
        
      $cameras_data = $this->Crud_model->GetData('mst_cameras','',"is_delete='No' and status='Active'");

      $cameras_address = $this->Crud_model->GetData('mst_cameras','',"is_delete='No' and status='Active'");

      $bpatrak = $this->Crud_model->GetData('bpatrak', 'count(id) as total_bpatrak',"", '', '', '', '1');
        
      $bpatrak_data = $this->Crud_model->GetData('bpatrak');

      $police_departments = $this->Crud_model->GetData('mst_police_departments', 'department_name',"is_delete='No' and status='Active'", '', '', '', '');

      $police_stations = $this->Crud_model->GetData('mst_police_stations', 'name',"is_delete='No' and status='Active'", '', '', '', '');

      $allPoliceData = $this->Crud_model->GetData('mst_police', 'police_name',"is_delete='No' and status='Active' and designation_type='Police'", '', '', '', '');

      $allPoliceStationHead = $this->Crud_model->GetData('mst_police', 'police_name',"is_delete='No' and status='Active' and designation_type='Station_Head'", '', '', '', '');

      $allPoliceHeadPerson = $this->Crud_model->GetData('mst_police', 'police_name',"is_delete='No' and status='Active' and designation_type='Head_Person'", '', '', '', '');

      $policeActivities = $this->Crud_model->GetData('police_activities', 'name',"is_delete='No' and status='Active'", '', '', '', '');

      $data = array(
                  'breadcrumbs' => $breadcrumbs,                 
                  'police_departments' => count($police_departments),                  
                  'police_stations' => count($police_stations),                  
                  'allPoliceStationHead' => count($allPoliceStationHead),                  
                  'allPoliceHeadPerson' => count($allPoliceHeadPerson),                  
                  'allPoliceData' => count($allPoliceData),                  
                  'policeActivities' => count($policeActivities),                  
                  'total_criminals' => $criminals->total_criminals,                  
                  'total_bpatrak' => $bpatrak->total_bpatrak,                  
                  'criminals_data' => $criminals_data,                  
                  'total_cameras' => $cameras->total_cameras,                  
                  'cameras_data' => $cameras_data,                                
                  'total_bpatrak' => $bpatrak->total_bpatrak,                                
                  'bpatrak_data' => $bpatrak_data,                                
                  'sensitive_areas_data' => $sensitive_areas_data,                                
                  'police_stations_data' => $police_stations_data,                                
                  );
     $this->load->view('index',$data);
  }

}
?>