<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Criminal_crime extends CI_Controller 
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model("Criminalcrime_model");
    $this->load->library('Excel');
  }

  public function index()
  {
     if($_SESSION[SESSION_NAME]['type']=='Head_Person' || $_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
    $getCities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
  }else{
    $getCities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No'","","city_name asc");
  }
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Crime</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'getCities' => $getCities,
      'actioncolumn' => 12,
      'ajax_manage_page' => site_url('Criminal_crime/ajax_manage_page'),
      'action' => site_url('Criminal_crime/create'),
      'deleteAction' => site_url('Criminal_crime/delete'),
      'changeAction' => site_url('Criminal_crime/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Crime',
    );
    // print_r($data);exit();
    $this->load->view('criminals/list',$data);
  }

  public function ajax_manage_page() 
  {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "crm.police_station_id='".$row->police_station_id."'";
      $city_id = $_POST['SearchData7'];
      $police_station_id = $_POST['SearchData6'];
      $condition .= " and crm.id<>0";

      if($city_id!='')
      {
          $condition .=" and crm.city_id ='".$city_id."' ";
      }

      if($police_station_id!='')
      {
          $condition .=" and crm.police_station_id ='".$police_station_id."' ";
      }
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "crm.district_id='".$row->district_id."'";
      $district_id = $_POST['SearchData7'];
      $police_station_id = $_POST['SearchData6'];
      $condition .= " and crm.id<>0";

      if($district_id!='')
      {
          $condition .=" and crm.district_id ='".$district_id."' ";
      }

      if($police_station_id!='')
      {
          $condition .=" and crm.police_station_id ='".$police_station_id."' ";
      }
      
    }else{

    $condition = "1=1";
     $city_id = $_POST['SearchData7'];
      $police_station_id = $_POST['SearchData6'];

      $condition .= " and crm.id<>0";

      if($city_id!='')
      {
          $condition .=" and crm.city_id ='".$city_id."' ";
      }

      if($police_station_id!='')
      {
          $condition .=" and crm.police_station_id ='".$police_station_id."' ";
      }

    }
    $CriminalsData = $this->Criminalcrime_model->get_datatables($condition);
    //print_r($CriminalsData);exit();  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($CriminalsData as $row) 
    {

      $viewUrl = "Criminals/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Criminals/update";
      $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

     

      
       if($row->crime_name=='' || $row->crime==0)
      {
        $crime_name = "N/A";           
      }
      else
      {
        $crime_name = $row->crime_name;
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = ucfirst($row->criminal_name);
      $nestedData[] = ucwords($crime_name);
      // $nestedData[] = ucwords($row->crime_date);
      $nestedData[] = date('d-m-Y', strtotime($row->crime_date));
      $nestedData[] = ucwords($row->crime_place);
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Criminalcrime_model->count_all($condition),
      "recordsFiltered" => $this->Criminalcrime_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create($id) 
  {  
    // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

    $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");

    $police_stations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
     $crime_names = $this->Crud_model->GetData('mst_crimes',"","status='Active'","","crime_name asc");

    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li>Manage Crime</li>
                      <li class='active'>Add Crime</li>
                    </ul>";

    $data = array(
      'button'    => 'Create',
      'heading'   => 'Create Crime',
      'breadcrumbs' => $breadcrumbs,
      'criminal_id' => $id,
      'states'    => $states,
      'police_stations'    => $police_stations,
      'crime_names'    => $crime_names,
      'action'    => site_url('Criminal_crime/create_action/'.$id),
      'cancelbtn'   => site_url('Criminal_crime/index'), 
      'id'      => set_value('id',$this->input->post('id')),
      'police_station_id'      => set_value('police_station_id',$this->input->post('police_station_id')),
      'country_id' => "101",
      'state_id'    => set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'latitude' => set_value('lat',$this->input->post('lat')),
      'longitude' => set_value('lon',$this->input->post('lon')),
      'crime' =>  set_value('crime',$this->input->post('crime')),
      'crime_date' =>  set_value('crime_date',$this->input->post('crime_date')),
      'crime_place' =>  set_value('crime_place',$this->input->post('crime_place')),
      'section' =>  set_value('section',$this->input->post('section')),
      'description'    => set_value('description',$this->input->post('description')),
    ); 
    $this->load->view('criminals/crimeform',$data);
  }


  public function create_action($id) 
  {   
    // echo "<pre>"; print_r($_POST); die();
    $this->_rules(0);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create($id);
    } 
    else {
      
      $data = array(
        'criminal_id' => $id,
        'police_station_id' => $this->input->post('police_station_id'),
        'country_id' => "101",
        'state_id'    => $this->input->post('state_id'),
        'district_id' => $this->input->post('district_id'),
        'city_id' => $this->input->post('city_id'),
        'latitude'    => $this->input->post('lat'),
        'longitude'    => $this->input->post('lon'),
        'crime_id' => $this->input->post('crime_id'),
        'crime_date' => $this->input->post('crime_date'),
        'crime_place'    => $this->input->post('crime_place'),
        'section'    => $this->input->post('section'),
        'description'    => $this->input->post('description'),
      
      );  
      $this->Crud_model->SaveData("criminal_crimes",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Crime has been created successfully</span>');
      redirect('Criminals/view/'.base64_encode($id));
    }
  }

  public function getState() 
  {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) 
    {
      $response = '<option value="">Select State</option>';
      foreach($states as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select State</option>';
    }
    echo $response;
  }

  
   public function getDistrict()
  {
        if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='admin'){
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

  }

  public function getCity()
  {
    $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

    if(!empty($cities)) 
    {
      $response = '<option value="">Select City</option>';
      foreach($cities as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select City</option>';
    }
    echo $response;
  }

  public function getPoliceStation()
  {
    $police_stations = $this->Crud_model->GetData("mst_police_stations",'name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"name asc");

    if(!empty($police_stations)) 
    {
      $response = '<option value="">Select Police Station </option>';
      foreach($police_stations as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Police Station</option>';
    }
    echo $response;
  }

  // view criminalrecord
  public function view($id)
  {
    $cond = base64_decode($id);
    $row = $this->Criminalcrime_model->viewCriminalDetails($cond);

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Criminal_crime/index').'">Manage Criminal</a></li>
                    <li class="active">Criminal Details</li>
                  </ul>';

      
    $data = array(
      'row'=> $row,
       'heading' => 'Manage Crime',
      'breadcrumbs'=>$breadcrumbs,
      'cancelbtn'   => site_url('Criminal_crime/index'),  
      // 'id'=>$row->id, 
      'id'=> set_value('id', $row->id),   
      'criminal_name'=>$row->criminal_name,    
      'crime'=>$row->crime_name,    
      'country_name'=>$row->country_name,    
      'state_name'=>$row->state_name,    
      'city_name'=>$row->city_name,  
      'district_name'=>$row->district_name,  
      'crime_date'=>$row->crime_date,    
      'crime_place'=>$row->crime_place,    
      'section'=>$row->section,    
      'description'=>$row->description,   
      'police_station_name'=>$row->police_station_name,    
    );
    $this->load->view('criminals/view',$data);
  }

  // update 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);
      $row = $this->Crud_model->GetData("criminal_crimes",'',"id='".$id."'",'','','','1');
     // print_r($row);exit();
      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li><a href='".site_url('Criminal_crime')."'>Manage Criminals</a></li>
                        <li class='active'>Update Criminal</li>
                      </ul>";

      if(!empty($row)) 
      {
        // $police_stations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

        // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");


        if($_SESSION[SESSION_NAME]['type']=='Head_Person' || $_SESSION[SESSION_NAME]['type']=='Station_Head'){

            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."' and id='".$row->district_id."'","","district_name asc");
          } else {
            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");
          }

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $police_stations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","name asc");
        $crime_names = $this->Crud_model->GetData('mst_crimes',"","status='Active' ","","crime_name asc");

        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Criminal',
          'breadcrumbs' => $breadcrumbs,
          'police_stations' => $police_stations,
          'crime_names' => $crime_names,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'cancelbtn'   => site_url('Criminal_crime/index'), 
          'action'    => site_url('Criminal_crime/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'criminal_name'   => set_value('criminal_name', $row->criminal_name),
          'police_station_id'    => set_value('police_station_id', $row->police_station_id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'    => set_value('city_id', $row->city_id),
          'latitude'   => set_value('latitude', $row->latitude),
          'longitude'   => set_value('longitude', $row->longitude),
          'crime'   => set_value('crime', $row->crime),
          'crime_date'   => set_value('crime_date', $row->crime_date),
          'crime_place'   => set_value('crime_place', $row->crime_place),
          'section'   => set_value('section', $row->section),
          'description'   => set_value('description', $row->description),
        );
        $this->load->view('criminals/crimeform', $data);
      } 
      else 
      {
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Criminal_crime/index');
      }
    } 
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Criminal_crime/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) 
    {          
      $this->update($update_id);
    } 
    else 
    {  
      
      $data = array(
        'criminal_name' => $this->input->post('criminal_name',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'country_id' => "101",
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'latitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),
        'crime' => $this->input->post('crime',TRUE),
        'crime_date' => $this->input->post('crime_date',TRUE),
        'crime_place' => $this->input->post('crime_place',TRUE),
        'section' => $this->input->post('section',TRUE),
        'description' => $this->input->post('description',TRUE),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("criminal_crimes",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Criminal has been updated successfully</span>');
      redirect('Criminal_crime/index');
    }
  }

  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 1;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 1) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    // $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Criminal_crime/index'));            
    } 
    $data = $fields_fun;
    // echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' && $val[8] !='' && $val[9] !='' && $val[10] !='' && $val[11])
      { 
        $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".strtolower($val[4])."'",'','','','single');

         $getPoliceStation = $this->Crud_model->GetData('mst_police_stations','id',"LOWER(name)='".strtolower(trim($val[5]))."' and city_id='".$cities->id."' and is_delete='No' and status='Active'",'','','','single');

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[2]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[3]."'",'','','','single'); 

           $crime = $this->Crud_model->GetData('mst_crimes','id',"crime_name='".$val[7]."'",'','','','single'); 

        

         /*for already exist check*/

         if(!empty($getPoliceStation))
         {
            if(!empty($crime->id))
            {
               $crime=$crime->id;
            } 
            else
            {
               $crime="";
            }

            if(!empty($val[6]))
            {
               $address=$val[6];
            } 
            else
            {
               $address="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

           

            if(!empty($val[8]))
            {
               $crime_date=date("Y-m-d", strtotime($val[8]));
            } 
            else
            {
               $crime_date="";
            }

            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }
            if(!empty($val[9]))
            {
               $crime_place=$val[9];
            } 
            else
            {
               $crime_place="";
            }
             if(!empty($val[10]))
            {
               $section=$val[10];
            } 
            else
            {
               $section="";
            }
            if(!empty($val[11]))
            {
               $description=$val[11];
            } 
            else
            {
               $description="";
            }

            $data = array(
               'criminal_name' => trim($name),
               'country_id' => "101",
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'police_station_id' => $getPoliceStation->id,
               'crime' => $crime,
               'crime_date' => $crime_date,
               'crime_place' => $crime_place,
               'section' => $section,
               'description' => $description,
            );
            $SaveAssets = $this->Crud_model->SaveData('criminal_crimes',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[11],'Police station not exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[11],'Mandatory fields empty');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Criminal_crime/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('Criminal_crime/duplicate',$data);
   } 
  }
 
  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('criminal_crimes', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Criminal deleted successfully</span>');
    redirect('Criminal_crime/index');
  }

  public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['latitude'];
      $longitude=$_POST['longitude'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  }   

  // SEVER SIDE VALIDATION
  public function _rules($id) 
  {
    $this->form_validation->set_rules('police_station_id', 'police station', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('district_id', 'district', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('city_id', 'city', 'trim|required', array('required' => 'Please select %s'));
    
    $this->form_validation->set_rules('crime_id', 'crime', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('crime_date', 'crime datetime', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('crime_place', 'crime place', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('section', 'section', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('description', 'description', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }

 

public function export() 
{
    ob_clean();
     $criminalsData = $this->Criminalcrime_model->exportcriminalsData();
    $FileTitle='criminals_'.date('Ymd');
    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Criminals Details');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Criminals Details');
    $this->excel->getActiveSheet()->setCellValue('A3', "Sr.No");
    $this->excel->getActiveSheet()->setCellValue('B3', "Police Station");
    $this->excel->getActiveSheet()->setCellValue('C3', "Criminal Name");
    $this->excel->getActiveSheet()->setCellValue('D3', "Crime");
    $this->excel->getActiveSheet()->setCellValue('E3', "Crime Place");
    $this->excel->getActiveSheet()->setCellValue('F3', "Crime Date");
    $this->excel->getActiveSheet()->setCellValue('G3', "Section");
    $this->excel->getActiveSheet()->setCellValue('H3', "Address");
    
   
    $a='4';        
    $sr_no=1;
    foreach ($criminalsData as $line)
    {
       
        $this->excel->getActiveSheet()->setCellValue('A'.$a, $sr_no);
        $this->excel->getActiveSheet()->setCellValue('B'.$a, ucfirst($line->police_station_name));
        $this->excel->getActiveSheet()->setCellValue('C'.$a, ucfirst($line->criminal_name));
        $this->excel->getActiveSheet()->setCellValue('D'.$a,  ucfirst($line->crime_name));
        $this->excel->getActiveSheet()->setCellValue('E'.$a, ucfirst($line->crime_place));
        $this->excel->getActiveSheet()->setCellValue('F'.$a, date('Y/m/d', strtotime($line->crime_date)));
        $this->excel->getActiveSheet()->setCellValue('G'.$a,  ucfirst($line->section));
        $this->excel->getActiveSheet()->setCellValue('H'.$a, $line->address);
       
        +
        $a++;
        $sr_no++;
    }
            $this->excel->getActiveSheet()->mergeCells('A1:H1');
            $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(14);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('G3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('H3')->getFont()->setSize(11);
           

            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H3')->getFont()->setBold(true);
           
   
      foreach(range('A','H') as $columnID)
      {
          $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
      }
    $filename=$FileTitle.'.xls'; 
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="'.$filename.'"'); 
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
    $objWriter->save('php://output');
}

  public function getPoliceStationByCity()
  {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
    $police_stations = $this->Crud_model->GetData("mst_police_stations",'name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active' and id='".$row->police_station_id."'",'',"name asc");
  }else{

    $police_stations = $this->Crud_model->GetData("mst_police_stations",'name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"name asc");
  }

    if(!empty($police_stations)) 
    {
      $response = '<option value="">Select Police Station </option>';
      foreach($police_stations as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Police Station</option>';
    }
    echo $response;
  }
}