<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Corporate_works extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Corporate_works_model');
    $this->load->database();
  }

  public function index() { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Corporate works</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '6' ,
      'action' =>  site_url('Corporate_works/create') ,
      'ajax_manage_page' => site_url('Corporate_works/ajax_manage_page') ,
      'heading' => 'Manage Corporate works',
    );
    $this->load->view('corporate_works/list', $data);
  }

  public function ajax_manage_page() {
    $Data = $this->Corporate_works_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
      $viewUrl = "Corporate_works/view";
          $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Corporate_works/update";
      $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->mla_name);
      $nestedData[] = ucfirst($row->ward_member_name);
      $nestedData[] = ucfirst($row->employee_name);
      $nestedData[] = ucfirst($row->collector_name);
      $nestedData[] = ucfirst($row->roles_and_responsible_person);
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Corporate_works_model->count_all(),
      "recordsFiltered" => $this->Corporate_works_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Corporate_works/index')."'>Manage Corporate works</a></li>
    <li class='active'>Create</li>
    </ol>";

    $data = array(
      'button'=>'Create',
      'heading'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Corporate_works/create_action"), 
      'cancelbtn' => site_url('Corporate_works/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'mla_name' =>  set_value('mla_name',$this->input->post('mla_name')),
      'ward_member_name' =>  set_value('ward_member_name',$this->input->post('ward_member_name')),
      'employee_name' =>  set_value('employee_name',$this->input->post('employee_name')),
      'collector_name' =>  set_value('collector_name',$this->input->post('collector_name')),
      'roles_and_responsible_person' =>  set_value('roles_and_responsible_person',$this->input->post('roles_and_responsible_person')),
    ); 
    $this->load->view('corporate_works/add_corporate_works',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    // $id = '0';
    // $this->_rules($id);
    // if($this->form_validation->run() == FALSE) 
    // {  
    //   $this->create();
    // } 
    // else
    // {  

      $data = array(
        'mla_name' => $this->input->post('mla_name',TRUE),
        'ward_member_name' => $this->input->post('ward_member_name',TRUE),
        'employee_name' => $this->input->post('employee_name',TRUE),
        'collector_name' => $this->input->post('collector_name',TRUE),
        'roles_and_responsible_person' => $this->input->post('roles_and_responsible_person',TRUE),
      );  
      $this->Crud_model->SaveData("corporate_works",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Created successfully</span>');
      redirect('Corporate_works/index');
    // }
  }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("corporate_works",'',"id='".$id."'",'','','','1');
     
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Corporate_works</li>
                    </ul>";

      if(!empty($row)) {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active'","","country_name asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update',
//          'Corporate_works'    => $Corporate_works,
          'cancelbtn'   => site_url('Corporate_works/index'), 
          'action'    => site_url('Corporate_works/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'mla_name'  => set_value('mla_name', $row->mla_name),
          'ward_member_name'    => set_value('ward_member_name', $row->ward_member_name),
          'employee_name'    => set_value('employee_name', $row->employee_name),
          'collector_name'    => set_value('collector_name', $row->collector_name),
          'roles_and_responsible_person'    => set_value('roles_and_responsible_person', $row->roles_and_responsible_person),
        );
        $this->load->view('corporate_works/add_corporate_works', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Corporate_works/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Corporate_works/index');
    }
  }



  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    // $this->_rules($id);
    // if ($this->form_validation->run() == FALSE) {          
    //   $this->update($update_id);
    // } 
    // else 
    // {  

      $data = array(
        'mla_name' => $this->input->post('mla_name',TRUE),
        'ward_member_name' => $this->input->post('ward_member_name',TRUE),
        'employee_name' => $this->input->post('employee_name',TRUE),
        'collector_name' => $this->input->post('collector_name',TRUE),
        'roles_and_responsible_person' => $this->input->post('roles_and_responsible_person',TRUE),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("corporate_works",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Updated successfully</span>');
      redirect('Corporate_works/index');
    // }
  }

  // VIEW
    public function view($id)
    {
        $cond = "id='".base64_decode($id)."'";
        $row = $this->Corporate_works_model->viewCompDetails($cond);
        //echo "<pre>"; print_r($row); die();
        $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Corporate_works/index').'">Manage Corporate_works</a></li>
                        <li class="active">Corporate Details</li>
                      </ul>';

        $data = array(

                        'row'=> $row,
                        'breadcrumbs'=>$breadcrumbs, 
                        'id'=>$row->id,    
                        'name'=>$row->name,    
                        'email'=>$row->email,    
                        'mobile'=>$row->mobile,
                        'country_name'=>$row->country_name,    
                        'state_name'=>$row->state_name,    
                        'city_name'=>$row->city_name,    
                        // 'area'=>$row->area,    
                        'role'=>$row->role,    
                        'state_id'=>$row->state_id,  
                        'address'=>$row->address,    
                        'pincode'=>$row->pincode,   
                        'image'=>$row->image,   
                        'status'=>$row->status,   
                  );
       $this->load->view('Corporate_works/view',$data);
    }
  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('corporate_works', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Deleted successfully</span>');
    redirect('Corporate_works/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('corporate_works','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('corporate_works',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('corporate_works',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Corporate_works/index");
  }

  // public function _rules($id) {
  //   $cond = "mobile='".$this->input->post('mobile',TRUE)."' and email='".$this->input->post('email',TRUE)."' and id!='".$id."'";
  //   $row = $this->Crud_model->GetData("Corporate_works",'',$cond,'','','','');
  //   $count = count($row); 
  //   if($count==0) {
  //     $is_unique = "";
  //     $is_unique2 = "";
  //   } else {
  //     $is_unique = "|is_unique[Corporate_works.email]";
  //     $is_unique2 = "|is_unique[Corporate_works.mobile]";

  //   $this->form_validation->set_rules('name', 'name', 'trim|required', array('required' => 'Please enter %s'));
  //   } 
  //   $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
  //     array(
  //       'required'      => 'Required',
  //       'is_unique'     => 'Already exists'
  //   ));

  //   $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
  //     array(
  //       'required'      => 'Required',
  //       'is_unique'     => 'Already exists'
  //   ));


  //   $this->form_validation->set_rules('country_id', 'country', 'required', array('required' => 'Please select %s'));

  //   $this->form_validation->set_rules('state_id', 'state', 'required', array('required' => 'Please select %s'));
  //   $this->form_validation->set_rules('district_id', 'district', 'required', array('required' => 'Please select %s'));

  //   $this->form_validation->set_rules('city_id', 'city', 'required', array('required' => 'Please enter %s'));
  //   $this->form_validation->set_rules('zone_id', 'zone', 'required', array('required' => 'Please enter %s'));
  //   $this->form_validation->set_rules('area_id', 'area', 'required', array('required' => 'Please enter %s'));
  //   $this->form_validation->set_rules('role', 'role', 'required', array('required' => 'Please select %s'));

  //   $this->form_validation->set_rules('pincode', 'pincode', 'trim|required', array('required' => 'Please enter %s'));
  //   $this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please select %s'));

    
  //   $this->form_validation->set_rules('id', 'id', 'trim');

  //   $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  // }

}