<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Constitution extends CI_Controller 
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Constitution_model");
    }

    public function index()
    {
        $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Constitution</li>
                        </ul>";

        $data = array(
            'breadcrumbs' => $breadcrumbs,
            'actioncolumn' => '5',
            'ajax_manage_page' => site_url('Constitution/ajax_manage_page'),
            'deleteAction' => site_url('Constitution/delete'),
            'changeAction' => site_url('Constitution/changeStatus'),
            'button' => 'Create',
            'heading' => 'Manage Constitution',
        );
        $this->load->view('constitution/list',$data);
    }

    public function ajax_manage_page() 
    {
        $Data = $this->Constitution_model->get_datatables();  
        $data = array();  
        if(empty($_POST['start'])) {
          $no =0;   
        } else {
          $no =$_POST['start'];
        }

        foreach($Data as $row) {
          $update_url = "Constitution/update";

          $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($update_url.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
          $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

          if($row->status=='Active')
            {
              $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
            }
            else
            {
              $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
            }
          $no++;  
          $nestedData = array();
          $nestedData[] = $no;
          $nestedData[] = $row->title;
          $nestedData[] = $row->article_title;
          $nestedData[] = $row->description;
          $nestedData[] = $status;
          $nestedData[] = $btn;
          $data[] = $nestedData;
          $selected = '';

        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Constitution_model->count_all(),
          "recordsFiltered" => $this->Constitution_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
    
    public function create() 
    {  
        $articles = $this->Crud_model->GetData('constitution_articles',"title,id","status='Active'","","title asc");
        $breadcrumbs = "<ul class='breadcrumb'>
                          <li>
                              <i class='ace-icon fa fa-home home-icon'></i>
                              <a href='".site_url('Dashboard')."'>Dashboard</a>
                          </li>
                          <li><a href='".site_url('Constitution')."'>Manage Constitution</a></li>
                          <li class='active'>Add</li>
                        </ul>";

        $data = array(
          'button'    => 'Create',
          'heading'   => 'Create',
          'breadcrumbs' => $breadcrumbs,
          'articles' => $articles,
          'action'    => site_url('Constitution/create_action'),
          'cancelbtn'   => site_url('Constitution/index'), 
          'id'      => set_value('id',$this->input->post('id')),
          'article_id'        => set_value('article_id',$this->input->post('article_id')),
          'article_title'        => set_value('article_title',$this->input->post('article_title')),
          'article_title_marathi'        => set_value('article_title_marathi',$this->input->post('article_title_marathi')),
          'article_title_hindi'        => set_value('article_title_hindi',$this->input->post('article_title_hindi')),
          'description'     => set_value('description',$this->input->post('description')),
          'description_marathi'     => set_value('description_marathi',$this->input->post('description_marathi')),
          'description_hindi'     => set_value('description_hindi',$this->input->post('description_hindi')),
        ); 
        $this->load->view('constitution/form',$data);
    }

    public function create_action() 
    {   
        $id = '0';
        $this->_rules($id);
        if($this->form_validation->run() == FALSE) 
        {  
            $this->create();
        } 
        else 
        { 
          $data = array(
              'article_id'      => $this->input->post('article_id'),
              'article_title'      => trim($this->input->post('article_title')),
              'article_title_marathi'      => trim($this->input->post('article_title_marathi')),
              'article_title_hindi'      => trim($this->input->post('article_title_hindi')),
              //'section'     => $this->input->post('section'),
              'description'    => trim($this->input->post('description')),
              'description_marathi'    => trim($this->input->post('description_marathi')),
              'description_hindi'    => trim($this->input->post('description_hindi')),
          );  
          $this->Crud_model->SaveData("constitution_article_details",$data);
          $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Created successfully</span>');
          redirect('Constitution/index');
        }
    }


    
  
    //UPDATE 
    public function update($update_id) 
    {  
       $articles = $this->Crud_model->GetData('constitution_articles',"title,id","status='Active'","","title asc");
        if(!empty($update_id)) 
        {
            $id = base64_decode($update_id);
            
            $row = $this->Crud_model->GetData("constitution_article_details",'',"id='".$id."'",'','','','1'); 
            $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                              <i class='ace-icon fa fa-home home-icon'></i>
                              <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Constitution</li>
                          </ul>";

            if(!empty($row)) 
            {
                $data=array(
                    'button'    => 'Update',
                    'heading'   => 'Update',
                    'breadcrumbs' => $breadcrumbs,
                    'articles' => $articles,
                    'cancelbtn'   => site_url('Constitution/index'), 
                    'action'    => site_url('Constitution/update_action'.'/'.$update_id),
                    'id'      => set_value('id', $row->id),
                    'article_id'   => set_value('article_id', $row->article_id),
                    'article_title'   => set_value('article_title', $row->article_title),
                    'article_title_marathi'   => set_value('article_title_marathi', $row->article_title_marathi),
                    'article_title_hindi'   => set_value('article_title_hindi', $row->article_title_hindi),
                    'description'   => set_value('description', $row->description),
                    'description_marathi'   => set_value('description_marathi', $row->description_marathi),
                    'description_hindi'   => set_value('description_hindi', $row->description_hindi),
                );
                $this->load->view('constitution/form',$data);
            } 
            else 
            {
                print_r("expression");exit;
                $this->session->set_flashdata('message', 'Record Not Found');
                redirect('Constitution/index');
            }
        } 
        else 
        {
            print_r("expression1");exit;
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect('Constitution/index');
        }
    }

    //UPDATE ACTION
    public function update_action($update_id) 
    {
        $id = base64_decode($update_id);
        $this->_rules($id);
        if ($this->form_validation->run() == FALSE) 
        {          
            $this->update($update_id);
        } 
        else 
        {  
            $data = array(
                'article_id' => $this->input->post('article_id',TRUE),
                'article_title' => trim($this->input->post('article_title',TRUE)),
                'article_title_marathi' => trim($this->input->post('article_title_marathi',TRUE)),
                'article_title_hindi' => trim($this->input->post('article_title_hindi',TRUE)),
                'description' => trim($this->input->post('description',TRUE)),
                'description_marathi' => trim($this->input->post('description_marathi',TRUE)),
                'description_hindi' => trim($this->input->post('description_hindi',TRUE)),
            ); 
            $id = $this->input->post('id', TRUE);
            $con  = "id = '".$id."'";
            $this->Crud_model->SaveData("constitution_article_details",$data,$con);
            $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Updated successfully</span>');
            redirect('Constitution/index');
        }
    }

    public function changeStatus() 
    {   
        $change_status = $this->Crud_model->GetData('constitution_article_details','',"id='".$_POST['id']."'",'','','','row');

        if($change_status->status=='Active')
        {
            $this->Crud_model->SaveData('constitution_article_details',array('status'=>'Inactive'),"id='".$_POST['id']."'");
        }
        else
        {
            $this->Crud_model->SaveData('constitution_article_details',array('status'=>'Active'),"id='".$_POST['id']."'");
        }
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
        redirect('Constitution/index');
    }

    public function delete() 
    {
        $con = "id='".$_POST['id']."'";
        $this->Crud_model->DeleteData('constitution_article_details',$con);

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Deleted successfully</span>');
        redirect('Constitution/index');
    } 

    public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Constitution/index'));            
   } 
   $data = $fields_fun;
  //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='')
      { 
         $getConstitution = $this->Crud_model->GetData('constitution_article_details','article_title',"article_title='".trim($val[1])."'",'','','','single'); 
       
         $constitution_articles = $this->Crud_model->GetData('constitution_articles','id',"title='".$val[0]."'",'','','','single'); 

         /*for already exist check*/

         if(empty($getConstitution))
         {
            if(!empty($constitution_articles))
            {
               $article_id=$constitution_articles->id;
            } 
            else
            {
               $article_id="";
            }

            if(!empty($val[1]))
            {
               $article_title=$val[1];
            } 
            else
            {
               $article_title="";
            }

            if(!empty($val[2]))
            {
               $description=$val[2];
            } 
            else
            {
               $description="";
            }

  
            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'article_id' => $article_id,
               'article_title' => trim($article_title),
               'description' => trim($description),
            );

            $SaveAssets = $this->Crud_model->SaveData('constitution_article_details',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],'Already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Constitution/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('constitution/duplicateConstitutation',$data);
   } 
}

    // SEVER SIDE VALIDATION
    public function _rules($id) 
    {
        $cond = "article_id='".trim($this->input->post('article_id',TRUE))."' and article_title='".trim($this->input->post('article_title',TRUE))."' and id!='".$id."'";
        $row = $this->Crud_model->GetData("constitution_article_details",'',$cond,'','','','');
        $count = count($row);

        if($count==0) 
        {
            $is_unique = "";
            //$is_unique2 = "";
        } 
        else 
        {
            $is_unique = "|is_unique[constitution_article_details.article_title]";
            //$is_unique2 = "|is_unique[constitution_article_details.section]";
        } 
        
        // $this->form_validation->set_rules('article_no', 'article no', 'trim|required'.$is_unique,
        // array(
        //   'required'      => 'Please enter %s',
        //   'is_unique'     => 'article no already exists'
        // ));

        $this->form_validation->set_rules('article_title', 'article_title', 'trim|required'.$is_unique,
        array(
          'required'      => 'Please enter %s',
          'is_unique'     => 'Section already exists'
        ));

        //$this->form_validation->set_rules('section', 'section', 'trim|required', array('required' => 'Please enter %s'));
        
        $this->form_validation->set_rules('description', 'description', 'trim|required', array('required' => 'Please enter %s'));


       
        $this->form_validation->set_rules('id', 'id', 'trim');
        $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
    }
}