<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CMS extends CI_Controller {

  function __construct()
  {
  parent::__construct();
  $this->load->model('Cms_model');
  $this->load->database();
  }
  
  public function index()
  {   
      
        $breadcrumbs = "<ul class='breadcrumb'>
                    <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li class='active'>Manage CMS</li>
                    </ul>";

        $data = array('breadcrumbs' => $breadcrumbs ,'actioncolumn' => '3' ,'ajax_manage_page' => site_url('CMS/ajax_manage_page'),'heading' => 'Manage CMS');
        $this->load->view('cms/list',$data);
  }



    public function ajax_manage_page()
    {
        $getData = $this->Cms_model->get_datatables(); 
        $data = array();       
        $no=0; 
        foreach($getData as $row) 
        {  
            $btn = '';

            $btn = ('<a href='.site_url("CMS/update/".$row->id).' class="green" ><span class="btn btn-info btn-circle btn-sm"><i class="ace-icon fa fa-pencil bigger-130"></i></span></a>');
            
            $no++;
            $nestedData = array();
            $nestedData[] = $no ;
            $nestedData[] = $row->cms_title;
            $nestedData[] = $row->description;      
            $nestedData[] = $btn;       
            $data[] = $nestedData;
            $selected = '';
        }

        $output = array(
                    "draw" => $_POST['draw'],
                    "recordsTotal" => $this->Cms_model->count_all(),
                    "recordsFiltered" => $this->Cms_model->count_filtered(),
                    "data" => $data,
                );
       
        echo json_encode($output);
    }

    public function update($id)
    {
      $mail_body = $this->Crud_model->GetData('cms',"","id='".$id."'",'','','','row');
       $breadcrumbs = "<ul class='breadcrumb'>
                    <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                     <li>
                        <a href='".site_url('CMS')."'>Manage CMS</a>
                    </li>
                    <li class='active'>Update CMS</li>
                    </ul>";
      
      $data = array(
                      'button' => 'Update',
                      'action' => site_url('CMS/update_action/'.$id), 
                      'breadcrumbs' => $breadcrumbs, 
                       'heading' => 'Update CMS',                   
                       'id' => set_value('id',$mail_body->id),
                       'cms_title' => set_value('cms_title',$mail_body->cms_title),
                       'description' => set_value('description',$mail_body->description),
                       'image' => set_value('image',$mail_body->image),
                    );

      $this->load->view('cms/form',$data);

    }

    public function update_action($id)
    {
      
      if($id!='')
      {

          $image=$_POST['image'];
          if($_FILES['image']['name']!='' )
          {
            $image= rand(0000,9999)."_".$_FILES['image']['name'];
            $config2['image_library'] = 'gd2';
            $config2['source_image'] =  $_FILES['image']['tmp_name'];
            $config2['new_image'] =   getcwd().'/uploads/cms/'.$image;
            $config2['upload_path'] =  getcwd().'/uploads/cms/';
              $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
            $this->image_lib->initialize($config2);
            if(!$this->image_lib->resize())
            {
              echo('<pre>');
              echo ($this->image_lib->display_errors());
              exit;
            }   
          }

          $data = array(
            'cms_title'=>$_POST['cms_title'],
            'description'=>$_POST['description'],
            'image'=>$image,
            );

            $this->Crud_model->SaveData("cms",$data,"id='".$id."'");      
            $this->session->set_flashdata('message', 'success');
            redirect('CMS/index');
      }
      else
      {
        redirect('Mail_body');
      }
    }
}
