<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Branches extends CI_Controller 
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Branches_model");
    }

    public function index()
    {
        $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Branches</li>
                        </ul>";

        $data = array(
            'breadcrumbs' => $breadcrumbs,
            'actioncolumn' => '11',
            'ajax_manage_page' => site_url('Branches/ajax_manage_page'),
            'action' => site_url('Branches/create'),
            'deleteAction' => site_url('Branches/delete'),
            'changeAction' => site_url('Branches/changeStatus'),
            'button' => 'Create',
            'heading' => 'Manage Branches',
        );
        $this->load->view('branches/list',$data);
    }

    public function ajax_manage_page() 
    {
        $Data = $this->Branches_model->get_datatables();  
        //echo "<pre>"; print_r($Data); die();
        $data = array();  
        if(empty($_POST['start'])) {
          $no =0;   
        } else {
          $no =$_POST['start'];
        }

        foreach($Data as $row) {
          $viewUrl = "Branches/view";
          $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

          // $assignUrl = "Branches/assignBranchHead";
          // $btn .='<span class="action-buttons"><a title="Assign Branch Head" href="'.site_url($assignUrl.'/'.base64_encode($row->id)).'" class="btn btn-warning btn-circle btn-xs"><i class="fa fa-arrows-h"></i></a></span>&nbsp;|&nbsp;';

          // $assignUrl = "Branches/assignBranchHead";
          // $btn .= '&nbsp;|&nbsp;'.('<a href="#myModalassign" title="Branch Head"  data-toggle="modal" data-target="" class="btn btn-warning btn-circle btn-xs" onclick="getEditvalueassign('.$row->id.');">
          //     <i class="fa fa-arrows-h"></i></a>&nbsp;|&nbsp;');

          $updateUrl = "Branches/update";
          $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';


          $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

          if($row->status=='Active')
            {
              $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
            }
            else
            {
              $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
            }
          $no++;  
          $nestedData = array();
          $nestedData[] = $no;
          $nestedData[] = ucfirst($row->department_name);
          $nestedData[] = $row->branch_name;
          $nestedData[] = $row->zone_name;
          $nestedData[] = $row->area;
          $nestedData[] = $row->address;
          $nestedData[] = $status;
          $nestedData[] = $btn;
          $data[] = $nestedData;
          $selected = '';

        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Branches_model->count_all(),
          "recordsFiltered" => $this->Branches_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
    
  public function create() {  
      $departments = $this->Crud_model->GetData('mst_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc");
      //$branchEmpHead = $this->Branches_model->branchEmpHead();

      $corporates = $this->Crud_model->GetData('corporates',"name,role,id","role='Employees' and status='Active' and is_delete='No'","","name asc");

      $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and is_delete='No'","","zone_name asc");

      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                            <i class='ace-icon fa fa-home home-icon'></i>
                            <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li>Manage Branches</li>
                        <li class='active'>Add Branch</li>
                        </ul>";

        $data = array(
          'button'    => 'Create',
          'heading'   => 'Create Branch',
          'breadcrumbs' => $breadcrumbs,
          'departments'    => $departments,
          'corporates'    => $corporates,
          'zones'    => $zones,
          //'areas'    => $areas,
          //'branchEmpHead'    => $branchEmpHead,
          'action'    => site_url('Branches/create_action'),
          'cancelbtn'   => site_url('Branches/index'), 
          'id'      => set_value('id',$this->input->post('id')),
          'department_id'      => set_value('department_id',$this->input->post('department_id')),
          'zone_id'      => set_value('zone_id',$this->input->post('zone_id')),
          'area_id'      => set_value('area_id',$this->input->post('area_id')),
          'branch_name'        => set_value('branch_name',$this->input->post('branch_name')),
          'branch_name_marathi'        => set_value('branch_name_marathi',$this->input->post('branch_name_marathi')),
          'branch_name_hindi'        => set_value('branch_name_hindi',$this->input->post('branch_name_hindi')),
          'address'    => set_value('address',$this->input->post('address')),
          'address_marathi'    => set_value('address_marathi',$this->input->post('address_marathi')),
          'address_hindi'    => set_value('address_hindi',$this->input->post('address_hindi')),
          'description'    => set_value('description',$this->input->post('description')),
          'description_marathi'    => set_value('description_marathi',$this->input->post('description_marathi')),
          'description_hindi'    => set_value('description_hindi',$this->input->post('description_hindi')),
          'lattitude' => set_value('lat',$this->input->post('lat')),
          'longitude' => set_value('lon',$this->input->post('lon')),
        ); 
        $this->load->view('branches/form',$data);
  }


  public function create_action() {   
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) {  
      $this->create();
    } 
    else
     {
        //echo "<pre>"; print_r($_POST); die();
        $image='';
        if( $_FILES['image']['name']!='' )
        {
          $image= rand(0000,9999)."_".$_FILES['image']['name'];
          $config2['image_library'] = 'gd2';
          $config2['source_image'] =  $_FILES['image']['tmp_name'];
          $config2['new_image'] =   getcwd().'/uploads/branches/'.$image;
          $config2['upload_path'] =  getcwd().'/uploads/branches/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
          $this->image_lib->initialize($config2);
          if(!$this->image_lib->resize())
          {
            echo('<pre>');
            echo ($this->image_lib->display_errors());
            exit;
          }
        }

        $data = array(
          'department_id'      => $this->input->post('department_id'),
          'zone_id'      => $this->input->post('zone_id'),
          'area_id'      => $this->input->post('area_id'),
          //'branch_head_id'      => $this->input->post('branch_head_id'),
          //'branch_emp_id'      => $this->input->post('branch_emp_id'),
          'branch_name'     => trim($this->input->post('branch_name')),
          'branch_name_marathi'     => trim($this->input->post('branch_name_marathi')),
          'branch_name_hindi'     => trim($this->input->post('branch_name_hindi')),
          'address'    => $this->input->post('address'),
          'address_marathi'    => trim($this->input->post('address_marathi')),
          'address_hindi'    => trim($this->input->post('address_hindi')),
          'description'    => trim($this->input->post('description')),
          'description_marathi'    => trim($this->input->post('description_marathi')),
          'description_hindi'    => trim($this->input->post('description_hindi')),
          'lattitude'    => $this->input->post('lat'),
          'longitude'    => $this->input->post('lon'),
          'image'    => $image,
        );  
        $this->Crud_model->SaveData("mst_department_branches",$data);
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Branch has been created successfully</span>');
        redirect('Branches/index');
    }
  }

  
    // VIEW
    public function view($id)
    {
        $cond = "id='".base64_decode($id)."'";
        $row = $this->Branches_model->branchDetails($cond);
        // echo "<pre>"; print_r($row); die();
        $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Branches/index').'">Manage Branches</a></l>
                        <li class="active">Branches Detail</li>
                      </ul>';

        $data = array(

                        'breadcrumbs'=>$breadcrumbs, 
                        'branch_id'=>$row->id,    
                        'department_name'=>$row->department_name,    
                        'branch_name'=>$row->branch_name,
                        'branch_name_hindi'=>$row->branch_name_hindi,
                        'branch_name_marathi'=>$row->branch_name_marathi,
                        'zone_name'=>$row->zone_name,
                        'area'=>$row->area,
                        'address'=>$row->address,
                        'address_marathi'=>$row->address_marathi,
                        'address_hindi'=>$row->address_hindi,
                        'backButton' => site_url('Branches'),
                  );
       $this->load->view('branches/view',$data);
    }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_department_branches",'',"id='".$id."'",'','','','1'); 
      
      $departments = $this->Crud_model->GetData('mst_departments',"","status='Active' and is_delete='No'");
      
      $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No'","","zone_name asc");

      //$areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and id='".$row->area_id."'","","area asc");

      $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No' and zone_id='".$row->zone_id."'","","area asc");

      $corporates = $this->Crud_model->GetData('corporates',"name,role,id","role='Employees' and status='Active'  and is_delete='No'","","name asc");

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'><a href='".site_url('Branches')."'>Manage Branches</a></li>
                      <li class='active'>Update Branch</li>
                    </ul>";

      if(!empty($row)) {
       
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Branch',
          'breadcrumbs' => $breadcrumbs,
          // 'branchHeads' => $branchHeads,
          'corporates' => $corporates,
          'areas' => $areas,
          'zones' => $zones,
          'cancelbtn'   => site_url('Branches/index'), 
          'action'    => site_url('Branches/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
           'department_id'=> set_value('department_id', $row->department_id),
           'zone_id'=> set_value('zone_id', $row->zone_id),
           'area_id'=> set_value('area_id', $row->area_id),
          'branch_name'   => set_value('branch_name', $row->branch_name),
          'branch_name_marathi'   => set_value('branch_name_marathi', $row->branch_name_marathi),
          'branch_name_hindi'   => set_value('branch_name_hindi', $row->branch_name_hindi),
          'address'   => set_value('address', $row->address),
          'address_marathi'   => set_value('address_marathi', $row->address_marathi),
          'address_hindi'   => set_value('address_hindi', $row->address_hindi),
          'description'   => set_value('description', $row->description),
          'description_marathi'   => set_value('description_marathi', $row->description_marathi),
          'description_hindi'   => set_value('description_hindi', $row->description_hindi),
          'lattitude'   => set_value('lat', $row->lattitude),
          'longitude'   => set_value('lon', $row->longitude),
          'image'   => set_value('image', $row->image),
          'departments' =>$departments,
        );
        $this->load->view('branches/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Branches/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Branches/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {

    $id = base64_decode($update_id);
    //echo $id; die;

    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } 
    else 
    {  
      $image=$_POST['old_image'];
      if($_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/branches/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/branches/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      
      }
      $data = array(
       
        'department_id' => $this->input->post('department_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        //'branch_head_id' => $this->input->post('branch_head_id',TRUE),
        //'branch_emp_id' => $this->input->post('branch_emp_id',TRUE),
        'branch_name' => trim($this->input->post('branch_name',TRUE)),
        'branch_name_marathi' => trim($this->input->post('branch_name_marathi',TRUE)),
        'branch_name_hindi' => trim($this->input->post('branch_name_hindi',TRUE)),
        'address' => trim($this->input->post('address',TRUE)),
        'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),
        'description' => trim($this->input->post('description',TRUE)),
        'description_marathi' => trim($this->input->post('description_marathi',TRUE)),
        'description_hindi' => trim($this->input->post('description_hindi',TRUE)),
        'lattitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_department_branches",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Branch has been updated successfully</span>');
      redirect('Branches/index');
      
    }
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('mst_department_branches','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
        $this->Crud_model->SaveData('mst_department_branches',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('mst_department_branches',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Branches/index');
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('mst_department_branches', $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Branch deleted successfully</span>');
    redirect('Branches/index');
  } 

  public function getArea() {
      $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and status='Active'  and is_delete='No'",'',"area asc");

      if(!empty($areas)) {
        $response = '<option value="">Select Area</option>';
        foreach($areas as $row) {
          $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
        }
      }else {
          $response = '<option value="">Select Area</option>';
      }
      echo $response;
    }

  public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
}   

  public function assignBranchHead($id) {

      $cond = base64_decode($id);
      // $row = $this->Branches_model->branchMembers($cond);

      $notAssignedHead = $this->Branches_model->getNotAssignedHead();
      // echo "<pre>"; print_r($notAssignedHead); die();
      $row = $this->Crud_model->GetData("mst_department_branches",'',"id='".$cond."'",'','','','1'); 
      
      $departments = $this->Crud_model->GetData('mst_departments',"","status='Active' and is_delete='No'");

      $branches = $this->Crud_model->GetData('mst_department_branches',"","status='Active' and is_delete='No'");

      $corporates = $this->Crud_model->GetData('corporates',"","status='Active' and is_delete='No' and role='Employees'");

      $breadcrumbs='<ul class="breadcrumb">
                        <li>
                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                        </li>
                        <li><a href="'.site_url('Branches/index').'">Manage Branches</a></l>
                        <li class="active">Assign Branch Head</li>
                    </ul>';

        $data = array(
              'breadcrumbs'=>$breadcrumbs, 
              'departments'=>$departments,
              'corporates'=>$corporates,
              'notAssignedHead'=>$notAssignedHead,
              'action' => site_url('Branches/assignBranchHeadAction'.'/'.$id),
              'id'=>set_value('id', $row->id),  
              'department_id'=> set_value('department_id', $row->department_id),
              'branch_name'   => set_value('branch_name', $row->branch_name),
              'branch_emp_id'   => set_value('branch_emp_id', $row->branch_emp_id),
              'button' => 'Assign',
              'cancelbtn' => site_url('Branches/index'), 
              'heading' => 'Assign Branch Head',
              );
       $this->load->view('branches/assignBranchHead',$data);
  }

  public function assignBranchHeadAction($id) {
    
    $cond = base64_decode($id);
    // echo $cond; die;

    $data = array(
     
      'department_id' => $this->input->post('department_id',TRUE),
      'branch_name' => $this->input->post('branch_name',TRUE),
      'branch_emp_id' => $this->input->post('branch_emp_id',TRUE),
    ); 
    // echo "<pre>"; print_r($data); die();

    $id = $this->input->post('id', TRUE);
    $con  = "id = '".$id."'";
    $this->Crud_model->SaveData("mst_department_branches",$data,$con);
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Branch Head has been assigned successfully</span>');
    redirect('Branches/index');
      
  }

  public function getEditvalueassign()
  {
      $notAssignedHead = $this->Branches_model->getNotAssignedHead();
      // echo "<pre>"; print_r($notAssignedHead); die();

      $html= '<option value="">Select Branch Head</option>';
      foreach ($notAssignedHead as $row) 
      {
        $html .='<option value="'.$row->id.'">'.$row->name.'</option>';
      }
      echo $html; exit();

  }

  public function addAssignData()
  {
    // echo "<pre>"; print_r($_POST);die();
        $data = array(
          'branch_emp_id' => $this->input->post('head_id'),
          'modified' => date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('mst_department_branches', $data, "id = '".$this->input->post('branch_id')."'");
        $this->session->set_flashdata('message', 'success');
        echo 2;
  }
  
  
  public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Branches/index'));            
   } 
   $data = $fields_fun;
  //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='')
      { 
         $getBranch = $this->Crud_model->GetData('mst_department_branches','branch_name',"branch_name='".trim($val[1])."'",'','','','single'); 
       
         $departments = $this->Crud_model->GetData('mst_departments','id',"department_name='".$val[0]."'",'','','','single'); 

         $areas = $this->Crud_model->GetData('mst_areas','id',"area='".$val[2]."'",'','','','single'); 
         /*for already exist check*/

         if(empty($getBranch))
         {

            if(!empty($val[4]))
            {
               $description=$val[4];
            } 
            else
            {
               $description="";
            }

            if(!empty($val[3]))
            {
               $address=$val[3];
            } 
            else
            {
               $address="";
            }

            if(!empty($areas))
            {
               $area_id=$areas->id;
            } 
            else
            {
               $area_id="";
            }

            if(!empty($val[1]))
            {
               $branch_name=$val[1];
            } 
            else
            {
               $branch_name="";
            }

            if(!empty($departments))
            {
               $department_id=$departments->id;
            } 
            else
            {
               $department_id="";
            }
  
            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'department_id' => $department_id,
               'branch_name' => trim($branch_name),
               'area_id' => $area_id,
               'address' => $address,
               'description' => $description,
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_department_branches',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],'Branch already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Branches/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('branches/duplicateBranches',$data);
   } 
}



  // SEVER SIDE VALIDATION
  public function _rules($id) {
      $cond = "department_id='".trim($this->input->post('department_id',TRUE))."' and branch_name='".trim($this->input->post('branch_name',TRUE))."' and id!='".$id."'";
      $row = $this->Crud_model->GetData("mst_department_branches",'',$cond,'','','','');
      $count = count($row); 
      if($count==0) {
        $is_unique = "";
        
      } else {
        $is_unique = "|is_unique[mst_department_branches.branch_name]";
        
      } 

      $this->form_validation->set_rules('branch_name', 'branch name', 'trim|required'.$is_unique,
      array(
        'required'      => 'Please enter %s',
        'is_unique'     => 'Branch already exists'
      ));

      $this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please enter %s'));

      $this->form_validation->set_rules('area_id', 'area', 'trim|required', array('required' => 'Please select %s'));
  
      
      $this->form_validation->set_rules('id', 'id', 'trim');
      $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}