<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bpatrak extends CI_Controller {
  

  public function __construct() {
    parent::__construct();
     $this->load->library('Excel');
    $this->load->model("Bpatrak_model");
  }


  public function index()
  {   

    $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Incidence Spot</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '8',
            'heading' => 'Incidence Spot',
            'deleteAction' => site_url('Bpatrak/delete'),
            'ajax_manage_page' => site_url('Bpatrak/ajax_manage_page'),
          );
          $this->load->view('bpatrak/list',$data);
  }


  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.district_id='".$row->district_id."'";
      
    }else{

    $condition = "1=1";
    }
    $getData = $this->Bpatrak_model->get_datatables($condition);

    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {

      $viewUrl = "Bpatrak/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($Data->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

      if($_SESSION[SESSION_NAME]['type']=='admin'){

      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
    }

        if(empty($Data->description) || $Data->description=="" || $Data->description==null)
              {
                  $description =  "N/A";            
              }
              else
              {
                  if(strlen($Data->description)>100)
                  {
                      $description = substr($Data->description, 0,100).'...';
                  } else {
                      $description = $Data->description;                
                  }
              }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($Data->name);
      $nestedData[] = ucfirst($Data->police_name);
      $nestedData[] = $Data->incident_name;
      $nestedData[] = $description;
      $nestedData[] = date("d-m-Y", strtotime($Data->date));
      $nestedData[] = date("h:i:s", strtotime($Data->time));
      $nestedData[] = $Data->current_location;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Bpatrak_model->count_all($condition),
      "recordsFiltered" => $this->Bpatrak_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function view($id)
  {
    $id = base64_decode($id);
    $con="b.id='".$id."'";
    $row = $this->Bpatrak_model->viewBpatrakDetails($con);
    
    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Bpatrak/index').'">Manage Incidence Spot</a></li>
                    <li class="active">Incidence Spot Details</li>
                  </ul>';

    if(!empty($row))
    {
      $data = array(
        "breadcrumbs"=>$breadcrumbs,
        "cancelbtn"=>site_url('Bpatrak'),
        "station_name"=>$row->name,
        "police_name"=>$row->police_name,
        "current_location"=>$row->current_location,
        "incident_name"=>$row->incident_name,
        "description"=>$row->description,        
        "location"=>$row->current_location,        
        "date"=>$row->date,        
        "time"=>$row->time,        
        "image"=>$row->image,
        "video"=>$row->video,
      );
      $this->load->view('bpatrak/view', $data);
    }   
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Bpatrak/index');
    }         
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->DeleteData('bpatrak',$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Bpatrak/index');
   } 

 

  public function export() 
{
    ob_clean();
    $bpatrakData = $this->Bpatrak_model->getBpatrakData();
    $FileTitle='incidenceSpot_'.date('Ymd');
    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Incident Spot Details');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Incident Spot Details');
    $this->excel->getActiveSheet()->setCellValue('A3', 'Sr.No');
    $this->excel->getActiveSheet()->setCellValue('B3', 'Station Name');
    $this->excel->getActiveSheet()->setCellValue('C3', 'Police Name');
    $this->excel->getActiveSheet()->setCellValue('D3', 'Datee');
    $this->excel->getActiveSheet()->setCellValue('E3', 'Time');
    $this->excel->getActiveSheet()->setCellValue('F3', 'Incident Name');
    $this->excel->getActiveSheet()->setCellValue('G3', 'Discription');
    $this->excel->getActiveSheet()->setCellValue('H3', 'Location.');
    $this->excel->getActiveSheet()->setCellValue('I3', 'Image');
    $this->excel->getActiveSheet()->setCellValue('J3', 'Video');
   
    $a='4';        
    $sr_no=1;
    foreach ($bpatrakData as $line)
    {
        if(!empty($line->image)){
          $img=base_url('uploads/patrolling/'.$line->image);
          }else{
          $img="N/A";
          }
         if(!empty($line->video)){
         $video=base_url('uploads/patrolling/'.$line->video);
         }else{
        $video="N/A";
        }
        $this->excel->getActiveSheet()->setCellValue('A'.$a, $sr_no);
        $this->excel->getActiveSheet()->setCellValue('B'.$a, strtoupper($line->name)); 
        $this->excel->getActiveSheet()->setCellValue('C'.$a, strtoupper($line->police_name));
        $this->excel->getActiveSheet()->setCellValue('D'.$a,  date('d-m-Y',strtotime($line->date)));
        $this->excel->getActiveSheet()->setCellValue('E'.$a, date('h:m:i',strtotime($line->time)));
        $this->excel->getActiveSheet()->setCellValue('F'.$a, strtoupper($line->incident_name));
        $this->excel->getActiveSheet()->setCellValue('G'.$a, strtoupper($line->description));
        $this->excel->getActiveSheet()->setCellValue('H'.$a, strtoupper($line->current_location));            
        $this->excel->getActiveSheet()->setCellValue('I'.$a,  $img);
        $this->excel->getActiveSheet()->setCellValue('J'.$a, $video);
        +
        $a++;
        $sr_no++;
    }
            $this->excel->getActiveSheet()->mergeCells('A1:J1');
            $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(14);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('G3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('H3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('I3')->getFont()->setSize(11);
            $this->excel->getActiveSheet()->getStyle('J3')->getFont()->setSize(11);

            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('A3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I3')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J3')->getFont()->setBold(true);
   
      foreach(range('A','J') as $columnID)
      {
          $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
      }
    $filename=$FileTitle.'.xls'; 
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="'.$filename.'"'); 
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
    $objWriter->save('php://output');
}

  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Bpatrak/index'));            
    } 
    $data = $fields_fun;
    //echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' )
      { 
         $police_station_id = $this->Crud_model->GetData('mst_police_stations','',"name='".trim($val[1])."'",'','','','single'); 
          
         $police_id = $this->Crud_model->GetData('mst_police','id',"police_name='".trim($val[2])."'",'','','','single'); 

       
     

         if(!empty($police_station_id)){

            if(!empty($val[7]))
            {
               $current_location=$val[7];
            } 
            else
            {
               $current_location="";
            }

            if(!empty($val[6]))
            {
               $description=$val[6];
            } 
            else
            {
               $description="";
            }

            if(!empty($val[5]))
            {
               $incident_name=$val[5];
            } 
            else
            {
               $incident_name="";
            }

            if(!empty($val[4]))
            {
               $time=$val[4];
            } 
            else
            {
               $time="";
            }

            if(!empty($val[3]))
            {
               $date=$val[3];
            } 
            else
            {
               $date="";
            }

            if(!empty($police_station_id))
            {
               $station_id=$police_station_id->id;
               $country_id=$police_station_id->country_id;
               $state_id=$police_station_id->state_id;
               $district_id=$police_station_id->district_id;
               $city_id=$police_station_id->city_id;
            } 
            else
            {
               $station_id="";
              $country_id='';
              $state_id='';
              $district_id='';
              $city_id='';
            }
            if(!empty($police_id))
            {
               $police_id=$police_id->id;
            } 
            else
            {
               $police_id="";
            }


            
            $data = array(       
        "police_station_id"=>$station_id,
        'country_id'=> $country_id,
        'state_id'=> $state_id,
        'district_id'=> $district_id,
        'city_id'=> $city_id,
        "police_id"=>$police_id,
        "date"=> date("d/m/Y", strtotime($date)),        
        "time"=>date("h:i:s", strtotime($time)),        
        "incident_name"=>$incident_name,
        "description"=>$description,        
        "current_location"=>$current_location,
         
       
      );
            $SaveAssets = $this->Crud_model->SaveData('bpatrak',$data);
        } else
         { 
             $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Police sation not exists</span>');
             redirect('Bpatrak/index');
         }   
      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Mandatory fields empty');
          $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Mandatory fields empty</span>');
             redirect('Bpatrak/index');
      }
   }
    $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Police sation not exists</span>');
             redirect('Bpatrak/index');
 } 
}