<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Zones extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Zones_model');
    $this->load->database();
  }

  public function index()
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
    <li>
    <i class='ace-icon fa fa-home home-icon'></i>
    <a href='".site_url('Dashboard')."'>Dashboard</a>
    </li>
    <li class='active'>Manage Zones</li>
    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '7',
      'ajax_manage_page' => site_url('Zones/ajax_manage_page'),
      'heading' => 'Manage Zones',
    );
    $this->load->view('zones/list',$data);
  }

  public function ajax_manage_page()
  {
    $Data = $this->Zones_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start']))
    {
      $no =0;   
    }
    else
    {
      $no =$_POST['start'];
    }      
    foreach($Data as $row) 
    {
      $updateUrl = "Zones/update";

      $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = ucfirst($row->city_name);
      $nestedData[] = ucfirst($row->zone_name);
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Zones_model->count_all(),
      "recordsFiltered" => $this->Zones_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                    <i class='ace-icon fa fa-home home-icon'></i>
                    <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Zones')."'>Manage Zones</a></li>
                    <li class='active'>Create Zone</li>
                  </ul>";

    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");
    
    $data = array(
      'button'=>'Create',
      'heading'=>'Create Zone',
      'sub_title'=>'Create',
      'countries' =>$countries,
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url('Zones/create_action'), 
      'cancelbtn' => site_url('Zones/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'zone_name' =>  set_value('zone_name',$this->input->post('zone_name')),
      'zone_name_marathi' =>  set_value('zone_name_marathi',$this->input->post('zone_name_marathi')),
      'zone_name_hindi' =>  set_value('zone_name_hindi',$this->input->post('zone_name_hindi')),
    ); 
    $this->load->view('zones/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $data = array(
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_name' => trim($this->input->post('zone_name',TRUE)),
        'zone_name_hindi' => trim($this->input->post('zone_name_hindi',TRUE)),
        'zone_name_marathi' => trim($this->input->post('zone_name_marathi',TRUE)),
      );  
      $this->Crud_model->SaveData("mst_zones",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Zone has been created successfully</span>');
      redirect('Zones/index');
    }
  }

  //UPDATE 
  public function update($update_id)
  {  
    if(!empty($update_id))
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_zones",'',"id='".$id."'",'','','','1'); 
      $breadcrumbs="<ul class='breadcrumb'>
                    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
                    <li><a href='".site_url('Zones')."'>Manage Zones</a></li>
                    <li class='active'>Update Zones</li>
                    </ul>";

      if(!empty($row))
      {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Zones',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'districts'   => $districts,
          'cities'   => $cities,
          'cancelbtn'   => site_url('Zones'), 
          'action'    => site_url('Zones/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id' => set_value('district_id', $row->district_id),
          'city_id' => set_value('city_id', $row->city_id),
          'zone_name'   => set_value('zone_name', $row->zone_name),
          'zone_name_marathi'   => set_value('zone_name_marathi', $row->zone_name_marathi),
          'zone_name_hindi'   => set_value('zone_name_hindi', $row->zone_name_hindi),
        );
        $this->load->view('zones/form',$data);
      }
      else
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Zones/index');
      }
    }
    else
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Zones/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE)
    {          
      $this->update($update_id);
    }
    else 
    {  
      $data = array(
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_name' => ucwords($this->input->post('zone_name',TRUE)),
        'zone_name_marathi' => trim($this->input->post('zone_name_marathi',TRUE)),
        'zone_name_hindi' => trim($this->input->post('zone_name_hindi',TRUE)),
        'modified'=> date('Y-m-d H:i:s'),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_zones",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Zone has been updated successfully</span>');
      redirect('Zones/index');
    }
  }

  public function delete()
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_zones', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Zone deleted successfully</span>');
    redirect('Zones/index');
  } 

  public function changeStatus()
  {
    $change_status = $this->Crud_model->GetData('mst_zones','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active')
    {
      $this->Crud_model->SaveData('mst_zones',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
      $this->Crud_model->SaveData('mst_zones',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Zones/index');
  }

  function getState()
    {
        $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"state_name asc");
        if(!empty($states))
        {
            $response = '<option value="">Select State</option>';
            foreach($states as $row)
            {
                 $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
            }
        }
        else
        {
             $response = '<option value="">Select State</option>';
        }

        echo $response;
    }


    public function getDistrict()
    {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
    }

    public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and status='Active' and is_delete='No'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }

   public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Zones/index'));            
   } 
   $data = $fields_fun;

   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='')
      { 
         $getZone = $this->Crud_model->GetData('mst_zones','zone_name',"zone_name='".$val[4]."'",'','','','single'); 
       
         $countries = $this->Crud_model->GetData('mst_countries','id',"country_name='".$val[0]."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[1]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[2]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[3]."'",'','','','single');   

         /*for already exist check*/

         if(empty($getZone))
         {

            if(!empty($val[6]))
            {
               $zone_name_hindi=$val[6];
            } 
            else
            {
               $zone_name_hindi="";
            }

            if(!empty($val[5]))
            {
               $zone_name_marathi=$val[5];
            } 
            else
            {
               $zone_name_marathi="";
            }

            if(!empty($val[4]))
            {
               $zone_name=$val[4];
            } 
            else
            {
               $zone_name="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($countries))
            {
               $country_id=$countries->id;
            } 
            else
            {
               $country_id="";
            }
            
            $data = array(
               'country_id' => $country_id,
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'zone_name' => $zone_name,
               'zone_name_marathi' => $zone_name_marathi,
               'zone_name_hindi' => $zone_name_hindi,
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_zones',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],'Zone already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Zones/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('zones/duplicateZones',$data);
   } 
}

  public function _rules($id)
  {
    $cond = "zone_name='".trim($this->input->post('zone_name',TRUE))."' and id!='".$id."' and country_id='".$this->input->post('country_id',TRUE)."' and state_id='".$this->input->post('state_id',TRUE)."' and district_id='".$this->input->post('district_id',TRUE)."'";
    $row = $this->Crud_model->GetData("mst_zones",'',$cond,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else 
    {
      $is_unique = "|is_unique[mst_zones.zone_name]";

    } 
    $this->form_validation->set_rules('zone_name', 'zone name', 'trim|required'.$is_unique,
      array(
        'required'      => 'Required',
        'is_unique'     => 'Zone already exists'
      ));

    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}