<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vehicles extends CI_Controller {

   public function __construct() {
    parent::__construct();
    //$this->load->library('ciqrcode');
    $this->load->model("Vehicles_model");
  }
  
 
  public function index()
  {   
       $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Manage Vehicles</li>
       </ol>";
          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '6',
            'heading' => 'Manage Vehicles',
            'ajax_manage_page' => site_url('Vehicles/ajax_manage_page'),
          );
          $this->load->view('vehicles/list',$data);
  }

  public function ajax_manage_page() 
  { 
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mv.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mps.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $Data = $this->Vehicles_model->get_datatables($condition);  
  // /  print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
      
      $updateUrl = "Vehicles/update";
      $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
    
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
        $img="";
        if(!empty($row->vehicle_image))
        {
          $img=" <a class='example-image-link' href='". base_url('uploads/vehicles/'.$row->vehicle_image)."' data-lightbox='example-set'>
          <img src='".base_url('uploads/vehicles/'.$row->vehicle_image)."'style='width:100px;'></a>";
        }

         $type='';
        if($row->vehicle_type =='Two_wheeler')
        {
          $type = 'Two Wheeler';
        }
        elseif($row->vehicle_type =='Four_wheeler')
        {
          $type = 'Four Wheeler';
        }
       

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->name;
      $nestedData[] = $img;
      $nestedData[] = $row->vehicle_name;
      $nestedData[] = $row->vehicle_no;
      $nestedData[] = $type;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }
    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Vehicles_model->count_all($condition),
      "recordsFiltered" => $this->Vehicles_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {

    $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

     $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Manage Vehicles</li>
       </ol>";
       $data = array(
      'button'=>'Create',
      'heading'=>'Create Vehicle',
      'sub_title'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
      'policeStations' =>$policeStations,
      'action' => site_url("Vehicles/create_action"), 
      'cancelbtn' => site_url('Vehicles/index'),
      'id' =>  set_value('id',$this->input->post('id')),
      'vehicle_type' =>  set_value('vehicle_type',$this->input->post('vehicle_type')),
      'vehicle_no' =>  set_value('vehicle_no',$this->input->post('vehicle_no')),
      'vehicle_name' =>  set_value('vehicle_name',$this->input->post('vehicle_name')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
    );
     $this->load->view('vehicles/form',$data);
  }

  public function create_action() 
  {  
     $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) {  
      $this->create();
    }else{

    $vehicle_image='';
    if( $_FILES['vehicle_image']['name']!='' )
    {
      $vehicle_image= rand(0000,9999)."_".$_FILES['vehicle_image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['vehicle_image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/vehicles/'.$vehicle_image;
      $config2['upload_path'] =  getcwd().'/uploads/vehicles/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'vehicle_type' => $this->input->post('vehicle_type',TRUE),
        'vehicle_no' => $this->input->post('vehicle_no',TRUE),
        'vehicle_name' => $this->input->post('vehicle_name',TRUE),
        'vehicle_image'=>$vehicle_image,
        'created' => date('d-m-y H:i:s')
      );  
      $this->Crud_model->SaveData("mst_vehicles",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Vehicles/index');
    }
  }

   public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('mst_vehicles','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
        $this->Crud_model->SaveData('mst_vehicles',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('mst_vehicles',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Vehicles/index');
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_vehicles', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Vehicles/index');
  } 

  public function update($update_id)
  {
     if(!empty($update_id)) 
     {
        $id = base64_decode($update_id);
        $row = $this->Crud_model->GetData("mst_vehicles",'',"id='".$id."'",'','','','1');
         $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
        $breadcrumbs = "<ul class='breadcrumb'>
                      <li><i class='ace-icon fa fa-home home-icon'></i><a href='".site_url('Dashboard')."'>Dashboard</a></li>
                       <li><a href='".site_url('Vehicles')."'>Manage Vehicles</a></li>
                      </ul>";
        if(!empty($row)) 
        {
            $data=array(
            'button'    => 'Update',
            'heading'   => 'Update Vehicle',
            'breadcrumbs' => $breadcrumbs,
            'policeStations'    => $policeStations,
            'cancelbtn'   => site_url('Vehicles/index'), 
            'action'    => site_url('Vehicles/update_action'.'/'.$update_id),
            'id'      => set_value('id', $row->id),
            'police_station_id' =>  set_value('police_station_id',$row->police_station_id),
            'vehicle_type'      => set_value('vehicle_type', $row->vehicle_type),
            'vehicle_no'      => set_value('vehicle_no', $row->vehicle_no),
            'vehicle_name'      => set_value('vehicle_name', $row->vehicle_name),
            'vehicle_image'      => set_value('vehicle_image', $row->vehicle_image),
            );
            $this->load->view('vehicles/form', $data);
        }
        else 
        {
          print_r("expression");exit;
          $this->session->set_flashdata('message', 'Record Not Found');
          redirect('Vehicles/index');
        }
     }
     else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Vehicles/index');
      }
  }

  public function update_action($update_id)
  {
      $id = base64_decode($update_id);

    $this->_rules($id);
    if ($this->form_validation->run() == FALSE){          
      $this->update($id);
    } else {

      $image=$_POST['old_image'];
      if($_FILES['vehicle_image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['vehicle_image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['vehicle_image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/vehicles/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/vehicles/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      }
      $data =array(
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'vehicle_type' => $this->input->post('vehicle_type',TRUE),
        'vehicle_no' => $this->input->post('vehicle_no',TRUE),
        'vehicle_name' => $this->input->post('vehicle_name',TRUE),
        'vehicle_image'=>$image,
        'modified' => date('d-m-y H:i:s')
      );
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_vehicles",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Vehicles/index');
    }
  }


  public function _rules($id)
  {
    $cond = "vehicle_no='".$this->input->post('vehicle_no',TRUE)."' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_vehicles",'',$cond,'','','','');
    $count = count($row); 
    if($count==0){
      $is_unique = "";
    } else {
      $is_unique = "|is_unique[mst_vehicles.vehicle_no]";
    }

    $this->form_validation->set_rules('vehicle_no', 'vehicle no', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'vehicle no already exists'
    ));

    
    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}
?>