<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Sub_admin extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Sub_admin_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index() { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Sub Admin</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '9' ,
      'action' =>  site_url('Sub_admin/create') ,
      'ajax_manage_page' => site_url('Sub_admin/ajax_manage_page') ,
      'heading' => 'Manage Sub Admin',
    );
    $this->load->view('sub_admin/list', $data);
  }

  public function ajax_manage_page() {
    $Data = $this->Sub_admin_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
       $updateUrl = "Sub_admin/view";

      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "Sub_admin/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
      
       $updateUrl = "Sub_admin/change_password";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Sub_admin/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Change Password" ' );

       



      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';



      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = $row->address;
    /*  $nestedData[] = $img;*/
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Sub_admin_model->count_all(),
      "recordsFiltered" => $this->Sub_admin_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Sub_admin/index')."'>Manage Sub Admin</a></li>
    <li class='active'>Create Sub Admin</li>
    </ol>";
    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
   // $designations = $this->Crud_model->GetData('mst_designations',"designation_name,id","status='Active'","","designation_name asc");

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Sub Admin',
      'sub_title'=>'Create',
      'countries' =>$countries,
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Sub_admin/create_action"), 
      'cancelbtn' => site_url('Sub_admin/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'name' =>  set_value('name',$this->input->post('name')),
      'name_marathi' =>  set_value('name_marathi',$this->input->post('name_marathi')),
      'name_hindi' =>  set_value('name_hindi',$this->input->post('name_hindi')),
      'email' =>  set_value('email',$this->input->post('email')),
      'password' =>  set_value('password',$this->input->post('password')),
      'address' =>  set_value('address',$this->input->post('address')),
      'address_marathi' =>  set_value('address_marathi',$this->input->post('address_marathi')),
      'address_hindi' =>  set_value('address_hindi',$this->input->post('address_hindi')),
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
    ); 
    $this->load->view('sub_admin/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    //echo "<pre>"; print_r($_POST); die();

    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $image='';
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/profile/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/profile/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
        'name' => trim($this->input->post('name',TRUE)),
        'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'password' => md5($this->input->post('password',TRUE)),
        'show_password' => $this->input->post('password',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),
        //'pincode' => $this->input->post('pincode',TRUE),
         'image'=>$image,
        'user_type'=>'sub_admin',
        'created_by'=>$_SESSION[SESSION_NAME]['id'],
        'created'=> date('Y-m-d H:i:s'),
      );  
      $this->Crud_model->SaveData("admins",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Sub_admin/index');
    }
  }

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("admins",'',"id='".$id."'",'','','','1'); 
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Sub Admin</li>
                    </ul>";

      if(!empty($row)) {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No'","","country_name asc");
        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Sub Admin',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          //'designations'    => $designations,
          'cancelbtn'   => site_url('Sub_admin/index'), 
          'action'    => site_url('Sub_admin/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'name'   => set_value('name', $row->name),
          'name_marathi'   => set_value('name_marathi', $row->name_marathi),
          'name_hindi'   => set_value('name_hindi', $row->name_hindi),
          'password'   => set_value('password', $row->password),
          'email'   => set_value('email', $row->email),
          'mobile'   => set_value('mobile', $row->mobile),
          'address'   => set_value('address', $row->address),
          'address_marathi'   => set_value('address_marathi', $row->address_marathi),
          'address_hindi'   => set_value('address_hindi', $row->address_hindi),
          'image'   => set_value('image', $row->image),
        );
       // print_r($data);exit();
        $this->load->view('sub_admin/form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Sub_admin/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Sub_admin/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) {          
      $this->update($update_id);
    } 
    else 
    {  

    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/profile/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/profile/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'name' => trim($this->input->post('name',TRUE)),
        'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'password' => $this->input->post('password',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("admins",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Sub_admin/index');
    }
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('admins', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Sub_admin/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('admins','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('admins',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('admins',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Sub_admin/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }


  public function import()
  {
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Sub_admin/index'));            
   } 
   $data = $fields_fun;
  
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' || $val[1] !='' || $val[2] !='' || $val[3] !='' || $val[4] !='' || $val[5] !='' || $val[6] !='' || $val[7] !='')
      { 
         $getAdmins = $this->Crud_model->GetData('admins','mobile',"mobile='".$val[6]."'",'','','','single'); 

         $countries = $this->Crud_model->GetData('mst_countries','id',"country_name='".$val[3]."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[4]."'",'','','','single'); 

         //$districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[6]."'",'','','','single'); 

         //$cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[5]."'",'','','','single');

         /*for already exist check*/

         if(empty($getAdmins))
         {

             if(!empty($val[7]))
            {
               $address=$val[7];
            } 
            else
            {
               $address="";
            }

            if(!empty($val[6]))
            {
               $mobile=$val[6];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[5]))
            {
               $city=$val[5];
            } 
            else
            {
               $city="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($countries))
            {
               $country_id=$countries->id;
            } 
            else
            {
               $country_id="";
            }


            if(!empty($val[2]))
            {
               $password=$val[2];
            } 
            else
            {
               $password="";
            }

            if(!empty($val[1]))
            {
               $email=$val[1];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }


            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'name' => $name,
               'email' => $email,
               'password' => $password,
               'country_id' => $country_id,
               'state_id' => $state_id,
               'city' => $city,
               'mobile' => $mobile,
               'address' => $address,
               'image'  => 'profile_default.png',
            );

            $SaveAssets = $this->Crud_model->SaveData('admins',$data);
         }
         else
         { 
            $existAssets[]=array($val[6],'Already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[11],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Imported successfully</span>');
      redirect('Sub_admin/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('sub_admin/duplicate',$data);
   } 
}

  public function _rules($id) {
    $cond_email = "email='".$this->input->post('email',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("admins",'',$cond_email,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[admins.email]";
    }

    $cond_mobile = "mobile='".$this->input->post('mobile',TRUE)."' and is_delete='No' and id!='".$id."'";
    $row = $this->Crud_model->GetData("admins",'',$cond_mobile,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique2 = "";
    }
    else
    {
      $is_unique2 = "|is_unique[admins.mobile]";
    }


    $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'email already exists'
    ));

    $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'mobile already exists'
    ));

    $this->form_validation->set_rules('name', 'name', 'trim|required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('password', 'password', 'trim|required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('country_id', 'country', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('district_id', 'district', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('city_id', 'city', 'trim|required', array('required' => 'Please enter %s'));

    //$this->form_validation->set_rules('address', 'address', 'trim|required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }

   public function view($id)
  {
    
    $row = $this->Sub_admin_model->getSubAdminDetails("a.id='".$id."'"); 
    //print_r($row);exit();

     $breadcrumbs='<ul class="breadcrumb">
    <li>
    <i class="ace-icon fa fa-home home-icon"></i>
    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
    </li>
    <li><a href="'.site_url('Sub_admin/index').'">Manage Sub Admin</a></li>
    <li class="active"><a >Sub Admin Details</a></li>
    </ul>';

    if(!empty($row)) 
    {
        
         // $dept_id=explode(",", $row->dept_id);
         // print_r($dept_id);exit();
          $data = array(

                          /*'row'=> $row,*/
                          'breadcrumbs'=>$breadcrumbs, 
                          'id'=>$row->id,    
                          'name'=>$row->name,    
                          'email'=>$row->email,    
                          'mobile'=>$row->mobile,   
                          'image'=>$row->image,   
                          'country'=>$row->country_name, 
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name,    
                          'address'=>$row->address, 
                          'status'=>$row->status,   
                    );
         // print_r($data);exit();
         $this->load->view('sub_admin/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('Sub_admin/index/'));
  }
}

public function change_password($id)
    { 
     // print_r($id);exit();

        $id = base64_decode($id);
      $clientData=$this->Crud_model->GetData("admins","","id='".$id."'",'','','','1');
        $password = rand(000000,999999);
   //  print_r($password);exit();

        $data = array(
        'password' => md5($password),
        'show_password' => $password 
        );
      //  print_r($data);exit();
        $this->Crud_model->SaveData("admins",$data,"id='".$id."'");   

        /*$row = $this->Crud_model->GetData("clients","","id='".$id."'");

        /* $settings = $this->Common_model->GetData('settings','sitetitle,favicon,header_logo','id="1"','','','','1');*/

          /*$mail_body=$this->Common_model->GetData("mst_mail_body","","mail_subject='Change Password'");

          
          $mail_body[0]->template=str_replace("{user_name}",ucfirst($_SESSION[SESSION_NAME]['name']),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{email}",($_SESSION[SESSION_NAME]['email']),$mail_body[0]->template);*/
        /*  $mail_body[0]->template=str_replace("{company_name}",ucfirst($settings->sitetitle),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{Company_logo}","<img src='".base_url('admin/uploads/logo/'.$settings->header_logo)."'>",$mail_body[0]->template);*/

        /*  $subject=$mail_body[0]->subject;
          $body=$mail_body[0]->template;
          $to = $_SESSION[SESSION_NAME]['email'];
          $MailData = array('mailoutbox_to'=>$to,'mailoutbox_subject'=>$subject,'mailoutbox_body'=>$body);*/
         //print_r($body);
          //$this->SendMail->Send($MailData);
          /* if($this->email->send())
         { 
          $this->session->set_flashdata('message', '<div style="color:green">Your are password changed successfully, please check your email</div>');
                            }else {
          $this->session->set_flashdata("message","<div style='color:red'>Error in sending email</div>"); 
                }
           }  
          
        $this->session->set_flashdata('message', 'Password has been changed successfully');
        redirect(site_url('clients'));
}*/
     $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Password changed succesfully.Credentials has send to register email.</span>');
    redirect("Sub_admin/index");
}
}