<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class States extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('States_model');
    $this->load->database();
  }
  
  public function index()
  {
    
    $condUser ="status='Active' and is_delete='No' and country_name='India'";
    $countries =  $this->Crud_model->GetData('mst_countries','',$condUser);
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage States</li>
                    </ul>";

        $data = array(
          'actioncolumn' => '4',
          'ajax_manage_page' => site_url('States/ajax_manage_page'),
          'heading' => 'Manage States',
          'countries' =>$countries,
          'breadcrumbs' =>$breadcrumbs,
          );

    $this->load->view('states/list',$data);     
  }

  public function ajax_manage_page()
  {
    $condition="";
    $getData = $this->States_model->get_datatables($condition);
    
    $data = array();
    if(empty($_POST['start']))
    {
        $no =0;   
    }
    else
    {
        $no =$_POST['start'];
    }    

    foreach ($getData as $Data) 
    {
      $btn='';
      $btn .= ('<a href="#myModaledit" title="Edit" class="btn btn-info btn-circle btn-sm" data-toggle="modal"  onclick="getEditvalue('.$Data->id.');"> <i class="fa fa-pencil bigger-130"></i></a>');
            
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="fa fa-trash-o bigger-130"></i></a>';
             $status ='';
       
      if($Data->status=='Active')
      {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      }
      else
      {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-warning label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $Data->country_name;
      $nestedData[] = ucwords($Data->state_name);
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
    }   

    $output = array(
        "draw" => $_POST['draw'],
        "recordsTotal" => $this->States_model->count_all($condition),
        "recordsFiltered" => $this->States_model->count_filtered($condition),
        "data" => $data,
        );

    //output to json format
    echo json_encode($output);
  }

  public function changeStatus()
  {
    $change_status = $this->Crud_model->GetData('mst_states','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
        $this->Crud_model->SaveData('mst_states',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('mst_states',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('States/index');
  }


  public function addData()
  {
    $condDuplication = "state_name='".trim($this->input->post('state_name'))."' and country_id='".trim($this->input->post('country_id'))."'";
    $duplication = $this->Crud_model->GetData('mst_states','', $condDuplication);

    if(count($duplication) > 0 )
    {
      echo 1;
    }
    else
    {
      $data = array(
        'country_id' => $this->input->post('country_id'),
        'state_name' => $this->input->post('state_name'),
        'state_name_marathi' => $this->input->post('state_name_marathi'),
        'state_name_hindi' => $this->input->post('state_name_hindi'),
        'created' => date('Y-m-d H:i:s'),
      );
      $this->Crud_model->SaveData('mst_states', $data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }        
  }

  public function updateData()
  {  
    $condDuplication = "state_name='".trim($this->input->post('state_name'))."' and country_id='".trim($this->input->post('country_id'))."' and id !='".$this->input->post('id')."'"; 

    $duplication = $this->Crud_model->GetData('mst_states','',$condDuplication); 
    if(count($duplication) > 0 )
    {
      echo 1;
    }
    else
    {  
        $data = array(                
          'country_id' => $this->input->post('country_id'),
          'state_name' => $this->input->post('state_name'),
          'state_name_marathi' => $this->input->post('state_name_marathi'),
          'state_name_hindi' => $this->input->post('state_name_hindi'),
          'modified' => date('Y-m-d H:i:s'),                
        );  

        $this->Crud_model->SaveData('mst_states', $data, "id='".$this->input->post('id')."'"); 
        $this->session->set_flashdata('message', 'success');
        echo 2;
    }  
  }


  public function delete()
  {
    $con = "id='".$_POST['id']."'";
     $data = array('is_delete' =>'Yes');
    $this->Crud_model->SaveData('mst_states',$data,$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('States/index');

  }

  public function getUpdateName()
  {
    $row = $this->Crud_model->GetData('mst_states','',"id='".$_POST['id']."'",'','','','row');
    
    $country = $this->Crud_model->GetData('mst_countries','','status="Active" and is_delete="No" and country_name="India"');
    $data = array('state_name'=> $row->state_name,'state_name_marathi'=> $row->state_name_marathi,'state_name_hindi'=> $row->state_name_hindi,'id'=> $row->id,'country_id'=> $row->country_id, 'country'=> $country);
    $this->load->view('states/geteditState',$data);
  }


 

}