<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SensitiveAreas extends CI_Controller {

   public function __construct() {
    parent::__construct();
    $this->load->library('ciqrcode');
    $this->load->model("Sensitive_Areas_model");
  }
  
 
  public function index()
  {   
       $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Sensitive Areas</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '5',
            'heading' => 'Manage Sensitive Areas',
            'ajax_manage_page' => site_url('SensitiveAreas/ajax_manage_page'),
          );
          $this->load->view('sensitive_areas/list',$data);
  }

  public function ajax_manage_page() 
  {
    $Data = $this->Sensitive_Areas_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
      
      $updateUrl = "SensitiveAreas/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "SensitiveAreas/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
    
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
        $img="";
        if(!empty($row->image))
        {
          $img=" <a class='example-image-link' href='". base_url('uploads/qrcodeci/'.$row->image)."' data-lightbox='example-set'>
          <img src='".base_url('uploads/qrcodeci/'.$row->image)."'style='width:100px;'></a>";
        }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $img;
      $nestedData[] = $row->qrcode;
      /*$nestedData[] = $row->image;*/
      // $nestedData[] = $row->country_name;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }
    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Sensitive_Areas_model->count_all(),
      "recordsFiltered" => $this->Sensitive_Areas_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {
      $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
      // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");
      $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
      $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Sensitive Areas</li>
       </ol>";
       $data = array(
      'button'=>'Create',
      'heading'=>'Create Sensitive Area',
      'sub_title'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
      'states' =>$states,
      'policeStations'    => $policeStations,
      'action' => site_url("SensitiveAreas/create_action"), 
      'cancelbtn' => site_url('SensitiveAreas/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'country_id' =>  '101',
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'address' =>  set_value('address',$this->input->post('address')),
      'latitude' => set_value('lat',$this->input->post('lat')),
      'longitude' => set_value('lon',$this->input->post('lon')),
      'qrcode' =>  set_value('qrcode',$this->input->post('qrcode')),
      'image' =>  set_value('image',$this->input->post('image')),
      
    );
    $this->load->view('sensitive_areas/form',$data);
  }


  public function create_action()
  {
      $data = array(
        'country_id' =>  '101',
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'police_station_id'  => $this->input->post('police_station_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
         'latitude'    => $this->input->post('lat'),
        'longitude'    => $this->input->post('lon'),
        'qrcode'  => $this->input->post('qrcode',TRUE),
        'image'  => $this->input->post('image_name',TRUE),
        'created' => date('d-m-Y h:i:s')
      );
      $this->Crud_model->SaveData("sensitive_areas",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('SensitiveAreas/index');
  }

  public function qrcodeGenerator()
  { 
      $data['image']="";
      $qr_image=rand().'.png';
      $params['data'] = $this->input->post('qrcode');
      $params['level'] = 'H';
      $params['size'] = 8;
      $params['savename'] =FCPATH."uploads/qrcodeci/".$qr_image;
      if($this->ciqrcode->generate($params))
      {
        $data['image']=$qr_image; 
      }
     echo $data['image'];
  }

  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);
      $row = $this->Crud_model->GetData("sensitive_areas",'',"id='".$id."'",'','','','1');
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li><i class='ace-icon fa fa-home home-icon'></i><a href='".site_url('Dashboard')."'>Dashboard</a></li>
                      <li><a href='".site_url('SensitiveAreas')."'>Manage Sensitive Areas</a></li>
                      </ul>";
     if(!empty($row)) 
     {
      $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");
  
      // $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and id='101'","","country_name asc");

      $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
      $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

      $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

      $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Sensitive Area',
          'breadcrumbs' => $breadcrumbs,
          'policeStations'    => $policeStations,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'cancelbtn'   => site_url('SensitiveAreas/index'), 
          'action'    => site_url('SensitiveAreas/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'    => set_value('city_id', $row->city_id),
          'police_station_id'    => set_value('police_station_id', $row->police_station_id),
          'address'   => set_value('address', $row->address),
          'latitude'   => set_value('lat', $row->latitude),
          'longitude'   => set_value('lon', $row->longitude),
          'qrcode'   => set_value('qrcode', $row->qrcode),
          'image'   => set_value('image', $row->image),
        );
        $this->load->view('sensitive_areas/form', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('SensitiveAreas/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('SensitiveAreas/index');
    }
  }

  public function update_action($update_id)
  {
    $id = base64_decode($update_id);
      $data = array(
          'country_id' =>  '101',
          'state_id' => $this->input->post('state_id',TRUE),
          'district_id' => $this->input->post('district_id',TRUE),
          'city_id' => $this->input->post('city_id',TRUE),
          'police_station_id' => $this->input->post('police_station_id',TRUE),
          'address' => trim($this->input->post('address',TRUE)),
          'latitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),
          'qrcode'  => $this->input->post('qrcode',TRUE),
          'image'  => $this->input->post('image_name',TRUE),
          'modified' => date('d-m-y H:i:s')
        );
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("sensitive_areas",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('SensitiveAreas/index');
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('sensitive_areas','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Confirmed')
    {
        $this->Crud_model->SaveData('sensitive_areas',array('status'=>'Pending'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('sensitive_areas',array('status'=>'Confirmed'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('SensitiveAreas/index');
  }

   public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('sensitive_areas', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('SensitiveAreas/index');
  } 


  public function view($id)
  {
    $row = $this->Sensitive_Areas_model->viewDetailsQRcode("sa.id='".$id."'"); 
    //print_r($row);exit();
    $breadcrumbs='<ul class="breadcrumb"><li><i class="ace-icon fa fa-home home-icon"></i><a href="'.site_url('Dashboard/index').'">Dashboard</a></li><li><a href="'.site_url('SensitiveAreas/index').'">Manage Sensitive Areas</a></li><li class="active"><a >Sensitive Areas Details</a></li></ul>';
    if(!empty($row)) 
    { 
          $data = array(
                          'breadcrumbs'=>$breadcrumbs, 
                          'id'=>$row->id,    
                          'name'=>$row->name,
                          'image'=>$row->image,   
                          'country'=>$row->country_name, 
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name,    
                          'address'=>$row->address,
                          'qrcode'=>$row->qrcode,
                          'image'=>$row->image, 
                          'status'=>$row->status,   
                    );
         $this->load->view('sensitive_areas/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('SensitiveAreas/index/'));
  }
}
  
   public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  }   

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
      {
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }

     public function getpolicestation()
    {
      $policestation = $this->Crud_model->GetData("mst_police_stations","id,name","city_id='".$_POST['id']."' and is_delete='No' and status='Active'","","name asc");
        if(!empty($policestation)) {
            $response = '<option value="">Select Police Station</option>';
            foreach($policestation as $row) {
              $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
            }
          }else {
              $response = '<option value="">Select Police Station</option>';
          }
          echo $response;
    }
}
