<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Police_station extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Police_station_model');
    $this->load->library('Excel');
    $this->load->database();
  }

  public function index($flag='') { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '7' ,
      'action' =>  site_url('Police_station/create') ,
      'ajax_manage_page' => site_url('Police_station/ajax_manage_page'),
      'heading' => 'Manage Police Station',
    );
    $this->load->view('police_station/list', $data);
  }

  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "admins.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $Data = $this->Police_station_model->get_datatables($condition);  
    //print_r($Data);exit();
    $data = array();  
    if(empty($_POST['start'])) {
      $no =0;   
    } else {
      $no =$_POST['start'];
    }

    foreach($Data as $row) {
       $updateUrl = "Police_station/view";

      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

       $updateUrl = "Police_station/update";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
    
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
        {
          $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
        }
        else
        {
          $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
        }
      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      $nestedData[] = $row->state_name;
      $nestedData[] = $row->district_name;
      $nestedData[] = $row->city_name;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Police_station_model->count_all($condition),
      "recordsFiltered" => $this->Police_station_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Police_station/index')."'>Manage Police Station</a></li>
    <li class='active'>Create Police Station</li>
    </ol>";

    $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");
     $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
     $police_higher_authorities = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");
     $head_of_police_stations = $this->Crud_model->GetData('head_of_police_stations',"station_head_name,id","status='Active' and is_delete='No'","","station_head_name asc");
     $sdpoData = $this->Crud_model->GetData("mst_sdpo",'name,id',"status='Active'",'',"name asc");


    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Station',
      'sub_title'=>'Create',
      'states' =>$states,
      'police_higher_authorities' =>$police_higher_authorities,
      'head_of_police_stations' =>$head_of_police_stations,
      'police_departments' =>$police_departments,
      'sdpoData' =>$sdpoData,
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Police_station/create_action"), 
      'cancelbtn' => site_url('Police_station/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'higher_authority_id' =>  set_value('higher_authority_id',$this->input->post('higher_authority_id')),
      'station_head_id' =>  set_value('station_head_id',$this->input->post('station_head_id')),
      'department_id' =>  set_value('department_id',$this->input->post('department_id')),
      'country_id' => '101',
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'sdpo_id' =>  set_value('sdpo_id',$this->input->post('sdpo_id')),
      'name' =>  set_value('name',$this->input->post('name')),     
      'email' =>  set_value('email',$this->input->post('email')),      
      'address' =>  set_value('address',$this->input->post('address')),     
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'gender' =>  set_value('gender',$this->input->post('gender')),
      'latitude' => set_value('lat',$this->input->post('lat')),
      'longitude' => set_value('lon',$this->input->post('lon')),
    ); 
    $this->load->view('police_station/form',$data);
  }

  public function create_action() 
  {  
     $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) {  
      $this->create();
    }else{
      $image='';
  
    if( $_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_image/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_image/';
      $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)), 
        'name' => trim($this->input->post('name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => '101',
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'sdpo_id' => $this->input->post('sdpo_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),
        'gender' => $this->input->post('gender',TRUE),
        'latitude'    => $this->input->post('lat'),
        'longitude'    => $this->input->post('lon'),
        'image'=>$image,           
        'created'=> date('Y-m-d H:i:s'),
      ); 
      $this->Crud_model->SaveData("mst_police_stations",$data);
      $last_id=$this->db->insert_id();
      foreach($_POST['department_id'] as $i=>$row){
        $data1 = array(
        'police_station_id' => $last_id,
        'station_head_id' => $_POST['station_head_id'][$i],
        'department_id' => $_POST['department_id'][$i],
      );
      $this->Crud_model->SaveData("police_station_department_map",$data1);

      }
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_station/index');
   }
  }

  public function update($update_id) { 
    if(!empty($update_id)) {
      $id = base64_decode($update_id);
      $row = $this->Crud_model->GetData("mst_police_stations",'',"id='".$id."'",'','','','1');
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Station</li>
                    </ul>";

      if(!empty($row)) {

          $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='101' and id='22'","","state_name asc");


          if($_SESSION[SESSION_NAME]['type']=='Head_Person' || $_SESSION[SESSION_NAME]['type']=='Station_Head'){

            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."' and id='".$row->district_id."'","","district_name asc");
          } else {
            $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");
          }



          $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");
          $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","zone_name asc");
          $area = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No' and zone_id='".$row->zone_id."'","","area asc");
          $police_station_department = $this->Crud_model->GetData('police_station_department_map',"","police_station_id='".$row->id."'","","");
          $police_higher_authorities = $this->Crud_model->GetData('mst_police_higher_authorities',"higher_authority_name,id","status='Active' and is_delete='No'","","higher_authority_name asc");
          $head_of_police_stations = $this->Crud_model->GetData('head_of_police_stations',"station_head_name,id","status='Active' and is_delete='No'","","station_head_name asc");
          $police_departments = $this->Crud_model->GetData('mst_police_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc"); 
          $sdpoData = $this->Crud_model->GetData("mst_sdpo",'name,id',"city_id='".$row->city_id."' and status='Active'",'',"name asc");

     $department_id=[];
     $station_head_id=[];
     $j=0;
     foreach ($police_station_department as $i=>$psd) {

       $department_id[$j]=$psd->department_id;
       $station_head_id[$j]=$psd->station_head_id;
       $j++;
     }
     $data = array(
          'button'    => 'Update',
          'heading'   => 'Update Police Station',
          'breadcrumbs' => $breadcrumbs,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'zones'    => $zones,
          'area'    => $area,
          'police_station_department'    => $police_station_department,
          'police_higher_authorities'    => $police_higher_authorities,
          'head_of_police_stations'    => $head_of_police_stations,
          'police_departments'    => $police_departments,
          'sdpoData'    => $sdpoData,
          'cancelbtn'   => site_url('Police_station/index'), 
          'action'    => site_url('Police_station/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'higher_authority_id'  => set_value('higher_authority_id', $row->higher_authority_id),
          'department_id'    => $department_id,
          'station_head_id'    => $station_head_id,
          'country_id'    => set_value('country_id', $row->country_id),
          'state_id'   => set_value('state_id', $row->state_id),
          'district_id'   => set_value('district_id', $row->district_id),
          'city_id'   => set_value('city_id', $row->city_id),
          'sdpo_id'   => set_value('sdpo_id', $row->sdpo_id),
          'name'   => set_value('name', $row->name),
          'email'   => set_value('email', $row->email),
          'address'   => set_value('address', $row->address),
          'mobile'   => set_value('mobile', $row->mobile),
          'pincode'   => set_value('pincode', $row->pincode),
          'image'   => set_value('image', $row->image),
          'latitude'   => set_value('lat', $row->latitude),
          'longitude'   => set_value('lon', $row->longitude),
        );     
        $this->load->view('police_station/form', $data);
      } else {
       
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_station/index');
      }
    }else {
    
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_station/index');
    }

  }

 
  public function update_action($update_id) {
   $id = base64_decode($update_id);
//print_r($id);exit();
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE){          
      $this->update($update_id);
    } else {
    $image=$_POST['old_image'];
    if($_FILES['image']['name']!='' )
    {
      $image= rand(0000,9999)."_".$_FILES['image']['name'];
      $config2['image_library'] = 'gd2';
      $config2['source_image'] =  $_FILES['image']['tmp_name'];
      $config2['new_image'] =   getcwd().'/uploads/police_station_image/'.$image;
      $config2['upload_path'] =  getcwd().'/uploads/police_station_image/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
      $this->image_lib->initialize($config2);
      if(!$this->image_lib->resize())
      {
        echo('<pre>');
        echo ($this->image_lib->display_errors());
        exit;
      }   
    }
      $data = array(
        'higher_authority_id' => trim($this->input->post('higher_authority_id',TRUE)), 
        'name' => trim($this->input->post('name',TRUE)),        
        'email' => $this->input->post('email',TRUE),        
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => '101',
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'sdpo_id' => $this->input->post('sdpo_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),       
        'pincode' => $this->input->post('pincode',TRUE),
        'latitude' => $this->input->post('lat',TRUE),
        'longitude' => $this->input->post('lon',TRUE),
         'image'=>$image,           
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police_stations",$data,$con);
      $last_id=$this->db->insert_id();
      foreach($_POST['department_id'] as $i=>$row){
        $data1 = array(
        'police_station_id' => $last_id,
        'station_head_id' => $_POST['station_head_id'][$i],
        'department_id' => $_POST['department_id'][$i],
      );
      $this->Crud_model->SaveData("police_station_department_map",$data1,'id="'.$last_id.'"');
      }
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_station/index');
   }
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_police_stations', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_station/index');
  } 

  public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_police_stations','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') {
      $this->Crud_model->SaveData('mst_police_stations',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
      $this->Crud_model->SaveData('mst_police_stations',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Police_station/index");
  }

  public function getState() {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) {
      $response = '<option value="">Select state</option>';
      foreach($states as $row) {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }else {
        $response = '<option value="">Select state</option>';
    }
    echo $response;
  }

  public function getDistrict()
  {

        if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
        $mst_police = $this->Crud_model->GetData("mst_police",'district_id',"id='".$_SESSION[SESSION_NAME]['id']."' and is_delete='No' and status='Active'",'',"","","1");

        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"id='".$mst_police->district_id."' and state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

      if($_SESSION[SESSION_NAME]['type']=='admin'){
        $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

        if(!empty($districts)) {
          $response = '<option value="">Select District</option>';
          foreach($districts as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
          }
        }else {
            $response = '<option value="">Select District</option>';
        }
        echo $response;
      }

  }

   public function getCity()
    {
        $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

        if(!empty($cities)) {
          $response = '<option value="">Select City</option>';
          foreach($cities as $row) {
            $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
          }
        }else {
            $response = '<option value="">Select City</option>';
        }
        echo $response;
    }
     public function getSdpo()
  {
   // print_r('hi');exit();
    $sdpoData = $this->Crud_model->GetData("mst_sdpo",'name,id',"city_id='".$_POST['id']."' and status='Active'",'',"name asc");

    if(!empty($sdpoData)) 
    {
      $response = '<option value="">Select Sdpo</option>';
      foreach($sdpoData as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Sdpo</option>';
    }
    echo $response;
  }

  
  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"area asc");

    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Police_station/index'));            
    } 
    $data = $fields_fun;
    
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='')
      { 
         $getPoliceStation = $this->Crud_model->GetData('mst_police_stations','mobile',"mobile='".trim($val[2])."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[3]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[4]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[5]."'",'','','','single');
         if(empty($getPoliceStation))
         {
            if(!empty($val[7]))
            {
               $pincode=$val[7];
            } 
            else
            {
               $pincode="";
            }

            if(!empty($val[6]))
            {
               $address=$val[6];
            } 
            else
            {
               $address="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($val[2]))
            {
               $mobile=$val[2];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[1]))
            {
               $email=$val[1];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }

            $data = array(
               'name' => trim($name),
               'email' => trim($email),
               'mobile' => trim($mobile),
               'country_id' => "101",
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'address' => $address,
               'pincode' => $pincode,
            );
            $SaveAssets = $this->Crud_model->SaveData('mst_police_stations',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],'<span style="color:red">Police station already exist</span>');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],'<span style="color:red">Mandatory fields empty</span>');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Police_station/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('police_station/duplicatePoliceStation',$data);
   } 
  }

  
  public function getAddress() 
  {
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  }   

   public function view($id)
  {
    
    $row = $this->Police_station_model->getSubAdminDetails("admins.id='".$id."'"); 
  
    $police_data = $this->Crud_model->GetData('mst_police','',"police_station_id='".$row->id."' and designation_type='Police' and is_delete='No'"); 

    $criminal_data = $this->Crud_model->GetData('criminals','',"police_station_id='".$row->id."' and is_delete='No'"); 
    $camera_data = $this->Crud_model->GetData('mst_cameras','',"police_station_id='".$row->id."' and is_delete='No'"); 

    $bpatrak_data = $this->Crud_model->GetData('bpatrak','',"police_station_id='".$row->id."'"); 

     $breadcrumbs='<ul class="breadcrumb">
    <li>
    <i class="ace-icon fa fa-home home-icon"></i>
    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
    </li>
    <li><a href="'.site_url('Police_station/index').'">Manage Police Station</a></li>
    <li class="active"><a >Police Station Details</a></li>
    </ul>';

    if(!empty($row)) 
    {
          $data = array(

                          
                          'breadcrumbs'=>$breadcrumbs, 
                          'police_data'=>$police_data, 
                          'criminal_data'=>$criminal_data, 
                          'camera_data'=>$camera_data, 
                          'bpatrak_data'=>$bpatrak_data,
                          'cancelbtn'   => site_url('Police_station/index'), 
                          'id'=>$row->id,    
                          'name'=>$row->name,    
                          'email'=>$row->email,    
                          'mobile'=>$row->mobile,   
                          'image'=>$row->image,   
                          'state'=>$row->state_name, 
                          'district'=>$row->district_name, 
                          'city'=>$row->city_name,    
                          'address'=>$row->address, 
                          'pincode'=>$row->pincode, 
                          'status'=>$row->status,   
                    );
         $this->load->view('police_station/view',$data);
  }
  else 
  {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('Police_station/index/'));
  }
}

public function change_password($id)
    { 
        $id = base64_decode($id);
      $clientData=$this->Crud_model->GetData("mst_police_stations","","id='".$id."'",'','','','1');
        $password = rand(000000,999999);
        $data = array(
        'password' => md5($password),
        'show_password' => $password 
        );
        $this->Crud_model->SaveData("mst_police_stations",$data,"id='".$id."'");   

        /*$row = $this->Crud_model->GetData("clients","","id='".$id."'");

        /* $settings = $this->Common_model->GetData('settings','sitetitle,favicon,header_logo','id="1"','','','','1');*/

          /*$mail_body=$this->Common_model->GetData("mst_mail_body","","mail_subject='Change Password'");

          
          $mail_body[0]->template=str_replace("{user_name}",ucfirst($_SESSION[SESSION_NAME]['name']),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{email}",($_SESSION[SESSION_NAME]['email']),$mail_body[0]->template);*/
        /*  $mail_body[0]->template=str_replace("{company_name}",ucfirst($settings->sitetitle),$mail_body[0]->template);
          $mail_body[0]->template=str_replace("{Company_logo}","<img src='".base_url('admin/uploads/logo/'.$settings->header_logo)."'>",$mail_body[0]->template);*/

        /*  $subject=$mail_body[0]->subject;
          $body=$mail_body[0]->template;
          $to = $_SESSION[SESSION_NAME]['email'];
          $MailData = array('mailoutbox_to'=>$to,'mailoutbox_subject'=>$subject,'mailoutbox_body'=>$body);*/
         //print_r($body);
          //$this->SendMail->Send($MailData);
          /* if($this->email->send())
         { 
          $this->session->set_flashdata('message', '<div style="color:green">Your are password changed successfully, please check your email</div>');
                            }else {
          $this->session->set_flashdata("message","<div style='color:red'>Error in sending email</div>"); 
                }
           }  
          
        $this->session->set_flashdata('message', 'Password has been changed successfully');
        redirect(site_url('clients'));
}*/
     $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Password changed succesfully.Credentials has send to register email.</span>');
    redirect("Sub_admin/index");
}

public function _rules($id)
  {
    $cond = "name='".$this->input->post('name',TRUE)."' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police_stations",'',$cond,'','','','');
    $count = count($row); 
    if($count==0){
      $is_unique = "";
    } else {
      $is_unique = "|is_unique[mst_police_stations.name]";
    }

    $this->form_validation->set_rules('name', 'name', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'Police stations already exists'
    ));

    $cond = "email='".$this->input->post('email',TRUE)."' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police_stations",'',$cond,'','','','');
    $count = count($row); 
    if($count==0){
      $is_unique = "";
    } else {
      $is_unique = "|is_unique[mst_police_stations.email]";
    }

    $this->form_validation->set_rules('email', 'Email', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => '%s already exists'
    ));

    $cond = "mobile='".$this->input->post('mobile',TRUE)."' and id!='".$id."'";
    $row = $this->Crud_model->GetData("mst_police_stations",'',$cond,'','','','');
    $count = count($row); 
    if($count==0){
      $is_unique = "";
    } else {
      $is_unique = "|is_unique[mst_police_stations.mobile]";
    }

    $this->form_validation->set_rules('mobile', 'Mobile', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => '%s already exists'
    ));
    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }

}