<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Police_Departments extends CI_Controller {

  function __construct()
    {
    parent::__construct();
    $this->load->model("Police_Departments_model");
    }

    //LIST VIEW
  public function index()
  {
        $breadcrumbs = "<ul class='breadcrumb'>
                    <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li class='active'>Manage Police Departments</li>
                    </ul>";
        $data = array(
        'breadcrumbs' => $breadcrumbs ,
        'actioncolumn' => '2' ,
        'ajax_manage_page' => site_url('Police_Departments/ajax_manage_page') ,
        'button' => 'Create',
        'heading' => 'Manage Police Departments',
        );
        $this->load->view('police_departments/departments_list',$data);
  }

   public function ajax_manage_page()
   {
     
      $getData = $this->Police_Departments_model->get_datatables();

        $data = array();
        if(empty($_POST['start']))
            {
                $no =0;   
            }
            else
            {
                $no =$_POST['start'];
            }
            foreach ($getData as $Data) {
              $btn = '';
               $updateUrl = "Police_Departments/update";
               $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($Data->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
            $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
            $status = '';
             if($Data->status=='Active')
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
              }
              else
              {
                  $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-warning label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
              }
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = ucfirst($Data->department_name);
            $row[] = $status;
            $row[] = $btn;
            $data[] = $row;
        }
        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Police_Departments_model->count_all(),
          "recordsFiltered" => $this->Police_Departments_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
   		public function changeStatus(){
        //print_r($_POST);exit;
        $change_status = $this->Crud_model->GetData('mst_police_departments','',"id='".$_POST['id']."'",'','','','row');

        if($change_status->status=='Active')
        {
            $this->Crud_model->SaveData('mst_police_departments',array('status'=>'Inactive'),"id='".$_POST['id']."'");
        }
        else
        {
            $this->Crud_model->SaveData('mst_police_departments',array('status'=>'Active'),"id='".$_POST['id']."'");
        }
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
        redirect('Police_Departments/index');
    }
    
 public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ol class='breadcrumb'>
    <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
    <li><a href='".site_url('Police_station/index')."'>Manage Police Departments</a></li>
    <li class='active'>Create Police Departments</li>
    </ol>";   

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Police Departments',
      'sub_title'=>'Create',      
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Police_Departments/create_action"), 
      'cancelbtn' => site_url('Police_Departments/index'), 
      'id' =>  set_value('id',$this->input->post('id')),      
      'department_name' => set_value('department_name',$this->input->post('department_name')),
    ); 
    $this->load->view('police_departments/departments_form',$data);
   }
  public function create_action() 
  { 
   $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $data = array(            
        'department_name' => $this->input->post('department_name',TRUE),       
        'created'=> date('Y-m-d H:i:s'),
      ); 

      $this->Crud_model->SaveData("mst_police_departments",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Police_Departments/index');
  }
}

  //UPDATE 
  public function update($update_id) {  
    if(!empty($update_id)) {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("mst_police_departments",'',"id='".$id."'",'','','','1'); 
      // /echo "<pre>"; print_r($row); die();
      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Police Departments</li>
                    </ul>";

      if(!empty($row)) {
       
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Police Departments',
          'breadcrumbs' => $breadcrumbs,         
          'cancelbtn'   => site_url('Police_Departments/index'), 
          'action'    => site_url('Police_Departments/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),          
          'department_name'   => set_value('department_name', $row->department_name),
         
        );
     
        $this->load->view('police_departments/departments_form', $data);
      } else {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Police_Departments/index');
      }
    } else {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Police_Departments/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) { 
      
      $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    { 
      $data = array(              
        'department_name' => $this->input->post('department_name',TRUE),        
      ); 
     if(!empty($update_id)) {
      $id = base64_decode($update_id);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("mst_police_departments",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Police_Departments/index');
    }
  }
}

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('mst_police_departments', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Police_Departments/index');
  } 

  public function _rules($id) {
    $cond = "department_name='".$this->input->post('department_name',TRUE)."' ";
    $row = $this->Crud_model->GetData("mst_police_departments",'',$cond,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[mst_police_departments.department_name]";
    }

   

    $this->form_validation->set_rules('department_name', 'department_name', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'Police designation name already exists'
    ));

    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }


     
}
