<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Corporates extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Corporates_model');
    $this->load->database();
  }

  public function index($flag='') 
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Corporates</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '11' ,
      'action' =>  site_url('Corporates/create') ,
      'ajax_manage_page' => site_url('Corporates/ajax_manage_page/'.$flag),
      'heading' => 'Manage Corporates',
    );
    $this->load->view('corporates/corporates_list', $data);
  }

  public function ajax_manage_page($flag='') 
  {
    if($flag=="WM") 
    {
      $flag = "Ward Member";
    }

    $corporatesData = $this->Corporates_model->get_datatables($flag);  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($corporatesData as $row) 
    {
      $viewUrl = "Corporates/view";
      $btn = '<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Corporates/update";
      $btn .= '<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      /*
      $updateUrl = "Corporates/change_password";
      $btn .= '&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Corporates/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Reset Password" ' );
      */

      $btn .= '&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      /*
      $updateUrl = "Corporates/role_acess";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons"><a title="Assign Role" href="'.site_url($updateUrl.'/'.$row->id).'" class="btn btn-warning btn-circle btn-xs"><i class="ace-icon fa fa-list bigger-130"></i></a></span>';
      */

      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      if($row->address=='')
      {
        $address = "N/A";            
      }
      else
      {
        $address =  $row->address;
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      $nestedData[] = $address;
      $nestedData[] = $row->role;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Corporates_model->count_all($flag),
      "recordsFiltered" => $this->Corporates_model->count_filtered($flag),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Corporates')."'>Manage Corporates</a></li>
                    <li class='active'>Create Corporate</li>
                  </ul>";

    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");
    
    $departments = $this->Crud_model->GetData('mst_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc");

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Corporate',
      'sub_title'=>'Create',
      'countries' =>$countries,
      'departments' =>$departments,
      'breadcrumbs' =>$breadcrumbs,
      'action' => site_url("Corporates/create_action"), 
      'cancelbtn' => site_url('Corporates/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'name' =>  set_value('name',$this->input->post('name')),
      'name_marathi' =>  set_value('name_marathi',$this->input->post('name_marathi')),
      'name_hindi' =>  set_value('name_hindi',$this->input->post('name_hindi')),
      'email' =>  set_value('email',$this->input->post('email')),
      'mobile' =>  set_value('mobile',$this->input->post('mobile')),
      'country_id' =>  set_value('country_id',$this->input->post('country_id')),
      'state_id' =>  set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'zone_id' =>  set_value('zone_id',$this->input->post('zone_id')),
      'area_id' =>  set_value('area_id',$this->input->post('area_id')),
      'role' =>  set_value('role',$this->input->post('role')),
      'corporate_id' =>  set_value('corporate_id',$this->input->post('corporate_id')),
      'department_id' =>  set_value('department_id',$this->input->post('department_id')),
      'branch_id' =>  set_value('branch_id',$this->input->post('branch_id')),
      'pincode' =>  set_value('pincode',$this->input->post('pincode')),
      'address' =>  set_value('address',$this->input->post('address')),
      'address_marathi' =>  set_value('address_marathi',$this->input->post('address_marathi')),
      'address_hindi' =>  set_value('address_hindi',$this->input->post('address_hindi')),
      'is_check' =>  set_value('is_check',$this->input->post('is_check')),
    ); 
    $this->load->view('corporates/add_corporate',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
    $id = '0';
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else
    {  
      $image='';
      if( $_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/corporates/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/corporates/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }
      }

      $data = array(
        'name' => trim($this->input->post('name',TRUE)),
        'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'role' => $this->input->post('role',TRUE),
        'parent_id' => $this->input->post('corporate_id',TRUE),
        'department_id' => $this->input->post('department_id',TRUE),
        'branch_id' => $this->input->post('branch_id',TRUE),
        'pincode' => $this->input->post('pincode',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),
        'is_checked' => $this->input->post('is_check',TRUE),
        'image'    => $image,
      );  
      $this->Crud_model->SaveData("corporates",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Corporates has been created successfully</span>');
      redirect('Corporates/index');
    }
  }

  //UPDATE 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("corporates",'',"id='".$id."'",'','','','1');
      //echo "<pre>"; print_r($row); die();
      $departments = $this->Crud_model->GetData('mst_departments',"department_name,id","status='Active' and is_delete='No'","","department_name asc");

      $branches = $this->Crud_model->GetData('mst_department_branches',"branch_name,id","status='Active' and department_id='".$row->department_id."'","","branch_name asc");

      if($row->role=='Ward Member') 
      {
        $corporates = $this->Crud_model->GetData('corporates',"name,id","status='Active' and is_delete='No' and role='MLA'","","name asc"); 
      }
      else 
      {
        $corporates=[];
      }

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Corporates</li>
                    </ul>";

      if(!empty($row)) 
      {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","zone_name asc");

        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No' and zone_id='".$row->zone_id."'","","area asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Corporate',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'departments'   => $departments,
          'branches'   => $branches,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'zones'    => $zones,
          'areas'    => $areas,
          'corporates'    => $corporates,
          'cancelbtn'   => site_url('Corporates/index'), 
          'action'    => site_url('Corporates/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'    => set_value('city_id', $row->city_id),
          'zone_id'    => set_value('zone_id', $row->zone_id),
          'area_id'    => set_value('area_id', $row->area_id),
          'corporate_id'   => set_value('corporate_id', $row->parent_id),
          'department_id'    => set_value('department_id', $row->department_id),
          'branch_id'    => set_value('branch_id', $row->branch_id),
          'name'   => set_value('name', $row->name),
          'name_marathi'   => set_value('name_marathi', $row->name_marathi),
          'name_hindi'   => set_value('name_hindi', $row->name_hindi),
          'email'   => set_value('email', $row->email),
          'mobile'   => set_value('mobile', $row->mobile),
          'address'   => set_value('address', $row->address),
          'address_marathi'   => set_value('address_marathi', $row->address_marathi),
          'address_hindi'   => set_value('address_hindi', $row->address_hindi),
          'pincode'   => set_value('pincode', $row->pincode),
          'is_check'   => set_value('is_check', $row->is_checked),
          'role'   => set_value('role', $row->role),
          'image'   => set_value('image', $row->image),
        );
        $this->load->view('corporates/add_corporate', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Corporates/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Corporates/index');
    }
  }



  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) 
    {          
      $this->update($update_id);
    } 
    else 
    {  

      $image=$_POST['old_image'];
      
      if($_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/corporates/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/corporates/';
          $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      }

      $data = array(
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'name' => trim($this->input->post('name',TRUE)),
        'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),
        'email' => $this->input->post('email',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),
        'pincode' => $this->input->post('pincode',TRUE),
        'role' => $this->input->post('role',TRUE),
        'is_checked' => $this->input->post('is_check',TRUE),
        'parent_id' => $this->input->post('corporate_id',TRUE),
        'department_id' => $this->input->post('department_id',TRUE),
        'branch_id' => $this->input->post('branch_id',TRUE),
        'image'=>$image,
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("corporates",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Corporate has been updated successfully</span>');
      redirect('Corporates/index');
    }
  }


  public function import()
  {
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Corporates/index'));            
   } 
   $data = $fields_fun;
    //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' && $val[8] !='' &&  $val[9] !='')
      { 
         $corporates = $this->Crud_model->GetData('corporates','mobile',"mobile='".trim($val[2])."'",'','','','single'); 

         $countries = $this->Crud_model->GetData('mst_countries','id',"country_name='".$val[3]."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[4]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[5]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[6]."'",'','','','single');

         $zones = $this->Crud_model->GetData('mst_zones','id',"zone_name='".$val[7]."'",'','','','single');

         $areas = $this->Crud_model->GetData('mst_areas','id',"area='".$val[8]."'",'','','','single');

         /*for already exist check*/

         if(empty($corporates))
         {

            // if(!empty($val[11]))
            // {
            //    $address=$val[11];
            // } 
            // else
            // {
            //    $address="";
            // } 


            // if(!empty($val[10]))
            // {
            //    $pincode=$val[10];
            // } 
            // else
            // {
            //    $pincode="";
            // }

            if(!empty($val[9]))
            {
               $role=$val[9];
            } 
            else
            {
               $role="";
            }

            if(!empty($areas))
            {
               $area_id=$areas->id;
            } 
            else
            {
               $area_id="";
            }

            if(!empty($zones))
            {
                $zone_id =$zones->id;
            } 
            else
            {
               $zone_id ="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($countries))
            {
               $country_id=$countries->id;
            } 
            else
            {
               $country_id="";
            }

            if(!empty($val[2]))
            {
               $mobile=$val[2];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[1]))
            {
               $email=$val[1];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }


            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'name' => trim($name),
               'email' => trim($email),
               'mobile' => trim($mobile),
               'country_id' => $country_id,
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'zone_id' => $zone_id,
               'area_id' => $area_id,
               'role' => $role,
               //'pincode' => $pincode,
               //'address' => $address,
            );

            $SaveAssets = $this->Crud_model->SaveData('corporates',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Corporate already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Corporates/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('corporates/duplicateCorporates',$data);
   } 
}

  // VIEW
  public function view($id)
  {
    $cond = "id='".base64_decode($id)."'";
    $cond2 = "corporate_id='".base64_decode($id)."'";
    $row = $this->Corporates_model->viewCorporateDetails($cond);
    //echo "<pre>"; print_r($row); die();
    $citizenName = $this->Corporates_model->getCitizenAppointmentName($cond2);

    $pendingComplaints = $this->Crud_model->GetData('complaints','',"corporate_id='".$row->id."' and complaint_status='Pending'");

    $approvedComplaints = $this->Crud_model->GetData('complaints','',"corporate_id='".$row->id."' and complaint_status='Approved'");

    $resolvedComplaints = $this->Crud_model->GetData('complaints','',"corporate_id='".$row->id."' and complaint_status='Resolved'");

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Corporates/index').'">Manage Corporates</a></li>
                    <li class="active">Corporate Details</li>
                  </ul>';

    $data = array(
        'row'=> $row,
        'breadcrumbs'=>$breadcrumbs, 
        'id'=>$row->id,    
        'name'=>$row->name,    
        'email'=>$row->email,    
        'mobile'=>$row->mobile,
        'country_name'=>$row->country_name,    
        'state_name'=>$row->state_name,    
        'district_name'=>$row->district_name,    
        'city_name'=>$row->city_name,    
        'zone_name'=>$row->zone_name,    
        'area'=>$row->area,    
        'role'=>$row->role,    
        'state_id'=>$row->state_id,  
        'address'=>$row->address,    
        'pincode'=>$row->pincode,   
        'image'=>$row->image,   
        'status'=>$row->status,   
        'citizenName'=>$citizenName,   
        'pendingComplaints'=>$pendingComplaints,   
        'approvedComplaints'=>$approvedComplaints,   
        'resolvedComplaints'=>$resolvedComplaints,   
        );
   $this->load->view('corporates/view',$data);
  }
    
  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('corporates', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Corporate deleted successfully</span>');
    redirect('Corporates/index');
  } 

  public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('corporates','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') 
    {
      $this->Crud_model->SaveData('corporates',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } 
    else 
    {
      $this->Crud_model->SaveData('corporates',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Corporates/index");
  }

  public function getState() 
  {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) 
    {
      $response = '<option value="">Select State</option>';
      foreach($states as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select State</option>';
    }
    echo $response;
  }

  
  public function getDistrict()
  {
    $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

    if(!empty($districts)) 
    {
      $response = '<option value="">Select District</option>';
      foreach($districts as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select District</option>';
    }
    echo $response;
  }

  public function getCity()
  {
    $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

    if(!empty($cities)) 
    {
      $response = '<option value="">Select City</option>';
      foreach($cities as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select City</option>';
    }
    echo $response;
  }

  public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row)
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }



  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"area asc");
    
    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else
    {
        $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

  public function getMLA()
  {
      if($_POST['id']=='Ward Member') 
      {
        $corporates = $this->Crud_model->GetData("corporates",'name,id',"status='Active' and is_delete='No' and role='MLA'",'',"name asc");
      
        if(!empty($corporates)) 
        {
          $response = '<option value="">Select MLA</option>';
          foreach($corporates as $row) 
          {
              $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
          }
        }
        else 
        {
            $response = '<option value="">Select MLA</option>';
        }
      }
      else 
      {
          $response = '<option value="">Select MLA</option>';
      }
      echo $response;
  }

  public function getBranch()
  {
      $branches = $this->Crud_model->GetData("mst_department_branches",'branch_name,id',"department_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"branch_name asc");

      if(!empty($branches)) 
      {
        $response = '<option value="">Select Branch</option>';
        foreach($branches as $row) 
        {
          $response .= '<option value="'.$row->id.'">'.$row->branch_name.'</option>';
        }
      }
      else 
      {
          $response = '<option value="">Select Branch</option>';
      }
      echo $response;
  }

  public function _rules($id) 
  {
    $cond_email = "email='".$this->input->post('email',TRUE)."' and is_delete='no' and id!='".$id."'";
    $row = $this->Crud_model->GetData("corporates",'',$cond_email,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[corporates.email]";
    }

    $cond_mobile = "mobile='".$this->input->post('mobile',TRUE)."' and is_delete='no' and id!='".$id."'";
    $row = $this->Crud_model->GetData("corporates",'',$cond_mobile,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique2 = "";
    }
    else
    {
      $is_unique2 = "|is_unique[corporates.mobile]";
    }

    $this->form_validation->set_rules('name', 'name', 'required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'email already exists'
    ));

    $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
    array(
      'required'      => 'Please enter %s',
      'is_unique'     => 'mobile already exists'
    ));

    $this->form_validation->set_rules('country_id', 'country', 'required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('state_id', 'state', 'required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('district_id', 'district', 'required', array('required' => 'Please select %s'));

    $this->form_validation->set_rules('city_id', 'city', 'required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('zone_id', 'zone', 'required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('area_id', 'area', 'required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('role', 'role', 'required', array('required' => 'Please select %s'));
    
    $this->form_validation->set_rules('id', 'id', 'trim');

    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }


  /*
  public function role_acess($id)
  {  
    if(!empty($id))
    {
        $CorpData = $this->Crud_model->GetData("corporates","","id='".$id."'","","","","1");
        if(!empty($CorpData))
        {  
            $role_access = $this->Crud_model->GetData("role_access","menu_name","corporate_id='".$id."'"); 
            if(!empty($role_access))
            {
               foreach ($role_access as $menu ) 
               {
                   $menus[]=$menu->menu_name;
                } 
            }  
            else
            {
                $menus="";
            }

            $data=array(
                'menu_name'=>$menus,
                'button'=>'Submit',
                'action'=>site_url('Corporates/role_acess_action/'.$id),
                 );
            $this->load->view('corporates/role_acess',$data);
        }
        else
        {
            redirect('Corporates');
        }         
    }   
    else
    {
        redirect('Corporates');
    } 
  }
  */


  /*
  public function role_acess_action($id)
  {
    $role_access = $this->Crud_model->GetData("role_access","id","corporate_id='".$id."'"); 
    
    if(!empty($role_access))
    {  
      $this->Crud_model->DeleteData("role_access","corporate_id='".$id."'");
    }

    $count = count($this->input->post('menu_name[]'));
    for($i=0;$i<$count;$i++)
    {
      if($_POST['menu_name'][$i]!='')
      {
         $datadetail = array(
          'menu_name'=>$_POST['menu_name'][$i], 
          'corporate_id' => $id,
          'created'=> date('Y-m-d H:i:s'),
        
        );
        $this->Crud_model->SaveData("role_access",$datadetail);
      }
    }
    $this->session->set_flashdata('message', 'Role Assigned Successfully');
    redirect('Corporates');
  }
  */
     
}