<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Contact_us extends CI_Controller 
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Contact_us_model");
    }

    public function index()
    {

        $contact_us = $this->Crud_model->GetData("contact_us","is_delete='No'"); 
        //echo "<pre>"; print_r($contact_us);die;
        $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                                <i class='ace-icon fa fa-home home-icon'></i>
                                <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Contact Us</li>
                        </ul>";

        $data = array(
            'breadcrumbs' => $breadcrumbs,
            'contact_us' => $contact_us,
            'actioncolumn' => '5',
            'createAction' => site_url('Contact_us/create'),
            'ajax_manage_page' => site_url('Contact_us/ajax_manage_page'),
            'deleteAction' => site_url('Contact_us/delete'),
            'changeAction' => site_url('Contact_us/changeStatus'),
            'button' => 'Create',
            'heading' => 'Manage Contact Us',
        );
        $this->load->view('contact_us/list',$data);
    }

    public function ajax_manage_page() 
    {
        $Data = $this->Contact_us_model->get_datatables();  
        $data = array();  
        if(empty($_POST['start'])) {
          $no =0;   
        } else {
          $no =$_POST['start'];
        }

        foreach($Data as $row) {
          $update_url = "Contact_us/update";

          $btn ='<span class="action-buttons"><a title="Update" href="'.site_url($update_url.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';
          $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

          if($row->status=='Active')
            {
              $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
            }
            else
            {
              $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
            }
          $no++;  
          $nestedData = array();
          $nestedData[] = $no;
          $nestedData[] = $row->title;
          $nestedData[] = $row->mobile;
          $nestedData[] = $row->email;
          $nestedData[] = '<img style="width: 120px; height:120px;" src="'.base_url().'uploads/contact_us/'.$row->image.'" class="img-thumbnail">';
          $nestedData[] = $status;
          $nestedData[] = $btn;
          $data[] = $nestedData;
          $selected = '';

        }

        $output = array(
          "draw" => $_POST['draw'],
          "recordsTotal" => $this->Contact_us_model->count_all(),
          "recordsFiltered" => $this->Contact_us_model->count_filtered(),
          "data" => $data,
        );
        echo json_encode($output);
    }
    
    public function create() 
    {  
        $breadcrumbs = "<ul class='breadcrumb'>
                          <li>
                              <i class='ace-icon fa fa-home home-icon'></i>
                              <a href='".site_url('Dashboard')."'>Dashboard</a>
                          </li>
                          <li><a href='".site_url('Contact_us')."'>Manage Contact Us</a></li>
                          <li class='active'>Add</li>
                        </ul>";

        $data = array(
          'button'    => 'Create',
          'heading'   => 'Create',
          'breadcrumbs' => $breadcrumbs,
          'action'    => site_url('Contact_us/create_action'),
          'cancelbtn'   => site_url('Contact_us/index'), 
          'id'      => set_value('id',$this->input->post('id')),
          'title'        => set_value('title',$this->input->post('title')),
          'mobile'     => set_value('mobile',$this->input->post('mobile')),
          'email'     => set_value('email',$this->input->post('email')),
        ); 
        $this->load->view('contact_us/form',$data);
    }

    public function create_action() 
    {   

        // $id = '0';
        // $this->_rules($id);
        // if($this->form_validation->run() == FALSE) 
        // {  
        //     $this->create();
        // } 
        // else 
        // { 

          $image='';
          if( $_FILES['image']['name']!='' )
          {
            $image= rand(0000,9999)."_".$_FILES['image']['name'];
            $config2['image_library'] = 'gd2';
            $config2['source_image'] =  $_FILES['image']['tmp_name'];
            $config2['new_image'] =   getcwd().'/uploads/contact_us/'.$image;
            $config2['upload_path'] =  getcwd().'/uploads/contact_us/';
            $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
            $this->image_lib->initialize($config2);
            if(!$this->image_lib->resize())
            {
              echo('<pre>');
              echo ($this->image_lib->display_errors());
              exit;
            }
          // }
          $data = array(
              'title'      => $this->input->post('title'),
              'mobile'     => $this->input->post('mobile'),
              'email'    => $this->input->post('email'),
              'image'    => $image,
          );  
          $this->Crud_model->SaveData("contact_us",$data);
          $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Created successfully</span>');
          redirect('Contact_us/index');
        }
    }


    
  
    //UPDATE 
    public function update($update_id) 
    {  
        if(!empty($update_id)) 
        {
            $id = base64_decode($update_id);
            
            $row = $this->Crud_model->GetData("contact_us",'',"id='".$id."'",'','','','1'); 
            $breadcrumbs = "<ul class='breadcrumb'>
                            <li>
                              <i class='ace-icon fa fa-home home-icon'></i>
                              <a href='".site_url('Dashboard')."'>Dashboard</a>
                            </li>
                            <li class='active'>Manage Contact Us</li>
                          </ul>";

            if(!empty($row)) 
            {
                $data=array(
                    'button'    => 'Update',
                    'heading'   => 'Update',
                    'breadcrumbs' => $breadcrumbs,
                    'cancelbtn'   => site_url('Contact_us/index'), 
                    'action'    => site_url('Contact_us/update_action'.'/'.$update_id),
                    'id'      => set_value('id', $row->id),
                    'title'   => set_value('title', $row->title),
                    'mobile'   => set_value('mobile', $row->mobile),
                    'email'   => set_value('email', $row->email),
                    'image'   => set_value('image', $row->image),
                );
                $this->load->view('contact_us/form',$data);
            } 
            else 
            {
                print_r("expression");exit;
                $this->session->set_flashdata('message', 'Record Not Found');
                redirect('Contact_us/index');
            }
        } 
        else 
        {
            print_r("expression1");exit;
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect('Contact_us/index');
        }
    }

    //UPDATE ACTION
    public function update_action($update_id) 
    {
        $id = base64_decode($update_id);
       
            $image=$_POST['old_image'];
            if($_FILES['image']['name']!='' )
            {
              $image= rand(0000,9999)."_".$_FILES['image']['name'];
              $config2['image_library'] = 'gd2';
              $config2['source_image'] =  $_FILES['image']['tmp_name'];
              $config2['new_image'] =   getcwd().'/uploads/contact_us/'.$image;
              $config2['upload_path'] =  getcwd().'/uploads/contact_us/';
                $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
              $this->image_lib->initialize($config2);
              if(!$this->image_lib->resize())
              {
                echo('<pre>');
                echo ($this->image_lib->display_errors());
                exit;
              }  

            }

            $data = array(
                'title' => $this->input->post('title',TRUE),
                'mobile' => $this->input->post('mobile',TRUE),
                'email' => $this->input->post('email',TRUE),
                'image'=>$image,
            ); 
            $id = $this->input->post('id', TRUE);
            $con  = "id = '".$id."'";
            $this->Crud_model->SaveData("contact_us",$data,$con);
            $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Updated successfully</span>');
            redirect('Contact_us/index');
    }


    public function changeStatus() 
    {   
        $change_status = $this->Crud_model->GetData('contact_us','',"id='".$_POST['id']."'",'','','','row');

        if($change_status->status=='Active')
        {
            $this->Crud_model->SaveData('contact_us',array('status'=>'Inactive'),"id='".$_POST['id']."'");
        }
        else
        {
            $this->Crud_model->SaveData('contact_us',array('status'=>'Active'),"id='".$_POST['id']."'");
        }
        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
        redirect('Contact_us/index');
    }

    public function delete() 
    {
        $con = "id='".$_POST['id']."'";
        $this->Crud_model->SaveData('contact_us', array('is_delete'=>'Yes'), $con);

        $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Deleted successfully</span>');
        redirect('Contact_us/index');
    } 

    // SEVER SIDE VALIDATION
    // public function _rules($id) 
    // {
    //     $cond = "mobile='".trim($this->input->post('mobile',TRUE))."' and id!='".$id."'";
    //     $row = $this->Crud_model->GetData("contact_us",'',$cond,'','','','');
    //     $count = count($row);

    //     if($count==0) 
    //     {
    //         $is_unique = "";
    //     } 
    //     else 
    //     {
    //         $is_unique = "|is_unique[contact_us.mobile]";
    //     } 
      

    //     $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique,
    //     array(
    //       'required'      => 'Please enter %s',
    //       'is_unique'     => 'mobile already exists'
    //     ));

    //     $this->form_validation->set_rules('ttile', 'ttile', 'trim|required', array('required' => 'Please enter %s'));
        
    //     $this->form_validation->set_rules('email', 'email', 'trim|required', array('required' => 'Please enter %s'));


       
    //     $this->form_validation->set_rules('id', 'id', 'trim');
    //     $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
    // }
}