<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Constitution_article extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model("Constitution_article_model");
  }

  public function index() {
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Constitution Article</li>
                    </ul>";
    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '3',
      'ajaxManagePage' => site_url('Constitution_article/ajaxManagePage'),
      'addAction' => site_url('Constitution_article/addData'),
      'updateAction' => site_url('Constitution_article/updateData'),
      'deleteAction' => site_url('Constitution_article/deleteData'),
      'changeAction' => site_url('Constitution_article/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Constitution Article'
    );
    $this->load->view('constitutions_articles/list', $data);       
  }

  public function ajaxManagePage() {
    $condition = "";
    $getData = $this->Constitution_article_model->get_datatables($condition);
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $btn = '';
      $btn .= ('<a href="#myModaledit" title="Edit"  data-toggle="modal" class="btn btn-info btn-circle btn-sm" onclick="getEditValue('.$Data->id.');">
              <i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      $status = '';

      if($Data->status=='Active') {
        $status .=  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      } else {
        $status .=  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->title);
      $row[] = $status;
      $row[] = $btn;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Constitution_article_model->count_all($condition),
      "recordsFiltered" => $this->Constitution_article_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

	public function changeStatus() {
    $change_status = $this->Crud_model->GetData('constitution_articles','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active') {
        $this->Crud_model->SaveData('constitution_articles',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
        $this->Crud_model->SaveData('constitution_articles',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Constitution_article/index');
  }
  
  public function addData() {
    $condDuplication = "title='".$this->input->post('title')."'";
    $duplication = $this->Crud_model->GetData('constitution_articles','', $condDuplication);

    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(
        'title' => $this->input->post('title'),
        'title_marathi' => $this->input->post('title_marathi'),
        'title_hindi' => $this->input->post('title_hindi'),
      );
      $this->Crud_model->SaveData('constitution_articles',$data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }      
  }

  public function updateData() {
    $condDuplication = "title='".$this->input->post('title')."' and id !='".$this->input->post('id')."'";
    $duplication = $this->Crud_model->GetData('constitution_articles','', $condDuplication);
    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(                          
        'title' => $this->input->post('title'),               
        'title_marathi' => $this->input->post('title_marathi'),               
        'title_hindi' => $this->input->post('title_hindi'),               
      );
      $this->Crud_model->SaveData('constitution_articles', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo 2;
    } 
  }

  public function deleteData() {
    $con = "id='".$_POST['id']."'";
    //$this->Crud_model->DeleteData('constitution_articles',$con);
    $this->Crud_model->SaveData('constitution_articles', array('is_delete'=>'Yes'), $con);
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Constitution_article/index');
  }

  public function getUpdateName() {
    $row = $this->Crud_model->GetData('constitution_articles','',"id='".$_POST['id']."'",'','','','row');   
    $data = array(
			'title' => $row->title,
      'title_marathi' => $row->title_marathi,
      'title_hindi' => $row->title_hindi,
			);
    echo json_encode($data);
  }

  public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Constitution_article/index'));            
   } 
   $data = $fields_fun;
  //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='')
      { 
         $constitution_article = $this->Crud_model->GetData('constitution_articles','title',"title='".trim($val[0])."'",'','','','single'); 

         /*for already exist check*/

         if(empty($constitution_article))
         {

            if(!empty($val[0]))
            {
               $title=$val[0];
            } 
            else
            {
               $title="";
            }
  
            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);

            $data = array(
               'title' => $title,
            );

            $SaveAssets = $this->Crud_model->SaveData('constitution_articles',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],'Article already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Constitution_article/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('constitutions_articles/duplicateArticle',$data);
   } 
}


}