<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Citizens extends CI_Controller 
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model("Citizens_model");
    $this->load->library('Excel');
  }

  public function index()
  {
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Citizens</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs,
      'actioncolumn' => '13',
      'ajax_manage_page' => site_url('Citizens/ajax_manage_page'),
      'action' => site_url('Citizens/create'),
      'deleteAction' => site_url('Citizens/delete'),
      'changeAction' => site_url('Citizens/changeStatus'),
      'button' => 'Create',
      'heading' => 'Manage Citizens',
    );
    $this->load->view('citizens/citizens_list',$data);
  }

  public function ajax_manage_page() 
  {
    $citizensData = $this->Citizens_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($citizensData as $row) 
    {
      $viewUrl = "Citizens/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Citizens/update";
      $btn .='<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      /*
      $pwChangeUrl = "Citizens/change_password";
      $btn .='&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Citizens/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Reset Password" ' );
      */

      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = $row->name;
      $nestedData[] = $row->email;
      $nestedData[] = $row->mobile;
      //$nestedData[] = $row->dob;
      //$nestedData[] = $row->gender;
      $nestedData[] = ucwords($row->country_name);
      $nestedData[] = ucwords($row->state_name);
      $nestedData[] = ucwords($row->district_name);
      $nestedData[] = ucwords($row->city_name);
      //$nestedData[] = ucwords($row->zone_name);
      //$nestedData[] = $row->address;
      //$nestedData[] = $row->pincode;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Citizens_model->count_all(),
      "recordsFiltered" => $this->Citizens_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create() 
  {  
    $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

    $professions = $this->Crud_model->GetData('mst_professions',"profession,id","status='Active' and is_delete='No'","","profession asc");
    
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li>Manage Citizens</li>
                      <li class='active'>Add Citizen</li>
                    </ul>";

    $data = array(
      'button'    => 'Create',
      'heading'   => 'Create Citizen',
      'breadcrumbs' => $breadcrumbs,
      'countries'    => $countries,
      'professions'    => $professions,
      'action'    => site_url('Citizens/create_action'),
      'cancelbtn'   => site_url('Citizens/index'), 
      'id'      => set_value('id',$this->input->post('id')),
      'name'        => set_value('name',$this->input->post('name')),
      'mobile'     => set_value('mobile',$this->input->post('mobile')),
      'email'     => set_value('email',$this->input->post('email')),
      'dob'    => set_value('dob',$this->input->post('dob')),
      'profession_id'    => set_value('profession_id',$this->input->post('profession_id')),
      'gender'    => set_value('gender',$this->input->post('gender')),
      'country_id'    => set_value('country_id',$this->input->post('country_id')),
      'state_id'    => set_value('state_id',$this->input->post('state_id')),
      'district_id' =>  set_value('district_id',$this->input->post('district_id')),
      'city_id' =>  set_value('city_id',$this->input->post('city_id')),
      'zone_id' =>  set_value('zone_id',$this->input->post('zone_id')),
      //'area_id' =>  set_value('area_id',$this->input->post('area_id')),
      'adhar_no'    => set_value('adhar_no',$this->input->post('adhar_no')),
      'voter_no'    => set_value('voter_no',$this->input->post('voter_no')),
      'total_members'    => set_value('total_members',$this->input->post('total_members')),
      'total_male'    => set_value('total_male',$this->input->post('total_male')),
      'total_female'    => set_value('total_female',$this->input->post('total_female')),
    ); 
    $this->load->view('citizens/add_citizen',$data);
  }


  public function create_action() 
  {   
    $id = 0;
    $this->_rules($id);
    if($this->form_validation->run() == FALSE) 
    {  
      $this->create();
    } 
    else 
    {
      /*
      $image='';
      if( $_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/citizens/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/citizens/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }
      }
      */
      $data = array(
        'name'      => $this->input->post('name'),
        'mobile'    => $this->input->post('mobile'),
        'email'     => $this->input->post('email'),
        'dob'    => date('Y-m-d',strtotime($this->input->post('dob'))),
        'profession_id'    => $this->input->post('profession_id'),
        'gender'    => $this->input->post('gender'),
        'country_id'    => $this->input->post('country_id'),
        'state_id'    => $this->input->post('state_id'),
        'district_id' => $this->input->post('district_id'),
        'city_id' => $this->input->post('city_id'),
        'zone_id' => $this->input->post('zone_id'),
        'adhar_no'    => $this->input->post('adhar_no'),
        'voter_no'    => $this->input->post('voter_no'),
        'total_members'    => $this->input->post('total_members'),
        'total_male'    => $this->input->post('total_male'),
        'total_female'    => $this->input->post('total_female'),
      );  
      $this->Crud_model->SaveData("citizens",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen has been created successfully</span>');
      redirect('Citizens/index');
    }
  }

  public function getState() 
  {
    $states = $this->Crud_model->GetData("mst_states",'state_name,id',"country_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"state_name asc");

    if(!empty($states)) 
    {
      $response = '<option value="">Select State</option>';
      foreach($states as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->state_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select State</option>';
    }
    echo $response;
  }

  
  public function getDistrict()
  {
    $districts = $this->Crud_model->GetData("mst_districts",'district_name,id',"state_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"district_name asc");

    if(!empty($districts)) 
    {
      $response = '<option value="">Select District</option>';
      foreach($districts as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->district_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select District</option>';
    }
    echo $response;
  }

  public function getCity()
  {
    $cities = $this->Crud_model->GetData("mst_cities",'city_name,id',"district_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"city_name asc");

    if(!empty($cities)) 
    {
      $response = '<option value="">Select City</option>';
      foreach($cities as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->city_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select City</option>';
    }
    echo $response;
  }

  public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }

  /*
  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"area asc");

    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }
  */

  // view citizen
  public function view($id)
  {
    $cond = "id='".base64_decode($id)."'";
    $row = $this->Citizens_model->viewCompDetails($cond);
    $complaints = $this->Crud_model->GetData("complaints",'',"citizen_id='".$row->id."' and status='Active' and is_delete='No'");
    //echo "<pre>"; print_r($complaints); die();
    $complaint_feedbacks = $this->Crud_model->GetData("complaint_feedbacks",'feedback,image,subject',"citizen_id='".$row->id."'");

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Citizens/index').'">Manage Citizen</a></li>
                    <li class="active">Citizen Details</li>
                  </ul>';

    $data = array(
      'row'=> $row,
      'complaints'=> $complaints,
      'complaint_feedbacks'=> $complaint_feedbacks,
      'breadcrumbs'=>$breadcrumbs, 
      'id'=>$row->id,    
      'name'=>$row->name,    
      'email'=>$row->email,    
      'mobile'=>$row->mobile,    
      'dob'=>$row->dob,    
      'gender'=>$row->gender,    
      'profession'=>$row->profession,    
      'country_name'=>$row->country_name,    
      'state_name'=>$row->state_name,    
      'city_name'=>$row->city_name,  
      'district_name'=>$row->district_name,  
      'zone_name'=>$row->zone_name,    
      'area'=>$row->area,    
      'address'=>$row->address,    
      'pincode'=>$row->pincode,   
      'adhar_no'=>$row->adhar_no,   
      'voter_no'=>$row->voter_no,   
      'total_members'=>$row->total_members,   
      'total_male'=>$row->total_male,   
      'total_female'=>$row->total_female,   
      'image'=>$row->image,   
      'status'=>$row->status,   
      'feedback'=>$row->feedback,   
      'feedback_image'=>$row->image,   
      'title'=>$row->title,   
      'description'=>$row->description,   
    );
    $this->load->view('citizens/view',$data);
  }

  // update 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);
      $row = $this->Crud_model->GetData("citizens",'',"id='".$id."'",'','','','1');
      $breadcrumbs = "<ul class='breadcrumb'>
                        <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                        </li>
                        <li><a href='".site_url('Citizens')."'>Manage Citizens</a></li>
                        <li class='active'>Update Citizen</li>
                      </ul>";

      if(!empty($row)) 
      {
        $countries = $this->Crud_model->GetData('mst_countries',"country_name,id","status='Active' and is_delete='No' and country_name='India'","","country_name asc");

        $professions = $this->Crud_model->GetData('mst_professions',"profession,id","status='Active' and is_delete='No'","","profession asc");

        $states = $this->Crud_model->GetData('mst_states',"state_name,id","status='Active' and is_delete='No' and country_id='".$row->country_id."'","","state_name asc");

        $districts = $this->Crud_model->GetData('mst_districts',"district_name,id","status='Active' and is_delete='No' and state_id='".$row->state_id."'","","district_name asc");

        $cities = $this->Crud_model->GetData('mst_cities',"city_name,id","status='Active' and is_delete='No' and district_id='".$row->district_id."'","","city_name asc");

        $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No' and city_id='".$row->city_id."'","","zone_name asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Citizen',
          'breadcrumbs' => $breadcrumbs,
          'countries'   => $countries,
          'states'    => $states,
          'districts'    => $districts,
          'cities'    => $cities,
          'zones'    => $zones,
          'professions'    => $professions,
          'cancelbtn'   => site_url('Citizens/index'), 
          'action'    => site_url('Citizens/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'name'   => set_value('name', $row->name),
          'mobile'   => set_value('mobile', $row->mobile),
          'email'   => set_value('email', $row->email),
          'dob'   => set_value('dob', $row->dob),
          'profession_id'    => set_value('profession_id', $row->profession_id),
          'gender'   => set_value('gender', $row->gender),
          'country_id'  => set_value('country_id', $row->country_id),
          'state_id'    => set_value('state_id', $row->state_id),
          'district_id'    => set_value('district_id', $row->district_id),
          'city_id'    => set_value('city_id', $row->city_id),
          'zone_id'    => set_value('zone_id', $row->zone_id),
          'adhar_no'   => set_value('adhar_no', $row->adhar_no),
          'voter_no'   => set_value('voter_no', $row->voter_no),
          'total_members'   => set_value('total_members', $row->total_members),
          'total_male'   => set_value('total_male', $row->total_male),
          'total_female'   => set_value('total_female', $row->total_female),
        );
        $this->load->view('citizens/add_citizen', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Citizens/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Citizens/index');
    }
  }

  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);
    $this->_rules($id);
    if ($this->form_validation->run() == FALSE) 
    {          
      $this->update($update_id);
    } 
    else 
    {  
      /*
      $image=$_POST['old_image'];
      if($_FILES['image']['name']!='' )
      {
        $image= rand(0000,9999)."_".$_FILES['image']['name'];
        $config2['image_library'] = 'gd2';
        $config2['source_image'] =  $_FILES['image']['tmp_name'];
        $config2['new_image'] =   getcwd().'/uploads/citizens/'.$image;
        $config2['upload_path'] =  getcwd().'/uploads/citizens/';
        $config2['allowed_types'] = 'png|PNG|jpg|JPG|jpeg|JPEG';
        $this->image_lib->initialize($config2);
        if(!$this->image_lib->resize())
        {
          echo('<pre>');
          echo ($this->image_lib->display_errors());
          exit;
        }   
      }
      */
      $data = array(
        'name' => $this->input->post('name',TRUE),
        'mobile' => $this->input->post('mobile',TRUE),
        'email' => $this->input->post('email',TRUE),
        'dob' => $this->input->post('dob',TRUE),
        'profession_id' => $this->input->post('profession_id',TRUE),
        'gender' => $this->input->post('gender',TRUE),
        'country_id' => $this->input->post('country_id',TRUE),
        'state_id' => $this->input->post('state_id',TRUE),
        'district_id' => $this->input->post('district_id',TRUE),
        'city_id' => $this->input->post('city_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'adhar_no' => $this->input->post('adhar_no',TRUE),
        'voter_no' => $this->input->post('voter_no',TRUE),
        'total_members' => $this->input->post('total_members',TRUE),
        'total_male' => $this->input->post('total_male',TRUE),
        'total_female' => $this->input->post('total_female',TRUE),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("citizens",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen has been updated successfully</span>');
      redirect('Citizens/index');
    }
  }

  public function changeStatus()
  {
    $change_status = $this->Crud_model->GetData('citizens','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active')
    {
      $this->Crud_model->SaveData('citizens',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    }
    else
    {
      $this->Crud_model->SaveData('citizens',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Citizens/index');
  }

  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('citizens', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Citizen deleted successfully</span>');
    redirect('Citizens/index');
  }



  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Citizens/index'));            
    } 
    $data = $fields_fun;
    //echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' && $val[8] !='' && $val[9] !='' && $val[10] !='' && $val[13] !='' && $val[14] !='' && $val[15] !='')
      { 
         $getCitizen = $this->Crud_model->GetData('citizens','mobile',"mobile='".trim($val[1])."'",'','','','single'); 
       
         $countries = $this->Crud_model->GetData('mst_countries','id',"country_name='".$val[6]."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[7]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[8]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[9]."'",'','','','single');

         $zones = $this->Crud_model->GetData('mst_zones','id',"zone_name='".$val[10]."'",'','','','single');

         //$areas = $this->Crud_model->GetData('mst_areas','id',"area='".$val[5]."'",'','','','single');

         $professions = $this->Crud_model->GetData('mst_professions','id',"profession='".$val[4]."'",'','','','single'); 
     

         /*for already exist check*/

         if(empty($getCitizen))
         {
           /* 
           if(!empty($val[15]))
            {
               $voter_no=$val[15];
            } 
            else
            {
               $voter_no="";
            }

            if(!empty($val[14]))
            {
               $adhar_no=$val[14];
            } 
            else
            {
               $adhar_no="";
            }

            if(!empty($val[13]))
            {
               $pincode=$val[13];
            } 
            else
            {
               $pincode="";
            }

            if(!empty($val[12]))
            {
               $address=$val[12];
            } 
            else
            {
               $address="";
            }

            if(!empty($val[11]))
            {
               $mobile=$val[11];
            } 
            else
            {
               $mobile="";
            }

            if(!empty($val[10]))
            {
               $email=$val[10];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[9]))
            {
               $gender=$val[9];
            } 
            else
            {
               $gender="";
            }

            if(!empty($val[8]))
            {
               $dob=$val[8];
            } 
            else
            {
               $dob="";
            } 


            if(!empty($val[7]))
            {
               $name=$val[7];
            } 
            else
            {
               $name="";
            }

            if(!empty($professions))
            {
               $profession_id=$professions->id;
            } 
            else
            {
               $profession_id="";
            }

            if(!empty($areas))
            {
               $area_id=$areas->id;
            } 
            else
            {
               $area_id="";
            }
            */

            if(!empty($val[15]))
            {
               $total_female=$val[15];
            } 
            else
            {
               $total_female="";
            }

            if(!empty($val[14]))
            {
               $total_male=$val[14];
            } 
            else
            {
               $total_male="";
            }

            if(!empty($val[13]))
            {
               $total_members=$val[13];
            } 
            else
            {
               $total_members="";
            }

            if(!empty($val[12]))
            {
               $voter_no=$val[12];
            } 
            else
            {
               $voter_no="";
            }

            if(!empty($val[11]))
            {
               $adhar_no=$val[11];
            } 
            else
            {
               $adhar_no="";
            }

            if(!empty($zones))
            {
                $zone_id =$zones->id;
            } 
            else
            {
               $zone_id ="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            if(!empty($countries))
            {
               $country_id=$countries->id;
            } 
            else
            {
               $country_id="";
            }

            if(!empty($val[5]))
            {
               $gender=$val[5];
            } 
            else
            {
               $gender="";
            }

             if(!empty($professions))
            {
               $profession_id=$professions->id;
            } 
            else
            {
               $profession_id="";
            }

            if(!empty($val[3]))
            {
               $dob=$val[3];
            } 
            else
            {
               $dob="";
            }

            if(!empty($val[2]))
            {
               $email=$val[2];
            } 
            else
            {
               $email="";
            }

            if(!empty($val[1]))
            {
               $mobile=$val[1];
            } 
            else
            {
               $mobile="";
            }


            if(!empty($val[0]))
            {
               $name=$val[0];
            } 
            else
            {
               $name="";
            }

            $data = array(
               'name' => trim($name),
               'mobile' => trim($mobile),
               'email' => trim($email),
               'dob' => date("Y-m-d", strtotime($dob)),
               'profession_id' => $profession_id,
               'gender' => trim($gender),
               'country_id' => $country_id,
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'zone_id' => $zone_id,
               'adhar_no' => $adhar_no,
               'voter_no' => $voter_no,
               'total_members' => $total_members,
               'total_male' =>$total_male,
               'total_female' => $total_female,
               // 'area_id' => $area_id,
               // 'address' => $address,
               // 'pincode' => $pincode,
            );
            //echo "<pre>"; print_r($data); die();
            $SaveAssets = $this->Crud_model->SaveData('citizens',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[13],$val[14],$val[15],'Citizen already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],$val[10],$val[13],$val[14],$val[15],'Mandatory fields empty');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Citizens/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('citizens/duplicateCitizen',$data);
   } 
  }

  // SEVER SIDE VALIDATION
  public function _rules($id) 
  {
    $cond_email = "email='".$this->input->post('email',TRUE)."' and is_delete='no' and id!='".$id."'";
    $row = $this->Crud_model->GetData("citizens",'',$cond_email,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique = "";
    }
    else
    {
      $is_unique = "|is_unique[citizens.email]";
    }

    $cond_mobile = "mobile='".$this->input->post('mobile',TRUE)."' and is_delete='no' and id!='".$id."'";
    $row = $this->Crud_model->GetData("citizens",'',$cond_mobile,'','','','');
    $count = count($row); 
    if($count==0)
    {
      $is_unique2 = "";
    }
    else
    {
      $is_unique2 = "|is_unique[citizens.mobile]";
    }

    $this->form_validation->set_rules('name', 'name', 'trim|required', array('required' => 'Please enter %s'));

    $this->form_validation->set_rules('mobile', 'mobile', 'trim|required'.$is_unique2,
                            array(
                              'required' => 'Please enter %s',
                              'is_unique' => 'mobile already exists'
                            ));

    $this->form_validation->set_rules('email', 'email', 'trim|required'.$is_unique,
                            array(
                              'required' => 'Please enter %s',
                              'is_unique' => 'email already exists'
                            ));

    $this->form_validation->set_rules('dob', 'dob', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('profession_id', 'profession', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('gender', 'gender', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('country_id', 'country', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('state_id', 'state', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('district_id', 'district', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('city_id', 'city', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('zone_id', 'zone', 'trim|required', array('required' => 'Please select %s'));
    $this->form_validation->set_rules('total_members', 'total members', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('total_male', 'total male', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('total_female', 'total female', 'trim|required', array('required' => 'Please enter %s'));
    $this->form_validation->set_rules('id', 'id', 'trim');
    $this->form_validation->set_error_delimiters('<span style="color: red">', '</span>');   
  }
}