<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bpatrak extends CI_Controller {
  

  public function __construct() {
    parent::__construct();
    $this->load->model("Bpatrak_model");
  }


  public function index()
  {   

    $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Incidence Spot</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '6',
            'heading' => 'Incidence Spot',
            'ajax_manage_page' => site_url('Bpatrak/ajax_manage_page'),
          );
          $this->load->view('bpatrak/list',$data);
  }


  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $getData = $this->Bpatrak_model->get_datatables($condition);

    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {

      $viewUrl = "Bpatrak/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($Data->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($Data->fir_number);
      $nestedData[] = $Data->complaint_title;
      $nestedData[] = $Data->criminal_name;
      $nestedData[] = $Data->arrested_datetime;
      $nestedData[] = $Data->crime_datetime;
      $nestedData[] = $Data->fir_datetime;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Bpatrak_model->count_all($condition),
      "recordsFiltered" => $this->Bpatrak_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function view($id)
  {
    $id = base64_decode($id);
    $row = $this->Crud_model->GetData("bpatrak",'',"id='".$id."'","","","","1");
    
    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Bpatrak/index').'">Manage Incidence Spot</a></li>
                    <li class="active">Incidence Spot Details</li>
                  </ul>';

    if(!empty($row))
    {
      $data = array(
        "breadcrumbs"=>$breadcrumbs,
        "cancelbtn"=>site_url('Bpatrak'),
        "fir_number"=>$row->fir_number,
        "complaint_title"=>$row->complaint_title,
        "criminal_name"=>$row->criminal_name,
        "arrested_datetime"=>$row->arrested_datetime,
        "crime_datetime"=>$row->crime_datetime,
        "fir_datetime"=>$row->fir_datetime,
        "lost_things"=>$row->lost_things,
        "found_things"=>$row->found_things,
        "crime_place"=>$row->crime_place,
        "incident_name"=>$row->incident_name,
        "victim_mobile_number"=>$row->victim_mobile_number,
        "reality"=>$row->reality,
        "police_id"=>$row->police_id,
        "police_station_head_id"=>$row->police_station_head_id,
        "image"=>$row->image,
        "video"=>$row->video,
      );
      $this->load->view('bpatrak/view', $data);
    }   
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Bpatrak/index');
    }         
  }
}
