<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Attendances extends CI_Controller {

   public function __construct() {
    parent::__construct();
    $this->load->model("Attendances_model");
  }
  
  public function index()
  {   
    
       $attendances = $this->Crud_model->GetData("attendances"); 

       $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Patrolling Attendance</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'attendances' =>$attendances,
            'actioncolumn' => '4',
            'heading' => 'Manage Patrolling Attendance',
            'ajax_manage_page' => site_url('Attendances/ajax_manage_page'),
          );
          $this->load->view('attendances/list',$data);
  }

  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mp.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "mp.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $getData = $this->Attendances_model->get_datatables($condition);
    //echo "<pre>"; print_r($getData); die();
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->police_name);
      $row[] = date("d-m-Y", strtotime($Data->attendance_date));
      $row[] = date("h:i A", strtotime($Data->in_time));
      $row[] = date("h:i A", strtotime($Data->out_time));
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Attendances_model->count_all($condition),
      "recordsFiltered" => $this->Attendances_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function changeStatus(){
        
    $change_status = $this->Crud_model->GetData('attendances','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Confirmed')
    {
        $this->Crud_model->SaveData('attendances',array('status'=>'Pending'),"id='".$_POST['id']."'");
    }
    else
    {
        $this->Crud_model->SaveData('attendances',array('status'=>'Confirmed'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Attendences/index');
  }


}
