<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Assigned_station_activities extends CI_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->model('Assigned_station_activities_model');
    $this->load->database();
  }

  public function index() 
  { 
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Assigned Station Activities</li>
                    </ul>";

    $data = array(
      'breadcrumbs' => $breadcrumbs ,
      'actioncolumn' => '10' ,
      'action' =>  site_url('Assigned_station_activities/create') ,
      'ajax_manage_page' => site_url('Assigned_station_activities/ajax_manage_page'),
      'heading' => 'Manage Assigned Station Activities',
    );
    $this->load->view('assigned_station_activities/list', $data);
  }

  public function ajax_manage_page() 
  {

    $allData = $this->Assigned_station_activities_model->get_datatables();  
    $data = array();  
    if(empty($_POST['start'])) 
    {
      $no =0;   
    } 
    else 
    {
      $no =$_POST['start'];
    }

    foreach($allData as $row) 
    {
      $viewUrl = "Assigned_station_activities/view";
      $btn = '<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($row->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>&nbsp;|&nbsp;';

      $updateUrl = "Assigned_station_activities/update";
      $btn .= '<span class="action-buttons"><a title="Update" href="'.site_url($updateUrl.'/'.base64_encode($row->id)).'" class="btn btn-info btn-circle btn-xs"><i class="ace-icon fa fa-pencil bigger-130"></i></a></span>';

      /*
      $updateUrl = "Corporates/change_password";
      $btn .= '&nbsp;|&nbsp;'.'<span class="action-buttons">' .anchor(site_url('Corporates/change_password/'.base64_encode($row->id)),'<i class="btn btn-warning btn-circle btn-xs ace-icon fa fa-key bigger-130"></i></span>','onclick="javasciprt: return confirm(\'Do you really wants to change password?\')" title="Reset Password" ' );
      */

      $btn .= '&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-xs" onclick="checkStatus('.$row->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';

    
     
      if($row->status=='Active')
      {
        $status =  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$row->id.")'> Active </a>";            
      }
      else
      {
        $status =  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$row->id.")'> Inactive </a>";
      }

      if($row->address=='')
      {
        $address = "N/A";            
      }
      else
      {
        $address =  $row->address;
      }

      

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($row->activity_name);
      $nestedData[] = ucfirst($row->higher_authority_name);
      $nestedData[] = ucfirst($row->name);
      $nestedData[] = ucfirst($row->police_station_head_name);
      $nestedData[] = $row->zone_name;
      $nestedData[] = $row->area;
      $nestedData[] = date('d-m-Y',strtotime($row->from_date));
      $nestedData[] = date('d-m-Y',strtotime($row->to_date));
      $nestedData[] = $address;
      $nestedData[] = $status;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';

    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Assigned_station_activities_model->count_all(),
      "recordsFiltered" => $this->Assigned_station_activities_model->count_filtered(),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function create()
  {  
    //BREADCRUMBS
    $breadcrumbs="<ul class='breadcrumb'>
                    <li>
                      <i class='ace-icon fa fa-home home-icon'></i>
                      <a href='".site_url('Dashboard')."'>Dashboard</a>
                    </li>
                    <li><a href='".site_url('Assigned_station_activities')."'>Manage Assigned Station Activities</a></li>
                    <li class='active'>Create Assigned Station Activities</li>
                  </ul>";

   $policeActivities = $this->Crud_model->GetData('police_activities',"name,id","status='Active' and is_delete='No'","","name asc");

       $higherAuthority = $this->Crud_model->GetData("mst_police",'police_name,id',"designation_type='Head_Person' and is_delete='No' and status='Active'",'',"police_name asc");
       //print_r($higherAuthority);exit();

        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

        $policeStationHead = $this->Crud_model->GetData('mst_police',"police_name,id","designation_type='Station_Head' and status='Active' and is_delete='No'","","police_name asc");

        $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No'","","zone_name asc");
        //print_r($zones);exit();
        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No'","","area asc");

    $data = array(
      'button'=>'Create',
      'heading'=>'Create Assigned Station Activities',
      'sub_title'=>'Create',
      'breadcrumbs' =>$breadcrumbs,
        'policeActivities'   => $policeActivities,
          'higherAuthority'    => $higherAuthority,
          'policeStations'    => $policeStations,
          'policeStationHead'    => $policeStationHead,
          'zones'    => $zones,
          'areas'    => $areas,
      'action' => site_url("Assigned_station_activities/create_action"), 
      'cancelbtn' => site_url('Assigned_station_activities/index'), 
      'id' =>  set_value('id',$this->input->post('id')),
      'activity_id' =>  set_value('activity_id',$this->input->post('activity_id')),
      'higher_authority_id' =>  set_value('higher_authority_id',$this->input->post('higher_authority_id')),
      'police_station_id' =>  set_value('police_station_id',$this->input->post('police_station_id')),
      'police_station_head_id' =>  set_value('police_station_head_id',$this->input->post('police_station_head_id')),
      'zone_id' =>  set_value('zone_id',$this->input->post('zone_id')),
      'area_id' =>  set_value('area_id',$this->input->post('area_id')),
      'address' =>  set_value('address',$this->input->post('address')),
      'description' =>  set_value('description',$this->input->post('description')),
      'from_date' =>  set_value('from_date',$this->input->post('from_date')),
      'to_date' =>  set_value('to_date',$this->input->post('to_date')),
    ); 
    $this->load->view('assigned_station_activities/form',$data);
  }

  //ADD ACTION
  public function create_action() 
  {  
   // print_r($_POST);exit();
   

      $data = array(
        
      /*  'name_marathi' => trim($this->input->post('name_marathi',TRUE)),
        'name_hindi' => trim($this->input->post('name_hindi',TRUE)),*/
        'activity_id' => $this->input->post('activity_id',TRUE),
        'higher_authority_id' => $this->input->post('higher_authority_id',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'police_station_head_id' => $this->input->post('police_station_head_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'description' => trim($this->input->post('description',TRUE)),
        'from_date' => trim($this->input->post('from_date',TRUE)),
        'to_date' => trim($this->input->post('to_date',TRUE)),
      
      /*  'address_marathi' => trim($this->input->post('address_marathi',TRUE)),
        'address_hindi' => trim($this->input->post('address_hindi',TRUE)),*/
      );  
      $this->Crud_model->SaveData("police_station_activity_map",$data);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been created successfully</span>');
      redirect('Assigned_station_activities/index');
    
  }

  //UPDATE 
  public function update($update_id) 
  {  
    if(!empty($update_id)) 
    {
      $id = base64_decode($update_id);

      $row = $this->Crud_model->GetData("police_station_activity_map",'',"id='".$id."'",'','','','1');
      //echo "<pre>"; print_r($row); die();

      $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Corporates</li>
                    </ul>";

      if(!empty($row)) 
      {
        $policeActivities = $this->Crud_model->GetData('police_activities',"name,id","status='Active' and is_delete='No'","","name asc");

       $higherAuthority = $this->Crud_model->GetData("mst_police",'police_name,id',"designation_type='Head_Person' and is_delete='No' and status='Active'",'',"police_name asc");

        $policeStations = $this->Crud_model->GetData('mst_police_stations',"name,id","status='Active' and is_delete='No'","","name asc");

        $policeStationHead = $this->Crud_model->GetData('mst_police',"police_name,id","designation_type='Station_Head' and status='Active' and is_delete='No'","","police_name asc");

        $zones = $this->Crud_model->GetData('mst_zones',"zone_name,id","status='Active' and is_delete='No'","","zone_name asc");

        $areas = $this->Crud_model->GetData('mst_areas',"area,id","status='Active' and is_delete='No'","","area asc");
        
        $data=array(
          'button'    => 'Update',
          'heading'   => 'Update Assigned Station Activities',
          'breadcrumbs' => $breadcrumbs,
          'policeActivities'   => $policeActivities,
          'higherAuthority'    => $higherAuthority,
          'policeStations'    => $policeStations,
          'policeStationHead'    => $policeStationHead,
          'zones'    => $zones,
          'areas'    => $areas,
          'cancelbtn'   => site_url('Assigned_station_activities/index'), 
          'action'    => site_url('Assigned_station_activities/update_action'.'/'.$update_id),
          'id'      => set_value('id', $row->id),
          'activity_id'  => set_value('activity_id', $row->activity_id),
          'higher_authority_id'    => set_value('higher_authority_id', $row->higher_authority_id),
          'police_station_id'    => set_value('police_station_id', $row->police_station_id),
          'police_station_head_id'    => set_value('police_station_head_id', $row->police_station_head_id),
          'zone_id'    => set_value('zone_id', $row->zone_id),
          'area_id'    => set_value('area_id', $row->area_id),
          'address'   => set_value('address', $row->address),
          'description'   => set_value('description', $row->description),
          'from_date'   => set_value('from_date', $row->from_date),
          'to_date'   => set_value('to_date', $row->to_date),
        );
        $this->load->view('assigned_station_activities/form', $data);
      } 
      else 
      {
        print_r("expression");exit;
        $this->session->set_flashdata('message', 'Record Not Found');
        redirect('Assigned_station_activities/index');
      }
    } 
    else 
    {
      print_r("expression1");exit;
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Assigned_station_activities/index');
    }
  }



  //UPDATE ACTION
  public function update_action($update_id) 
  {
    $id = base64_decode($update_id);
      $data = array(
        'activity_id' => $this->input->post('activity_id',TRUE),
        'higher_authority_id' => $this->input->post('higher_authority_id',TRUE),
        'police_station_id' => $this->input->post('police_station_id',TRUE),
        'police_station_head_id' => $this->input->post('police_station_head_id',TRUE),
        'zone_id' => $this->input->post('zone_id',TRUE),
        'area_id' => $this->input->post('area_id',TRUE),
        'address' => trim($this->input->post('address',TRUE)),
        'description' => trim($this->input->post('description',TRUE)),
        'from_date' => trim($this->input->post('from_date',TRUE)),
        'to_date' => trim($this->input->post('to_date',TRUE)),
      ); 
      $id = $this->input->post('id', TRUE);
      $con  = "id = '".$id."'";
      $this->Crud_model->SaveData("police_station_activity_map",$data,$con);
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record has been updated successfully</span>');
      redirect('Assigned_station_activities/index');
   
  }

  // VIEW
  public function view($id)
  {
    $cond = "id='".base64_decode($id)."'";
    $row = $this->Assigned_station_activities_model->viewDetails($cond);
  //  echo "<pre>"; print_r($row); die();
  

    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Assigned_station_activities/index').'">Manage Corporates</a></li>
                    <li class="active">Corporate Details</li>
                  </ul>';

    $data = array(
        'row'=> $row,
        'breadcrumbs'=>$breadcrumbs, 
        
        );
   $this->load->view('assigned_station_activities/view',$data);
  }
    
  public function delete() 
  {
    $con = "id='".$_POST['id']."'";
    $this->Crud_model->SaveData('police_station_activity_map', array('is_delete'=>'Yes'), $con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Corporate deleted successfully</span>');
    redirect('Assigned_station_activities/index');
  } 

  public function changeStatus() 
  {
    $change_status = $this->Crud_model->GetData('police_station_activity_map','',"id='".$_POST['id']."'",'','','','row');
    if($change_status->status=='Active') 
    {
      $this->Crud_model->SaveData('police_station_activity_map',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } 
    else 
    {
      $this->Crud_model->SaveData('police_station_activity_map',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect("Assigned_station_activities/index");
  }

  public function getZone()
  {
    $zones = $this->Crud_model->GetData("mst_zones",'zone_name,id',"city_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"zone_name asc");

    if(!empty($zones)) 
    {
      $response = '<option value="">Select Zone</option>';
      foreach($zones as $row)
      {
        $response .= '<option value="'.$row->id.'">'.$row->zone_name.'</option>';
      }
    }
    else 
    {
        $response = '<option value="">Select Zone</option>';
    }
    echo $response;
  }


  public function getStationhead(){
    $stationhead = $this->Crud_model->GetData("mst_police",'police_name,id',"police_station_id='".$_POST['id']."' and designation_type='Station_Head' and is_delete='No' and status='Active'",'',"police_name asc");

    if(!empty($stationhead)) 
    {
      $response = '<option value="">Select Police Name</option>';
      foreach($stationhead as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->police_name.'</option>';
      }
    }
    else 
    {
      $response = '<option value="">Select Police Name</option>';
    }
    echo $response;
  }

  public function getArea()
  {
    $areas = $this->Crud_model->GetData("mst_areas",'area,id',"zone_id='".$_POST['id']."' and is_delete='No' and status='Active' and is_delete='No'",'',"area asc");
    
    if(!empty($areas)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areas as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->area.'</option>';
      }
    }
    else
    {
        $response = '<option value="">Select Area</option>';
    }
    echo $response;
  }

  
 
  public function getAreaPoliceStation()
  {
    $areapPoliceStation = $this->Crud_model->GetData("mst_police_stations",'name,id',"area_id='".$_POST['id']."' and is_delete='No' and status='Active'",'',"name asc");
    
    if(!empty($areapPoliceStation)) 
    {
      $response = '<option value="">Select Area</option>';
      foreach($areapPoliceStation as $row) 
      {
        $response .= '<option value="'.$row->id.'">'.$row->name.'</option>';
      }
    }
    else
    {
        $response = '<option value="">Select Police Station</option>';
    }
    echo $response;
  }
     
}