<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Areas extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model("Areas_model");
  }

  public function index() {
    $condUser ="status='Active' and is_delete='No'";
    $zones =  $this->Crud_model->GetData('mst_zones','',$condUser);
    //echo "<pre>"; print_r($areas); die();
    $breadcrumbs = "<ul class='breadcrumb'>
                      <li>
                        <i class='ace-icon fa fa-home home-icon'></i>
                        <a href='".site_url('Dashboard')."'>Dashboard</a>
                      </li>
                      <li class='active'>Manage Areas</li>
                    </ul>";

    $data = array(
      'breadcrumbs' =>$breadcrumbs,
      'actioncolumn' => '4' ,
      'ajax_manage_page' => site_url('Areas/ajax_manage_page') ,
      'heading' => 'Manage Areas',
      'zones' =>$zones,
    );
    $this->load->view('areas/areas_list', $data);       
  }

  public function ajax_manage_page() {
    $condition = "";
    $getData = $this->Areas_model->get_datatables($condition);
    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {
      $btn = '';
      $btn .= ('<a href="#myModaledit" title="Edit"  data-toggle="modal" class="btn btn-info btn-circle btn-sm" onclick="getEditValue('.$Data->id.');">
              <i class="ace-icon fa fa-pencil bigger-130"></i></a>');
      $btn .='&nbsp;|&nbsp;'.'<a href="#deleteData" data-toggle="modal" title="Delete" class="btn btn-danger btn-circle btn-sm" onclick="checkStatus('.$Data->id.')"><i class="ace-icon fa fa-trash-o bigger-130"></i></a>';
      $status = '';

      if($Data->status=='Active') {
        $status .=  "<a href='#checkStatus' data-toggle='modal' class='label-success label' onclick='checkStatus(".$Data->id.")'> Active </a>";            
      } else {
        $status .=  "<a href='#checkStatus' data-toggle='modal'  class='label-danger label' onclick='checkStatus(".$Data->id.")'> Inactive </a>";
      }

      $no++;   
      $row = array();
      $row[] = $no;
      $row[] = ucfirst($Data->zone_name);
      $row[] = ucfirst($Data->area);
      $row[] = $status;
      $row[] = $btn;
      $data[] = $row;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Areas_model->count_all($condition),
      "recordsFiltered" => $this->Areas_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

	public function changeStatus() {
    $change_status = $this->Crud_model->GetData('mst_areas','',"id='".$_POST['id']."'",'','','','row');

    if($change_status->status=='Active') {
        $this->Crud_model->SaveData('mst_areas',array('status'=>'Inactive'),"id='".$_POST['id']."'");
    } else {
        $this->Crud_model->SaveData('mst_areas',array('status'=>'Active'),"id='".$_POST['id']."'");
    }
    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Status has been changed successfully</span>');
    redirect('Areas/index');
  }
  
  public function addData() {
    $condDuplication = "zone_id='".$this->input->post('zone_id')."' and area='".$this->input->post('area')."'";
    $duplication = $this->Crud_model->GetData('mst_areas','', $condDuplication);

    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(
        'zone_id' => $this->input->post('zone_id'),
        'latitude' => $this->input->post('lat'),
        'longitude' => $this->input->post('lon'),
        'area' => $this->input->post('area'),
        'area_marathi' => $this->input->post('area_marathi'),
        'area_hindi' => $this->input->post('area_hindi'),
      );
      $this->Crud_model->SaveData('mst_areas',$data);
      $this->session->set_flashdata('message', 'success');
      echo 2;
    }      
  }

  public function updateData() {
    $condDuplication = "zone_id='".$this->input->post('zone_id')."' and area='".$this->input->post('area')."' and id !='".$this->input->post('id')."'";
    $duplication = $this->Crud_model->GetData('mst_areas','', $condDuplication);
    if(count($duplication) > 0 ) {
      echo 1;
    } else {
      $data = array(                              
        'area' => $this->input->post('area'),
        'area_marathi' => $this->input->post('area_marathi'),
        'area_hindi' => $this->input->post('area_hindi'),
        'zone_id' => $this->input->post('zone_id'),
        'latitude' => $this->input->post('lat'),
        'longitude' => $this->input->post('lon'), 
      );
      $this->Crud_model->SaveData('mst_areas', $data, "id='".$this->input->post('id')."'");
      $this->session->set_flashdata('message', 'success');
      echo 2;
    } 
  }

  public function delete() {
    $con = "id='".$_POST['id']."'";
    $data = array('is_delete' =>'Yes',);
    $this->Crud_model->SaveData('mst_areas',$data,$con);

    $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px;">Record deleted successfully</span>');
    redirect('Areas/index');

  }

  public function getUpdateName() {
    $row = $this->Crud_model->GetData('mst_areas','',"id='".$_POST['id']."'",'','','','row');

    //echo "<pre>"; print_r($row); die();  
    $zones = $this->Crud_model->GetData('mst_zones','','status="Active" and is_delete="No"');   
    $data = array(
		'area' => $row->area,'area_marathi' => $row->area_marathi,'area_hindi' => $row->area_hindi,'id'=> $row->id,'zone_id'=> $row->zone_id,'zones' => $zones
			);
    //echo json_encode($data);
    $this->load->view('areas/geteditArea',$data);
  }

  public function getAddress() 
  {
      //print_r('hiee');exit;
      $latitude=$_POST['lat'];
      $longitude=$_POST['lon'];
      if(!empty($latitude) && !empty($longitude))
      { 
           $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize'); 

          $output = json_decode($geocodeFromLatLong);
          $status = $output->status;
          //Get address from json data
          $address = ($status=="OK")?$output->results[1]->formatted_address:'';
          
          if(!empty($address))
          {
              $dataKey['address']=$address;
          }    
          else
          {
              $dataKey['address']='';
          }    
         
      }
      else
      {
           $dataKey['address']='';
      }  
      echo json_encode($dataKey);exit;
  }

  public function import()
{
   $file = $_FILES['excel_file']['tmp_name'];
   $this->load->library('excel');
   //read file from path
   $objPHPExcel = PHPExcel_IOFactory::load($file);
   $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

   $arrayCount = count($allDataInSheet);
   $i = 3;

   foreach ($allDataInSheet as $val) 
   {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
   }
   $removed = array_shift($fields_fun);

   if(!isset($fields_fun))
   {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Areas/index'));            
   } 
   $data = $fields_fun;
  //echo "<pre>"; print_r($data); die();
   $exists = 0;
   foreach ($data as $val) 
   {  
      if($val[0] !='' && $val[1] !='')
      { 
         $getArea = $this->Crud_model->GetData('mst_areas','area',"area='".$val[1]."'",'','','','single'); 
       
         $zones = $this->Crud_model->GetData('mst_zones','id',"zone_name='".$val[0]."'",'','','','single');   

         /*for already exist check*/

         if(empty($getArea))
         {

            if(!empty($val[1]))
            {
               $area=$val[1];
            } 
            else
            {
               $area="";
            }

            if(!empty($zones))
            {
               $zone_id=$zones->id;
            } 
            else
            {
               $zone_id="";
            }

            // $slug=preg_replace('/[^a-zA-Z0-9_ -]/s', '', $product_name);
            // $slug= str_replace(" ",'-',$slug);  
            //  $title = str_replace("'",'&#39;',$product_name);
            //  $product_code = str_replace("'",'&#39;',$product_code);
            $data = array(
               'zone_id' => $zone_id,
               'area' => $area,
            );

            $SaveAssets = $this->Crud_model->SaveData('mst_areas',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],'Area already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],'Mandatory fields empty');
      }
   }
   if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Areas/index');
   }
   else{
      $data = array('existAssets' => $existAssets);
      $this->load->view('areas/duplicateAreas',$data);
   } 
}

}