<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Crud_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
     public function GetData($table,$field='',$condition='',$group='',$order='',$limit='',$result='')
    {
        if($field != '')
        $this->db->select($field);
        if($condition != '')
        $this->db->where($condition);
        if($order != '')
        $this->db->order_by($order);
        if($limit != '')
        $this->db->limit($limit);
        if($group != '')
        $this->db->group_by($group);
        if($result != '')
        {
            $return =  $this->db->get($table)->row();
        }else{
            $return =  $this->db->get($table)->result();
        }
        return $return;
    }
    public function get_single_record($table,$cond)
    {
        $this->db->select($table);
        if($cond !='')
        {
            $this->db->where($cond);
        }
         $return =  $this->db->get($table)->row();
    }
    public function GetDataArr($table,$field='',$condition='',$group='',$order='',$limit='',$result='')
    {
        if($field != '')
        $this->db->select($field);
        if($condition != '')
        $this->db->where($condition);
        if($order != '')
        $this->db->order_by($order);
        if($limit != '')
        $this->db->limit($limit);
        if($group != '')
        $this->db->group_by($group);
        if($result != '')
        {
            $return =  $this->db->get($table)->row_array();
        }else{
            $return =  $this->db->get($table)->result_array();
        }
        return $return;
    }

    public function SaveData($table,$data,$condition='')
    {
        $DataArray = array();
        if(!empty($data))
        {
            $data['created']=date("Y-m-d H:i:s");
            $data['modified']=date("Y-m-d H:i:s");
        }
        $table_fields = $this->db->list_fields($table);
        foreach($data as $field=>$value)
        {
            if(in_array($field,$table_fields))
            {
                $DataArray[$field]= $value;
            }
        }
       
        if($condition != '')
        {
            $this->db->where($condition);
            return $this->db->update($table, $DataArray);
        }else{
            return $this->db->insert($table, $DataArray);
        }
    }

    public function DeleteData($table,$condition='',$limit='')
    {
       if($condition != '')
        $this->db->where($condition);
        if($limit != '')
        $this->db->limit($limit);
        return $this->db->delete($table);
    }

    public function ComplaintViewDetails($cond)
    {
      $this->db->select("comp.*, c.country_name, s.state_name,mc.city_name, d.district_name,mz.zone_name,ma.area,mb.branch_name,co.name,approved.name approved_by_name,md.department_name");
      $this->db->from("complaints comp");
      $this->db->join("mst_countries c", 'comp.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'comp.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'comp.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = comp.zone_id', 'left');
      $this->db->join("mst_areas ma", 'ma.id = comp.area_id', 'left');
      $this->db->join("corporates co", 'co.id = comp.corporate_id', 'left');
      $this->db->join("corporates approved", 'approved.id = comp.approved_by', 'left');
      $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
      $this->db->join("mst_departments md", 'md.id = mb.department_id', 'left');
      $this->db->where($cond);
       $this->db->group_by('comp.id');
       $this->db->order_by('comp.id desc');
      return $this->db->get()->result();
    }

      public function ShowComplainDetails($cond)
    {
      $this->db->select("comp.*, c.country_name, s.state_name,mc.city_name, d.district_name,mz.zone_name,ma.area,mb.branch_name,co.name,ci.image,ci.video,md.department_name,approved.name approved_by_name,resolved.name resolved_by_name");
      $this->db->from("complaints comp");
      $this->db->join("mst_countries c", 'comp.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'comp.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'comp.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = comp.zone_id', 'left');
      $this->db->join("mst_areas ma", 'ma.id = comp.area_id', 'left');
      $this->db->join("corporates co", 'co.id = comp.corporate_id', 'left');
      $this->db->join("complaint_images ci", 'ci.complaint_id = comp.id', 'left');
      $this->db->join("corporates approved", 'approved.id = comp.approved_by', 'left');
      $this->db->join("corporates resolved", 'resolved.id = comp.resolved_by', 'left');
      $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
      $this->db->join("mst_departments md", 'md.id = mb.department_id', 'left');
      $this->db->where($cond);
       $this->db->group_by('comp.id');
       $this->db->order_by('comp.id desc');
      return $this->db->get()->row();
    }
 
   /* public function ComplaintViewDetails($cond)
    {
      $this->db->select("comp.*, c.country_name, s.state_name,mc.city_name, d.district_name,mz.zone_name,ma.area,mb.branch_name,co.name,approved.name approved_by_name");
      $this->db->from("complaints comp");
      $this->db->join("mst_countries c", 'comp.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'comp.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'comp.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = comp.zone_id', 'left');
      $this->db->join("mst_areas ma", 'ma.id = comp.area_id', 'left');
      $this->db->join("corporates co", 'co.id = comp.corporate_id', 'left');
      $this->db->join("corporates approved", 'co.id = comp.approved_by', 'left');
      //$this->db->join("mst_departments md", 'md.id = comp.dept_id', 'left');
      $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
      $this->db->where($cond);
       $this->db->group_by('comp.id');
      return $this->db->get()->result();
    }*/

     public function AllCorporateComplaints()
    {
      $this->db->select("comp.branch_id,md.department_name, mb.branch_name, count(comp.id) total_complaint");
      $this->db->from("complaints comp");
      $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
      $this->db->join("mst_departments md", 'md.id = mb.department_id', 'left');
      $this->db->group_by('comp.branch_id');
      return $this->db->get()->result();
    }

     public function CorporateComplaintsDetails($cond)
    {
        $this->db->select("comp.*, c.country_name, s.state_name,mc.city_name, d.district_name,mz.zone_name,ma.area,mb.branch_name,co.name,md.department_name");
          $this->db->from("complaints comp");
          $this->db->join("mst_countries c", 'comp.country_id = c.id', 'left');
          $this->db->join("mst_states s", 'comp.state_id = s.id', 'left');
          $this->db->join("mst_cities mc", 'comp.city_id = mc.id', 'left');
          $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
          $this->db->join("mst_zones mz", 'mz.id = comp.zone_id', 'left');
          $this->db->join("mst_areas ma", 'ma.id = comp.area_id', 'left');
          $this->db->join("corporates co", 'co.id = comp.corporate_id', 'left');
          $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
          $this->db->join("mst_departments md", 'md.id = mb.department_id', 'left');
           $this->db->where($cond);
           $this->db->order_by('comp.id asc');
        return $this->db->get()->result();
    }
    

   /*  public function CorporateComplaintsView($cond)
    {
        $this->db->select("comp.*, c.country_name, s.state_name,mc.city_name, d.district_name,mz.zone_name,ma.area,mb.branch_name,co.name");
        $this->db->from("complaints comp");
        $this->db->join("mst_countries c", 'comp.country_id = c.id', 'left');
        $this->db->join("mst_states s", 'comp.state_id = s.id', 'left');
         $this->db->join("mst_cities mc", 'comp.city_id = mc.id', 'left');
          $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
          $this->db->join("mst_zones mz", 'mz.id = comp.zone_id', 'left');
          $this->db->join("mst_areas ma", 'ma.id = comp.area_id', 'left');
          $this->db->join("corporates co", 'co.id = comp.corporate_id', 'left');
          //$this->db->join("mst_departments md", 'md.id = comp.dept_id', 'inner');
          $this->db->join("mst_department_branches mb", 'mb.id = comp.branch_id', 'left');
        $this->db->where($cond);
        return $this->db->get()->result();
    }
*/
      public function CorporateDetails($cond)
    {
        $this->db->select("co.id,co.name,co.image,role,mb.branch_name,co.email");
        $this->db->from("corporates co");
          $this->db->join("mst_department_branches mb", 'mb.id = co.branch_id', 'left');
          //$this->db->join("mst_departments md", 'md.id = comp.dept_id', 'inner');
        $this->db->where($cond);
          $this->db->order_by('co.id desc');
        return $this->db->get()->result();
    }
    

     public function ShowChairPersonAppointmentData($cond)
    {
        $this->db->select("ap.*,c.name");
        $this->db->from("appointments ap");
         $this->db->join("citizens c", 'ap.citizen_id = c.id', 'left');
        $this->db->where($cond);
         $this->db->order_by('ap.id desc');
        return $this->db->get()->result();
    }

    public function ShowCitizenAppointmentData($cond)
    {
        $this->db->select("ap.*,c.name");
        $this->db->from("appointments ap");
         $this->db->join("corporates c", 'ap.corporate_id = c.id', 'left');
        $this->db->where($cond);
         $this->db->order_by('ap.id desc');
        return $this->db->get()->result();
    }


    public function nearByShop($lat,$lng,$id)
    {
       $this->db->select("*, ( 3959 * acos( cos( radians($lat) ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians($lng) ) + sin( radians($lat) ) * sin( radians( latitude ) ) ) ) AS distance");                         
        //$this->db->having('distance <= ' . $miles);                     
        $this->db->order_by('distance');                    
        $this->db->limit(20, 0);
        $this->db->where("category_id='".$id."'");
        return $this->db->get("shops")->result_array();
    }

  
    public function GetOrderDetails($condition)
    {
        $this->db->select('c.cat_name category,sc.cat_name subcategory,ord.quantity,ord.price,p.product_name,p.status,p.id as product_id,p.image');
        $this->db->from('order_details ord');
        $this->db->join('orders o','o.id=ord.order_id','left');
        $this->db->join('products p','ord.product_id=p.id','left');
        $this->db->join('categories c','c.id=p.category_id','left');
        $this->db->join('categories sc','sc.id=p.sub_category_id','left');
        $this->db->join('shops s','s.id=p.shop_id','left');
        $this->db->where($condition);
        $this->db->order_by('ord.id desc');
        $query = $this->db->get();
        return $query->result();
    }

   function getConstitution()
   {
    $this->db->select("c.id,c.title,concat('1-',count(ca.id)) count");
    $this->db->from("constitution_articles c");
    $this->db->join("constitution_article_details ca", 'c.id = ca.article_id', 'left');
    $this->db->where("c.is_delete='No' and ca.is_delete='No'"); 
    $this->db->group_by('c.id');
    $query = $this->db->get();
    return $query->result();
  }

  public function branchWiseEmployees($cond)
    {
        $this->db->select("co.id,role,co.name,co.email,co.mobile,co.image");
        $this->db->from("corporates co");
         $this->db->join("mst_department_branches mb", 'mb.id = co.branch_id', 'left');
       //   $this->db->join("corporates co", 'co.id = co.branch_id', 'inner');
        $this->db->where($cond);
        return $this->db->get()->result();
    }

     /*public function getCorporateResponsibilities($cond)
    {
        $this->db->select("crm.responsibility");
        $this->db->from("roles_and_responsibilities rr");
         $this->db->join("corporate_responsibilities_mapping crm", 'rr.id = crm.roles_respo_id', 'left');
        $this->db->where($cond);
        return $this->db->get()->result();
    }*/
    
    public function getCorporateResponsibilities($cond)
    {
        $this->db->select("crm.id, crm.role_id, crm.responsibility,crm.responsibility_marathi, crm.responsibility_hindi, mr.title, mr.title_marathi, mr.title_hindi, rr.image");
        $this->db->from("corporate_responsibilities_mapping crm");
        $this->db->join("roles_and_responsibilities rr", 'crm.role_id=rr.role_id', 'INNER');
        $this->db->join("mst_roles mr", 'crm.role_id = mr.id', 'INNER');
        $this->db->where($cond);
        return $this->db->get()->result();
    }

    public function getRoleAndImage()
    {
        $this->db->select("rr.id, rr.role_id, rr.image, mr.title, mr.title_marathi, mr.title_hindi");
        $this->db->from("roles_and_responsibilities rr");
        $this->db->join("mst_roles mr", 'rr.role_id=mr.id', 'INNER');
        $this->db->where("rr.is_delete='No'");
        $this->db->group_by('rr.role_id');
        return $this->db->get()->result();
    }


public function getStationAssignActivity($con){
        $this->db->select("pa.name as activity_name,psam.activity_id");
        $this->db->from("police_station_activity_map psam");
        $this->db->join("police_activities pa", 'pa.id=psam.activity_id', 'INNER');
        $this->db->where($con);
        return $this->db->get()->result();
}
public function getStationAssignActivityDetails($cond)
    {    
        $this->db->select('psam.address,psam.description,psam.from_date,psam.to_date,a.area,z.id as zoneId,z.zone_name,mps.name as station_name,mps.address as station_address,p.police_name as station_head_name');
        $this->db->from('police_station_activity_map psam');
        $this->db->join("mst_areas a", 'a.id=psam.area_id','left');
        $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
        $this->db->join("mst_police p",'p.police_station_id=psam.police_station_id','left');
        $this->db->join("mst_police_stations mps", 'mps.id=psam.police_station_id','left');
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');     
        $this->db->where($cond);
        return $this->db->get()->row();
    }
 

  public function getPoliceEyes()
    {
       
            $this->db->select("mc.*,mps.name as police_station_name,z.zone_name,a.area");
            $this->db->from("mst_cameras mc");
            $this->db->join("mst_police_stations mps",'mps.id=mc.police_station_id','left');
            $this->db->join("mst_zones z",'z.id=mc.zone_id','left');
            $this->db->join("mst_areas a",'a.id=mc.area_id','left');
            $this->db->where("mc.is_delete='No' and mc.status='Active'");
             return $this->db->get()->result();
    } 

    public function AssignPoliceStationActivities()
    {
       
           $this->db->select("psam.*,z.zone_name,a.area,mps.name,p.police_name as higher_authority_name,pam.police_name as police_station_head_name,pa.name as activity_name");
           $this->db->from("police_station_activity_map psam");
           /*  $this->db->join("mst_police mp", 'mp.id = psam.higher_authority_id', 'left');*/
             $this->db->join("mst_police_stations mps", 'mps.id = psam.police_station_id', 'left');
             $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
             $this->db->join("mst_police p", 'p.id = psam.higher_authority_id', 'left');
             $this->db->join("mst_police pam", 'pam.id = psam.police_station_head_id', 'left');
           $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
            $this->db->join("mst_areas a",'a.id=psam.area_id','left');
           $this->db->where("psam.is_delete='No' and psam.status='Active'");
          $this->db->order_by('psam.id desc');
           $this->db->group_by("psam.id");
          return $this->db->get()->result();
    }

    public function GetListOfPoliceTask($con)
    {
          $this->db->select("ptc.id as police_task_completion_id,pa.name as activity_name,psam.from_date,psam.to_date");
          $this->db->from("police_task_completion ptc");
          $this->db->join("police_station_activity_map psam", 'psam.id = ptc.police_station_activity_map_id', 'left');
          $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
          $this->db->join("mst_police p", 'p.id = psam.higher_authority_id', 'left');
          $this->db->join("mst_police pam", 'pam.id = psam.police_station_head_id', 'left');
          $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
          $this->db->join("mst_areas a",'a.id=psam.area_id','left');
          $this->db->where($con);
          return $this->db->get()->result();
    }

    public function GetListOfPoliceStationActivity($con)
    {
          $this->db->select("psam.id,psam.activity_id,pa.name as activity_name,psam.police_station_id");
          $this->db->from("police_station_activity_map psam");          
          $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
          $this->db->where("psam.id NOT IN (SELECT police_station_activity_map_id FROM police_task_completion)");  
          $this->db->join("mst_police p", 'p.id = psam.higher_authority_id', 'left');
          $this->db->join("mst_police pam", 'pam.id = psam.police_station_head_id', 'left');
          $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
          $this->db->join("mst_areas a",'a.id=psam.area_id','left');
          $this->db->where($con);
          return $this->db->get()->result();



    }
     public function GetPoliceTaskDetails($con)
    {
          $this->db->select("ptc.id as police_task_completion_id,pa.name as activity_name,psam.from_date,psam.to_date,psam.address,psam.description");
          $this->db->from("police_task_completion ptc");
          $this->db->join("police_station_activity_map psam", 'psam.id = ptc.police_station_activity_map_id', 'left');
          $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
          $this->db->join("mst_police p", 'p.id = psam.higher_authority_id', 'left');
          $this->db->join("mst_police pam", 'pam.id = psam.police_station_head_id', 'left');
          $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
          $this->db->join("mst_areas a",'a.id=psam.area_id','left');
          $this->db->where($con);
          return $this->db->get()->row();
    }
    public function getPoliceEyesDetails($cond)
    {
       
            $this->db->select("mc.*,mps.name,c.country_name, s.state_name,mci.city_name, d.district_name");
            $this->db->from("mst_cameras mc");
             $this->db->join("mst_police_stations mps", 'mps.id = mc.police_station_id', 'left');
            $this->db->join("mst_countries c", 'mc.country_id = c.id', 'left');
            $this->db->join("mst_states s", 'mc.state_id = s.id', 'left');
            $this->db->join("mst_cities mci", 'mc.city_id = mci.id', 'left');
            $this->db->join("mst_districts d", 'mc.district_id = d.id', 'left');
            $this->db->where("mc.is_delete='No' and mc.status='Active'");
             $this->db->where($cond);
             return $this->db->get()->row();
    }
// this api is use for Get Police Station Details
   public function GetPoliceStationDetails($con)
   {
           $this->db->select("mps.id,mps.name,mps.email,mps.mobile,mps.address,mps.image,mps.latitude,mps.longitude,c.country_name, s.state_name,mci.city_name, d.district_name,mp.police_name as station_head_name,");
            $this->db->from("mst_police_stations mps");
            ;
            $this->db->join("mst_countries c", 'mps.country_id = c.id', 'left');      
            $this->db->join("mst_police mp", 'mp.police_station_id = mps.id', 'left');
            $this->db->join("mst_states s", 'mps.state_id = s.id', 'left');
            $this->db->join("mst_cities mci", 'mps.city_id = mci.id', 'left');
            $this->db->join("mst_districts d", 'mps.district_id = d.id', 'left');
            $this->db->where("mps.is_delete='No' and mps.status='Active'");
            
            $this->db->where("mp.designation_type='Station_Head'");

             $this->db->where($con);
             return $this->db->get()->row();
   }
   public function getCriminalsList($cond)
    {
        $this->db->select("crm.*, c.country_name, s.state_name, d.district_name, mc.city_name, mps.name as police_station_name");
        $this->db->from("criminals crm");
        $this->db->join("mst_countries c", 'crm.country_id = c.id', 'left');
        $this->db->join("mst_states s", 'crm.state_id = s.id', 'left');
        $this->db->join("mst_districts d", 'crm.district_id = d.id', 'left');
        $this->db->join("mst_cities mc", 'crm.city_id = mc.id', 'left');
        $this->db->join("mst_police_stations mps", 'crm.police_station_id = mps.id', 'left');
        $this->db->where("crm.is_delete='No' AND crm.police_station_id='".$cond."'");
        return $this->db->get()->result();
    }

    public function getPoliceStationActivityDetails($cond)
    {   
      $this->db->select("psam.id,psam.activity_id,psam.police_station_id,psam.address,psam.description,psam.from_date,psam.to_date,mps.name,p.police_name as higher_authority_name,pam.police_name as police_station_head_name,pa.name as activity_name,ptc.activity_status,psam.police_station_head_id as police_station_head_id");
           $this->db->from("police_station_activity_map psam");
            
             $this->db->join("mst_police_stations mps", 'mps.id = psam.police_station_id', 'left');
             $this->db->join("police_task_completion ptc", 'ptc.police_station_activity_map_id = psam.id', 'left');
             $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
             $this->db->join("mst_police p", 'p.id = psam.higher_authority_id', 'left');
             $this->db->join("mst_police pam", 'pam.id = psam.police_station_head_id', 'left');
         
           $this->db->where("psam.is_delete='No' and psam.status='Active'");
           $this->db->where($cond);
           $this->db->group_by("psam.id");
          return $this->db->get()->row();
    }

// this api is use for Get Police Station Details
   public function GetPoliceStationDetailsForStationHead($con)
   {
           $this->db->select("mps.id as police_station_id,mps.name,mps.email,mps.mobile,mps.address,mps.image,mps.latitude,mps.longitude,c.country_name, s.state_name,mci.city_name, d.district_name,p.police_name as station_head_name");
            $this->db->from("mst_police p");                      
            $this->db->join("mst_police_stations mps", 'mps.id = p.police_station_id', 'left');      
            $this->db->join("mst_countries c", 'mps.country_id = c.id', 'left');      
            //$this->db->join("mst_police mp", 'mp.id = mps.station_head_id', 'left');
            $this->db->join("mst_states s", 'mps.state_id = s.id', 'left');
            $this->db->join("mst_cities mci", 'mps.city_id = mci.id', 'left');
            $this->db->join("mst_districts d", 'mps.district_id = d.id', 'left');
            $this->db->where("mps.is_delete='No' and mps.status='Active'");
             $this->db->where($con);
             return $this->db->get()->row();
   }
   public function getAllBpatrakData()
      {
         
             $this->db->select("bp.*,p.police_name,pam.police_name as police_station_head_name");
             $this->db->from("bpatrak bp");
               $this->db->join("mst_police p", 'p.id = bp.police_id', 'left');
               $this->db->join("mst_police pam", 'pam.id = bp.police_station_head_id', 'left');
            return $this->db->get()->result();
      }

       public function GetCriminalsRecordDetails($con)
   {
           $this->db->select("c.*,mps.name as police_station_name");
            $this->db->from("criminals c");                      
            $this->db->join("mst_police_stations mps", 'mps.id = c.police_station_id', 'left');  
            
             $this->db->where($con);
             return $this->db->get()->row();
   }

   public function getqrcode($con)
   {
            $this->db->select("count(sc.id) count");
            $this->db->from("sensitive_areas sc");                      
            $this->db->where("sc.id IN (SELECT sensitive_areas_id FROM police_task_completion where activity_status='Completed' and date(created)='".date('Y-m-d')."')");            
             $this->db->where($con);
             return $this->db->get()->row();

   }

     public function getListOfPoliceTasks($con)
   {
           $this->db->select("sc.*,mps.name as police_station_name");
            $this->db->from("sensitive_areas sc");                      
            $this->db->join("mst_police_stations mps", 'mps.id = sc.police_station_id', 'left');  
            
             $this->db->where($con);
             return $this->db->get()->result();
   }
    public function getListOfPoliceTasksComp($con)
   {
            $this->db->select("sc.id");
            $this->db->from("sensitive_areas sc");                      
            $this->db->where("sc.id IN (SELECT sensitive_areas_id FROM police_task_completion where activity_status='Completed' and date(created)='".date('Y-m-d')."')");            
             $this->db->where($con);
             return $this->db->get()->result();
   }

public function getActivities($con)
   {
            $this->db->select("count(psam.id) count");
            $this->db->from("police_station_activity_map psam");                      
            $this->db->where("psam.id IN (SELECT police_station_activity_map_id FROM police_task_completion where activity_status='Completed' )");/*and date(created)='".date('Y-m-d')."'*/            
             $this->db->where($con);
             return $this->db->get()->row();

   }

   public function GetListOfPoliceStationActivityforStation($con)
    {
          $this->db->select("pa.name as activity_name,psam.from_date,psam.to_date,psam.police_station_id,mps.name as police_station_name,psam.id");
          $this->db->from("police_station_activity_map psam");
          $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
          $this->db->join("mst_police_stations mps", 'mps.id = psam.police_station_id', 'left'); 
          $this->db->where($con);
           $this->db->where("psam.is_delete='No' and psam.status='Active'");  
           $this->db->order_by('psam.id desc');
          return $this->db->get()->result();
    }
    public function GetListOfPoliceStationActivityforStationComp($con)
    {
          $this->db->select("psam.id");
          $this->db->from("police_station_activity_map psam");         
           $this->db->where("psam.id IN (SELECT police_station_activity_map_id FROM police_task_completion where activity_status='Completed')"); 
          $this->db->where($con);
           $this->db->where("psam.is_delete='No' and psam.status='Active'");  
           $this->db->order_by('psam.id desc');
          return $this->db->get()->result();
    }
  public function GetOverallPoliceEyes($con)
   {
           $this->db->select("mc.*,mps.name as police_station_name");
            $this->db->from("mst_cameras mc");                      
            $this->db->join("mst_police_stations mps", "mps.id = mc.police_station_id", 'left');
            $this->db->where("mc.is_delete='No' and mc.status='Active'");             
             $this->db->where($con);
             return $this->db->get()->result();
   }

     public function GetOverallPoliceQR($con)
   {
           $this->db->select("sa.*,mps.name as police_station_name");
            $this->db->from("sensitive_areas sa");                      
            $this->db->join("mst_police_stations mps", 'mps.id = sa.police_station_id', 'left');
            
            $this->db->where("sa.is_delete='No' and sa.status='Active'");            
             $this->db->where($con);
             return $this->db->get()->result();
   }
   /*public function GetOverallPoliceQRComp($con)
   {
           $this->db->select("sa.*,mps.name as police_station_name");
            $this->db->from("sensitive_areas sa");                      
            $this->db->join("mst_police_stations mps", 'mps.id = sa.police_station_id', 'left');
            $this->db->where("sa.id IN (SELECT sensitive_areas_id FROM police_task_completion where activity_status='Completed' GROUP BY sensitive_areas_id)");
            $this->db->where("sa.is_delete='No' and sa.status='Active'");            
             $this->db->where($con);
             return $this->db->get()->result();
   }*/

   public function GetOverallPoliceQRComp($con)
   {
           $this->db->select("ptc.*");
            $this->db->from("police_task_completion ptc");  
            
            $this->db->where("ptc.activity_status='Completed'");          
            $this->db->where("date(ptc.created)='".date('Y-m-d')."'");          
             $this->db->where($con);
             $this->db->group_by('ptc.sensitive_areas_id');

             return $this->db->get()->result();
   }
    public function getOverallBpatrak($con)
   {
           $this->db->select("bp.*,mps.name as police_station_name");
            $this->db->from("bpatrak bp");                      
            $this->db->join("mst_police_stations mps", 'mps.id = bp.police_station_id', 'left');
            //$this->db->where("bp.is_delete='No' and bp.status='Active'");            
             $this->db->where($con);
             return $this->db->get()->result();
   }

     public function GetOverallPoliceStaionActivityforHead($con)
   {
           $this->db->select("psam.*,mps.name as police_station_name,pa.name as activity_name");
            $this->db->from("police_station_activity_map psam");                      
            $this->db->join("mst_police_stations mps", 'mps.id = psam.police_station_id', 'left');            
            $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
            $this->db->where("psam.is_delete='No' and psam.status='Active'");            
             $this->db->where($con);
             $this->db->order_by('psam.id desc');
             return $this->db->get()->result();
   }
    public function GetOverallPoliceStaionActivityforHeadComp($con)
   {
           $this->db->select("psam.*,mps.name as police_station_name,pa.name as activity_name");
            $this->db->from("police_station_activity_map psam");                      
            $this->db->join("mst_police_stations mps", 'mps.id = psam.police_station_id', 'left');            
            $this->db->join("police_activities pa", 'pa.id = psam.activity_id', 'left');
             $this->db->where("psam.id IN (SELECT police_station_activity_map_id FROM police_task_completion where activity_status='Completed')"); 
            $this->db->where("psam.is_delete='No' and psam.status='Active'");            
             $this->db->where($con);
             $this->db->order_by('psam.id desc');
             return $this->db->get()->result();
   }
    public function GetOverallPoliceStationCriminals($con)
   {
           $this->db->select("c.*,mps.name as police_station_name");
            $this->db->from("criminals c");                      
            $this->db->join("mst_police_stations mps", 'mps.id = c.police_station_id', 'left');
            $this->db->where("c.is_delete='No' and c.status='Active'");            
             $this->db->where($con);
             return $this->db->get()->result();
   }

   public function GetQrcodeDetailsonQrno($con)
   {
            $this->db->select("sa.*,mps.name as police_station_name");
            $this->db->from("sensitive_areas sa");                      
            $this->db->join("mst_police_stations mps", 'mps.id = sa.police_station_id', 'left');
            $this->db->where("sa.is_delete='No' and sa.status='Active'");            
            $this->db->where($con);
             return $this->db->get()->row();
   }

    public function getQrcodeDetails()
   {
            $this->db->select("sa.*,mps.name as police_station_name");
            $this->db->from("sensitive_areas sa");                      
            $this->db->join("mst_police_stations mps", 'mps.id = sa.police_station_id', 'left');
            $this->db->where("sa.is_delete='No' and sa.status='Active'");            
             return $this->db->get()->row();
   }
}