<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH . '/libraries/REST_Controller.php';

class Police_masters extends REST_Controller 
{

  public function __construct()
  {
    parent::__construct();
    $this->load->library('Sms');
    $this->Sms=new Sms;
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);
    $this->load->library('Ciqrcode');
  }

  /*----------Master API start-------------------------*/
  // This API is used to get police designations
  public function getPoliceDesignations_post() 
  {
      $table = "mst_police_designations";
      $data = $this->Crud_model->GetData($table,'',"is_delete='No' AND status='Active'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

   // This API is used to get crimes
  public function getCrimes_post() 
  {
      $table = "mst_crimes";
      $data = $this->Crud_model->GetData($table,'',"status='Active'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get police departments
  public function getPoliceDepartments_post() 
  {
      $table = "mst_police_departments";
      $data = $this->Crud_model->GetData($table,'',"is_delete='No' AND status='Active'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get police activities
  public function getPoliceActivities_post() 
  {
      $table = "police_activities";
      $data = $this->Crud_model->GetData($table,'',"is_delete='No' AND status='Active'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get countries
  public function getCountry_post()
  {
      $table = "mst_countries";
      $data = $this->Crud_model->GetData($table,'',"status='Active' and is_delete='No' and id='101'");

      if(!empty($data))
      {   
        $result= array('success' =>1, "message" =>"Data found","data" => $data);      
      }
      else
      {
        $result= array('success' =>0, "message" =>"Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get states
  public function getStates_post()
  {
      $country_id = $this->_request['country_id'];
      
      if(!empty($country_id))
      {
        $data = $this->Crud_model->GetData('mst_states','',"status='Active' and country_id='".$country_id."' AND is_delete='No' AND country_id=101",'','state_name asc');

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data found", "data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get districts
  public function getDistricts_post()
  {   
      $table = "mst_districts";
      $state_id=$this->_request['state_id'];

      if(!empty($state_id))
      {
        $data = $this->Crud_model->GetData($table,'',"status='Active' AND is_delete='No' AND state_id='".$state_id."'",'','district_name');

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get police cities
  public function getCities_post()
  {
      $table = "mst_cities";
      $district_id = $this->_request['district_id'];

      if(!empty($district_id))
      {
        $data = $this->Crud_model->GetData($table,'',"status='Active' AND district_id='".$district_id."' AND is_delete='No'",'','city_name');
      
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get zones
  public function getZones_post()
  {
      $table = "mst_zones";
      $city_id=$this->_request['city_id'];

      if(!empty($city_id))
      {
        $data = $this->Crud_model->GetData('mst_zones','',"status='Active' AND is_delete='No' AND city_id='".$city_id."'");

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get areas
  public function getAreas_post()
  { 
      $table = "mst_areas";
      $zone_id=$this->_request['zone_id'];

      if(!empty($zone_id))
      {
        $data = $this->Crud_model->GetData('mst_areas','',"status='Active' AND is_delete='No' AND zone_id='".$zone_id."'");

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

/*---------------------Master API End-------------------------*/

/*----------------------------Common API Start-------------------------------*/
// This API is used to get all police stations present at city
  public function getPoliceStationPresentAtCity_post() 
  {
      $table = "mst_police_stations";
      $city_id=$this->_request['city_id'];
       if(!empty($city_id))
      {
      $data = $this->Crud_model->GetData($table,'',"is_delete='No' AND status='Active' AND city_id='".$city_id."'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }
     
  // This API is used to get police Higher Authority at city
  public function getPoliceHigherAuthorityAtCity_post() 
  {
      $table = "mst_police";
      $city_id=$this->_request['city_id'];
      if(!empty($city_id))
      {
      $data = $this->Crud_model->GetData($table,'id,police_name',"is_delete='No' and status='Active' and designation_type='Head_Person' and city_id='".$city_id."'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    } else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get Police Station Head
  public function getPolicesStationHead_post() 
  {
      $table = "mst_police";
      $police_station_id=$this->_request['police_station_id'];
       if(!empty($police_station_id))
      {
      $data = $this->Crud_model->GetData($table,'id,police_name',"is_delete='No' and status='Active' and designation_type='Station_Head' and police_station_id='".   $police_station_id."'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get Police Stations details
  public function getPoliceStationDetails_post() 
  {
      $table = "mst_police_stations";
      $police_station_id=$this->_request['police_station_id'];
       if(!empty($police_station_id))
      {
        
        $con="mps.id='".$police_station_id."'";
       $data = $this->Crud_model->GetPoliceStationDetails($con);

      if(!empty($data))
      {
        $image_path = IMAGEPATH."police_station_image/";
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data,"image_path"=>$image_path);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
       }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

   // This API is used to get Police Stations details
  public function getPoliceStationDetailsForPolice_post() 
  {
     $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
        if($loginusertype=='Police'){
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $station_id = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
          if(!empty($station_id)){
           $con="mps.id='".$station_id->police_station_id."'";
           $data = $this->Crud_model->GetPoliceStationDetails($con);
          print_r($this->db->last_query());exit();

      if(!empty($data))
      {
        $image_path = IMAGEPATH."police_station_image/";
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data,"image_path"=>$image_path);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
       }else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
       }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


  /*----------------------------Common API End-------------------------------*/

/*----------------Police Station Assign Activity Start-------------------*/

   // This API is used to get Police station assign activity
  public function getPoliceStationAssignActivity_post() 
  {
      $table = "police_station_activity_map";
      $police_station_id=$this->_request['police_station_id'];
       if(!empty($police_station_id))
      {
        $con="psam.is_delete='No' and psam.status='Active' and police_station_id='".$police_station_id."'";
      $data = $this->Crud_model->getStationAssignActivity($con);

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


   // This API is used to get Police station assign activity details
  public function getPoliceStationAssignActivityDetails_post() 
  {
      $table = "police_station_activity_map";
      $activity_id=$this->_request['activity_id'];
      $police_station_id=$this->_request['police_station_id'];
       if(!empty($activity_id) && !empty($police_station_id))
      {
        $con="psam.is_delete='No' and psam.status='Active' and psam.activity_id='".$activity_id."' and psam.police_station_id='".$police_station_id."'";
      $data = $this->Crud_model->getStationAssignActivityDetails($con);

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

    public function getAssignPoliceStationActivities_post() 
  {
      $table = "police_station_activity_map";
      $data = $this->Crud_model->AssignPoliceStationActivities();
    //  print_r($data);exit();
      //print_r($this->db->last_query());exit();

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // this api use for assigning activity to particular police station by akash

  public function saveAssignStationActivities_post()
  {
    $activity_id = $this->_request['activity_id'];
    $higher_authority_id = $this->_request['higher_authority_id'];
    $country_id = $this->_request['country_id'];
    $state_id = $this->_request['state_id'];
    $district_id = $this->_request['district_id'];
    $city_id = $this->_request['city_id'];
    $police_station_id = $this->_request['police_station_id'];
    $police_station_head_id = $this->_request['police_station_head_id'];
    $address = $this->_request['address'];
    $description = $this->_request['description'];
    $from_date = $this->_request['from_date'];
    $to_date = $this->_request['to_date'];

    if(!empty($activity_id) && !empty($higher_authority_id) && !empty($country_id) && !empty($state_id) && !empty($district_id) && !empty($city_id) && !empty($police_station_id) && !empty($police_station_head_id) && !empty($address) && !empty($from_date) && !empty($to_date) && !empty($description))

      {
        $data = array(
              'activity_id'=>$activity_id,
              'higher_authority_id'=>$higher_authority_id,
              'country_id'=>$country_id,
              'state_id'=>$state_id,
              'district_id'=>$district_id,
              'city_id'=>$city_id,
              'police_station_id'=>$police_station_id,
              'police_station_head_id'=> $police_station_head_id,
              'address'=>$address,
              'description'=>$description,
              'from_date'=>$from_date,
              'to_date'=>$to_date,
              );

        $this->Crud_model->SaveData("police_station_activity_map",$data);
        $task_id=$this->db->insert_id();
        $result= array('success' =>1,"message"=>"Data saved successfully","data" =>$data);
        if(!empty($police_station_id)){

          $data = $this->Crud_model->GetData("mst_police",'id,police_name,player_id',"is_delete='No' and status='Active' and designation_type='Station_Head' and police_station_id='".$police_station_id."' and id='".$police_station_head_id."'",'','','','1');
          $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','id="'.$police_station_id.'" and is_delete="No" and status="Active"','','','','1');
           $activity_name = $this->Crud_model->GetData('police_activities','id,name','id="'.$activity_id.'" and is_delete="No" and status="Active"','','','','1');
         // print_r($mst_police_stations_data);exit();

        $to = $data->player_id;
        $heading = 'Selfie App';
        $message = 'New ' .$activity_name->name.' Task is Assigned to your Police Station '.$mst_police_stations_data->name.' from '.$from_date.' to '.$to_date.' on the location '.$address;
        
        $this->Sms->sendMessage($to, $heading, $message);

        $save_data_notification=array(
          'task_id'=>$task_id,
          'id_type'=>$higher_authority_id,
          'receiver_id'=>$police_station_head_id,
          'type'=>'Task',
          'user_type'=>'Head_Person',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
          $this->Crud_model->SaveData('police_notifications',$save_data_notification);

        }
      }
      else
      {
         $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }


/*----------------Police Station Assign Activity End-------------------*/

/*-------------Police Eyes Start--------------*/  
//this API is for overall list of police eyes for head person
public function getOverallPoliceEyes_post()
  {
      //$table="mst_police_stations";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="mc.city_id='".$checkCity->city_id."'";               
                $data = $this->Crud_model->GetOverallPoliceEyes($con);                   
                }
                elseif ($loginusertype=='Station_Head') {
                $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
                $station_id = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');   
                 $con2="mc.police_station_id='".$station_id->police_station_id."'";        
                  $data = $this->Crud_model->GetOverallPoliceEyes($con2); 
                   } 
                   elseif ($loginusertype=='Police') {
                $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
                $station_id = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');   
                 $con2="mc.police_station_id='".$station_id->police_station_id."'";        
                  $data = $this->Crud_model->GetOverallPoliceEyes($con2); 
                   }             

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

//This API is used to get police eyes count according to the police station 

  public function getPoliceEyesCount_post()
  {
      $table="mst_police_stations";
       $sdpo_id=$this->_request['sdpo_id'];
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="city_id='".$checkCity->city_id."' and sdpo_id='".$sdpo_id."' and is_delete='No' and status='Active'";
                $police_stations = $this->Crud_model->GetData($table,'id,name as police_station_name',$con);
                $data=[];

                foreach ($police_stations as $row) 
                {
                    $total_police_eyes = $this->Crud_model->GetData('mst_cameras','count(id) as total_police_eyes',"police_station_id='".$row->id."' and is_delete='No' and status='Active'",'','','','1');
                    $key['id'] = $row->id;
                    $key['police_station_name'] = $row->police_station_name;            
                    $key['total_police_eyes'] = $total_police_eyes->total_police_eyes;             
                    array_push($data, $key);
                }
              }
              else if($loginusertype=='Station_Head')
              {
                $con="id='".$police_id."'";
      $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
      $con="id='".$checkStation->police_station_id."'";
                $police_stations = $this->Crud_model->GetData($table,'id,name',$con,'','','','1');  
                
                $data=[]; 
        
                 if(empty($police_stations)){
                   $result= array('success' =>0, 'message' => "Required Police Stations is missing");      
                  $this->response($result, REST_Controller::HTTP_OK); 
                }
               $total_police_eyes = $this->Crud_model->GetData('mst_cameras','count(id) as total_police_eyes',"police_station_id='".$police_stations->id."' and is_delete='No' and status='Active'",'','','','1');

                    $key['id'] = $police_stations->id;
                    $key['police_station_name'] = $police_stations->name;            
                    $key['total_police_eyes'] = $total_police_eyes->total_police_eyes;                         
                      
               array_push($data, $key);     
               
              }

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

// This API is used to get Police Eyes count according to the police station SDPO
  public function getSDPOPoliceEyesCount_post()
  {
      $table="mst_sdpo";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."' and is_delete='No' and status='Active'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                 $con="city_id='".$checkCity->city_id."' and status='Active'";
                $sdpo_data = $this->Crud_model->GetData($table,'id,name as sdpo_name',$con);
                
                $data=[];

                foreach ($sdpo_data as $row) 
                {
                 $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','sdpo_id="'.$row->id.'"');
                    $key['sdpo_id'] = $row->id;
                    $key['sdpo_name'] = $row->sdpo_name;  
                    $count=0;          
                  foreach ($mst_police_stations_data as $val) {

                    $total_police_eyes = $this->Crud_model->GetData('mst_cameras','count(id) as total_police_eyes',"police_station_id='".$val->id."' and is_delete='No' and status='Active'",'','','','1');

                    $count=$count+$total_police_eyes->total_police_eyes;   
                   }
                  
                    $key['total_police_eyes'] = $count;           

                    array_push($data, $key);
              }
              }
              

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }






// This API is used to get list ofpolice eyes according to the police station
  public function getPoliceEyes_post() 
  {
      $police_station_id=$this->_request['police_station_id'];

      if(!empty($police_station_id))
      {
          $data = $this->Crud_model->GetData('mst_cameras','',"police_station_id='".$police_station_id."'");

          if(!empty($data))
          {
            $result= array('success' =>1, 'message' => "Data found", "data"=>$data);
          }
          else
          {
            $result= array('success' =>0, 'message' => "Data not found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  public function getPoliceEyesDetails_post() 
  {
      
      $id=$this->_request['id'];

       $cond="mc.id='".$id."'";
      $data = $this->Crud_model->getPoliceEyesDetails($cond);

      if(!empty($data))
      {
        $image_path = IMAGEPATH."police_eyes/";
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data, "image_path"=>$image_path);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  /*-------------Police Eyes End--------------*/  


/*--------------Police Activity Start----------------*/

// This API is used to get List of police task
public function getListOfPoliceTask_post()
{
      $table="police_task_completion";
      $police_id=$this->_request['police_id'];
       if(!empty($police_id))
      {
        $con="police_id='".$police_id."' and activity_status='Pending'";

        $data=$this->Crud_model->GetListOfPoliceTask($con);
         

        
      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}


// This API is used to get police task deatils
public function getPoliceTaskDetails_post()
{
      $table="police_task_completion";
      $police_task_completion_id=$this->_request['police_task_completion_id'];
       if(!empty($police_task_completion_id))
      {
        $con="ptc.id='".$police_task_completion_id."'";
        $data=$this->Crud_model->GetPoliceTaskDetails($con);
         

        
      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}

// This API is used to save police task data
public function savePoliceTaskdata_post()
{
      $table="police_task_completion";
      $police_id=$this->_request['police_id'];
      $longitude=$this->_request['longitude'];
      $latitude=$this->_request['latitude'];
      $current_location=$this->_request['current_location'];
      $police_task_completion_id=$this->_request['police_task_completion_id'];
      
       if(!empty($police_id) && !empty($police_task_completion_id) && !empty($longitude) && !empty($latitude) && !empty($current_location) )
      {
        $con="police_id='".$police_id."' and id='".$police_task_completion_id."'";
        $data = $this->Crud_model->GetData($table,'',$con,'','','','1');

         
        $image = base64_decode($this->_request['image']);
        $image_name = $this->_request['image_name'];
        if(!empty($image_name))
        {
          $path_parts = pathinfo($image_name);
          $ext = $path_parts['extension'];
          $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
          $path = FCPATH."../admin/uploads/police_activities/".$attachment;
          file_put_contents($path,$image);
          $image=$attachment;
          
      }else{
         $image='';
      }

        $video = base64_decode($this->_request['video']);
        $video_name = $this->_request['video_name'];
        if(!empty($video_name))
        {
          $path_parts = pathinfo($video_name);
          $ext = $path_parts['extension'];
          $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
          $path = FCPATH."../admin/uploads/police_activities/".$attachment;
          file_put_contents($path,$video);
          $video=$attachment;
         
      }else{
        $video='';
      }

          $image_array = array(
            'police_task_complition_id' => $data->id, 
            'police_id' => $data->police_id,
            'image' => $image, 
            'video' => $video,
          );
          $this->Crud_model->SaveData('police_task_completion_images',$image_array);
            $data2 = array(
              'activity_status' =>'Completed',
               'current_location'=>$current_location,
              'latitude' =>$longitude,
              'longitude' =>$latitude,
               );
         $this->Crud_model->SaveData('police_task_completion',$data2,"id='".$data->id."'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data save successfully");
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}

/*--------------Police Activity End----------------*/

/*-------------------Sensitive Areas/QR/Petrolling start--------------------*/

//this api is change and now it show the completed Qr codes at persent date

public function getOverallPoliceQR_post()
  {
      //$table="mst_police_stations";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $data=[];
                $con="sa.city_id='".$checkCity->city_id."'";               
                $data2 = $this->Crud_model->GetOverallPoliceQR($con);  
               // print_r($data2);exit();
               foreach ($data2 as  $row) {
               $item['police_station_name']=$row->police_station_name;
               $item['address']=$row->address;
               $item['image']=$row->image;
               $item['qrcode']=$row->qrcode;
               $item['id']=$row->id;
               $item['police_station_id']=$row->police_station_id;
                
              $con2="ptc.sensitive_areas_id='".$row->id."'";
              $data3 = $this->Crud_model->GetOverallPoliceQRComp($con2);
              //print_r($this->db->last_query());exit();    
                if(!empty($data3)){
                     $item['type']='Completed';  
                }else{              
                    $item['type']='Pending';             
                }     
              array_push($data, $item);

             }
             //print_r($data);exit();           
                }           

              if(!empty($data))
              {
              $image_path = IMAGEPATH."qrcodeci/";
              $result= array('success' =>1, "message"=>"Data found", 'data' => $data, "image_path"=>$image_path);     
               // $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

/*public function getOverallPoliceQR_post()
  {
      //$table="mst_police_stations";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="sa.city_id='".$checkCity->city_id."'";               
                $data = $this->Crud_model->GetOverallPoliceQR($con);                   
                }           

              if(!empty($data))
              {    
              $image_path = IMAGEPATH."qrcodeci/";
              $result= array('success' =>1, "message"=>"Data found", 'data' => $data, "image_path"=>$image_path);     
               // $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }*/


//This API is used to list the police station And QR count W.R.T police type
public function getlistAndCountofPoliceStaionforQR_post()
{
  $table="mst_police_stations";
  $sdpo_id=$this->_request['sdpo_id'];
  $police_id=$this->_request['police_id'];
  $loginusertype=$this->_request['loginusertype'];
  if(!empty($police_id) and !empty($loginusertype))
  {
    $con="id='".$police_id."' and designation_type='".$loginusertype."'";
    $get_city_id = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');
    if(!empty($get_city_id))
    {
       
      if($loginusertype=='Head_Person'  && !empty($sdpo_id)){
         
        $con="city_id='".$get_city_id->city_id."'and sdpo_id='".$sdpo_id."' and is_delete='No' and status='Active'";
        $police_station_list = $this->Crud_model->GetData($table,'id,name as police_station_name',$con,'','','','');

        $data=[];

        foreach ($police_station_list as $value) {

         $total_qrCount = $this->Crud_model->GetData('sensitive_areas','count(id) count',"police_station_id='".$value->id."'AND is_delete='No' AND status='Active'",'','','','1');

         $cond="sc.police_station_id='".$value->id."'";
         $total_qrScann=$this->Crud_model->getqrcode($cond);
           //print_r($this->db->last_query());exit(); 
         $item['id'] = $value->id;
         $item['police_station_name'] = $value->police_station_name;            
         $item['total_QRcodes'] = $total_qrCount->count;             
         $item['total_qrScann'] = $total_qrScann->count;             
         array_push($data, $item);
       }
     }else if($loginusertype=='Station_Head')
     {
  
        $con="id='".$police_id."'";
                $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
                  $con="id='".$checkStation->police_station_id."' AND is_delete='No' AND status='Active'";
 
      $police_station_list = $this->Crud_model->GetData($table,'id,name',$con,'','','','1');
//print_r($police_station_list);exit();
       $data=[];

        if(empty($police_station_list)){
                   $result= array('success' =>0, 'message' => "Required Police Stations is missing");      
                  $this->response($result, REST_Controller::HTTP_OK); 
                }
         $total_qrCount = $this->Crud_model->GetData('sensitive_areas','count(id) count',"police_station_id='".$police_station_list->id."'",'','','','1');

         $cond="sc.police_station_id='".$police_station_list->id."'";
         $total_qrScann=$this->Crud_model->getqrcode($cond);
            
         $item['id'] = $police_station_list->id;
         $item['police_station_name'] = $police_station_list->name;            
         $item['total_QRcodes'] = $total_qrCount->count;             
         $item['total_qrScann'] = $total_qrScann->count;             
         array_push($data, $item);
             

    }
    if(!empty($data))
    {         
      $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
    }
    else
    {
      $result= array('success' =>0, 'message' => "Data not found");
    }

  }else{

   $result= array('success' =>0, 'message' => "Data not Found");
 }
}else
{
  $result= array('success' =>0, 'message' => "Required parameters missing");
}
$this->response($result, REST_Controller::HTTP_OK); 

}

//This API is used to get police station QR count for SDPO
  public function getSDPOlistAndCountofPoliceStaionforQR_post()
  {
      $table="mst_sdpo";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="city_id='".$checkCity->city_id."' and status='Active'";
                $sdpo_data = $this->Crud_model->GetData($table,'id,name as sdpo_name',$con);
                $data=[];

                foreach ($sdpo_data as $row) 
                {
                  $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','sdpo_id="'.$row->id.'"');    
                  //print_r($sdpo_Police_station_data);exit(); 
                    $key['sdpo_id'] = $row->id;
                    $key['sdpo_name'] = $row->sdpo_name;  
                    $total_QRcodes=0;
                    $total_Scann=0;       
                  foreach ($mst_police_stations_data as $val) {
                    
                      $total_qrCount = $this->Crud_model->GetData('sensitive_areas','count(id) count',"police_station_id='".$val->id."'AND is_delete='No' AND status='Active'",'','','','1');

                       $cond="sc.police_station_id='".$val->id."'";
                      $total_qrScann=$this->Crud_model->getqrcode($cond);

                    $total_QRcodes=$total_QRcodes+$total_qrCount->count;   
                    $total_Scann=$total_Scann+ $total_qrScann->count;   
                   }
                  
                    $key['total_QRcodes'] = $total_QRcodes;           
                    $key['total_qrScann'] = $total_Scann;           

                    array_push($data, $key);
                }
              }
              
              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }



// This API is used to get qr code list according to the police stations
  public function getQrcodeList_post()
  {
     
      $police_station_id=$this->_request['police_station_id'];

      if(!empty($police_station_id))
      { 
        $data=[];
        $con="sc.police_station_id='".$police_station_id."'";
        $data2 = $this->Crud_model->getListOfPoliceTasks($con);        
        foreach ($data2 as  $row) {
               $item['police_station_name']=$row->police_station_name;
               $item['address']=$row->address;
               $item['image']=$row->image;
               $item['qrcode']=$row->qrcode;
               $item['id']=$row->id;
               $item['police_station_id']=$row->police_station_id;
              
        $con2="sc.police_station_id='".$police_station_id."' and sc.id='".$row->id."'";
        $data3 = $this->Crud_model->getListOfPoliceTasksComp($con2);
          if(!empty($data3)){
               $item['type']='Completed';  
          }else{              
              $item['type']='Pending';             
          }     
        array_push($data, $item);

       }
       
      
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."qrcodeci/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, 'image_path'=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }

      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

// This API is used to get qr code details
  public function getQrcodeDetails_post()
  {
      $table="sensitive_areas";
      $qr_code_id=$this->_request['qr_code_id'];

      if(!empty($qr_code_id))
      {
        $con="sa.id=".$qr_code_id;
        $data = $this->Crud_model->getQrcodeDetails($con);
      
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."qrcodeci/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, 'image_path'=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }

      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get qr code details
  public function getQrcodeDetailsonQrno_post()
  {
      $table="sensitive_areas";
      $qrcode=$this->_request['qrcode'];

      if(!empty($qrcode))
      {
        $con="sa.qrcode='".$qrcode."'";
        $data = $this->Crud_model->GetQrcodeDetailsonQrno($con);
      
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."qrcodeci/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, 'image_path'=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }

      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }
// This API is used to save Sensitive Areas Activity
public function saveSensitiveAreasActivity_post()
{

      $table="sensitive_areas";
      $police_id=$this->_request['police_id'];
      $qrcode=$this->_request['qrcode'];
      $longitude=$this->_request['longitude'];
      $latitude=$this->_request['latitude'];
       $current_location=$this->_request['current_location'];
       if(!empty($qrcode) and !empty($police_id) && !empty($longitude) && !empty($latitude)&& !empty($current_location))
      {
        $con="id='".$police_id."'";
        $get_police_station_id = $this->Crud_model->GetData('mst_police','',$con,'','','','1');
        
        $getqrcode = $this->Crud_model->GetData('sensitive_areas','qrcode,latitude,longitude,id',"police_station_id='".$get_police_station_id->police_station_id."' and qrcode='".$qrcode."'",'','','','1');     
    // print_r($getqrcode);exit();
        if(!empty($getqrcode)){
          if((is_numeric($getqrcode->latitude)!=1 and is_numeric($getqrcode->longitude)!=1) or (trim($getqrcode->latitude)=='0' and trim($getqrcode->longitude)=='0') ){
           $qrcode_array = array(
           
            'longitude' => $longitude,
            'latitude' => $latitude, 
            
             );
              $this->Crud_model->SaveData('sensitive_areas',$qrcode_array,'id="'.$getqrcode->id.'"');
          }
        $con="qrcode='".$qrcode."'";
        $data=$this->Crud_model->GetData($table,'',"qrcode='".$qrcode."'",'','','','1');

        $image = base64_decode($this->_request['image']);
        $image_name = $this->_request['image_name'];
        if(!empty($image_name))
        {
          $path_parts = pathinfo($image_name);
          $ext = $path_parts['extension'];
          $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
          $path = FCPATH."../admin/uploads/patrolling/".$attachment;
          file_put_contents($path,$image);
          $image=$attachment;
          
      }else{
         $image='N/A';
      }
      $image_array = array(
            'sensitive_areas_id' => $data->id, 
            'police_id' => $police_id,
            'image' => $image, 
            
          );
          $this->Crud_model->SaveData('police_task_completion_images',$image_array);
        
      if(!empty($data))
      {
        $data2 = array(
          'police_id' =>$police_id , 
          'sensitive_areas_id' =>$data->id ,
          'latitude' =>$longitude,
          'longitude' =>$latitude, 
          'current_location'=>$current_location,
          'activity_status' =>'Completed' , 
        );
        $this->Crud_model->SaveData('police_task_completion',$data2);

        $result= array('success' =>1, "message"=>"Data save successfully");
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }

        }else{

           $result= array('success' =>0, 'message' => "QR Code is Invalid or your not registerd with this area police station");
        }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 

}

/*-------------------Sensitive Areas/QR/Petrolling End--------------------*/

/*---------------Bpatrak Start-------------------*/
// This API is used to save bpatrak
  /*public function bpatrak_post() 
  {
      $fir_number = $this->_request['fir_number'];

      if(!empty($fir_number))
      { 
        $checkFirNum = $this->Crud_model->GetData('bpatrak','',"fir_number='".$fir_number."'");

        if(!empty($checkFirNum))
        {
            $result= array('success' =>0,"message"=>"FIR already exits");
        }
        else
        {
          $image = base64_decode($this->_request['image']);
          $image_name = $this->_request['image_name'];

          if(!empty($image_name))
          {
              $path_parts = pathinfo($image_name);
              $ext = $path_parts['extension'];
              $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
              $path = FCPATH."../admin/uploads/bpatrak/".$attachment;
              file_put_contents($path,$image);
              $image=$attachment;
          }

          $video = base64_decode($this->_request['video']);
          $video_name = $this->_request['video_name'];
          if(!empty($video_name))
          {
            $path_parts = pathinfo($video_name);
            $ext = $path_parts['extension'];
            $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
            $path = FCPATH."../admin/uploads/bpatrak/".$attachment;
            file_put_contents($path,$video);
            $video=$attachment;            
          }

            $data = array(
                'fir_number'=>$fir_number,
                'complaint_title'=>$this->_request['complaint_title'],
                'criminal_name'=>$this->_request['criminal_name'],
                'arrested_datetime'=>$this->_request['arrested_datetime'],
                'incident_name'=>$this->_request['incident_name'],
                'crime_datetime'=>$this->_request['crime_datetime'],
                'fir_datetime'=>$this->_request['fir_datetime'],
                'reality'=>$this->_request['reality'],
                'country_id'=>$this->_request['country_id'],
                'state_id'=>$this->_request['state_id'],
                'district_id'=>$this->_request['district_id'],
                'city_id'=>$this->_request['city_id'],
                'address'=>$this->_request['address'],
                'latitude'=>$this->_request['latitude'],
                'longitude'=>$this->_request['longitude'],
                'police_station_id'=>$this->_request['police_station_id'],
                'police_id'=> $this->_request['police_id'],
                'police_station_head_id'=>$this->_request['police_station_head_id'],
                'image'=>$image,
                'video'=>$video,
                );
        $this->Crud_model->SaveData("bpatrak",$data);
        $result= array('success' =>1,"message"=>"Bpatrak saved successfully","data" =>$data);
        }
      }
      else
      {
         $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }*/


    public function bpatrak_post() 
  {

      $police_id = $this->_request['police_id'];
          if(!empty($police_id)){    
            $con="id='".$police_id."'";
            $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
            $con="id='".$checkStation->police_station_id."'";
            $police_stations = $this->Crud_model->GetData("mst_police_stations",'',$con,'','','','1');
            if(!empty($police_stations)){
              $police_station_id=$police_stations->id;
              $country_id=$police_stations->country_id;
              $state_id=$police_stations->state_id;
              $district_id=$police_stations->district_id;
              $city_id=$police_stations->city_id;
            }else{
              $police_station_id=null;
            }  
       
          $image = base64_decode($this->_request['image']);
          $image_name = $this->_request['image_name'];

          if(!empty($image_name))
          {
              $path_parts = pathinfo($image_name);
              $ext = $path_parts['extension'];
              $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
              $path = FCPATH."../admin/uploads/bpatrak/".$attachment;
              file_put_contents($path,$image);
              $image=$attachment;
          }

          $video = base64_decode($this->_request['video']);
          $video_name = $this->_request['video_name'];
          if(!empty($video_name))
          {
            $path_parts = pathinfo($video_name);
            $ext = $path_parts['extension'];
            $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
            $path = FCPATH."../admin/uploads/bpatrak/".$attachment;
            file_put_contents($path,$video);
            $video=$attachment;            
          }
          //print_r(date("d/m/Y", strtotime($this->_request['date'])));exit();
            $data = array(
                
                'date'=>date("Y-m-d", strtotime($this->_request['date'])),
                'time'=>date("h:i:s", strtotime($this->_request['time'])),
                'current_location'=>$this->_request['current_location'],                
                'incident_name'=>$this->_request['incident_name'],
                'description'=>$this->_request['description'],                
                'latitude'=>$this->_request['latitude'],
                'longitude'=>$this->_request['longitude'],
                'police_station_id'=>$police_station_id,
                'police_id'=> $this->_request['police_id'],
                'country_id'=> $country_id,
                'state_id'=> $state_id,
                'district_id'=> $district_id,
                'city_id'=> $city_id,
                'image'=>$image,
                'video'=>$video,
                );
        $this->Crud_model->SaveData("bpatrak",$data);
        $result= array('success' =>1,"message"=>"Bpatrak saved successfully","data" =>$data);
        }else{
           $result= array('success' =>0, 'message' => "Required parameters missing");
        }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  // This API is used to get List of Bpatrak by akash
    public function getBpatrakData_post() 
    {
        $table = "bpatrak";
        $data = $this->Crud_model->getAllBpatrakData();

        if(!empty($data))
        {
          $image_path = IMAGEPATH."bpatrak/";
          $result= array('success' =>1, "message"=>"Data found", 'data' => $data, "image_path"=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }
        $this->response($result, REST_Controller::HTTP_OK); 
    }

    // This API is used to get bpatrak list according to police station
  public function bpatrakList_post() 
  {
      $police_station_id = $this->_request['police_station_id'];

      if(!empty($police_station_id))
      {
        $data = $this->Crud_model->GetData("bpatrak","","police_station_id='".$police_station_id."'",'','id desc','','');
      
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."bpatrak/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, 'image_path'=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }

      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

public function getOverallBpatrak_post()
  {
      //$table="mst_police_stations";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="bp.city_id='".$checkCity->city_id."'";               
                $data = $this->Crud_model->getOverallBpatrak($con);                   
                }           

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


  
    // This API is used to get bpatrak count according to the police station
  public function getBpatrakCount_post()
  {
      $table="mst_police_stations";
       $sdpo_id=$this->_request['sdpo_id'];
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype) )
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."' and is_delete='No' and status='Active'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person' && !empty($sdpo_id))
              {
                $con="city_id='".$checkCity->city_id."'  and sdpo_id='".$sdpo_id."' and is_delete='No' and status='Active'";
                $police_stations = $this->Crud_model->GetData($table,'id,name as police_station_name',$con);
               
                $data=[];

                foreach ($police_stations as $row) 
                {
                    $total_bpatrak = $this->Crud_model->GetData('bpatrak','count(id) as total_bpatrak',"police_station_id='".$row->id."'",'','','','1');

                    $key['id'] = $row->id;
                    $key['police_station_name'] = $row->police_station_name;            
                    $key['total_bpatrak'] = $total_bpatrak->total_bpatrak;             
                    array_push($data, $key);
                }
              }
              else if($loginusertype=='Station_Head')
              {
                $con="id='".$police_id."'";
                $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
                  $con="id='".$checkStation->police_station_id."'";
                $police_stations = $this->Crud_model->GetData($table,'id,name',$con,'','','','1');   
                //print_r($police_stations);exit();
                  $data=[];
                 if(empty($police_stations)){
                   $result= array('success' =>0, 'message' => "Required Police Stations is missing");      
                  $this->response($result, REST_Controller::HTTP_OK); 
                }
                 $total_bpatrak = $this->Crud_model->GetData('bpatrak','count(id) as total_bpatrak',"police_station_id='".$police_stations->id."'",'','','','1');

                    $key['id'] = $police_stations->id;
                    $key['police_station_name'] = $police_stations->name;            
                    $key['total_bpatrak'] = $total_bpatrak->total_bpatrak; 

                    //print_r($key);exit();            
                    array_push($data, $key);    
                    
              }

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

// This API is used to get bpatrak count according to the police station SDPO
  public function getSDPOBpatrakCount_post()
  {
      $table="mst_sdpo";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."' and is_delete='No' and status='Active'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                 $con="city_id='".$checkCity->city_id."' and status='Active'";
                $sdpo_data = $this->Crud_model->GetData($table,'id,name as sdpo_name',$con);
                
                $data=[];

                foreach ($sdpo_data as $row) 
                {
                 $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','sdpo_id="'.$row->id.'"');
                    $key['sdpo_id'] = $row->id;
                    $key['sdpo_name'] = $row->sdpo_name;  
                    $count=0;          
                  foreach ($mst_police_stations_data as $val) {

                    $total_bpatrak = $this->Crud_model->GetData('bpatrak','count(id) as total_bpatrak',"police_station_id='".$val->id."'",'','','','1');

                    $count=$count+$total_bpatrak->total_bpatrak;   
                   }
                  
                    $key['total_bpatrak'] = $count;           

                    array_push($data, $key);
              }
              }
              

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }



  // This API is used to get bpatrak details according to police station
  public function bpatrakDetails_post() 
  {
      $bpatrak_id = $this->_request['bpatrak_id'];

      if(!empty($bpatrak_id))
      {
        $data = $this->Crud_model->GetData("bpatrak","","id='".$bpatrak_id."'","","","","1");
      
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."bpatrak/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, 'image_path'=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }

      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }
  /*---------------Bpatrak End-------------------*/

  /*---------------Near By Police Station Start-------------------*/
  // This API is used to get near by police stations by akash 
  public function getNearByPoliceStation_post()
  {
     $table = "mst_police_stations";

      $data = $this->Crud_model->GetData($table,'',"is_delete='No' AND status='Active'");

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

/*---------------Near By Police Station End-------------------*/

/*------------Police Station Head Activity Start------------*/

// This API is used to get List of police station Activity
public function getListOfPoliceStationActivity_post()
{
    
      $police_id=$this->_request['police_id'];
       if(!empty($police_id))
      {
       $data = $this->Crud_model->GetData("mst_police",'police_station_id,designation_type',"is_delete='No' and status='Active' and id='".$police_id."'",'','','','1');   
       if(!empty($data)){
        if($data->designation_type=='Station_Head' and !empty($data->police_station_id)){
         $con="psam.police_station_id=".$data->police_station_id;        
        $data2=$this->Crud_model->GetListOfPoliceStationActivity($con);
       //print_r($data2);exit();   
      if(!empty($data2))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data2);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
      }else{
         $result= array('success' =>0, 'message' => "your are not head of any police station");
      }
    }else{
      $result= array('success' =>0, 'message' => "Don't have any police Station under you");
    }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}

// This API is used to get List of police station Activity for station
public function getListOfPoliceStationActivityforStation_post()
{
    
      $police_station_id=$this->_request['police_station_id'];
      if(!empty($police_station_id)){
        $data=[];
         $con="psam.police_station_id='".$police_station_id."'";        
        $data2=$this->Crud_model->GetListOfPoliceStationActivityforStation($con);

      foreach ($data2 as $value) {
             $item['activity_name']=$value->activity_name;
             $item['from_date']=$value->from_date;
             $item['to_date']=$value->to_date;
             $item['police_station_id']=$value->police_station_id;
             $item['police_station_name']=$value->police_station_name;
             $item['id']=$value->id;
        $con="psam.police_station_id='".$police_station_id."' and psam.id='".$value->id."'";        
        $data3=$this->Crud_model->GetListOfPoliceStationActivityforStationComp($con);
         if(!empty($data3)){
               $item['type']='Completed';  
          }else{              
              $item['type']='Pending';             
          }     
        array_push($data, $item);
      }

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
     
    
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}


// This API is used to get police task deatils
public function getPoliceStationActivityDetails_post()
{
     
      $id=$this->_request['id'];
      $police_station_id=$this->_request['police_station_id'];
       if(!empty($id) and !empty($police_station_id))
      {
        $con="psam.id='".$id."' and psam.police_station_id='".$police_station_id."'";
        $data=$this->Crud_model->getPoliceStationActivityDetails($con);
         

        
      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}
public function getPolices_post()
  {
      $table = "mst_police";
      $police_station_id=$this->_request['police_station_id'];

      if(!empty($police_station_id))
      {
        $con="status='Active' AND is_delete='No' AND police_station_id='".$police_station_id."' and designation_type='Police'";
        $data = $this->Crud_model->GetData($table,'id,police_name',"status='Active' AND is_delete='No' AND police_station_id='".$police_station_id."' and designation_type='Police'");

       // print_r($data);exit();
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  public function savePoliceStationActivity_post()
  {
 //print_r($this->_request);exit();
      $id=$this->_request['id'];
      $police_id=[];
      $police_id=$this->_request['police_id'];
      
       if(!empty($police_id) && !empty($id))
      {
       
      foreach ($police_id as $row) {  
      $police_id=$row;
      $data = array(
       
        'police_station_activity_map_id' => $id,
        'police_id' => $police_id,             
        'created'=> date('Y-m-d H:i:s'),
      );  
   //print_r($data);exit(); 
      $this->Crud_model->SaveData("police_activity_map",$data);
     
       $data2 = array(
        'police_station_activity_map_id' => $id,        
        'activity_status' =>'Pending',
        'police_id' => $police_id,             
        'created'=> date('Y-m-d H:i:s'), 
      );
        $this->Crud_model->SaveData("police_task_completion",$data2);

        if(!empty($police_id)){

          $police_data = $this->Crud_model->GetData("mst_police",'id,police_name,player_id,police_station_id',"is_delete='No' and status='Active' and designation_type='Police' and id='".$police_id."'",'','','','1');
          $con="psam.id='".$id."' and psam.police_station_id='".$police_data->police_station_id."'";
        $task_data=$this->Crud_model->getPoliceStationActivityDetails($con);

        $to = $police_data->player_id;
        $heading = 'Selfie App';
        $message = 'Dear, '.ucfirst($police_data->police_name).' New '.ucfirst($task_data->activity_name). ' Task Assigned to your police station '.ucfirst($task_data->name). ' from '.$task_data->from_date.'  to '.$task_data->to_date.'  on the location '.ucfirst($task_data->address);
         //print_r($task_data);exit();
       
        $this->Sms->sendMessage($to, $heading, $message);

        $save_data_notification=array(
          'task_id'=>$id,
          'id_type'=>$task_data->police_station_head_id,
          'receiver_id'=>$police_id,
          'type'=>'TasktoPolice',
          'user_type'=>'Station_Head',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
          $this->Crud_model->SaveData('police_notifications',$save_data_notification);

        }


      }  
     
        $result= array('success' =>1, "message"=>"Data save successfully");
      
      
      
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  // This API is used to get Police Stations details For Station Head
  public function getPoliceStationDetailsForStationHead_post() 
  {
      $table = "mst_police_stations";
      $police_id=$this->_request['police_id'];
       if(!empty($police_id))
      {
        $police = $this->Crud_model->GetData("mst_police",'police_station_id,designation_type',"is_delete='No' and status='Active' and id='".$police_id."'",'','','','1');
        if(!empty($police)){
          if($police->designation_type=='Station_Head'){
        $con="p.id='".$police_id."'";
       $data = $this->Crud_model->GetPoliceStationDetailsForStationHead($con);

      if(!empty($data))
      {
        $image_path = IMAGEPATH."police_station_image/";
        $result= array('success' =>1, "message"=>"Data found", 'data' => $data,"image_path"=>$image_path);
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else{
      $result= array('success' =>0, 'message' => "Access Denied");
    }
    }else{
      $result= array('success' =>0, 'message' => "Unauthorized person");
    }
       }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


/*------------Police Station Head Activity End------------*/ 

/*--------Police Head Activity list start----------*/

public function getOverallPoliceStaionActivityforHead_post()
  {
      //$table="mst_police_stations";   
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
                if($loginusertype=='Head_Person')
                {
                  $data=[];
                $con="psam.city_id='".$checkCity->city_id."'";               
                $data2 = $this->Crud_model->GetOverallPoliceStaionActivityforHead($con); 
                foreach ($data2 as  $row) {
                $item['police_station_name']=$row->police_station_name;
                $item['activity_name']=$row->activity_name;
                $item['from_date']=$row->from_date;
                $item['to_date']=$row->to_date;
                $item['id']=$row->id;
                $item['police_station_id']=$row->police_station_id;

                $con2="psam.city_id='".$checkCity->city_id."' and psam.id='".$row->id."'";
                $data3 = $this->Crud_model->GetOverallPoliceStaionActivityforHeadComp($con2);
                if(!empty($data3)){
                $item['type']='Completed';  
                }else{              
                $item['type']='Pending';             
                }     
                array_push($data, $item);                  
                }           

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

}
//This API is used to list the police station And QR count W.R.T police type
public function getlistAndCountofPoliceStaionActivityforHead_post()
{
  $table="mst_police_stations";
  $sdpo_id=$this->_request['sdpo_id'];
  $police_id=$this->_request['police_id'];
  $loginusertype=$this->_request['loginusertype'];
  if(!empty($police_id) and !empty($loginusertype))
  {
    $con="id='".$police_id."' and designation_type='".$loginusertype."'";
    $get_city_id = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');
  //print_r("hi");exit();
    if(!empty($get_city_id))
    {
        //print_r($get_city_id->city_id);exit();
      if($loginusertype=='Head_Person' && !empty($sdpo_id)){
        $con="city_id='".$get_city_id->city_id."' and sdpo_id='".$sdpo_id."' and is_delete='No' and status='Active'";
        $police_station_list = $this->Crud_model->GetData($table,'id,name as police_station_name',$con,'','','','');

        $data=[];

        foreach ($police_station_list as $value) {

         $total_qrCount = $this->Crud_model->GetData('police_station_activity_map','count(id) count',"police_station_id='".$value->id."'",'','','','1');

         $cond="psam.police_station_id='".$value->id."'";
         $total_qrScann=$this->Crud_model->getActivities($cond);
           //print_r($this->db->last_query());exit(); 
         $item['id'] = $value->id;
         $item['police_station_name'] = $value->police_station_name;            
         $item['total_Activities'] = $total_qrCount->count;             
         $item['total_ActivitiesCompleted'] = $total_qrScann->count;             
         array_push($data, $item);
       }
     }else if($loginusertype=='Station_Head')
     {
     $con="id='".$police_id."'";
      $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
      $con="id='".$checkStation->police_station_id."' and is_delete='No' and status='Active'";
      $police_station_list = $this->Crud_model->GetData($table,'id,name',$con,'','','','1');
//print_r($police_station_list->id);exit();
         $data=[];      
          if(empty($police_station_list)){
                   $result= array('success' =>0, 'message' => "Required Police Stations is missing");      
                  $this->response($result, REST_Controller::HTTP_OK); 
                }
         $total_qrCount = $this->Crud_model->GetData('police_station_activity_map','count(id) count',"police_station_id='".$police_station_list->id."' and is_delete='No' and status='Active'",'','','','1');
         
         $cond="psam.police_station_id='".$police_station_list->id."'";
         $total_qrScann=$this->Crud_model->getActivities($cond);
            
         $item['id'] = $police_station_list->id;
         $item['police_station_name'] = $police_station_list->name;            
         $item['total_Activities'] = $total_qrCount->count;             
         $item['total_ActivitiesCompleted'] = $total_qrScann->count;
         
         array_push($data, $item);
             

    }
    if(!empty($data))
    {         
      $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
    }
    else
    {
      $result= array('success' =>0, 'message' => "Data not found");
    }

  }else{

   $result= array('success' =>0, 'message' => "Data not Found");
 }
}else
{
  $result= array('success' =>0, 'message' => "Required parameters missing");
}
$this->response($result, REST_Controller::HTTP_OK); 

}


  //This API is used to get police station task count for SDPO
  public function getSDPOlistAndCountofPoliceStaionActivityforHead_post()
  {
      $table="mst_sdpo";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="city_id='".$checkCity->city_id."' and status='Active'";
                $sdpo_data = $this->Crud_model->GetData($table,'id,name as sdpo_name',$con);
                $data=[];

                foreach ($sdpo_data as $row) 
                {
                  $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','sdpo_id="'.$row->id.'"');    
                  //print_r($sdpo_Police_station_data);exit(); 
                    $key['sdpo_id'] = $row->id;
                    $key['sdpo_name'] = $row->sdpo_name;  
                    $total_Activities=0;
                    $total_ActivitiesCompleted=0;       
                  foreach ($mst_police_stations_data as $val) {
                    
                     $total_qrCount = $this->Crud_model->GetData('police_station_activity_map','count(id) count',"police_station_id='".$val->id."'",'','','','1');

                     $cond="psam.police_station_id='".$val->id."'";
                     $total_qrScann=$this->Crud_model->getActivities($cond);        
                    $total_Activities=$total_Activities+$total_qrCount->count;   
                    $total_ActivitiesCompleted=$total_ActivitiesCompleted+ $total_qrScann->count;   
                   }
                  
                    $key['total_Activities'] = $total_Activities;           
                    $key['total_ActivitiesCompleted'] = $total_ActivitiesCompleted;           

                    array_push($data, $key);
                }
              }
              
              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


/*--------Police Head Activity list end----------*/
  
// This API is used to save Police Station Wise QR code
public function savePoliceStationsQRCode_post()
{       

      $table="sensitive_areas";
      $country_id=$this->_request['country_id'];
      $state_id=$this->_request['state_id'];
      $district_id=$this->_request['district_id'];
      $city_id=$this->_request['city_id'];
      $police_station_id=$this->_request['police_station_id'];
      $address=$this->_request['address'];
      $longitude=$this->_request['longitude'];
      $latitude=$this->_request['latitude'];


      $data['image']="";
      $qr_image=rand().'.png';
      $params['data'] = $address;
      $params['level'] = 'H';
      $params['size'] = 8;
      $params['savename'] =FCPATH."../admin/uploads/qrcodeci/".$qr_image;
      if($this->ciqrcode->generate($params))
      {
        $data['image']=$qr_image; 
      }
         $con="id='".$police_station_id."'";
          $police_station_name= $this->Crud_model->GetData('mst_police_stations','name',$con,'','','','1');
         $data2 = array(
             
              'country_id'=>$country_id,
              'state_id'=>$state_id,
              'district_id'=>$district_id,
              'city_id'=>$city_id,
              'police_station_id'=>$police_station_id,
              'police_station_name'=>$police_station_name->name,
              'address'=>$address,
              'latitude'=>$latitude,
              'longitude'=>$longitude,
              'qrcode'=>$address,
             'image'=>$data['image'],
              );

            $image_path = IMAGEPATH."qrcodeci/";
          $this->Crud_model->SaveData('sensitive_areas',$data2);
          $result= array('success' =>1, "message" =>"Record save successfully",'data'=>$data2,"image_path"=>$image_path);
      
    
      $this->response($result, REST_Controller::HTTP_OK); 
}

/*--------------This API is used to save Police Station Wise QR code ends Here----------------*/
// This API is used to get SDPO
  public function getSDPOList_post() 
  {
      $city_id = $this->_request['city_id'];

      if(!empty($city_id))
      {
          $data = $this->Crud_model->GetData("mst_sdpo",'',"status='Active' AND city_id='".$city_id."'");

          if(!empty($data))
          {
            $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
          }
          else
          {
            $result= array('success' =>0, 'message' => "Data not found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  public function getTaskNotificationsCount_post()
      {
        

        $receiver_id = $this->_request['receiver_id'];
        //$cond="no.receiver_id='".$receiver_id."'";
        $data = $this->Crud_model->GetData('police_notifications','',"receiver_id='".$receiver_id."' and is_read='No'");
        //print_r($data);exit();
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'count'=>count($data)); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function getTaskNotifications_post()
      {
       

        $receiver_id = $this->_request['receiver_id'];
        //$cond="no.receiver_id='".$receiver_id."'";
        $data = $this->Crud_model->GetData('police_notifications','',"receiver_id='".$receiver_id."' and is_read='No'");
        //print_r($data);exit();
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function SaveNotificationsStatus_post()
      {
       

        $receiver_id = $this->_request['receiver_id'];
        $type = $this->_request['type'];
        $id = $this->_request['id'];
        
        if($type=='TaskAccepted'){
           $data = $this->Crud_model->GetData('police_notifications','',"receiver_id='".$receiver_id."' and is_read='No' and type='TaskAccepted'",'','','','');
            foreach($data as $row){
               $notification_data = array('is_read' =>'Yes');
             $this->Crud_model->SaveData('police_notifications',$notification_data,'id="'.$row->id.'"');
            }

        }else{
          $data = $this->Crud_model->GetData('police_notifications','',"receiver_id='".$receiver_id."' and is_read='No' and id='".$id."'",'','','','1');
           $police_id=$data->id_type;
          $task_id1=$data->task_id;

         $notification_data = array('is_read' =>'Yes');
          $this->Crud_model->SaveData('police_notifications',$notification_data,'id="'.$id.'"');
        }
         
       
        //print_r($data);exit();
        if(!empty($data))
        {     
          if($type<>'TaskAccepted'){
           $police_receiver_data = $this->Crud_model->GetData("mst_police",'id,police_name,player_id,police_station_id',"is_delete='No' and status='Active'  and id='".$police_id."'",'','','','1');
           $police_sender_data = $this->Crud_model->GetData("mst_police",'id,police_name,player_id,police_station_id',"is_delete='No' and status='Active'  and id='".$receiver_id."'",'','','','1');
          $con="psam.id=".$task_id1;
        $task_data=$this->Crud_model->getPoliceStationActivityDetails($con);
//print_r($this->db->last_query());exit();
        $to = $police_receiver_data->player_id;
        $heading = 'Selfie App';
        $message = 'Dear '.ucfirst($police_receiver_data->police_name).' , The '.ucfirst($task_data->activity_name). ' Task Assigned to the police station '.ucfirst($task_data->name). ' from '.$task_data->from_date.'  to '.$task_data->to_date.'  on the location '.ucfirst($task_data->address).' is accepted by '.ucfirst($police_sender_data->police_name);        
       
        $this->Sms->sendMessage($to, $heading, $message);

        $save_data_notification=array(
          'task_id'=>$task_id1,
          'id_type'=>$receiver_id,
          'receiver_id'=>$police_id,
          'type'=>'TaskAccepted',
          'user_type'=>'Accepted',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
          $this->Crud_model->SaveData('police_notifications',$save_data_notification); 
        }
        $result= array('success' =>1, "message" =>"Notification accepted",'data'=>$data);
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }



}