<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH . '/libraries/REST_Controller.php';

class Login extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    $this->load->library('Sms');
    $config['protocol'] = 'sendmail';
    $config['mailpath'] = '/usr/sbin/sendmail';
    $config['charset'] = 'iso-8859-1'; 
    $config['wordwrap'] = TRUE;
       // $this->Custom = new Custom();
  }

  
  /* customer registration*/
  public function Registration_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $otp=rand(9999,1111);
    $name = $this->_request['name'];
    $email = $this->_request['email'];
    $mobile = $this->_request['mobile'];
    $dob = $this->_request['dob'];
    $gender = $this->_request['gender'];
    $adhar_no = $this->_request['adhar_no'];
    $voter_no = $this->_request['voter_no'];
    $country_id = $this->_request['country_id'];
    $state_id = $this->_request['state_id'];
    $district_id = $this->_request['district_id'];
    $zone_id = $this->_request['zone_id'];
    $city_id = $this->_request['city_id'];
    $total_members = $this->_request['total_members'];
    $total_male = $this->_request['total_male'];
    $total_female = $this->_request['total_female'];
    $profession_id = $this->_request['profession_id'];
    $player_id = $this->_request['player_id'];
     //$language=$this->_request['language'];
   /* $chk_login = $this->Crud_model->GetData("citizens",'id,email,mobile,name', "mobile='".$mobile."'",'','','','1');
    if (empty($chk_login)) 
    {*/
      $save_data=array(
        'name'=>$name,
        'email'=>$email,
        'mobile'=>$mobile,
        'dob'=>$dob,
        'gender'=>$gender,
        'adhar_no'=>$adhar_no,
        'voter_no'=>$voter_no,
        'country_id'=>$country_id,
        'state_id'=>$state_id,
        'district_id'=>$district_id,
        'zone_id'=>$zone_id,
        'city_id'=>$city_id,
        'total_members'=>$total_members,
        'total_male'=>$total_male,
        'total_female'=>$total_female,
        'profession_id'=>$profession_id,
        'player_id'=>$player_id,
        "otp"=>$otp,
      );
      $this->Crud_model->SaveData('citizens',$save_data);
      $citizen_id = $this->db->insert_id();

      $result= array(
        'success' =>1, 
        "message" =>"Registration done successfully",
        "otp"=>$otp,
        "citizen_id"=>$citizen_id,
        "email"=>$email,
        "mobile"=>$mobile,
        "name"=>$name,
        "is_checked"=>'No',
      );

    /*}
    else
    {
      $result= array('success' =>0, "message" =>"Mobile number already registred");
    }*/

    $this->response($result, REST_Controller::HTTP_OK);
  }


  /*Check otp*/
  public function checkOTP_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);
    $mobile = $this->_request['mobile'];
    $otp = $this->_request['otp'];
    $LoginDetail=$this->_request['loginusertype'];

    if (!empty($otp) && !empty($mobile) && !empty($LoginDetail) ) 
    {
      $cond="mobile='".$mobile."' and otp='".$otp."'";
      if($LoginDetail == 'Citizen') {
        $table="citizens";
        $chk_login = $this->Crud_model->GetData($table,'id,email,mobile,name',$cond,'','','','1');
      }     
      else{

        $table="corporates";
        $chk_login = $this->Crud_model->GetData($table,'id,email,mobile,name',$cond,'','','','1');

      }
      $check = $this->Crud_model->GetData($table,"",$cond,"","","","1");
      
      if(!empty($check)) 
      {
        $result= array('success' =>1, "message" =>"otp check successfully");
      }
      else
      {
        $result= array('success' =>0, "message" =>"Invalid OTP");
      }
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
    
  }

  public function ResendOtp_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);
    $mobile=$this->_request['mobile'];
    $LoginDetail=$this->_request['loginusertype'];

    $otp=rand(1111,9999);

    if($LoginDetail == 'Citizen') {
      $table="citizens";

    }     
    else{

      $table="corporates";

    }   
    $this->Crud_model->SaveData($table,["otp"=>$otp],"mobile='".$mobile."'");

    $result= array('success' =>1, "message" =>"Otp Sent successfully","otp"=>$otp);
    $this->response($result, REST_Controller::HTTP_OK);
  }

  function Login_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $LoginDetail=json_decode($this->_request, true);


    if(!empty($LoginDetail['mobile']) && !empty($LoginDetail['loginusertype']) && !empty($LoginDetail['player_id']))
    {
      $cond = "mobile='".$LoginDetail['mobile']."' and status='Active' and is_delete='No'";
      if($LoginDetail['loginusertype'] == 'Citizen') {
        $table="citizens";
        $chk_login = $this->Crud_model->GetData($table,'id,email,mobile,name',$cond,'','','','1');
      }     
      else{

        $table="corporates";
        $chk_login = $this->Crud_model->GetData($table,'id,email,mobile,name,is_checked',$cond,'','','','1');
      }
      

      if(!empty($chk_login))
      {  
        $datachecked = array(
          'id' => $chk_login->id,
          'email' => $chk_login->email,
          'mobile' => $chk_login->mobile,
          'name' => $chk_login->name,
          'is_checked' => isset($chk_login->is_checked) ? $chk_login->is_checked : 'No'
        );

        $otp = rand(1111,9999);
        $this->Crud_model->SaveData($table,["otp"=>$otp,"player_id"=>$LoginDetail['player_id']],"id='".$chk_login->id."'");   

        $result= array('success' =>1, "message" => "Logged in successfully","otp"=>$otp,"data"=>$datachecked);
        $this->response($result, REST_Controller::HTTP_OK);
      }
      else
      {
        $result= array('success' =>0, "message" => "Login credentials are wrong. Please try again!");
        $this->response($result, REST_Controller::HTTP_OK);
      }

    }
    else
    {
      $result = array('success' => 0,"message" => "Unsupported or invalid parameters, or missing required parameters.");
      $this->response($result, REST_Controller::HTTP_BAD_REQUEST);
    }
  }



  public function RegisterCountry_post()
  {
    $data = $this->Crud_model->GetData('mst_countries','id,country_name',"status='Active' and is_default='No' and id='101'");

    if(!empty($data))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function RegisterState_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $country_id=$this->_request['country_id'];
    $language=$this->_request['language'];

    $registerstates = $this->Crud_model->GetData('mst_states','*',"status='Active' and country_id='".$country_id."' and is_delete='No'",'','state_name asc');

     $data = [];
     foreach ($registerstates as $registerstate) {
      $item['id'] = $registerstate->id;
      $item['country_id'] = $country_id;

      if($language == 'Hindi'){

        $item['state_name'] = $registerstate->state_name_marathi;
      } else if($language == 'Marathi'){
        $item['state_name'] = $registerstate->state_name_hindi;
      } else {
        $item['state_name'] = $registerstate->state_name;
      }
      array_push($data, $item);
    }

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function RegisterCity_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $district_id=$this->_request['district_id'];
     $language=$this->_request['language'];
     if(!empty($district_id)){
    $cities = $this->Crud_model->GetData('mst_cities','*',"status='Active' and district_id='".$district_id."' and is_delete='No'",'','city_name asc');

     $data = [];
     foreach ($cities as $city) {
      $item['id'] = $city->id;
      $item['district_id'] = $district_id;

      if($language == 'Hindi'){

        $item['city_name'] = $city->city_name_hindi;
      } else if($language == 'Marathi'){
        $item['city_name'] = $city->city_name_marathi;
      } else {
        $item['city_name'] = $city->district_name;
      }
      array_push($data, $item);
    }


    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
     }
  else 
    {
      $result= array('success' =>0, "message" =>"Select district");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function RegisterZones_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $city_id=$this->_request['city_id'];
     $language=$this->_request['language'];
    if(!empty($city_id)){
    $zones = $this->Crud_model->GetData('mst_zones','*',"status='Active' and city_id='".$city_id."' and is_delete='No'",'','zone_name');
    
    $data = [];
     foreach ($zones as $zone) {
      $item['id'] = $zone->id;
      $item['city_id'] = $city_id;

      if($language == 'Hindi'){

        $item['zone_name'] = $zone->zone_name_hindi;
      } else if($language == 'Marathi'){
        $item['zone_name'] = $zone->zone_name_marathi;
      } else {
        $item['zone_name'] = $zone->city_name;
      }
      array_push($data, $item);
    } 

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    }
  else 
    {
      $result= array('success' =>0, "message" =>"Select city");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function Professions_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $language=$this->_request['language'];
    $professions = $this->Crud_model->GetData('mst_professions','*',"status='Active' and is_delete='No'",'','profession asc');

    $data = [];
     foreach ($professions as $profession) {
      $item['id'] = $profession->id;
    //  $item['city_id'] = $city_id;

      if($language == 'Hindi'){

        $item['profession'] = $profession->profession_hindi;
      } else if($language == 'Marathi'){
        $item['profession'] = $profession->profession_marathi;
      } else {
        $item['profession'] = $profession->profession;
      }
      array_push($data, $item);
    } 

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }
  

  public function Country_post()
  {
    $data = $this->Crud_model->GetData('mst_countries','id,country_name',"status='Active' and is_default='No' and id='101'");

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function State_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $country_id=$this->_request['country_id'];
    $language=$this->_request['language'];

    
    $states = $this->Crud_model->GetData('mst_states','*',"status='Active' and country_id='".$country_id."' and is_delete='No'",'','state_name asc');
    
    $data = [];
    foreach ($states as $state) {
      $item['id'] = $state->id;
      $item['country_id'] = $country_id;

      if($language == 'Hindi'){

        $item['state_name'] = $state->state_name_hindi;
      } else if($language == 'Marathi'){
        $item['state_name'] = $state->state_name_marathi;
      } else {
        $item['state_name'] = $state->state_name;
      }
      array_push($data, $item);
    }

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function District_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $state_id=$this->_request['state_id'];
    $language=$this->_request['language'];

    $districts = $this->Crud_model->GetData('mst_districts','*',"status='Active' and state_id='".$state_id."' and is_delete='No'",'','district_name asc');

     $data = [];
     foreach ($districts as $district) {
      $item['id'] = $district->id;
      $item['state_id'] = $state_id;

      if($language == 'Hindi'){

        $item['district_name'] = $district->district_name_hindi;
      } else if($language == 'Marathi'){
        $item['district_name'] = $district->district_name_marathi;
      } else {
        $item['district_name'] = $district->district_name;
      }
      array_push($data, $item);
    }

    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function City_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $district_id = $this->_request['district_id'];
   $language=$this->_request['language'];
    if(!empty($district_id)){

    $cities = $this->Crud_model->GetData('mst_cities','*',"status='Active' and district_id='".$district_id."' and is_delete='No'",'','city_name asc');

     $data = [];
     foreach ($cities as $city) {
      $item['id'] = $city->id;
      $item['district_id'] = $district_id;

      if($language == 'Hindi'){

        $item['city_name'] = $city->city_name_hindi;
      } else if($language == 'Marathi'){
        $item['city_name'] = $city->city_name_marathi;
      } else {
        $item['city_name'] = $city->district_name;
      }
      array_push($data, $item);
    }

    
    if(!empty($data ))
    {   
      $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    }
  else 
    {
      $result= array('success' =>0, "message" =>"Select district");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  // get zones
  public function getZone_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $city_id = $this->_request['city_id'];
    $language=$this->_request['language'];

    if(!empty($city_id))
    {
      $zones = $this->Crud_model->GetData('mst_zones','*',"status='Active' and city_id='".$city_id."' and is_delete='No'",'','zone_name asc');
      
      $data = [];
     foreach ($zones as $zone) {
      $item['id'] = $zone->id;
      $item['city_id'] = $city_id;

      if($language == 'Hindi'){

        $item['zone_name'] = $zone->zone_name_hindi;
      } else if($language == 'Marathi'){
        $item['zone_name'] = $zone->zone_name_marathi;
      } else {
        $item['zone_name'] = $zone->city_name;
      }
      array_push($data, $item);
    } 

      if(!empty($data))
      {   
        $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
      }
      else
      {
        $result= array('success' =>0, "message" =>"Data not found. Please try again!");
      }
    }
    else 
    {
      $result= array('success' =>0, "message" =>"Select zones");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function ComplaintZones_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $citizen_id=$this->_request['citizen_id'];
  //  $language=$this->_request['language'];
    if(!empty($citizen_id)) 
    {
      $citizens = $this->Crud_model->GetData('citizens','',"id='".$citizen_id."'",'','','','1');
      if(!empty($citizens)) 
      {
        $data = $this->Crud_model->GetData('mst_zones','id,zone_name',"status='Active' and city_id='".$citizens->city_id."'");
    
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        } 
      }
      else
      {
        $result= array('success' =>0, "message" =>"Data not found. Please try again!");
      }
    }
    else 
    {
      $result= array('success' =>0, "message" =>"Select zone");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function Area_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

    $zone_id = $this->_request['zone_id'];
    $language=$this->_request['language'];

    if(!empty($zone_id))
    {
      $areas = $this->Crud_model->GetData('mst_areas','*',"status='Active' and zone_id='".$zone_id."' and is_delete='No'",'','area asc');
      
       $data = [];
     foreach ($areas as $area) {
      $item['id'] = $area->id;
      $item['zone_id'] = $zone_id;

      if($language == 'Hindi'){

        $item['area'] = $area->area_hindi;
      } else if($language == 'Marathi'){
        $item['area'] = $area->area_marathi;
      } else {
        $item['area'] = $area->area;
      }
      array_push($data, $item);
    } 

      if(!empty($data))
      {   
        $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
      }
      else
      {
        $result= array('success' =>0, "message" =>"Data not found. Please try again!");
      }
    }
    else 
    {
      $result= array('success' =>0, "message" =>"Select area");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

public function Corporate_post()
{
  $this->_request = file_get_contents("php://input");
  header("Content-type: application/json");
  $this->_request=implode("",explode("\\",$this->_request));
  $this->_request=json_decode($this->_request, true);
  $area_id=$this->_request['area_id'];
  $language=$this->_request['language'];
  if(!empty($area_id))
  {
      $getCorporate = $this->Crud_model->GetData('corporates','*',"status='Active' and is_delete='No' and role='Ward Member' and area_id='".$area_id."'",'','id desc');
      //print_r($data);exit();

       $data = [];
     foreach ($getCorporate as $getCorpo) {
      $item['id'] = $getCorpo->id;
      $item['area_id'] = $area_id;

      if($language == 'Hindi'){

        $item['name'] = $getCorpo->name_hindi;
      } else if($language == 'Marathi'){
        $item['name'] = $getCorpo->name_marathi;
      } else {
        $item['name'] = $getCorpo->name;
      }
      array_push($data, $item);
    }


      if(!empty($getCorporate))
      {   
        $result= array('success' =>1, "message" =>"Data Found","data" => $getCorporate);      
      }
      else
      {
        $getCorporate[]=array('id' =>0 ,'name' =>'Others','role' =>'Others', );
        $result= array('success' =>1, "message" =>"Data Found","data" => $getCorporate); 
        //$getOtherdata = $this->Crud_model->GetData('corporates','id,role',"status='Active' and is_delete='No' and role ='Others'");
        //$result= array('success' =>1, "message" =>"Data Found","data" => $getOtherdata);
      }
  }
  else 
  {
    $result= array('success' =>0, "message" =>"Select area");
  }
  $this->response($result, REST_Controller::HTTP_OK);
}

 
  public function getDepartment_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

     $department_parent_id = $this->_request['department_parent_id'];
      $language=$this->_request['language'];
         //print_r($id);exit();
        $departments = $this->Crud_model->GetData('mst_departments','*',"parent_id='".$department_parent_id."' and status='Active' and is_delete='No'",'','');
   /* $data = $this->Crud_model->GetData('mst_departments','',"status='Active' and is_delete='No'");*/
   $data = [];
     foreach ($departments as $department) {
      $item['id'] = $department->id;
      $item['department_parent_id'] = $department_parent_id;

      if($language == 'Hindi'){

        $item['department_name'] = $department->department_name_hindi;
      } else if($language == 'Marathi'){
        $item['department_name'] = $department->department_name_marathi;
      } else {
        $item['department_name'] = $department->department_name;
      }
      array_push($data, $item);
    }
    if(!empty($data))
    {   
      $image_path = IMAGEPATH."departments/";
      $result= array('success' =>1, "message" =>"Data Found","data" => $data,'image_path'=>$image_path);      
    }
    else
    {
      $result= array('success' =>0, "message" =>"Data not found. Please try again!");
    }
    $this->response($result, REST_Controller::HTTP_OK);
  }

  public function getBranch_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true); 

   $area_id=$this->_request['area_id'];
   $language=$this->_request['language'];

  if(!empty($area_id))
  {
      $getbranch = $this->Crud_model->GetData('mst_department_branches','*',"status='Active' and is_delete='No' and area_id='".$area_id."'",'','branch_name asc');
      //print_r($getbranch);exit();

      $data = [];
     foreach ($getbranch as $getbranches) {
      $item['id'] = $getbranches->id;
      $item['area_id'] = $area_id;

      if($language == 'Hindi'){

        $item['branch_name'] = $getbranches->branch_name_hindi;
      } else if($language == 'Marathi'){
        $item['branch_name'] = $getbranches->branch_name_marathi;
      } else {
        $item['branch_name'] = $getbranches->branch_name;
      }
      array_push($data, $item);
    }


      if(!empty($getbranch))
      {   
        $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
      }
      else
      {
        $getbranch[] = array('id' =>0 ,'branch_name' =>'Others');
        $result = array('success' =>1, "message" =>"Data Found","data" => $data); 
      }
  }
  else 
  {
    $result= array('success' =>0, "message" =>"Select area");
  }
  $this->response($result, REST_Controller::HTTP_OK);
  }

  public function SaveComplaint_post()
  {
    $this->_request = file_get_contents("php://input");
    header("Content-type: application/json");
    $this->_request=implode("",explode("\\",$this->_request));
    $this->_request=json_decode($this->_request, true);

      
        $branch_id = $this->_request['branch_id'];
        $branchDepartments = $this->Crud_model->GetData('mst_department_branches','department_id',"id='".$branch_id."'",'','','','1');  
      	if(!empty($branchDepartments)){
			$department_id = $branchDepartments->department_id;
      	} else {
			$department_id = 0;
      	}
      	//  print_r($branchDepartments);exit;

        $citizen_id = $this->_request['citizen_id'];
        $citizen = $this->Crud_model->GetData('citizens','',"id='".$citizen_id."' and is_delete='No'",'','','','1');
        $corporate_id = $this->_request['corporate_id'];
        $area_id = $this->_request['area_id'];
        $country_id = $citizen->country_id;
        $state_id = $citizen->state_id;
        $district_id = $citizen->district_id;
        $city_id = $citizen->city_id;
        $zone_id = $this->_request['zone_id'];
        $title = $this->_request['title'];
        $description = $this->_request['description'];
        $latitude = $this->_request['latitude'];
        $longitude = $this->_request['longitude'];

        $save_data=array(
          'citizen_id'=>$citizen_id,
          'corporate_id'=>$corporate_id,
          'area_id'=>$area_id,
          'department_id'=>$department_id,
          'branch_id'=>$branch_id,
          'country_id'=>$country_id,
          'state_id'=>$state_id,
          'city_id'=>$city_id,
          'district_id'=>$district_id,
          'zone_id'=>$zone_id,
          'title'=>$title,
          'description'=>$description,
          'latitude'=>$latitude,
          'longitude'=>$longitude,
          // 'image'=>$image,
          // 'video'=>$video,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        
        $this->Crud_model->SaveData('complaints',$save_data);
        $citizen_complaint_id = $this->db->insert_id();

        $Comp_code = "CompCode_".$citizen_complaint_id;
        $this->Crud_model->SaveData('complaints',['comp_code'=>$Comp_code],"id='".$citizen_complaint_id."'");

        $image = base64_decode($this->_request['image']);
        $image_name = $this->_request['image_name'];
        if(!empty($image_name))
        {
	        $path_parts = pathinfo($image_name);
	        $ext = $path_parts['extension'];
	        $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
	        $path = FCPATH."../admin/uploads/complaints/".$attachment;
	        file_put_contents($path,$image);
	        $image=$attachment;

	        $image_array = array(
	        	'complaint_id' => $citizen_complaint_id, 
	        	'image' => $image, 
	        );
	        $this->Crud_model->SaveData('complaint_images',$image_array);
	    }

        $video = base64_decode($this->_request['video']);
        $video_name = $this->_request['video_name'];
        if(!empty($video_name))
        {
	        $path_parts = pathinfo($video_name);
	        $ext = $path_parts['extension'];
	        $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
	        $path = FCPATH."../admin/uploads/complaints/".$attachment;
	        file_put_contents($path,$video);
	        $video=$attachment;

	        $video_array = array(
	        	'complaint_id' => $citizen_complaint_id, 
	        	'video' => $video, 
	        );
	        $this->Crud_model->SaveData('complaint_images',$video_array);
	    }


        if(!empty($corporate_id)){
        $corporate = $this->Crud_model->GetData('corporates', 'player_id', "id='".$corporate_id."'",'','','','1');  
        $citizen = $this->Crud_model->GetData('citizens', 'name', "id='".$citizen_id."'",'','','','1'); 

        $to = $corporate->player_id;
        $heading = 'Citizen App';
        $message = 'Compalint register by '.$citizen->name;
        $this->sendMessage($to, $heading, $message);

        $save_data_notification=array(
          'id_type'=>$citizen_complaint_id,
          'receiver_id'=>$corporate_id,
          'type'=>'Complaint',
          'user_type'=>'Citizen',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
          $this->Crud_model->SaveData('notifications',$save_data_notification);
}
        $result= array('success' =>1, "message" =>"Complaint reached successfully",'Comp_code'=>$Comp_code);

        $this->response($result, REST_Controller::HTTP_OK);
      }

  

      public function AllComplaintList_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $citizen_id = $this->_request['citizen_id'];
    //print_r($citizen_id);exit();
        //$language=$this->_request['language'];
        $cond="comp.citizen_id='".$citizen_id."'";
    //print_r($cond);exit();
        $data = $this->Crud_model->ComplaintViewDetails($cond);

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function ShowComplaintDetails_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $id = $this->_request['complaint_id'];
    
        $cond="comp.id='".$id."'";
    
        $data = $this->Crud_model->ShowComplainDetails($cond);
        if(!empty($data))
        {  
             $image_path = IMAGEPATH."complaints/"; 
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data,'image_path'=>$image_path); 
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


     public function DepartmentBranchesList_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $department_id = $this->_request['department_id'];
        $detail = $this->Crud_model->GetData('mst_department_branches','id,branch_name,branch_name_marathi,,branch_name_hindi,discription,image',"status='Active' and is_delete='No' and department_id='".$department_id."'",'','branch_name asc');
        $image_path = IMAGEPATH."branches/";
        $detail =array(
          'image_path'=>$image_path,
          'details'=>$detail,
        );

        if(!empty($detail))
        {   
          $result= array('success' =>1, "message" =>"Data Found","detail" => $detail);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


       public function DepartmentBranchesViews_post()
      {
        //print_r('hiee');exit();
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $branch_id = $this->_request['id'];
        $cond ="co.branch_id='".$branch_id."' and role='Employees'";
          //print_r($cond);exit();
        $details = $this->Crud_model->branchWiseEmployees($cond);
        $co_image_path = IMAGEPATH."corporates/";

        $data = $this->Crud_model->GetData('mst_department_branches','branch_name,discription,image',"id='".$branch_id."'",'','','','1');
       // print_r($details);exit();
        $image_path = IMAGEPATH."branches/";
        
        if(!empty($details ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","details" => $details,"co_image_path"=>$co_image_path,"data"=>$data,'image_path'=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }



      public function getDepartmentParent_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $language=$this->_request['language']; 
        $dept_parents = $this->Crud_model->GetData('mst_departments_parent','*',"status='Active' and is_delete='No'",'','title asc');
        
        $data = [];
     foreach ($dept_parents as $row) {
      $item['id'] = $row->id;
     // $item['state_id'] = $state_id;

      if($language == 'Hindi'){

        $item['title'] = $row->title_hindi;
      } else if($language == 'Marathi'){
        $item['title'] = $row->title_marathi;
      } else {
        $item['title'] = $row->title;
      }
      array_push($data, $item);
    }
        if(!empty($data))
        {   
          $image_path = IMAGEPATH."parent_department/";
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,"image_path"=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }   

     
      public function ConstitutionList_post()
      {
         $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        
         $language=$this->_request['language'];
        $getAllData = $this->Crud_model->getConstitution();

    $data = [];
     foreach ($getAllData as $row) {
      $item['id'] = $row->id;
     // $item['state_id'] = $state_id;

      if($language == 'Hindi'){

        $item['title'] = $row->title_hindi;
      } else if($language == 'Marathi'){
        $item['title'] = $row->title_marathi;
      } else {
        $item['title'] = $row->title;
      }
      array_push($data, $item);
    }



        if(!empty($data ))
        {   
          $count = $this->Crud_model->GetData('constitution_article_details','id',"status='Active' and is_delete='No'",'','id asc');
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function ConstitutionView_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $article_id = $this->_request['article_id'];
        $language=$this->_request['language'];
        $constitution_article_details = $this->Crud_model->GetData('constitution_article_details','*',"article_id='".$article_id."'");
       // print_r($data);exit();
     $data = [];
     foreach ($constitution_article_details as $constitution_article_detail) {
      $item['id'] = $constitution_article_detail->id;
      $item['article_id'] = $article_id;

      if($language == 'Hindi'){

        $item['article_title'] = $constitution_article_detail->article_title_hindi;
      } else if($language == 'Marathi'){
        $item['article_title'] = $constitution_article_detail->article_title_marathi;
      } else {
        $item['article_title'] = $constitution_article_detail->article_title;
      }
      array_push($data, $item);
    }

        if(!empty($data ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }




      public function SaveComplaintFeedback_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['complaint_id'];
        $citizen_id = $this->_request['citizen_id'];
        $feedback = $this->_request['feedback'];
       // $image = $this->_request['image'];
        $subject = $this->_request['subject'];
        

        $image = base64_decode($this->_request['image']);
        $image_name = $this->_request['image_name'];
        if(!empty($image_name))
        {
        $path_parts = pathinfo($image_name);
        $ext = $path_parts['extension'];
        $attachment = time().''.rand(100,999).''.$path_parts['filename'].'.'.$ext;
        $path = FCPATH."../admin/uploads/complaints_feedback/".$attachment;
        file_put_contents($path,$image);
        $image=$attachment;


        $save_data=array(
          'complaint_id'=>$id,
          'citizen_id'=>$citizen_id,
          'feedback'=>$feedback,
          'subject'=>$subject,
          'image'=>$image,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('complaint_feedbacks',$save_data);
        $result= array('success' =>1, "message" =>"Feedback sent successfully");
    }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function SaveAppFeedback_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['citizen_id'];
        $title = $this->_request['title'];
        $description = $this->_request['description'];
        $loginusertype = $this->_request['loginusertype'];
        

        $save_data=array(
          'citizen_id'=>$id,
          'title'=>$title,
          'loginusertype'=>$loginusertype,
          'description'=>$description,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('app_feedbacks',$save_data);
        $result= array('success' =>1, "message" =>"Feedback sent successfully");

        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function change_profile_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $changeProfile=json_decode($this->_request, true);
        //print_r($changeProfile);exit;

        if((!empty($changeProfile['id'])) and (!empty($changeProfile['name'])) and (!empty($changeProfile['loginusertype'])))
        {
          if($changeProfile['loginusertype'] == 'Citizen'){
            $table = 'citizens';
          } else {
            $table = 'corporates';
          }


          if($changeProfile['image']!='')
          {
            $image = base64_decode($changeProfile['image']);
            $image_name = $changeProfile['image_name'];
            $path_parts = pathinfo($image_name);
            $ext = $path_parts['extension'];
            $attachment = time().'_'.rand(100,999).'_'.$path_parts['filename'].'.'.$ext;
            $path = FCPATH."../admin/uploads/".$table.'/'.$attachment;
            
            file_put_contents($path,$image);
            $image=$attachment;

            $check = $this->Crud_model->GetData($table,"image","id='".$changeProfile['id']."'","","","","1");
            if(!empty($check->image))
            {
              //unlink('../admin/uploads/'.$table.'/'.$check->image);
              unlink(FCPATH.'../admin/uploads/'.$table.'/'.$check->image);
            }  
          }      
          else
          {
            $image= '';
          }  

          $data=array('image' => $image, 'name' => $changeProfile['name']);
          $this->Crud_model->SaveData($table, $data, "id='".$changeProfile['id']."'");
          $result= array('success' =>1, "message" =>"Profile change successfully!");
        } 
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function viewProfile_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $profile=json_decode($this->_request, true);
        $image_path = IMAGEPATH."profile/";

        if((!empty($profile['id'])) and (!empty($profile['loginusertype'])))
        {

          if($profile['loginusertype'] == 'Citizen'){
            $table = 'citizens';
          } else {
            $table = 'corporates';
          }

          $data = $this->Crud_model->GetData($table,"","id='".$profile['id']."'","","","","1");
          
          $result= array('success' =>1, "message" =>"Data Found", 'data' => $data,'image_path'=>$image_path);
        } 
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function getAboutUs_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $language=$this->_request['language'];
        $aboutus = $this->Crud_model->GetData('cms','*',"slug='about-us'",'','','','');
       // print_r($aboutus);exit();
     $data = [];
     foreach ($aboutus as $row) {
      $item['id'] = $row->id;
      if($language == 'Hindi')
      {

        $item['cms_title'] = $row->cms_title_hindi;
        $item['slug'] = $row->slug_hindi;
        $item['description'] = $row->description_hindi;
      } 
      else if($language == 'Marathi')
      {
        $item['cms_title'] = $row->cms_title_marathi;
        $item['slug'] = $row->slug_marathi;
        $item['description'] = $row->description_marathi;
      } 
      else 
      {
        $item['cms_title'] = $row->cms_title;
        $item['slug'] = $row->slug;
        $item['description'] = $row->description;
      }
      array_push($data, $item);
    }


        $image_path = IMAGEPATH."cms/";

        if(!empty($data ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,'image_path'=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function getContactUs_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $data = $this->Crud_model->GetData('contact_us','',"status='Active' and is_delete='No'");
        $image_path = IMAGEPATH."contact_us/";
        if(!empty($data ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,'image_path'=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function getChairPerson_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $cond="co.is_delete='No' and co.status='Active'";
        $data = $this->Crud_model->CorporateDetails($cond);
        $image_path = IMAGEPATH."corporates/";
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,'image_path'=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function getChairPersonAppointment_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['corporate_id'];
        $citizen_id = $this->_request['citizen_id'];
        $date = $this->_request['date'];
        $time = $this->_request['time'];
        $purpose = $this->_request['purpose'];
        $save_data=array(
          'corporate_id'=>$id,
          'citizen_id'=>$citizen_id,
          'purpose'=>$purpose,
          'date'=>$date,
          'time'=>$time,
          'status'=>'Pending',
          'created'=>date('Y-m-d'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('appointments',$save_data);

         if(!empty($corporate_id)){
        $corporate = $this->Crud_model->GetData('corporates', 'player_id', "id='".$id."'",'','','','1');
        $citizen = $this->Crud_model->GetData('citizens', 'name', "id='".$citizen_id."'",'','','','1'); 
        $to = $corporate->player_id;
        $heading = 'Citizen App';
        $message = 'Your appointment booked with '.$citizen->name.' on '.$date.' - '.$time;
        $this->sendMessage($to, $heading, $message); 

        $save_data_notification=array(
          'id_type'=>'Appointment',
          'receiver_id'=>$id,
          'type'=>'Appointment',
          'user_type'=>'Corporate',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
          $this->Crud_model->SaveData('notifications',$save_data_notification);
}
        $result= array('success' =>1, "message" =>"Your appointment register successfully");

        $this->response($result, REST_Controller::HTTP_OK);
      }

      
      public function ConfirmChairPersonAppointment_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['id'];
        $corporate_id = $this->_request['corporate_id'];
        $citizen_id = $this->_request['citizen_id'];
        $date = $this->_request['date'];
        $time = $this->_request['time'];
        $updateAppointments = $this->Crud_model->GetData('appointments', 'id,corporate_id,citizen_id,date,time', "id='".$id."'",'','','','1');  
        $save_data=array(
          'id'=>$id,
          'corporate_id'=>$corporate_id,
          'citizen_id'=>$citizen_id,
          'date'=>$date,
          'time'=>$time,
          'status'=>'Confirmed',
          'created'=>date('Y-m-d'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('appointments',$save_data,"id='".$id."'");

        if(!empty($corporate_id)){
        $corporate = $this->Crud_model->GetData('corporates', 'player_id', "id='".$corporate_id."'",'','','','1'); 
        $citizen = $this->Crud_model->GetData('citizens', 'name', "id='".$citizen_id."'",'','','','1');  

        $to = $corporate->player_id;
        $heading = 'Citizen App';
        $message = 'Your appointment has been confirmed with '.$citizen->name.' on '.$date.' - '.$time;
        $this->sendMessage($to, $heading, $message);


        $save_data_notification=array(
          'id_type'=>$id,
          'receiver_id'=>$corporate_id,
          'user_type'=>'Corporate',
          'type'=>'Appointment',
          'is_read'=>'No',
          'message'=>$message,
          'created'=>date('Y-m-d H:i:s'),
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('notifications',$save_data_notification);

    }
        $result= array('success' =>1, "message" =>"Your appointment has been confirmed successfully");

        $this->response($result, REST_Controller::HTTP_OK);
      }



      public function ShowChairPersonAppointment_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['corporate_id'];
        $cond = "corporate_id='".$id."'";
        $data = $this->Crud_model->ShowChairPersonAppointmentData($cond);

        if(!empty($data ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function getCitizenAppointments_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['citizen_id'];
        $cond = "ap.citizen_id='".$id."'";
        $data = $this->Crud_model->ShowCitizenAppointmentData($cond);



        if(!empty($data ))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function AllCorporateComplaintList_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $corporate_id = $this->_request['corporate_id'];
        $corporate = $this->Crud_model->GetData('corporates','',"id='".$corporate_id."'",'','','','1');
        ////print_r($corporate);exit();
        if($corporate->role == 'Collector'){
          $con = "1=1";           
        } else if($corporate->role == 'MLA' || $corporate->role == 'Ward Member' || $corporate->role == 'Employees'){
          $con = "corporate_id = '".$corporate_id."'";
        } else {
          $con = "id=0";
        }

        $response = $this->Crud_model->AllCorporateComplaints($con);

        $data = [];
        foreach ($response as $key) { 
          $pending = $this->Crud_model->GetData('complaints','count(id) count',"branch_id='".$key->branch_id."' and complaint_status='Pending'",'','','','1');
          $resolved = $this->Crud_model->GetData('complaints','count(id) count',"branch_id='".$key->branch_id."' and complaint_status='Resolved'",'','','','1');


          $item['branch_id'] = $key->branch_id;
          $item['branch_name'] = $key->branch_name;
          $item['total_complaint'] = $key->total_complaint;
          $item['total_pending'] = $pending->count;
          $item['total_resolved'] = $resolved->count;
          $item['department_name'] = $key->department_name;
          array_push($data, $item);
        }


        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function CorporateComplaintDetails_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $branch_id = $this->_request['branch_id'];
       // $branchDepartments = $this->Crud_model->GetData('mst_department_branches','department_id',"id='".$branch_id."'",'','','','');
        $cond="comp.branch_id='".$branch_id."'";

        $data = $this->Crud_model->CorporateComplaintsDetails($cond);

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }

      public function CorporateComplaintNotificationsCount_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $receiver_id = $this->_request['receiver_id'];
        //$cond="no.receiver_id='".$receiver_id."'";
        $data = $this->Crud_model->GetData('notifications','',"receiver_id='".$receiver_id."'");
        //print_r($data);exit();
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'count'=>count($data)); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function CorporateComplaintNotifications_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $receiver_id = $this->_request['receiver_id'];
        //$cond="no.receiver_id='".$receiver_id."'";
        $data = $this->Crud_model->GetData('notifications','',"receiver_id='".$receiver_id."'");
        //print_r($data);exit();
        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }



      public function SaveAcceptedComplaints_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['complaint_id'];
        $approved_by = $this->_request['approved_by'];
        $date = $this->_request['date'];
        $time = $this->_request['time'];
        $save_data=array(
          //'id'=>$id,
          'approved_by'=>$approved_by,
          'date'=>$date,
          'time'=>$time,
          'complaint_status'=>'Approved',
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('complaints',$save_data,"id='".$id."'");


        $result= array('success' =>1, "message" =>"Your complaint approved successfully");

        $this->response($result, REST_Controller::HTTP_OK);
      }


     public function SaveResolvedComplaints_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['complaint_id'];
        $corporate_id = $this->_request['resolved_by'];
      /*  $date = $this->_request['date'];
        $time = $this->_request['time'];*/
        $save_data=array(
          //'id'=>$id,
          'resolved_by'=>$corporate_id,
          'resolve_date'=>date('Y-m-d'),
          'resolve_time'=>date('Y-m-d H:i:s'),
          'complaint_status'=>'Resolved',
          'modified'=>date('Y-m-d H:i:s'),
        );
        $this->Crud_model->SaveData('complaints',$save_data,"id='".$id."'");


        $result= array('success' =>1, "message" =>"Your complaint resolved successfully");

        $this->response($result, REST_Controller::HTTP_OK);
      }

         
      public function SaveCorporatePermission_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['corporate_id'];

          $save_data=array(
            'is_checked'=>'Yes',
            'modified'=>date('Y-m-d H:i:s'),
          );
          
        $this->Crud_model->SaveData('corporates',$save_data,"id='".$id."'");  
        
        $result= array('success' =>1, "message" =>"Permission granted",'is_checked'=>'Yes');
        $this->response($result, REST_Controller::HTTP_OK);
      }

       public function CancelAppointment_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);
        $id = $this->_request['id'];
       /* $id = $this->_request['appointment'];
        $id = $this->_request['appointment'];*/

          $save_data=array(
            'status'=>'Cancelled',
            'modified'=>date('Y-m-d H:i:s'),
          );
          
        $this->Crud_model->SaveData('appointments',$save_data,"id='".$id."'");  
        
        $result= array('success' =>1, "message" =>"Appointment cancelled",'status'=>'Cancelled');
        $this->response($result, REST_Controller::HTTP_OK);
      }


      public function getBranchLatLong_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $language=$this->_request['language'];  
        $deptbranches = $this->Crud_model->GetData('mst_department_branches','*',"status='Active' and is_delete='No'");
        //print_r($data);exit();

        $data = [];
     foreach ($deptbranches as $deptbranch) {
     // $item['id'] = $district->id;
      //$item['state_id'] = $state_id;

      if($language == 'Hindi'){

        $item['branch_name'] = $deptbranch->branch_name_hindi;
        $item['branch_address'] = $deptbranch->address_hindi;
      } else if($language == 'Marathi'){
        $item['branch_name'] = $deptbranch->branch_name_marathi;
        $item['branch_address'] = $deptbranch->address_marathi;
      } else {
        $item['branch_name'] = $deptbranch->district_name;
        $item['branch_address'] = $deptbranch->address;
      }
      array_push($data, $item);
    }

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found successfully",'data'=>$data); 
        }   
        else
        {
          $result= array('success' =>0, "message" =>"Data Not Found");
        }
        $this->response($result, REST_Controller::HTTP_OK);

      }   

      public function CorporateRolesAndResponsible_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
        $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        // $data = $this->Crud_model->GetData('roles_and_responsibilities','id,role,image',"status='Active' and is_delete='No'",'role');

        $data = $this->Crud_model->getRoleAndImage();

        if(!empty($data))
        {   
        	 $image_path = IMAGEPATH."roles_and_responsibilities/";
            $result= array('success' =>1, "message" =>"Data Found","data" => $data,"image_path"=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }		

       public function CorporateRolesAndResponsibleDetails_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
         $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $id = $this->_request['id'];
        $image_path = IMAGEPATH."roles_and_responsibilities/";
      
        // $data = $this->Crud_model->GetData('corporate_responsibilities_mapping','id, role_id, responsibility, responsibility_marathi, responsibility_hindi',"role_id='".$id."' and status='Active' and is_delete='No'");
        
        $data = $this->Crud_model->GetData('mst_roles','id,title,title_marathi,title_hindi',"id='".$id."' and status='Active' and is_delete='No'");

        $cond="crm.role_id='".$id."'";
        $datadetails = $this->Crud_model->getCorporateResponsibilities($cond);

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,"image_path"=>$image_path,"datadetails"=>$datadetails);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }



    /*  public function CorporateRolesAndResponsibleDetails_post()
      {
        $this->_request = file_get_contents("php://input");
        header("Content-type: application/json");
       	 $this->_request=implode("",explode("\\",$this->_request));
        $this->_request=json_decode($this->_request, true);

        $id = $this->_request['id'];
        $image_path = IMAGEPATH."roles_and_responsibilities/";
      
          
              $data = $this->Crud_model->GetData('roles_and_responsibilities','id,role,responsibility,image',"status='Active' and is_delete='No' and id='".$id."'");

        if(!empty($data))
        {   
          $result= array('success' =>1, "message" =>"Data Found","data" => $data,"image_path"=>$image_path);      
        }
        else
        {
          $result= array('success' =>0, "message" =>"Data not found. Please try again!");
        }
        $this->response($result, REST_Controller::HTTP_OK);
      }*/


		public function CheckDuplication_post()
		{
			$this->_request = file_get_contents("php://input");
			header("Content-type: application/json");
			$this->_request=implode("",explode("\\",$this->_request));
			$this->_request=json_decode($this->_request, true);
		
			$email = $this->_request['email'];
			$mobile = $this->_request['mobile'];
		
			if(!empty($email) && !empty($mobile)) 
			{
				$checkEmail =$this->Crud_model->GetData('citizens',"id","email='".$email."'","","","","1");
				$checkMobile =$this->Crud_model->GetData('citizens',"id","mobile='".$mobile."'","","","","1");
				if(!empty($checkEmail))
				{
					$result = array('success' =>0, "message" =>"This email already exits.");
				}
				else if(!empty($checkMobile))
				{
					$result = array('success' =>0, "message" =>"This mobile already exits.");
				}
				else {
					$result = array('success' =>1, "message" =>"New data found");
				}
			}
			else
			{
				$result = array('success' =>0, "message" =>"parameters not found");
				
			}
			$this->response($result, REST_Controller::HTTP_OK);
		}


      function sendMessage($to, $heading, $message)
      {
        $fields = array(
          'app_id' => "dde67350-baf3-490c-af1a-910e35c0c1cc",
                'include_player_ids' => [$to],
                'contents' => array("en" => $message),
                'headings' => array("en"=> $heading),
        );

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
                                       'Authorization: Basic YTU3MzBjMDUtYzE4Yy00Y2QxLWEzNDMtMGI5NWFkMTkwZDc3'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);    

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
      }     
    }