<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH . '/libraries/REST_Controller.php';

class Criminals extends REST_Controller 
{

  public function __construct()
  {
      parent::__construct();
      $this->_request = file_get_contents("php://input");
      header("Content-type: application/json");
      $this->_request=implode("",explode("\\",$this->_request));
      $this->_request=json_decode($this->_request, true);
  }

  // This API is used to get criminals record
  public function getCriminalsRecord_post() 
  {
      $police_station_id = $this->_request['police_station_id'];

      if(!empty($police_station_id))
      {
        $data = $this->Crud_model->getCriminalsList($police_station_id);

        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."criminals/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, "image_path"=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

// This API is used to get particular criminal record
  public function getCriminalsRecordDetails_post() 
  {   
      $police_station_id = $this->_request['police_station_id'];
      $criminal_id = $this->_request['criminal_id'];

      if(!empty($police_station_id) && !empty($criminal_id))
      {
        $con="c.id='".$criminal_id."' AND c.police_station_id='".$police_station_id."'";
        $data = $this->Crud_model->GetCriminalsRecordDetails($con);
        if(!empty($data)) 
        {
          $image_path = IMAGEPATH."criminals/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data,"image_path"=>$image_path);
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }

  public function getOverallPoliceStationCriminals_post()
  {
      //$table="mst_police_stations";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="c.city_id='".$checkCity->city_id."'";               
                $total_police_eyes = $this->Crud_model->GetOverallPoliceStationCriminals($con);                   
                }           

              if(!empty($total_police_eyes))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $total_police_eyes);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }


  
  //This API is used to get police station criminals count 
  public function getPoliceStationCriminalsCount_post()
  {
      $table="mst_police_stations";
      $sdpo_id=$this->_request['sdpo_id'];
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person'  && !empty($sdpo_id))
              {
                $con="city_id='".$checkCity->city_id."' and sdpo_id='".$sdpo_id."' and is_delete='No' and status='Active'";
                $police_stations = $this->Crud_model->GetData($table,'id,name as police_station_name,address',$con);
                //print_r($this->db->last_query());exit();
                $data=[];

                foreach ($police_stations as $row) 
                {
                    $total_criminals = $this->Crud_model->GetData('criminals','count(id) as total_criminals',"police_station_id='".$row->id."' and is_delete='No' and status='Active'",'','','','1');
                    $key['id'] = $row->id;
                    $key['police_station_name'] = $row->police_station_name;            
                    $key['address'] = $row->address;            
                    $key['total_criminals'] = $total_criminals->total_criminals;             
                    array_push($data, $key);
                }
              }
              else if($loginusertype=='Station_Head')
              {
              $con="id='".$police_id."'";
              $checkStation = $this->Crud_model->GetData('mst_police','police_station_id',$con,'','','','1');
              $con="id='".$checkStation->police_station_id."'";
                $police_stations = $this->Crud_model->GetData($table,'id,name',$con,'','','','1'); $data=[];

                if(empty($police_stations)){
                   $result= array('success' =>0, 'message' => "Required Police Stations is missing");      
                  $this->response($result, REST_Controller::HTTP_OK); 
                }

                    $total_criminals = $this->Crud_model->GetData('criminals','count(id) as total_criminals',"police_station_id='".$police_stations->id."'",'','','','1');
                    $key['id'] = $police_stations->id;
                    $key['police_station_name'] = $police_stations->name;            
                    $key['total_criminals'] = $total_criminals->total_criminals;             
                    array_push($data, $key);

                            
              }

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

  public function getPoliceStationCriminalsCountList_post()
  {
      $table="mst_police_stations";
     
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype) )
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="city_id='".$checkCity->city_id."' and is_delete='No' and status='Active'";
                $police_stations = $this->Crud_model->GetData($table,'id,name as police_station_name,address',$con);
                //print_r($this->db->last_query());exit();
                $data=[];

                foreach ($police_stations as $row) 
                {
                    $total_criminals = $this->Crud_model->GetData('criminals','count(id) as total_criminals',"police_station_id='".$row->id."' and is_delete='No' and status='Active'",'','','','1');
                    $key['id'] = $row->id;
                    $key['police_station_name'] = $row->police_station_name;            
                    $key['address'] = $row->address;            
                    $key['total_criminals'] = $total_criminals->total_criminals;             
                    array_push($data, $key);
                }
              }
              

              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }

   //This API is used to get police station criminals count for SDPO
  public function getSDPOPoliceStationCriminalsCount_post()
  {
      $table="mst_sdpo";
      $police_id=$this->_request['police_id'];
      $loginusertype=$this->_request['loginusertype'];

      if(!empty($police_id) && !empty($loginusertype))
      {
          $con="id='".$police_id."' AND designation_type='".$loginusertype."'";
          $checkCity = $this->Crud_model->GetData('mst_police','city_id',$con,'','','','1');

          if(!empty($checkCity))
          {
              if($loginusertype=='Head_Person')
              {
                $con="city_id='".$checkCity->city_id."' and status='Active'";
                $sdpo_data = $this->Crud_model->GetData($table,'id,name as sdpo_name',$con);
                $data=[];

                foreach ($sdpo_data as $row) 
                {
                  $mst_police_stations_data = $this->Crud_model->GetData('mst_police_stations','id,name','sdpo_id="'.$row->id.'"');    
                  //print_r($sdpo_Police_station_data);exit(); 
                    $key['sdpo_id'] = $row->id;
                    $key['sdpo_name'] = $row->sdpo_name;  
                    $count=0;          
                  foreach ($mst_police_stations_data as $val) {
                    
                    $total_criminals = $this->Crud_model->GetData('criminals','count(id) as total_criminals',"police_station_id='".$val->id."' and is_delete='No' and status='Active'",'','','','1');
                    //print_r($total_criminals->total_criminals);exit();           
                    $count=$count+$total_criminals->total_criminals;   
                   }
                  
                    $key['total_criminals'] = $count;           

                    array_push($data, $key);
                }
              }
              
              if(!empty($data))
              {         
                $result= array('success' =>1, "message"=>"Data found", 'data' => $data);
              }
              else
              {
                $result= array('success' =>0, 'message' => "Data not found");
              }
          }
          else
          {

              $result= array('success' =>0, 'message' => "Data not Found");
          }
      }
      else
      {
          $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
  }
  // This API is used to get base64 encode criminal image 
  public function getCriminalsImageBase64_post() 
  {   
      $police_station_id = $this->_request['police_station_id'];
      $criminal_id = $this->_request['criminal_id'];

      if(!empty($police_station_id) && !empty($criminal_id))
      {
        $con="c.id='".$criminal_id."' AND c.police_station_id='".$police_station_id."'";
        $data = $this->Crud_model->GetCriminalsRecordDetails($con);
        if (!empty($data)) {
          $base64='';
         if (!empty($data->image)) {
            $path =IMAGEPATH."criminals/".$data->image;
            $image_path = IMAGEPATH."criminals/";
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data1 = file_get_contents($path);
            //print_r($data1);exit();
            $base64 = base64_encode($data1);
            $result= array('success' =>1, 'message' => "Data found", 'data' => $data, "image" =>$base64, "image_path"=>$image_path);
          } else {
          $image_path = IMAGEPATH."criminals/";
          $result= array('success' =>1, 'message' => "Data found", 'data' => $data, "image" =>$base64, "image_path"=>$image_path);
           }
        }
        else
        {
          $result= array('success' =>0, 'message' => "Data not found");
        }
      }
      else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK);
  }
  public function saveCriminalVerification_post()
{
    if(!empty($this->_request['location_verified']) &&!empty($this->_request['criminal_id']) && !empty($this->_request['police_station_id']) && !empty($this->_request['police_id']) && !empty($this->_request['recent_image']) && !empty($this->_request['latitude']) && !empty($this->_request['longitude']) && !empty($this->_request['match_result']) )
      {
           $table="criminal_visit";
          $police_id=$this->_request['police_id'];
          $police_station_id=$this->_request['police_station_id'];
          $criminal_id=$this->_request['criminal_id'];
          $recent_image=$this->_request['recent_image'];
          $match_result=$this->_request['match_result'];
          $location_verified=$this->_request['location_verified'];
          $longitude=$this->_request['longitude'];
          $latitude=$this->_request['latitude'];
        
        $recent_image = base64_decode($this->_request['recent_image']);
        $image_name = $this->_request['image_name'];
        if(!empty($recent_image))
        {
          $path_parts = pathinfo($image_name);
          $ext = $path_parts['extension'];
          $attachment = time().''.$path_parts['filename'].'.'.$ext;
          $path = FCPATH."../admin/uploads/criminals/".$attachment;
          file_put_contents($path,$recent_image);
          $recent_image=$attachment;
          
      }else{
         $recent_image='';
      }
             $data2 = array(
             'match_result'=>$match_result,
              'recent_image'=>$recent_image,
              'police_id'=>$police_id,
              'police_station_id'=>$police_station_id,
              'criminal_id'=>$criminal_id,
              'latitude' =>$latitude,
              'longitude' =>$longitude,
              'location_verified' =>$location_verified,
               );
         $data=$this->Crud_model->SaveData('criminal_visit',$data2);
         $con="id='".$criminal_id."' AND (latitude='' OR longitude='' OR image='')";
          $checkCriminal= $this->Crud_model->GetData('criminals','id',$con,'','','','1');
          if(!empty($checkCriminal))
          {
             $dataCriminals = array(
              'latitude' =>$latitude,
              'longitude' =>$longitude,
              'image' =>$recent_image,
             );
            $this->Crud_model->SaveData('criminals',$dataCriminals,"id='".$criminal_id."'");
         }

      if(!empty($data))
      {
        $result= array('success' =>1, "message"=>"Data save successfully");
      }
      else
      {
        $result= array('success' =>0, 'message' => "Data not found");
      }
    }else
      {
        $result= array('success' =>0, 'message' => "Required parameters missing");
      }
      $this->response($result, REST_Controller::HTTP_OK); 
}

}